/*
 * File:		trd_dlg.cpp
 * Purpose:		get trade params from user
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: trd_dlg.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/05/04 18:23:05 $" */

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "trd_dlg.h"
#include "str_util.h"

#define ID_BROWSE_BTN		601

// ===============================================================
BEGIN_EVENT_TABLE(TradeDialog, wxDialog)
	EVT_BUTTON(ID_BROWSE_BTN, TradeDialog::OnBrowse)
END_EVENT_TABLE()

// ---------------------------------------------------------------
TradeDialog::TradeDialog(wxWindow *p) :
	StdDialog(p, "Configure Trade")
{
wxStaticText *msg[13];
wxButton *btn;

	msg[0] = new wxStaticText(this, -1, "Sector File:");
	msg[1] = new wxStaticText(this, -1, "Location:");
	msg[2] = new wxStaticText(this, -1, "Initial Date:");
	msg[3] = new wxStaticText(this, -1, "Admin:");
	msg[4] = new wxStaticText(this, -1, "Bribery:");
	msg[5] = new wxStaticText(this, -1, "Broker:");
	msg[6] = new wxStaticText(this, -1, "Liaison:");
	msg[7] = new wxStaticText(this, -1, "Carousing:");
	msg[8] = new wxStaticText(this, -1, "Steward:");
	msg[9] = new wxStaticText(this, -1, "Streetwise:");
	msg[10] = new wxStaticText(this, -1, "Trader:");
	msg[11] = new wxStaticText(this, -1, "-");

	src_sect = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 11), -1));
	btn = new wxButton(this, ID_BROWSE_BTN, "Browse",
			wxPoint(-1, -1),
			wxSize((int) (COL_OFFSET * 2.5), -1));
	src_loc = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((int)(COL_OFFSET * 1.5), -1));

	init_day = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((int)(COL_OFFSET * 1.5), -1));
	init_year = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((int)(COL_OFFSET * 1.5), -1));

	b7 = new wxCheckBox(this, -1, "Full Book 7",
			wxPoint(-1, -1));
	enh = new wxCheckBox(this, -1, "Enhanced",
			wxPoint(-1, -1));

	admin = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));
	bribery = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));
	broker = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));
	liaison = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));
	carousing = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));
	steward = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));
	streetwise = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));
	trader = new wxTextCtrl(this, -1, "", 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 1), -1));

	wxBoxSizer* sizer_5 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_8 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_16 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Skills"), wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_4 = new wxFlexGridSizer(2, 8, 0, 0);
    wxStaticBoxSizer* sizer_9 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "Options"), wxHORIZONTAL);
    wxBoxSizer* sizer_15 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* grid_sizer_3 = new wxFlexGridSizer(2, 2, 0, 0);
    wxBoxSizer* sizer_7 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_6 = new wxBoxSizer(wxHORIZONTAL);
    grid_sizer_3->Add(msg[0], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_6->Add(src_sect, 1, wxALL | wxEXPAND, DLG_OFFSET);
    sizer_6->Add(btn, 0, wxALL, DLG_OFFSET);
    grid_sizer_3->Add(sizer_6, 1, 0, 0);
    grid_sizer_3->Add(msg[1], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_7->Add(src_loc, 0, wxALL, DLG_OFFSET);
    sizer_7->Add(msg[2], 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_7->Add(init_day, 0, wxALL, DLG_OFFSET);
    sizer_7->Add(msg[11], 0, wxALL|wxALIGN_CENTER_VERTICAL, 0);
    sizer_7->Add(init_year, 0, wxALL, DLG_OFFSET);
    grid_sizer_3->Add(sizer_7, 0, 0, 0);
    sizer_5->Add(grid_sizer_3, 0, 0, 0);
    sizer_15->Add(b7, 0, wxALL, DLG_OFFSET / 2);
    sizer_15->Add(enh, 0, wxALL, DLG_OFFSET / 2);
    sizer_9->Add(sizer_15, 0, 0, 0);
    sizer_8->Add(sizer_9, 0, 0, 0);
    grid_sizer_4->Add(msg[3], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(admin, 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[4], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(bribery, 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[5], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(broker, 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[6], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(liaison, 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[7], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(carousing, 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[8], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(steward, 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[9], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(streetwise, 0, wxALL, DLG_OFFSET / 2);
    grid_sizer_4->Add(msg[10], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET / 2);
    grid_sizer_4->Add(trader, 0, wxALL, DLG_OFFSET / 2);
    sizer_16->Add(grid_sizer_4, 0, 0, 0);
    sizer_8->Add(sizer_16, 0, wxALL, DLG_OFFSET);
    sizer_5->Add(sizer_8, 0, wxALL, DLG_OFFSET);

	DoLayout(wxALL, DLG_OFFSET, sizer_5);
}	

// --------------------------------------------------------------------------
void
TradeDialog::OnBrowse(wxCommandEvent &event)
{
char *ptr;
wxString str;

	str = wxFileSelector("Choose Sector File", 
				NULL, 
				NULL,
				NULL,
				"*.sec",
				wxSAVE | wxHIDE_READONLY,
				this);
	ptr = (char *) str.GetData();

	if((ptr != NULL) && (ptr[0] != 0)) {
		src_sect->SetValue(ptr);
	}
}

// --------------------------------------------------------------------------
bool
TradeDialog::GetConfig(struct conf_struct *cfg)
{
char lbuff[20],*ptr;
int i,val;
wxTextCtrl *ctl;
wxString str;

	// set controls to known (sane/clear) state
	src_sect->SetValue("");
	src_loc->SetValue("");
	init_day->SetValue("");
	init_year->SetValue("");
	admin->SetValue("");
	bribery->SetValue("");
	broker->SetValue("");
	liaison->SetValue("");
	carousing->SetValue("");
	steward->SetValue("");
	streetwise->SetValue("");
	trader->SetValue("");
	b7->SetValue(FALSE);
	enh->SetValue(FALSE);
	// populate controls
	if(cfg->src_name != NULL) 
		src_sect->SetValue(cfg->src_name);
	if((cfg->src.hex_x >= 0) && (cfg->src.hex_y >= 0)) {
		sprintf(lbuff, "%02d%02d", cfg->src.hex_x+1, cfg->src.hex_y+1);
		src_loc->SetValue(lbuff);
	}
	sprintf(lbuff, "%d", cfg->init_date.day);
	init_day->SetValue(lbuff);
	sprintf(lbuff, "%d", cfg->init_date.year);
	init_year->SetValue(lbuff);
	for(i = 0;i < MAX_TRADE_SKILLS; i++) {
		ctl = NULL;

		if(NULL == cfg->skills[i])
			continue;
		if(strcasecmp(cfg->skills[i], "admin") == 0) {
			ctl = admin;
			val = cfg->levels[i];
		} else if(strcasecmp(cfg->skills[i], "bribery") == 0) {
			ctl = bribery;
			val = cfg->levels[i];
		} else if(strcasecmp(cfg->skills[i], "broker") == 0) {
			ctl = broker;
			val = cfg->levels[i];
		} else if(strcasecmp(cfg->skills[i], "liaison") == 0) {
			ctl = liaison;
			val = cfg->levels[i];
		} else if(strcasecmp(cfg->skills[i], "carousing") == 0) {
			ctl = carousing;
			val = cfg->levels[i];
		} else if(strcasecmp(cfg->skills[i], "steward") == 0) {
			ctl = steward;
			val = cfg->levels[i];
		} else if(strcasecmp(cfg->skills[i], "streetwise") == 0) {
			ctl = streetwise;
			val = cfg->levels[i];
		} else if(strcasecmp(cfg->skills[i], "trader") == 0) {
			ctl = trader;
			val = cfg->levels[i];
		}

		if(ctl != NULL) {
			sprintf(lbuff, "%d", val);
			ctl->SetValue(lbuff);
		}
	}

	if(cfg->full_book7)
		b7->SetValue(TRUE);
	if(cfg->enhanced)
		enh->SetValue(TRUE);
	// get input
	if(wxID_CANCEL == ShowModal())
		return(FALSE);

	// get data from controls
	wxBeginBusyCursor();
	str = src_sect->GetValue();
	ptr = (char *) str.GetData();
	if(cfg->src_name != NULL) {
		delete cfg->src_name;
		cfg->src_name = NULL;
	}
	cfg->src_name = new char[strlen(ptr) + 1];
	strcpy(cfg->src_name, ptr);

	str = src_loc->GetValue();
	ptr = (char *) str.GetData();
	i = atoi(ptr);
	cfg->src.hex_x = (i / 100);
	cfg->src.hex_y = (i - (cfg->src.hex_x * 100));
	cfg->src.hex_x--;
	cfg->src.hex_y--;

	str = init_day->GetValue();
	ptr = (char *) str.GetData();
	cfg->init_date.day = atoi(ptr);
	str = init_year->GetValue();
	ptr = (char *) str.GetData();
	cfg->init_date.year = atoi(ptr);

	// XXX
	for(i = 0;i < MAX_TRADE_SKILLS; i++) {
		cfg->levels[i] = 0;
		if(NULL == cfg->skills[i])
			continue;

		delete cfg->skills[i];
		cfg->skills[i] = NULL;
	}

	i = 0;
	str = admin->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Admin") + 1];
		strcpy(cfg->skills[i], "Admin");
		cfg->levels[i] = atoi(ptr);
		i++;
	}
	str = bribery->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Bribery") + 1];
		strcpy(cfg->skills[i], "Bribery");
		cfg->levels[i] = atoi(ptr);
		i++;
	}
	str = broker->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Broker") + 1];
		strcpy(cfg->skills[i], "Broker");
		cfg->levels[i] = atoi(ptr);
		i++;
	}
	str = liaison->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Liaison") + 1];
		strcpy(cfg->skills[i], "Liaison");
		cfg->levels[i] = atoi(ptr);
		i++;
	}
	str = carousing->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Carousing") + 1];
		strcpy(cfg->skills[i], "Carousing");
		cfg->levels[i] = atoi(ptr);
		i++;
	}
	str = steward->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Steward") + 1];
		strcpy(cfg->skills[i], "Steward");
		cfg->levels[i] = atoi(ptr);
		i++;
	}
	str = streetwise->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Streetwise") + 1];
		strcpy(cfg->skills[i], "Streetwise");
		cfg->levels[i] = atoi(ptr);
		i++;
	}
	str = trader->GetValue();
	ptr = (char *) str.GetData();
	if((ptr != NULL) && (ptr[0] != 0)) {
		cfg->skills[i] = new char[strlen("Trader") + 1];
		strcpy(cfg->skills[i], "Trader");
		cfg->levels[i] = atoi(ptr);
		i++;
	}

	cfg->full_book7 = b7->GetValue();
	cfg->enhanced = enh->GetValue();

	wxEndBusyCursor();

	return(TRUE);
}

