/////////////////////////////////////////////////////////////////////////////
// Name:        sector.cpp
// Purpose:     Traveller sector mapping 
// Author:      Mark A. Nordstrand
// Modified by:
// Created:     07/22/98
// Copyright: LGPL.
//            Traveller is a registered trademark of Far Future Enterprises.
/////////////////////////////////////////////////////////////////////////////

// RCS-ID:      "$RCSfile: sector.cpp,v $ $Revision: 1.40 $ $Author: man $ $Date: 2003/05/04 02:36:48 $"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"


#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include <ctype.h>
#include <libgen.h>
#include "sector.h"
#include "t_res.h"
#include "t_help.h"

// =========================================================================
// defines for windows
#define MAX_STATUS_BOX		4

#define NO_RESIZE_FRAME		wxCAPTION | wxTHICK_FRAME
#define RESIZE_FRAME		NO_RESIZE_FRAME | wxRESIZE_BORDER | wxMINIMIZE_BOX

// -------------------------------------------------------------------------
// misc drawing defines
#define ROUTE_WIDTH				5
#define ROUTE_STYLE				wxSOLID

#define DEFAULT_PEN_WIDTH		3

#define HEX_IMAGE_X				(HEX_X_CENTER - (HEX_CENTER_WIDTH / 2))
#define HEX_IMAGE_Y				(HEX_Y_CENTER - (HEX_CENTER_WIDTH / 2))

#define HEX_IMAGE_CENTER_X		(HEX_IMAGE_X + (HEX_CENTER_WIDTH / 2))
#define HEX_IMAGE_CENTER_Y		(HEX_IMAGE_Y + (HEX_CENTER_WIDTH / 2))

// defines for menus
#define	MAX_FILES				4

// -------------------------------------------------------------------------
// defines for map drawing
#define X_COUNT					32
#define Y_COUNT					40

#define HEX_MAP_X_SIZE			((HEX_BORDER_X_OFFSET * 2) + ((HEX_X_OFFSET + HEX_X_3) * (X_COUNT / 2)) + 1)
#define HEX_MAP_Y_SIZE			((HEX_BORDER_Y_OFFSET * 2) + (HEX_Y_4 * Y_COUNT) + HEX_Y_OFFSET + 1)


// -------------------------------------------------------------------------
// menu defines
#define USER_ID_OFFSET		10000

typedef enum {
	SECTOR_NEW=101,
	SECTOR_OPEN,
	SECTOR_SAVE,
	SECTOR_PRINT,
	SECTOR_CONFIG,
	SECTOR_ABOUT,
	SECTOR_EXIT,
// dummy one for parsing the command line
	SECTOR_COMMAND_LINE,

	SECTOR_FILE1,
	SECTOR_FILE2,
	SECTOR_FILE3,
	SECTOR_FILE4,
	SECTOR_FILE5,

	SECTOR_HEX,
	SECTOR_SECTOR,
	SECTOR_MODE,
	SECTOR_FILE_EDIT,

	SECTOR_HEX_SELECT,
	SECTOR_HEX_WORLD,
	SECTOR_HEX_VIEW,
	SECTOR_HEX_ROUTE,
	SECTOR_HEX_TRADE,
//	SECTOR_HEX_CP,
	SECTOR_HEX_BORDER,
	SECTOR_HEX_DETAIL,
	SECTOR_HEX_ENC,
	SECTOR_HEX_ADD,
	SECTOR_HEX_DEL,
//	SECTOR_HEX_EDIT,

	SECTOR_FEDIT_SS,
	SECTOR_FEDIT_DAT,
	SECTOR_FEDIT_SEC,
	SECTOR_FEDIT_VIEW,
	SECTOR_FEDIT_ROUTE,
	SECTOR_FEDIT_BORDER,
	SECTOR_FEDIT_SEARCH,

// special map modes
	SECTOR_MAP_MODE,
	SECTOR_BORDER_MODE,
	SECTOR_ROUTE_MODE,
	SECTOR_BORDER_MODE2,

	SECTOR_SEARCH,
	SECTOR_SEARCH_RANGES,
	SECTOR_SEARCH_TRADE,
	SECTOR_SEARCH_SHORT,

	SECTOR_VIEW_DETAIL,
	SECTOR_VIEW_MAP,
	SECTOR_VIEW_LIST,
//	SECTOR_VIEW_TILE,

	SECTOR_HEX_NOTES,
	SECTOR_FEDIT_NOTES,
	SECTOR_FEDIT_SS_NOTES,
	SECTOR_EDIT_HEX,
	SECTOR_ADD_HEX,
	SECTOR_DEL_HEX,

	SECTOR_FEDIT_SECTOR,
	SECTOR_FEDIT_HEX,
	ID_USER1,								// dummy sector menu event
	ID_USER2=(ID_USER1 + USER_ID_OFFSET),	// real sector menu events
	ID_USER3=(ID_USER2 + USER_ID_OFFSET),	// dummy hex menu event
	ID_USER4=(ID_USER3 + USER_ID_OFFSET)	// real hex menu events
};

#define ID_TOOLBAR		500

// map the popup menus to regular menus
#define POPUP_SELECT			SECTOR_HEX_SELECT
#define POPUP_WORLD				SECTOR_HEX_WORLD
#define POPUP_ROUTE				SECTOR_HEX_ROUTE
#define POPUP_VIEW				SECTOR_HEX_VIEW
#define POPUP_BORDER			SECTOR_HEX_BORDER
#define POPUP_DETAIL			SECTOR_HEX_DETAIL
#define POPUP_ENC				SECTOR_HEX_ENC
#define POPUP_TRADE				SECTOR_HEX_TRADE
//#define POPUP_CP				SECTOR_HEX_CP
#define POPUP_HEX_NOTES			SECTOR_HEX_NOTES
#define POPUP_EDIT_HEX			SECTOR_EDIT_HEX
#define POPUP_ADD_HEX			SECTOR_ADD_HEX
#define POPUP_DEL_HEX			SECTOR_DEL_HEX

#define POPUP_SS				SECTOR_FEDIT_SS
#define POPUP_EDIT_ROUTE		SECTOR_FEDIT_ROUTE
#define POPUP_EDIT_VIEW			SECTOR_FEDIT_VIEW
#define POPUP_EDIT_BORDER		SECTOR_FEDIT_BORDER
#define POPUP_NOTES				SECTOR_FEDIT_NOTES
#define POPUP_SS_NOTES			SECTOR_FEDIT_SS_NOTES
//#define POPUP_EDIT_ROUTE		SECTOR_ROUTE_MODE
//#define POPUP_EDIT_BORDER		SECTOR_BORDER_MODE

#define POPUP_SEARCH			SECTOR_SEARCH
#define POPUP_SEARCH_RANGE		SECTOR_SEARCH_RANGES
#define POPUP_SEARCH_TRADE		SECTOR_SEARCH_TRADE
#define POPUP_SEARCH_SHORT		SECTOR_SEARCH_SHORT

#define POPUP_BASES				SECTOR_GLOBAL_BASES
#define POPUP_CODES				SECTOR_GLOBAL_CODES
#define POPUP_ALLEG				SECTOR_GLOBAL_ALLEG

#define POPUP_HEX				SECTOR_HEX
#define POPUP_SECTOR			SECTOR_SECTOR
#define POPUP_MODE				SECTOR_MODE	

#define POPUP_SECTOR_EDIT		SECTOR_FEDIT_SECTOR
#define POPUP_HEX_EDIT			SECTOR_FEDIT_HEX

// =========================================================================
// globals (ugh)
SectorApp *app;
MainFrame *frame = NULL;
wxMenuBar *menu_bar = NULL;

// -------------------------------------------------------------------------
static wxFont *textHeaderFont;
static wxFont *textWindowFont;
static wxFont *NormalFont;
static wxFont *UnderlineFont;
static wxFont *BoldFont;

// -------------------------------------------------------------------------
// handle the width of the status box sections
int status_widths[MAX_STATUS_BOX] =
	{ -1, 64, 64, 64 };

// -------------------------------------------------------------------------
// a table for the menu(s)
//  some quick notes (since I tripped on this a couple of times):
//  the first MAX_BUTTONS of these are used for the button bar
//  add new stuff at the bottom
#define MAX_BUTTONS		21
static struct MENU_STRUCT {
	int		id;
	char	*desc;
	char	*short_help;
	char	*long_help;
} menu_struct[] = {
// follow the buttons, not the menus......
 { SECTOR_OPEN, 		"&Open",		"Open",			"Open a Sector" },
 { SECTOR_SAVE, 		"&Save",		"Save",			"Save Sector" },
 { SECTOR_PRINT, 		"&Print",		"Print",		"Print Sector" },
 { SECTOR_CONFIG, 		"&Configure",	"Config",		"Configure Global Parameters" },
 { SECTOR_ABOUT,		"&About",		"About",		"About MTU" },
 { SECTOR_EXIT, 		"E&xit",		"Exit",			"Exit Program" },
 { SECTOR_VIEW_DETAIL, 	"&Detail",		"Detail",		"Show the Detail Window" },
 { SECTOR_VIEW_MAP, 	"&Map",			"Map",			"Show the Map Window" },
 { SECTOR_VIEW_LIST, 	"&Listing",		"Listing",		"Show the Listing Window" },
// { SECTOR_VIEW_TILE, 	"&Tile",		"Tile",			"Tile Display Windows" },
 { SECTOR_FEDIT_SS,		"&S/S",			"Subsector",	"Define Subsector Names" },
 { SECTOR_FEDIT_VIEW,	"&View",		"View",			"Define View For This Sector" },
 { SECTOR_FEDIT_ROUTE,	"&Routes",		"Routes",		"Define Routes in This Sector" },
 { SECTOR_FEDIT_BORDER,	"&Borders",		"Borders",		"Define Borders in This Sector" },
 { SECTOR_FEDIT_SEARCH,	"&Search",		"Search",		"Search for Worlds" },
 { SECTOR_HEX_SELECT, 	"&Select",		"Hex",			"Select a Hex" },
 { SECTOR_HEX_VIEW, 	"&View",		"View",			"Specify View For This Hex" },
 { SECTOR_HEX_ROUTE, 	"&Route",		"Route",		"Specify a Route" },
 { SECTOR_HEX_BORDER, 	"&Border",		"Border",		"Specify a Border" },
 { SECTOR_HEX_DETAIL, 	"&Detail",		"Detail",		"Generate/Edit Detail" },
 { SECTOR_HEX_ENC, 		"En&counters",	"Encounters",	"Generate Encounters" },
 { SECTOR_HEX_TRADE,	"&Trade",		"Trade",		"Check Trade" },
// { SECTOR_HEX_CP,		"&CP",			"CP",			"Specify a CP" },
 { SECTOR_SEARCH,       "&Search",		"Search",		"Search For Worlds" },
 { SECTOR_SEARCH_RANGES,"&Range",		"Range",		"Search With Ranges" },
 { SECTOR_SEARCH_SHORT, "&Short",		"Short",		"Search With UWP Codes" },
 { SECTOR_SEARCH_TRADE, "&Trade",		"Trade",		"Search With Trade Codes" },
 { SECTOR_ROUTE_MODE,	"&Routes",		"Routes",		"Define Routes in This Sector" },
 { SECTOR_BORDER_MODE,	"&Borders",		"Borders",		"Define Borders in This Sector" },
 { SECTOR_FEDIT_NOTES,	"&Notes",		"Notes",		"Edit Sector Notes" },
 { SECTOR_FEDIT_SS_NOTES,"S/S N&otes",	"SS Notes",		"Edit SubSector Notes" },
 { SECTOR_HEX_NOTES,	"&Hex Notes",	"Hex Notes",	"Edit Hex Notes" },
 { SECTOR_EDIT_HEX,		"He&x",			"Hex",			"Edit Hex" },
 { SECTOR_ADD_HEX,		"&Add",			"Add",			"Add Hex" },
 { SECTOR_DEL_HEX,		"&Delete",		"Delete",		"Delete Hex" },
 { 0,					NULL,			NULL,			NULL }
};

// -------------------------------------------------------------------------
static char border_map[MAX_X_HEX][MAX_Y_HEX];

// -------------------------------------------------------------------------
// button labels for GTK
#ifndef __WXMSW__
#include "bitmaps/attr.xpm"
#include "bitmaps/brdr_hex.xpm"
#include "bitmaps/config.xpm"
#include "bitmaps/eye.xpm"
//#include "bitmaps/cp.xpm"
#include "bitmaps/cargo.xpm"
#include "bitmaps/critter.xpm"
//#include "bitmaps/detail.xpm"
#include "bitmaps/exit.xpm"
#include "bitmaps/help.xpm"
//#include "bitmaps/list.xpm"
#include "bitmaps/mag.xpm"
//#include "bitmaps/map.xpm"
#include "bitmaps/one_hex.xpm"
#include "bitmaps/open.xpm"
#include "bitmaps/print.xpm"
#include "bitmaps/rt_hex.xpm"
#include "bitmaps/save.xpm"
#include "bitmaps/sbrdr.xpm"
#include "bitmaps/sector.xpm"
#include "bitmaps/sml_hex.xpm"
#include "bitmaps/sroute.xpm"
#include "bitmaps/ssearch.xpm"
#include "bitmaps/subsect.xpm"
#endif

#ifdef TEST_FRAME
class TestCanvas : public wxScrolledWindow
{
public:
    TestCanvas(wxWindow *frame, 
			int x=-1, int y=-1, int w=-1, int h=-1, long style = wxRETAINED);
	~TestCanvas(void) {};

	void OnDraw(wxDC& dc);
	void OnEvent(wxMouseEvent& event);

DECLARE_EVENT_TABLE()
};

Sub_Frame *test_frame=NULL;
#endif

// -------------------------------------------------------------------------
IMPLEMENT_APP(SectorApp)

// =========================================================================
// app
bool 
SectorApp::OnInit(void)
{
	app = this;

	// Create fonts
	textHeaderFont = new wxFont(14, wxMODERN, wxNORMAL, wxBOLD);
	textWindowFont = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL);
	UnderlineFont = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL);
	NormalFont = new wxFont(11, wxSWISS, wxNORMAL, wxNORMAL);
	BoldFont = new wxFont(12, wxSWISS, wxNORMAL, wxBOLD);

	// create the main window
#ifdef SEPERATE_WINDOWS
	frame = new MainFrame(NULL, "Sector Editor", 0, 0, 503, 78,
		NO_RESIZE_FRAME);
#else
	frame = new MainFrame(NULL, "Sector Editor", 0, 0, 503, 330);
#endif
//	// dummy panel (seems wxGTK blows up without a child window....
	(void) new DummyPanel(frame);
	frame->CreateStatusBar(MAX_STATUS_BOX);
	frame->SetStatusWidths(MAX_STATUS_BOX, status_widths);
	frame->CreateToolBar(wxNO_BORDER | wxHORIZONTAL | wxTB_DOCKABLE, 
			ID_TOOLBAR);
	frame->InitButtons(frame->GetToolBar());
	frame->CreateMenus();
#ifdef __WINDOWS__
	frame->SetIcon(wxIcon("sector_icn"));
#endif
#ifdef __WXGTK__
	frame->SetIcon(wxIcon(sector_xpm));
#endif

#ifndef SEPERATE_WINDOWS
	// make a canvas to draw on
	frame->canvas = new SectorCanvas(frame);
	frame->canvas->SetScrollbars(HEX_X_2, HEX_Y_4, 
				X_COUNT+1, Y_COUNT+1, 0, 0);
	frame->canvas->SetBackgroundColour(*wxWHITE);
	frame->Fit();
#endif

#ifdef SEPERATE_WINDOWS
	// make the text window
    frame->list_frame = new Sub_Frame(NULL, "Listing", 
			100, 100, 400, 300, RESIZE_FRAME);
	frame->list_frame->canvas = new SectorText(frame->list_frame,
			100, 100, 430, 200, wxRETAINED);
	frame->list_frame->canvas->SetScrollbars(16, 12, 200, 500, 0, 0);
	frame->list_frame->canvas->SetBackgroundColour(*wxWHITE);
	frame->list_frame->Fit();
#ifdef __WINDOWS__
	frame->list_frame->SetIcon(wxIcon("list_icn"));
#endif
#ifdef __WXGTK__
	frame->list_frame->SetIcon(wxIcon(sector_xpm));
#endif

	// make the detail text window
    frame->detail_frame = new Sub_Frame(NULL, "Detail", 
			100, 100, 400, 300, NO_RESIZE_FRAME);
	frame->detail_frame->canvas = new DetailText(frame->detail_frame,
			100, 100, 450, 180, wxRETAINED);
	frame->detail_frame->canvas->SetBackgroundColour(*wxWHITE);
	frame->detail_frame->Fit();
#ifdef __WINDOWS__
	frame->detail_frame->SetIcon(wxIcon("detail_icn"));
#endif
#ifdef __WXGTK__
	frame->detail_frame->SetIcon(wxIcon(sector_xpm));
#endif

	// make the map frame
	frame->map_frame = new MapFrame(NULL, "Map", 
			100, 100, 400, 300, RESIZE_FRAME);
	frame->map_frame->canvas = new MapCanvas(frame->map_frame, 
// why does motif need these values:
			100, 100, 400, 300, wxRETAINED);
	frame->map_frame->canvas->SetScrollbars(HEX_X_2, HEX_Y_4, 
				//X_COUNT+1, Y_COUNT+1, 8, 10);
				X_COUNT+1, Y_COUNT+2, 0, 0);
	frame->map_frame->canvas->SetBackgroundColour(*wxWHITE);
	frame->map_frame->Fit();
#ifdef __WINDOWS__
	frame->map_frame->SetIcon(wxIcon("map_icn"));
#endif
#ifdef __WXGTK__
	frame->map_frame->SetIcon(wxIcon(sector_xpm));
#endif
#endif

#ifdef TEST_FRAME
	// make the text window
    test_frame = new Sub_Frame(NULL, "Testing 1,2,3", 
			100, 100, 400, 300, RESIZE_FRAME);
	test_frame->canvas = new TestCanvas(test_frame,
			100, 100, 430, 200, wxRETAINED);
	test_frame->canvas->SetScrollbars(16, 12, 200, 500, 0, 0);
	test_frame->canvas->SetBackgroundColour(*wxWHITE);
	test_frame->Fit();
	test_frame->Show(TRUE);
#endif

	// check argc and argv:
	if(argc > 1)
		frame->LoadFile(argv[1], TRUE);

	frame->SetModeMenu();
	frame->Show(TRUE);
	SetTopWindow(frame);

#ifdef SEPERATE_WINDOWS
	frame->map_frame->Show(FALSE);
	frame->list_frame->Show(FALSE);
	frame->detail_frame->Show(FALSE);

	frame->SetSubWindows(ENTRY_SECTOR_LIST, 
			frame->list_frame, SECTOR_VIEW_LIST);
	frame->SetSubWindows(ENTRY_SECTOR_DETAIL, 
			frame->detail_frame, SECTOR_VIEW_DETAIL);
	frame->SetSubWindows(ENTRY_SECTOR_MAP, 
			frame->map_frame, SECTOR_VIEW_MAP);
#endif


	return(TRUE);
}

int
SectorApp::OnExit(void)
{
wxWindow *w;

	while((w = GetTopWindow()) != NULL)
		delete w;
	return(0);
}

// ============================================================================
// ============================================================================
DummyPanel::DummyPanel(wxWindow *p) :
	wxPanel(p, -1, wxPoint(0,0), wxSize(-1, 1))
{
}

void 
DummyPanel::OnSize(wxSizeEvent& event)
{
int w,h;

//	wxPanel::OnSize(event);
	GetSize(&w, &h);
	SetSize(w, 1);
}
// ============================================================================
BEGIN_EVENT_TABLE(MainFrame, wxFrame)
	EVT_MENU(SECTOR_FILE1, MainFrame::LoadFile1)
	EVT_MENU(SECTOR_FILE2, MainFrame::LoadFile2)
	EVT_MENU(SECTOR_FILE3, MainFrame::LoadFile3)
	EVT_MENU(SECTOR_FILE4, MainFrame::LoadFile4)
	EVT_MENU(SECTOR_FILE5, MainFrame::LoadFile5)
	EVT_MENU(SECTOR_OPEN, MainFrame::SelectFile)
	EVT_MENU(SECTOR_SAVE, MainFrame::SaveSec)
	EVT_MENU(SECTOR_CONFIG, MainFrame::Config)
	EVT_MENU(SECTOR_ABOUT, MainFrame::OnAbout)
	EVT_MENU(SECTOR_PRINT, MainFrame::Print)
	EVT_MENU(SECTOR_EXIT, MainFrame::Quit)
	EVT_MENU(SECTOR_VIEW_DETAIL, MainFrame::ToggleDetail)
	EVT_MENU(SECTOR_VIEW_MAP, MainFrame::ToggleMap)
	EVT_MENU(SECTOR_VIEW_LIST, MainFrame::ToggleList)
	EVT_MENU(SECTOR_FEDIT_SS, MainFrame::EditSS)
	EVT_MENU(SECTOR_FEDIT_ROUTE, MainFrame::ChooseRoute)
	EVT_MENU(SECTOR_FEDIT_BORDER, MainFrame::ChooseBorder)
	EVT_MENU(SECTOR_FEDIT_SEARCH, MainFrame::GeneralSearch)
	EVT_MENU(SECTOR_FEDIT_VIEW, MainFrame::SectorView)
	EVT_MENU(SECTOR_HEX_SELECT, MainFrame::SelectHex)
	EVT_MENU(SECTOR_HEX_BORDER, MainFrame::EditBorder)
	EVT_MENU(SECTOR_HEX_ROUTE, MainFrame::EditRoute)
	EVT_MENU(SECTOR_HEX_VIEW, MainFrame::HexView)
	EVT_MENU(SECTOR_HEX_DETAIL, MainFrame::ExecDetail)
	EVT_MENU(SECTOR_HEX_ENC, MainFrame::ExecEnc)
	EVT_MENU(SECTOR_HEX_TRADE, MainFrame::ExecTrade)
//	EVT_MENU(SECTOR_HEX_CP, MainFrame::SelectCP)

	EVT_MENU(SECTOR_SEARCH_TRADE, MainFrame::SearchTrade)
	EVT_MENU(SECTOR_SEARCH_SHORT, MainFrame::SearchShort)
	EVT_MENU(SECTOR_SEARCH_RANGES, MainFrame::SearchRange)

	EVT_MENU(SECTOR_HEX_NOTES, MainFrame::HexNotes)
	EVT_MENU(SECTOR_FEDIT_SS_NOTES, MainFrame::SSectorNotes)
	EVT_MENU(SECTOR_FEDIT_NOTES, MainFrame::SectorNotes)
	EVT_MENU(SECTOR_EDIT_HEX, MainFrame::EditHex)
	EVT_MENU(SECTOR_ADD_HEX, MainFrame::HexAdd)
	EVT_MENU(SECTOR_DEL_HEX, MainFrame::HexDel)

	EVT_MENU_RANGE(ID_USER2, ID_USER2 + USER_ID_OFFSET, MainFrame::OnUser1)
	EVT_MENU_RANGE(ID_USER4, ID_USER4 + USER_ID_OFFSET, MainFrame::OnUser2)

	EVT_CLOSE(MainFrame::OnCloseWindow)

	EVT_TOOL_ENTER(500, MainFrame::OnToolEnter)
END_EVENT_TABLE()

// Define my frame constructor
MainFrame::MainFrame(wxFrame *frame, char *title, int x, int y, int w, int h,
		unsigned long s) :
	wxFrame(frame, -1, title, wxPoint(x, y), wxSize(w, h), s)
{
wxConfig *config;

#ifdef SEPERATE_WINDOWS
// app creates these 
	map_frame = NULL;
	detail_frame = NULL;
	list_frame = NULL;
#endif

	search_dlg = NULL;
// dialogs
	hex_dialog = NULL;
	ss_dialog = NULL;
	ec_dialog = NULL;
	sect_color_dialog = new SectColorDialog(this);
	route_dialog = new HexRouteDialog(this);
	border_dialog = NULL;
//	cp_dialog = NULL;
	print_dialog = NULL;
//	system_dialog = NULL;
	code_dialog = NULL;
	sss_dialog = NULL;
	world_dialog = NULL;
	fmt_dialog = NULL;

	user_smenu = NULL;
	user_hmenu = NULL;

// local stuff
	cur_x = cur_y = -1;
	view_mode = VM_map;

	dirs = new MTUFile();
	config = dirs->GetConfig();

	// create the global resources
	bitmaps = new BitmapList(config);

	colors = new ColorArray(config);

	codes = new TCodes(dirs->GetMTUDataDir());
	BuildBitmapList(codes);
	sect = new DetailSector(codes);
}

MainFrame::~MainFrame()
{
//	delete wxConfigBase::Set((wxConfigBase *) NULL);
	if(bitmaps != NULL)
		delete bitmaps;
	if(colors != NULL)
		delete colors;
	if(codes != NULL)
		delete codes;
	if(dirs != NULL)
		delete dirs;
}

//bool 
//MainFrame::OnClose(void)
void
MainFrame::OnCloseWindow(wxCloseEvent &event)
{
#ifdef SEPERATE_WINDOWS
char lbuff[2];
#endif
GenericParse gp;
wxString ptr;
int i,j;
char temp_str[MAX_FILE_LENGTH];
char *ptr1;
wxMenuItem *mn;
wxConfig *config;

	config = dirs->GetConfig();
//	wxConfigBase::Set(config);
//	wxConfigBase::Get();

	j = 0;
	for(i = 0; i < MAX_FILES;i++) {
		char *ptr2;

		mn = file_menu->FindItem(SECTOR_FILE1 + j);
		if((NULL == mn) || ((ptr1 = (char *)mn->GetText().GetData()) == NULL))
			continue;
		// WTF?????
		while((ptr2 = strchr(ptr1, '\\')) != NULL) {
			*ptr2 = '/';
		}
		sprintf(temp_str, "%s/%s%d", SECTION_HISTORY, ENTRY_SECT_FILES, j+1);
		config->Write((const wxString) temp_str, (const wxString) ptr1);
		j++;
	}

#ifdef SEPERATE_WINDOWS
	lbuff[1] = 0;
	if(frame->list_frame->IsShown())
		lbuff[0] = 'T';
	else
		lbuff[0] = 'F';
	config->Write((const wxString) "/"SECTION_DISPLAY"/"ENTRY_SECTOR_LIST,
			(const wxString) lbuff);

	if(frame->detail_frame->IsShown())
		lbuff[0] = 'T';
	else
		lbuff[0] = 'F';
	config->Write((const wxString) "/"SECTION_DISPLAY"/"ENTRY_SECTOR_DETAIL,
			(const wxString) lbuff);

	if(frame->map_frame->IsShown())
		lbuff[0] = 'T';
	else
		lbuff[0] = 'F';
	config->Write((const wxString) "/"SECTION_DISPLAY"/"ENTRY_SECTOR_MAP,
			(const wxString) lbuff);

//	if(mode & MODE_FLAG_DAT_READONLY)
//		temp_str[0] = 'T';
//	else
//		temp_str[0] = 'F';
//	wxWriteResource(SECTION_READONLY, ENTRY_DAT, temp_str, 
//		RESOURCE_FILE);
//
//	if(mode & MODE_FLAG_SEC_READONLY)
//		temp_str[0] = 'T';
//	else
//		temp_str[0] = 'F';
//	wxWriteResource(SECTION_READONLY, ENTRY_SEC, temp_str, 
//		RESOURCE_FILE);

	map_frame->Show(FALSE);
	map_frame->Close(TRUE);
	detail_frame->Show(FALSE);
	detail_frame->Close(TRUE);
	list_frame->Show(FALSE);
	list_frame->Close(TRUE);
//	search_frame->Show(FALSE);
//	search_frame->Close(TRUE);
#endif

	Show(FALSE);

	app->OnExit();
}

void 
MainFrame::Draw(wxDC& dc, bool draw_bitmaps)
{
  dc.SetPen(*wxGREEN_PEN);
  dc.DrawLine(0, 0, 200, 200);
  dc.DrawLine(200, 0, 0, 200);

  dc.SetBrush(*wxCYAN_BRUSH);
  dc.SetPen(*wxRED_PEN);

  dc.DrawRectangle(100, 100, 100, 50);
  dc.DrawRoundedRectangle(150, 150, 100, 50,20);

  dc.DrawEllipse(250, 250, 100, 50);
  dc.DrawSpline(50, 200, 50, 100, 200, 10);
  dc.DrawLine(50, 230, 200, 230);

  dc.SetPen(*wxBLACK_PEN);
  dc.DrawArc(50, 300, 100, 250, 100, 300);
}

void
MainFrame::DrawDetail(wxDC& dc, HexData *hd)
{
MainWorldDisplay *sd;

	dc.Clear();

	sd = new MainWorldDisplay(&dc);
	sd->Start();
	sd->DrawDetail(hd, codes);

    delete sd;
}

// --------------------------------------------------------------------------
void
MainFrame::CreateMenus(void)
{
int i,j;
char str[MAX_FILE_LENGTH];
GenericParse gp;
wxString ptr;
wxConfig *config;
#ifdef POPUP_MENUS
wxMenu *mode,*sector,*hex,*search,*hex_edit,*sector_edit;
#endif

	config = dirs->GetConfig();
	// Make a menubar
#ifdef SECT_MENUS
	//	file
	file_menu = new wxMenu;
	AddToMenu(file_menu, SECTOR_OPEN);
	AddToMenu(file_menu, SECTOR_SAVE);
	file_menu->AppendSeparator();
	AddToMenu(file_menu, SECTOR_PRINT);
	file_menu->AppendSeparator();
	AddToMenu(file_menu, SECTOR_CONFIG);
	file_menu->AppendSeparator();
	AddToMenu(file_menu, SECTOR_EXIT);

	j = 0;
	for(i = 0;i < MAX_FILES;i++) {
		ptr = "";
		sprintf(str, "/%s/%s%d", SECTION_HISTORY, ENTRY_SECT_FILES, i+1);
		if(!config->Read((const wxString) str, &ptr))
			break;

		if(j == 0)
			file_menu->AppendSeparator();
		file_menu->Append(SECTOR_FILE1+i, ptr,
					"Load Previous File");
		j++;
	}

	// view
	view_menu = new wxMenu;
	AddToMenu(view_menu, SECTOR_VIEW_DETAIL);
	AddToMenu(view_menu, SECTOR_VIEW_MAP);
	AddToMenu(view_menu, SECTOR_VIEW_LIST);
//	AddToMenu(view_menu, SECTOR_VIEW_DETAIL, TRUE);
//	AddToMenu(view_menu, SECTOR_VIEW_MAP, TRUE);
//	AddToMenu(view_menu, SECTOR_VIEW_LIST, TRUE);
//	AddToMenu(view_menu, SECTOR_VIEW_TILE, TRUE);

#if 0
	// edit
	edit_menu = new wxMenu;
	AddToMenu(edit_menu, SECTOR_FEDIT_NOTES);
	AddToMenu(edit_menu, SECTOR_FEDIT_SS_NOTES);
	AddToMenu(edit_menu, SECTOR_HEX_NOTES);
	AddToMenu(edit_menu, SECTOR_EDIT_HEX);
#endif

	// sector edit
	sector_edit_menu = new wxMenu;
	AddToMenu(sector_edit_menu, SECTOR_FEDIT_NOTES);
	AddToMenu(sector_edit_menu, SECTOR_FEDIT_SS_NOTES);
	AddToMenu(sector_edit_menu, SECTOR_FEDIT_SS);

	// sector 
	sector_menu = new wxMenu;
	AddToMenu(sector_menu, SECTOR_FEDIT_VIEW);
	AddToMenu(sector_menu, SECTOR_FEDIT_ROUTE);
	AddToMenu(sector_menu, SECTOR_FEDIT_BORDER);
	sector_menu->Append(SECTOR_FEDIT_SECTOR, "&Edit", sector_edit_menu);

	// sector search
	search_menu = new wxMenu;
	AddToMenu(search_menu, SECTOR_SEARCH_RANGES);
	AddToMenu(search_menu, SECTOR_SEARCH_TRADE);
	AddToMenu(search_menu, SECTOR_SEARCH_SHORT);

	// sector edit
	hex_edit_menu = new wxMenu;
	AddToMenu(hex_edit_menu, SECTOR_HEX_NOTES);
	AddToMenu(hex_edit_menu, SECTOR_EDIT_HEX);
	AddToMenu(hex_edit_menu, SECTOR_ADD_HEX);
	AddToMenu(hex_edit_menu, SECTOR_DEL_HEX);

	// Hex edits
	hex_menu = new wxMenu;
	AddToMenu(hex_menu, SECTOR_HEX_SELECT);
	hex_menu->AppendSeparator();
	AddToMenu(hex_menu, SECTOR_HEX_VIEW);
	AddToMenu(hex_menu, SECTOR_HEX_ROUTE);
	AddToMenu(hex_menu, SECTOR_HEX_BORDER);
//	AddToMenu(hex_menu, SECTOR_HEX_CP);
	hex_menu->AppendSeparator();
	AddToMenu(hex_menu, SECTOR_HEX_DETAIL);
	AddToMenu(hex_menu, SECTOR_HEX_ENC);
	AddToMenu(hex_menu, SECTOR_HEX_TRADE);
	hex_menu->AppendSeparator();
	hex_menu->Append(SECTOR_FEDIT_HEX, "&Edit", hex_edit_menu);

	//  help
	wxMenu *help_menu = new wxMenu;
	AddToMenu(help_menu, SECTOR_ABOUT);

	menu_bar = new wxMenuBar(wxMB_DOCKABLE);
	menu_bar->Append(file_menu,   "&File");
//	menu_bar->Append(edit_menu,   "&Edit");
	menu_bar->Append(view_menu,   "&View");
	menu_bar->Append(sector_menu, "&Sector");
	menu_bar->Append(search_menu, "&Search");
	menu_bar->Append(hex_menu,    "&Hex");
	menu_bar->Append(help_menu,    "&Help");

	// Associate the menu bar with the frame
	SetMenuBar(menu_bar);

#endif
#ifdef POPUP_MENUS
	// create the popup menus
	popup = new wxMenu();

	mode = new wxMenu;
	mode->Append(SECTOR_MAP_MODE, "Map");
	mode->Append(SECTOR_BORDER_MODE, "Border");
	mode->Append(SECTOR_ROUTE_MODE, "Route");
	mode->Append(SECTOR_BORDER_MODE2, "Border2");

	sector_edit = new wxMenu;
	sector_edit->Append(SECTOR_FEDIT_NOTES, "Notes");
	sector_edit->Append(SECTOR_FEDIT_SS_NOTES, "S/S Notes");
	sector_edit->Append(POPUP_SS, "S/S Names");

	sector = new wxMenu;
	sector->Append(POPUP_EDIT_VIEW, "View");
	sector->Append(POPUP_EDIT_ROUTE, "Routes");
	sector->Append(POPUP_EDIT_BORDER, "Borders");
	sector->Append(POPUP_SECTOR_EDIT, "Edit", sector_edit);

	search = new wxMenu;
	search->Append(POPUP_SEARCH_RANGE, "Range");
	search->Append(POPUP_SEARCH_TRADE, "Trade");
	search->Append(POPUP_SEARCH_SHORT, "Short");


	hex_edit = new wxMenu;
	hex_edit->Append(POPUP_EDIT_HEX, "Hex");
	hex_edit->Append(POPUP_ADD_HEX, "Add");
	hex_edit->Append(POPUP_DEL_HEX, "Delete");
	hex_edit->Append(POPUP_HEX_NOTES, "Notes");

	hex = new wxMenu;
//	hex->Append(POPUP_CP, "CP");
	hex->Append(POPUP_DETAIL, "Detail");
	hex->Append(POPUP_ENC, "Enc.");
	hex->Append(POPUP_TRADE, "Trade");
	hex->Append(POPUP_VIEW, "View");
	hex->Append(POPUP_ROUTE, "Routes");
	hex->Append(POPUP_BORDER, "Borders");
	hex->Append(POPUP_HEX_EDIT, "Edit", hex_edit);

	popup->Append(POPUP_MODE, "Mode", mode);
	popup->Append(POPUP_SECTOR, "Sector", sector);
	popup->Append(POPUP_SEARCH, "Search", search);
	popup->Append(POPUP_SELECT, "Select");
	popup->Append(POPUP_HEX, "Hex", hex);
	
#endif
}

#ifdef SEPERATE_WINDOWS
void
MainFrame::SetSubWindows(char *entry, SubFrame *f, 
		int menu_id)
{
char str[MAX_FILE_LENGTH];
const char *temp_ptr;
wxString ptr;
wxConfig *config;

	config = dirs->GetConfig();
	ptr = "";
	sprintf(str, "/%s/%s", SECTION_DISPLAY, entry);
	if(config->Read((const wxString) str, &ptr)) {
		temp_ptr = (char *)ptr.GetData();
		if(((temp_ptr[0] == 'T') || (temp_ptr[0] == 't')) && 
			(temp_ptr[0] != '0')) {
			f->ToggleShow();
#ifdef SECT_MENUS
			frame->view_menu->Check(menu_id, TRUE);
#endif
		}
	}
}
#endif

void
MainFrame::AddToMenu(wxMenu *mn, int id, bool tog_flag)
{
int i=0;

	while(menu_struct[i].id != 0) {
		if(id == menu_struct[i].id) {
			mn->Append(id, menu_struct[i].desc, menu_struct[i].long_help,
					tog_flag);
			return;
		}
		i++;
	}

	// oh-oh
	mn->Append(999, "Bad", "This is wrong!");
}

// --------------------------------------------------------------------------
void
MainFrame::BuildBitmapList(TCodes *codes)
{
BaseTable *ct;
BaseTableEntry *cte;
ListNode *ln;

	ct = codes->GetBaseTable();
	ln = ct->First();
	while(ln != NULL) {
		int ndx=0;
		wxNode *n;
		NamedBitmap *nb;

		cte = (BaseTableEntry *)ln->Data();
		cte->SetIndex(0, -1);
		cte->SetIndex(1, -1);
		n = bitmaps->First();
		while(n != NULL) {
			nb = (NamedBitmap *)n->Data();

			if((nb->GetName() != NULL) && (cte->GetName(0) != NULL) && 
				(strcmp(cte->GetName(0), nb->GetName()) == 0)) {
				cte->SetIndex(0, ndx);
			}
			if((nb->GetName() != NULL) && (cte->GetName(1) != NULL) && 
				(strcmp(cte->GetName(1), nb->GetName()) == 0)) {
				cte->SetIndex(1, ndx);
			}

			ndx++;
			n = n->Next();
		}

		ln = ln->Next();
	}
}

void
MainFrame::BuildSectorBitmaps(void)
{
char *ptr;
int x,y;
HexData *hd;
wxNode *n;
NamedBitmap *nb;

	for(x = 0;x < MAX_X_HEX;x++) {
		for(y = 0;y < MAX_Y_HEX;y++) {
			if(((hd = sect->GetHex(x, y)) != NULL) && (hd->cp != NULL) &&
					((ptr = hd->cp->GetBM()) != NULL)) {
				int ndx=0;
				n = bitmaps->First();
				while(n != NULL) {
					nb = (NamedBitmap *) n->Data();
					if(strcmp(hd->cp->GetBM(), nb->GetName()) == 0) {
						hd->cp->SetIndex(ndx);
						break;
					}
					n = n->Next();
				}
			}
		}
	}

}

// --------------------------------------------------------------------------
void
MainFrame::OnToolEnter(wxCommandEvent& event)
{
int i=0;
bool fail=TRUE;

	while(menu_struct[i].id != 0) {
		if(event.GetSelection() == menu_struct[i].id) {
			wxString str;
			str.Printf("%s", menu_struct[i].long_help);
			SetStatusText(str, 0);
			fail = FALSE;
			break;
		}
		i++;
	}
	if(fail)
		SetStatusText("", 0);
}

void
MainFrame::InitButtons(wxToolBar *tb)
{
int i;
int currentX = DLG_OFFSET;
#ifdef __WXMSW__
  int width = 24;
#else
  int width = 16;
#endif
wxBitmap* bm[MAX_BUTTONS];

	// Set up my toolbar
	tb->SetMargins(2, 2);
#ifdef __WXMSW__
	bm[0] = new wxBitmap("icon1");
	bm[1] = new wxBitmap("icon2");
	bm[2] = new wxBitmap("icon3");
	bm[3] = new wxBitmap("icon4");
	bm[4] = new wxBitmap("icon5");
	bm[5] = new wxBitmap("icon6");
	bm[6] = new wxBitmap("icon7");
	bm[7] = new wxBitmap("icon8");
	bm[8] = new wxBitmap("icon9");
	bm[9] = new wxBitmap("icon10");
	bm[10] = new wxBitmap("icon11");
	bm[11] = new wxBitmap("icon12");
	bm[12] = new wxBitmap("icon13");
	bm[13] = new wxBitmap("icon14");
	bm[14] = new wxBitmap("icon15");
	bm[15] = new wxBitmap("icon16");
	bm[16] = new wxBitmap("icon17");
	bm[17] = new wxBitmap("icon18");
	bm[18] = new wxBitmap("icon19");
	bm[19] = new wxBitmap("icon20");
	bm[20] = new wxBitmap("icon21");
#else
	bm[0] = new wxBitmap(open_xpm);
	bm[1] = new wxBitmap(save_xpm);
	bm[2] = new wxBitmap(print_xpm);
	bm[3] = new wxBitmap(config_xpm);
	bm[4] = new wxBitmap(help_xpm);
	bm[5] = new wxBitmap(exit_xpm);

	bm[6] = new wxBitmap(mag_xpm);
	bm[7] = new wxBitmap(sml_hex_xpm);
	bm[8] = new wxBitmap(attr_xpm);

	bm[9] = new wxBitmap(subsect_xpm);
	bm[10] = new wxBitmap(eye_xpm);
	bm[11] = new wxBitmap(sroute_xpm);
	bm[12] = new wxBitmap(sbrdr_xpm);
	bm[13] = new wxBitmap(ssearch_xpm);

	bm[14] = new wxBitmap(one_hex_xpm);
	bm[15] = new wxBitmap(eye_xpm);
	bm[16] = new wxBitmap(rt_hex_xpm);
	bm[17] = new wxBitmap(brdr_hex_xpm);
	bm[18] = new wxBitmap(mag_xpm);
	bm[19] = new wxBitmap(critter_xpm);
	bm[20] = new wxBitmap(cargo_xpm);

#endif

	for(i = 0;i < MAX_BUTTONS;i++) {
		tb->AddTool(menu_struct[i].id, *(bm[i]), wxNullBitmap, FALSE,
			currentX, -1, NULL, 
			menu_struct[i].short_help, menu_struct[i].long_help);
		currentX += width + DLG_OFFSET;
		if((5 == i) || (8 == i) || (13 == i))
			tb->AddSeparator();
	}
		
	tb->Realize();

	// Can delete the bitmaps since they're reference counted
	for (i = 0; i < MAX_BUTTONS; i++)
		delete bm[i];
}

// ----------------------------------------------------------------------------
void
MainFrame::SetModeMenu(void)
{
bool flag,flag1,flag2;
wxToolBar *tb;

	tb = GetToolBar();

	// first, check for specifics for the mapping mode
	if(MM_MAP == mapping_mode)
		flag = TRUE;
	else
		flag = FALSE;

	file_menu->Enable(SECTOR_OPEN, flag);
	file_menu->Enable(SECTOR_CONFIG, flag);
	file_menu->Enable(SECTOR_FILE1, flag);
	file_menu->Enable(SECTOR_FILE2, flag);
	file_menu->Enable(SECTOR_FILE3, flag);
	file_menu->Enable(SECTOR_FILE4, flag);
	view_menu->Enable(SECTOR_VIEW_DETAIL, flag);
	view_menu->Enable(SECTOR_VIEW_MAP, flag);
	view_menu->Enable(SECTOR_VIEW_LIST, flag);
	popup->Enable(POPUP_EDIT_VIEW, flag);
	tb->EnableTool(SECTOR_OPEN, flag);
	tb->EnableTool(SECTOR_CONFIG, flag);
	tb->EnableTool(SECTOR_VIEW_DETAIL, flag);
	tb->EnableTool(SECTOR_VIEW_MAP, flag);
	tb->EnableTool(SECTOR_VIEW_LIST, flag);

	// checks dependant on whether or not sector is loaded
	if((mode & MODE_FLAG_LOADED) && (MM_MAP == mapping_mode))
		flag = TRUE;
	else
		flag = FALSE;

#ifdef SECT_MENUS
	file_menu->Enable(SECTOR_SAVE, flag);
	file_menu->Enable(SECTOR_PRINT, flag);
#endif
	tb->EnableTool(SECTOR_SAVE, flag);
	tb->EnableTool(SECTOR_PRINT, flag);
#ifdef SECT_MENUS
	sector_menu->Enable(SECTOR_FEDIT_VIEW, flag);
	sector_menu->Enable(SECTOR_FEDIT_ROUTE, flag);
	sector_menu->Enable(SECTOR_FEDIT_BORDER, flag);
	sector_menu->Enable(SECTOR_FEDIT_SEARCH, flag);
	sector_edit_menu->Enable(SECTOR_FEDIT_SS, flag);
	sector_edit_menu->Enable(SECTOR_FEDIT_NOTES, flag);
	sector_edit_menu->Enable(SECTOR_FEDIT_SS_NOTES, flag);
	search_menu->Enable(SECTOR_SEARCH_RANGES, flag);
	search_menu->Enable(SECTOR_SEARCH_TRADE, flag);
	search_menu->Enable(SECTOR_SEARCH_SHORT, flag);
#endif
	tb->EnableTool(SECTOR_FEDIT_SS, flag);
	tb->EnableTool(SECTOR_FEDIT_VIEW, flag);
	tb->EnableTool(SECTOR_FEDIT_ROUTE, flag);
	tb->EnableTool(SECTOR_FEDIT_BORDER, flag);
	tb->EnableTool(SECTOR_FEDIT_SEARCH, flag);
#ifdef SECT_MENUS
	hex_menu->Enable(SECTOR_HEX_SELECT, flag);
#endif
	tb->EnableTool(SECTOR_HEX_SELECT, flag);
#ifdef POPUP_MENUS
	popup->Enable(POPUP_SS, flag);
	popup->Enable(POPUP_NOTES, flag);
	popup->Enable(POPUP_SS_NOTES, flag);
	popup->Enable(POPUP_EDIT_ROUTE, flag);
	popup->Enable(POPUP_EDIT_BORDER, flag);
	popup->Enable(POPUP_SEARCH_RANGE, flag);
	popup->Enable(POPUP_SEARCH_TRADE, flag);
	popup->Enable(POPUP_SEARCH_SHORT, flag);
	popup->Enable(POPUP_SELECT, flag);
#endif

	// check if there is a 'current' hex
	if((mode & MODE_FLAG_LOADED) && (MM_MAP == mapping_mode)) {
		if((cur_x > 0) && (cur_y > 0)) {
			HexData *hd;

			flag = TRUE;
			if(((hd = sect->GetHex(cur_x-1, cur_y-1)) != NULL) &&
					(hd->world != NULL)) {
				flag1 = TRUE;
			} else {
				flag1 = FALSE;
			}
			flag2 = !flag1;
		} else
			flag = flag1 = flag2 = FALSE;
	} else
		flag = flag1 = flag2 = FALSE;

#ifdef SECT_MENUS
	hex_menu->Enable(SECTOR_HEX_BORDER, flag);
	hex_menu->Enable(SECTOR_HEX_ROUTE, flag);
	hex_menu->Enable(SECTOR_HEX_VIEW, flag);
	hex_menu->Enable(SECTOR_HEX_DETAIL, flag1);
	hex_menu->Enable(SECTOR_HEX_ENC, flag1);
	hex_menu->Enable(SECTOR_HEX_TRADE, flag1);
//	hex_menu->Enable(SECTOR_HEX_CP, flag);
	hex_edit_menu->Enable(SECTOR_HEX_NOTES, flag1);
	hex_edit_menu->Enable(SECTOR_EDIT_HEX, flag1);
	hex_edit_menu->Enable(SECTOR_ADD_HEX, flag2);
	hex_edit_menu->Enable(SECTOR_DEL_HEX, flag1);
#endif
	tb->EnableTool(SECTOR_HEX_BORDER, flag);
	tb->EnableTool(SECTOR_HEX_ROUTE, flag);
	tb->EnableTool(SECTOR_HEX_VIEW, flag);
	tb->EnableTool(SECTOR_HEX_DETAIL, flag1);
	tb->EnableTool(SECTOR_HEX_ENC, flag1);
	tb->EnableTool(SECTOR_HEX_TRADE, flag1);
//	tb->EnableTool(SECTOR_HEX_CP, flag);
#ifdef POPUP_MENUS
	popup->Enable(POPUP_DETAIL, flag1);
	popup->Enable(POPUP_ENC, flag1);
	popup->Enable(POPUP_TRADE, flag1);
//	popup->Enable(POPUP_CP, flag);
	popup->Enable(POPUP_ROUTE, flag);
	popup->Enable(POPUP_VIEW, flag);
	popup->Enable(POPUP_BORDER, flag);
	popup->Enable(POPUP_EDIT_HEX, flag1);
	popup->Enable(POPUP_ADD_HEX, flag2);
	popup->Enable(POPUP_DEL_HEX, flag1);
	popup->Enable(POPUP_HEX_NOTES, flag1);
#endif

	CheckReadOnlyMenu();
	CheckCurrentHexMenu();
	switch(mapping_mode) {
		case MM_MAP:
			popup->Enable(SECTOR_MAP_MODE, FALSE);
			popup->Enable(SECTOR_ROUTE_MODE, TRUE);
			popup->Enable(SECTOR_BORDER_MODE, TRUE);
			popup->Enable(SECTOR_BORDER_MODE2, TRUE);
			SetStatusText("Map", 1);
			break;
		case MM_ROUTE:
			popup->Enable(SECTOR_MAP_MODE, TRUE);
			popup->Enable(SECTOR_ROUTE_MODE, FALSE);
			popup->Enable(SECTOR_BORDER_MODE, TRUE);
			popup->Enable(SECTOR_BORDER_MODE2, TRUE);
			SetStatusText("Route", 1);
			break;
		case MM_BORDER:
			popup->Enable(SECTOR_MAP_MODE, TRUE);
			popup->Enable(SECTOR_ROUTE_MODE, TRUE);
			popup->Enable(SECTOR_BORDER_MODE, FALSE);
			popup->Enable(SECTOR_BORDER_MODE2, TRUE);
			SetStatusText("Border", 1);
			break;
		case MM_BORDER2:
			popup->Enable(SECTOR_MAP_MODE, TRUE);
			popup->Enable(SECTOR_ROUTE_MODE, TRUE);
			popup->Enable(SECTOR_BORDER_MODE, TRUE);
			popup->Enable(SECTOR_BORDER_MODE2, FALSE);
			SetStatusText("Border 2", 1);
			break;
	}
}

void
MainFrame::CheckReadOnlyMenu(void)
{
	if((mode & MODE_FLAG_SEC_READONLY) && (mode & MODE_FLAG_DAT_READONLY))
		/*text_frame->*/SetStatusText("BOTH", 2);
	else if(mode & MODE_FLAG_SEC_READONLY)
		/*text_frame->*/SetStatusText("SEC", 2);
	else if(mode & MODE_FLAG_DAT_READONLY)
		/*text_frame->*/SetStatusText("DAT", 2);
	else
		/*text_frame->*/SetStatusText("", 2);
}

bool
MainFrame::CheckCurrentHexMenu(void)
{
char buff[12];

	if((cur_x < 0) && (cur_y < 0)) {
		/*text_frame->*/SetStatusText("NONE", 3);
		return(FALSE);
	}
	else {
		sprintf(buff, "%02d%02d", cur_x, cur_y);
		/*text_frame->*/SetStatusText(buff, 3);
		return(TRUE);
	}
}

// ----------------------------------------------------------------------------
void
MainFrame::MenuCheckCallBack(SubFrame *f)
{
#ifdef SEPERATE_WINDOWS
#ifdef SECT_MENUS
	if(f == list_frame)
		view_menu->Check(SECTOR_VIEW_LIST, FALSE);
	else 
	if(f == detail_frame)
		view_menu->Check(SECTOR_VIEW_DETAIL, FALSE);
	else if(f == map_frame)
		view_menu->Check(SECTOR_VIEW_MAP, FALSE);
#endif
#endif
}

HexData *
MainFrame::GetCurrentHex(void)
{
	if((cur_x > -1) && (cur_y > -1))
		return(sect->GetHex(cur_x-1, cur_y-1));
	else
		return(NULL);
}

void
MainFrame::RangeCheck(int *start_x, int *start_y, int *end_x, int *end_y)
{
	if((*start_x < 0) || (*start_x > X_COUNT))
		*start_x = 0;

	if((*start_y < 0) || (*start_y > Y_COUNT))
		*start_y = 0;

	if((*end_x < 0) || (*end_x > X_COUNT))
		*end_x = X_COUNT;
	
	if((*end_y < 0) || (*end_y > Y_COUNT))
		*end_y = Y_COUNT;
}

void
MainFrame::GetCurrentHex(short *x, short *y)
{
    *x = cur_x;
    *y = cur_y;
}

// ----------------------------------------------------------------------------
void
MainFrame::CalcMapSize(long *size_x, long *size_y,
                       int start_x, int start_y, int end_x, int end_y)
{
int x,y;

    RangeCheck(&start_x, &start_y, &end_x, &end_y);
    x = ((end_x - start_x) * HEX_X_2) +
      (HEX_X_3 - HEX_X_2) + (2 * HEX_BORDER_X_OFFSET);
    y = ((end_y - start_y) * HEX_Y_5) + HEX_Y_3 + (2 * HEX_BORDER_Y_OFFSET);

    *size_x = x;
    *size_y = y;
}

int
MainFrame::CalcWorldsOnPage(bool srch, bool list, bool hdr,
                            int lines_per_page, int page)
{
int lines_per_world;

// adjust for header and trailer
    lines_per_page -= 2;
    if(hdr)
        lines_per_page -= 2;

    if(list)
        lines_per_world = 1;
    else
        lines_per_world = 25;

    return(lines_per_page / lines_per_world);
}

int
MainFrame::CalcPageCount(bool srch, bool list, int lines, bool hdr,
                         int s_x, int s_y, int e_x, int e_y)
{
//int temp,lines_per_world,worlds_per_page;
int tot_count,lines_per_page,page_count=0;

	lines_per_page = lines - 2;
	if(hdr)
   		lines_per_page -= 2;

	RangeCheck(&s_x, &s_y, &e_x, &e_y);
	tot_count = sect->GetCount(s_x, s_y, e_x, e_y);
	// assuming lines is always true.......
	page_count = tot_count / lines_per_page;
	if((tot_count % lines_per_page) != 0)
		page_count++;

	return(page_count);
}

// ----------------------------------------------------------------------------
void
MainFrame::DrawRoute(wxDC& dc, int x, int y, int start_x, int start_y,
					 HexData *hd, ColorTable *ct, long off_x, long off_y)
{
long src_x, src_y, dest_x, dest_y;
Route *r;
ListNode *n;
	
	n = hd->routes->First();
	drawn_hex.GetAltXY(x, y, start_x, start_y, off_x, off_y, &src_x, &src_y);
	while(n != NULL) {
		int color_ndx;
		wxPen *p;

		r = (Route *)n->Data();
		drawn_hex.GetAltXY(r->x, r->y, start_x, start_y, off_x, off_y, 
				&dest_x, &dest_y);

		color_ndx = ct->GetColor(r->color);
		p = new wxPen(*colors->GetColor(color_ndx), ROUTE_WIDTH, ROUTE_STYLE);
		dc.SetPen(*p);
		dc.DrawLine(src_x + HEX_IMAGE_CENTER_X, src_y + HEX_IMAGE_CENTER_Y,
					dest_x + HEX_IMAGE_CENTER_X, dest_y + HEX_IMAGE_CENTER_Y);
		dc.SetPen(*wxBLACK_PEN);
		delete p;
		p = NULL;

		n = n->Next();
	}
}

void
MainFrame::DrawMap(wxDC& dc, long off_x, long off_y,
				   int start_x, int start_y, int end_x, int end_y,
				   char *msg1, char *msg2)
{
int i,j,color_ndx;
HexData *hd=NULL;
ColorTable *ct;
long w,h;
long descent;

	RangeCheck(&start_x, &start_y, &end_x, &end_y);

// header msgs......
	if((msg1 != NULL) && (msg1[0] != 0)) {
		dc.SetFont(*BoldFont);
		dc.GetTextExtent(msg1, &w, &h, &descent);
		drawn_hex.SetTextOffset(h + descent + 2);
		dc.DrawText(msg1, off_x, off_y);
	} else
		drawn_hex.SetTextOffset(0);

	// do the border stuff if we're in border mode....
	if(MM_BORDER == mapping_mode) {
		if(sect != NULL)
			ct = sect->GetBorderTable();
		else 
			ct = NULL;
		for(i = start_x;i < end_x;i++) {
			for(j = start_y;j < end_y;j++) {
//				color_ndx = sect->GetBorderCode(i, j);
				color_ndx = border_map[i][j];
				drawn_hex.DrawBorder(dc, i, j, start_x, start_y, color_ndx, ct, 
						colors, off_x, off_y);
			}
		}
	}

	// draw routes
	if(sect != NULL) {
		ct = sect->GetRouteTable();
		dc.SetPen(*wxBLACK_PEN);
		for(i = start_x;i < end_x;i++) {
			for(j = start_y;j < end_y;j++) {
				hd = sect->GetHex(i, j);
				if(hd != NULL)
					DrawRoute(dc, i, j, start_x, start_y, hd, ct, off_x, off_y);
			}
		}
	}

	// finally, draw the hexes
	dc.SetPen(*wxBLACK_PEN);
	dc.SetBrush(*wxBLACK_BRUSH);
	if(sect != NULL)
		ct = sect->GetBorderTable();
	else 
		ct = NULL;
	for(i = start_x;i < end_x;i++) {
		for(j = start_y;j < end_y;j++) {
			if(sect != NULL)
				hd = sect->GetHex(i, j);
			else 
				hd = NULL;
			drawn_hex.DrawTotalHex(dc, i, j, start_x, start_y, end_x, end_y,
				off_x, off_y, sect, hd, ct, colors, bitmaps, codes, 
				sect->GetLayout());
		}
	}
// trailer stuff
}

#define DEFAULT_MARGIN_X		20
#define DEFAULT_MARGIN_Y		DEFAULT_MARGIN_X
// simple wrapper to scale a map drawing to a dc
void
MainFrame::DrawMapScaled(wxDC& dc,
				   int start_x, int start_y, int end_x, int end_y,
				   char *msg1, char *msg2)
{
int a_h,a_w;
int w,h;
long max_x,max_y;
long size_x,size_y;
float scale, scale_x,scale_y;
long pos_x,pos_y;

	dc.GetSize(&w, &h);

	// should this be only for ps?
	a_h = h - 55;
	a_w = w - 35;

	// get the size of the image in pixels
	frame->CalcMapSize(&size_x, &size_y,
					   start_x, start_y, end_x, end_y);
	if((msg1 !=NULL) && (msg1[0] != 0))
	    size_y += 20;
	// set a margin
	// adjust for the margin
	max_x = size_x + (DEFAULT_MARGIN_X * 2);
	max_y = size_y + (DEFAULT_MARGIN_Y * 2);
	// calc a scale
	scale_x = (float) a_w / (float) max_x;
	scale_y = (float) a_h / (float) max_y;
	scale = wxMin(scale_x, scale_y);
	// set the scale
	dc.SetUserScale(scale, scale);
	// set it in the middle
	pos_x = (long)((((float)w - ((float)max_x * scale))/ 2.0) / scale);
	// my hp550 won't print right on the bottom...
	//  so, I am doing some hokey stuff here
	pos_y = (long) (20 / scale);
	// set a clipping region
	dc.SetClippingRegion(pos_x, pos_y, size_x, size_y);
#if 0
fprintf(stderr, "scale:%f\n", scale);
fprintf(stderr, "pos:%ld,%ld  size:%ld,%ld\nscale:%f,%f  max:%ld,%ld\n",
		pos_x, pos_y, size_x, size_y, scale_x, scale_y, max_x, max_y);
fprintf(stderr, "  w: %d    h: %d\n", w, h);
fprintf(stderr, "a_w: %d  a_h: %d\n", a_w, a_h);
#endif
	// draw (, pardner!)
	frame->DrawMap(dc, pos_x, pos_y, start_x, start_y, end_x, end_y,
		msg1, msg2);
}

void
MainFrame::DrawLegend(wxDC& dc)
{
int x,y;

	legend.DrawLegend(dc, 5, 5, &x, &y, TRUE, -1, sect, bitmaps, codes, 
			sect->GetBorderTable(), sect->GetRouteTable(), colors, 
			sect->GetLayout());
}

// ---------------------------------------------------------------------------
// draw formated subsectors
// nice fancy routine to dump a subsector map and a legend
void
MainFrame::DrawFormatedSS(wxDC& dc, int ss_ndx)
{
int x,y,hex_start_x,hex_start_y;

	hex_start_x = (ss_ndx % 4) * 8;
	hex_start_y = (ss_ndx / 4) * 10;

	legend.DrawLegend(dc, 5, 5, &x, &y, TRUE, ss_ndx, sect, bitmaps, codes, 
			sect->GetBorderTable(), sect->GetRouteTable(), colors, 
			sect->GetLayout());

	dc.SetClippingRegion(5 + x + 10, 18,
		(8 * HEX_X_4) + HEX_X_3 - HEX_X_4 + 5,
		(10 * HEX_Y_5) + HEX_Y_5 - HEX_Y_3 + 5);

	DrawMap(dc, 5 + x + 10, 18,
		hex_start_x, hex_start_y,
		hex_start_x + 8, hex_start_y + 10,
		NULL, NULL);
}

void
MainFrame::GetFormatedSize(wxDC& dc, int *w, int *h)
{
	legend.DrawLegend(dc, 5, 5, w, h, FALSE, 1, sect, bitmaps, codes, 
			sect->GetBorderTable(), sect->GetRouteTable(), colors, 
			sect->GetLayout());

	*w += (8 * HEX_X_4) + HEX_X_3 - HEX_X_4 + 5 + 15;
	if(*h < ((10 * HEX_Y_5) + HEX_Y_5 - HEX_Y_3 + 20))
		*h = ((10 * HEX_Y_5) + HEX_Y_5 - HEX_Y_3 + 20);
	*h += 15;
}

void 
MainFrame::GetLegendSize(wxDC& dc, int *w, int *h)
{
	legend.DrawLegend(dc, 5, 5, w, h, FALSE, -1, sect, bitmaps, codes, 
			sect->GetBorderTable(), sect->GetRouteTable(), colors, 
			sect->GetLayout());
	*h += 15;
}

// ---------------------------------------------------------------------------
void
MainFrame::LoadFile(char *s, bool from_command_line)
{
char buff[120],buffer[MAX_FILE_LENGTH],*ptr2;
char *t;
int i,j;
//ColorLookupTable *clt;
//ColorLookupEntry *cle;
wxMenuItem *mn;

	if(!from_command_line)
		wxBeginBusyCursor();
	// WTF?????
	sprintf(buffer, s);
	while((ptr2 = strchr(buffer, '\\')) != NULL) {
		*ptr2 = '/';
	}

	if(sect->LoadFile(buffer) > -1) {
		// now, refresh canvases
		RefreshAll();

		// set up the directories
		dirs->CrackNames(buffer);

		// look for the just opened file					
		j = 0;
		for(i = 0;i < MAX_FILES;i++) {
			if((mn = file_menu->FindItem(SECTOR_FILE1 + i)) == NULL)
				continue;
			if((t = (char *)mn->GetText().GetData()) == NULL)
				continue;
			if(stupid_file_name_cmp(buffer, t) == 0)
				j |= 1;
		}

		// file not found in out list, add it
		if(j == 0) {
			// brand new one
			mn = file_menu->FindItem(SECTOR_FILE1);
			if((NULL == mn) || (mn->GetText().IsNull())) {
				file_menu->AppendSeparator();
				file_menu->Append(SECTOR_FILE1, buffer, "Load Previous File");
			} else {
				// find last one
				j = -1;
				for(i = SECTOR_FILE1;i < (SECTOR_FILE1 + MAX_FILES);i++) {
					mn = file_menu->FindItem(i);
					if((NULL == mn) || (mn->GetText().IsNull())) {
						j = i;
						break;
					}
				}
				
				// not full?
				if(j != -1) {
					mn = file_menu->FindItem(j - 1);
					t = (char *)mn->GetText().GetData();
					file_menu->Append(j, t, "Load Previous File");
				} else {
					// ok now, point to last one
					j = SECTOR_FILE1 + MAX_FILES - 1;
				}

				// move 'em all down
				for(i = j; i > SECTOR_FILE1;i--) {
					mn = file_menu->FindItem(i - 1);
					file_menu->SetLabel(i, mn->GetText().GetData());
				}

				// append the new one
				file_menu->SetLabel(SECTOR_FILE1, buffer);
			}
		}

		// reuse s
		if((s = sect->GetName()) != NULL) {
			sprintf(buff, "Sector Viewer: %s", s);
			SetTitle(buff);
			SetMapTitle();
			sprintf(buff, "Listing: %s", s);
			list_frame->SetTitle(buff);
			sprintf(buff, "Detail: %s", s);
			detail_frame->SetTitle(buff);
		} else {
			sprintf(buff, "Sector Viewer");						
			SetTitle(buff);
			SetMapTitle();
			sprintf(buff, "Listing");
			list_frame->SetTitle(buff);
			sprintf(buff, "Detail");
			detail_frame->SetTitle(buff);
		}
		mode |= MODE_FLAG_LOADED;
		SetModeMenu();

		// setup the user menu
		if(user_smenu != NULL) {
			delete user_smenu;
			user_smenu = NULL;
		}

		// XXX this should have it's own in MTUFile
		sprintf(buffer, "%s", sect->GetSecName());
		if((s = strrchr(buffer, '/')) != NULL) {
			s++;
			*s = 0;
		} else {
			buffer[0] = 0;
		}
		strcat(buffer, "menu/sector.menu");
		user_smenu = new Menu(dirs, buffer, ID_USER2, ID_USER1);

		BuildSectorBitmaps();
	}
	if(!from_command_line)
		wxEndBusyCursor();
}

#if 0
void
DumpRoutes(DetailSector *sect)
{
int i,j;

	fprintf(stderr, "\n=======================================\n");
	for(i = 0;i < MAX_X_HEX;i++)
		{
		for(j = 0;j < MAX_X_HEX;j++)
			{
			HexData *hd;
			
			hd = sect->GetHex(i,j);
			if((hd != NULL) && (hd->routes != NULL))
				{
				ListNode *ln;
				Route *rt;

				ln = hd->routes->First();
				while(ln != NULL)
					{
					rt = (Route *)ln->Data();
					fprintf(stderr, "%02d%02d->%02d%02d (%d)\n",
						i+1, j+1, rt->x+1, rt->y+1, rt->color);
					ln = ln->Next();
					}
				}
			}
		}
}
#endif

void
MainFrame::LoadFile(const int id)
{
wxMenuItem *mn;

	mn = file_menu->FindItem(id);
	LoadFile((char *)mn->GetText().GetData());
}

// ---------------------------------------------------------------------------
void
MainFrame::LoadFile1(wxCommandEvent& event)
{
	LoadFile(SECTOR_FILE1);
}

void
MainFrame::LoadFile2(wxCommandEvent& event)
{
	LoadFile(SECTOR_FILE2);
}

void
MainFrame::LoadFile3(wxCommandEvent& event)
{
	LoadFile(SECTOR_FILE3);
}

void
MainFrame::LoadFile4(wxCommandEvent& event)
{
	LoadFile(SECTOR_FILE4);
}

void
MainFrame::LoadFile5(wxCommandEvent& event)
{
	LoadFile(SECTOR_FILE5);
}

void
MainFrame::SelectFile(wxCommandEvent& event)
{
wxString ptr;
char *s;

	ptr = wxFileSelector("Load sector File", NULL, NULL, NULL, 
			"*.sec", wxHIDE_READONLY, this);
	s = (char *)ptr.GetData();
	if(s[0] != 0)
		LoadFile(s);
}

void
MainFrame::SaveSec(wxCommandEvent& event)
{
	wxBeginBusyCursor();
	sect->WriteDat(codes);
	sect->WriteSec();
	wxEndBusyCursor();
}

void
MainFrame::Print(wxCommandEvent& event)
{
int i;
//int start_x=-1,start_y=-1,end_x=-1,end_y=-1;
//char *ptr1=NULL,*ptr2=NULL;

	if(NULL == print_dialog)
		print_dialog = new PrintDialog(this);

	for(i = 0;i < MAX_SS;i++)
		print_dialog->SetSSName(i, sect->GetSSName(i));
	
	if((cur_x < 0) || (cur_y < 0))
		print_dialog->SetCurrent(FALSE);
	else
		print_dialog->SetCurrent(TRUE);

	print_dialog->DoPrint();
}

void
MainFrame::Config(wxCommandEvent& event)
{
	if(NULL == code_dialog)
		code_dialog = new TCodeDialog(this);
	if(code_dialog->EditCodes(codes, bitmaps)) {
		RefreshAll();
	}
}

void
MainFrame::OnUser1(wxCommandEvent& event)
{
	if(user_smenu != NULL)
		user_smenu->HandleEvent(dirs, event.GetId());
}

void
MainFrame::OnUser2(wxCommandEvent& event)
{
	if(user_hmenu != NULL)
		user_hmenu->HandleEvent(dirs, event.GetId());
}

void
MainFrame::Quit(wxCommandEvent& event)
{
#ifdef SEPERATE_WINDOWS
	map_frame->Show(FALSE);
	map_frame->Close(TRUE);
	detail_frame->Show(FALSE);
	detail_frame->Close(TRUE);
	list_frame->Show(FALSE);
	list_frame->Close(TRUE);
//	search_frame->Show(FALSE);
//	search_frame->Close(TRUE);
#endif
	Close(TRUE);
}

void
MainFrame::GeneralSearch(wxCommandEvent& event)
{
	if(NULL == search_dlg)
		search_dlg = new SearchDialog(this);
	search_dlg->Search(sect, NULL, codes, dirs);
}

void
MainFrame::ToggleDetail(wxCommandEvent& event)
{
	view_mode = VM_detail;
#ifndef SEPERATE_WINDOWS
//	canvas->SetSize(350, 180);
	canvas->SetScrollbars(2, 2, 225, 140, 0, 0);
//	Fit();
	canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
	detail_frame->ToggleShow();
#endif
}

void
MainFrame::ToggleMap(wxCommandEvent& event)
{
	view_mode = VM_map;
#ifndef SEPERATE_WINDOWS
//	canvas->SetSize(400, 300);
	canvas->SetScrollbars(HEX_X_2, HEX_Y_4, 
				X_COUNT+1, Y_COUNT+1, 0, 0);
//	Fit();
	canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
	map_frame->ToggleShow();
#endif
}

void
MainFrame::ToggleList(wxCommandEvent& event)
{
	view_mode = VM_list;
#ifndef SEPERATE_WINDOWS
//	canvas->SetSize(400, 300);
	canvas->SetScrollbars(16, 12, 35, 500, 0, 0);
//	Fit();
	canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
	list_frame->ToggleShow();
#endif
}

// --------------------------------------------------------------------------
void
MainFrame::EditNotes(SECTOR_NOTES s)
{
char name[12],buff[256],*ss_names[MAX_SS],*ed_ptr,*dir_ptr;
int ss;

	switch(s) {
		case SN_SECT:
			sprintf(name, "%s", "sector");
			break;
		case SN_SS:
			for(ss = 0;ss < MAX_SS;ss++)
				ss_names[ss] = sect->GetSSName(ss);
			if(NULL == sss_dialog)
				sss_dialog = new SSSelectDialog(this);
			if((ss = sss_dialog->SelectSS(ss_names)) < 0)
				return;
			sprintf(name, "sub-%c", ss + 'a');
			break;
		case SN_HEX:
			sprintf(name, "%02d%02d", cur_x, cur_y);
			break;
	}

	ed_ptr = dirs->GetEditor();
	dir_ptr = dirs->GetSectTextDir();

	if(dir_ptr != NULL)
		sprintf(buff, "%s %s/%s.txt", ed_ptr, dir_ptr, name);
	else
		sprintf(buff, "%s %s.txt", ed_ptr, name);
	wxExecute(buff, FALSE);
}

void
MainFrame::EditHex(wxCommandEvent& event)
{
HexData *hd;

	if(((hd = sect->GetHex(cur_x-1, cur_y-1)) == NULL) || (NULL == hd->world))
		return;
	if(NULL == world_dialog)
		world_dialog = new EditWorldDialog(this, codes);
	if(world_dialog->EditWorld(hd->world, codes)) {
		RefreshAll();
	}
}

void
MainFrame::OnAbout(wxCommandEvent& event)
{
AboutDialog *dlg;

	dlg = new AboutDialog(this);
	dlg->ShowAbout("Sector Viewer");
	delete dlg;
}

void
MainFrame::HexAdd(wxCommandEvent& event)
{
main_world *mw;
HexData *hd;

	mw = new main_world;
	if(NULL == world_dialog)
		world_dialog = new EditWorldDialog(this, codes);
	if(world_dialog->EditWorld(mw, codes)) {
		hd = sect->AddOrGetHex(cur_x-1, cur_y-1);
		hd->world = mw;
		RefreshAll();
	} else {
		delete mw;
	}
}

void
MainFrame::HexDel(wxCommandEvent& event)
{
HexData *hd;
	
	if((hd = sect->GetHex(cur_x-1, cur_y-1)) != NULL) {
		if(hd->world != NULL) {
			if(wxMessageBox("Are you sure you want to delete this world?", 
					"Delete World", 
					wxCENTRE | wxYES_NO | wxICON_QUESTION) == wxYES) {
				delete hd->world;
				hd->world = NULL;
				RefreshAll();
			}
		}
	}
}

// --------------------------------------------------------------------------
void
MainFrame::EditSS(wxCommandEvent& event)
{
char *s_name,*ss_name[MAX_SS],*ptr;
int i;

	ptr = sect->GetName();
	if(NULL == ptr) {
		s_name = new char[10];
		sprintf(s_name, "Sector");
	} else {
		s_name = new char [strlen(ptr) + 1];
		strcpy(s_name, ptr);
	}

	for(i = 0;i < MAX_SS;i++) {
		ptr = sect->GetSSName(i);
		if(NULL == ptr) {
			ss_name[i] = new char[16];
			sprintf(ss_name[i], "Subsector %c", i + 'A');
		} else {
			ss_name[i] = new char [strlen(ptr) + 1];
			strcpy(ss_name[i], ptr);
		}
	}

	if(NULL == ss_dialog)
		ss_dialog = new SSDialog(this);

	if(ss_dialog->GetNames(&s_name, ss_name)) {
		sect->SetName(s_name);
		delete s_name;
		for(i = 0;i < MAX_SS;i++) {
			sect->SetSSName(i, ss_name[i]);
			delete ss_name[i];
		}
	}
}

void
MainFrame::SectorView(wxCommandEvent& event)
{
bool flag=FALSE;
HexLayout *l_layout,*layout;
HexData *hd;

	layout = sect->GetLayout();
	l_layout = new HexLayout(layout);
	if(NULL == fmt_dialog)
		fmt_dialog = new FormatDialog(this, bitmaps, codes, l_layout);
	if(fmt_dialog->GetFormat(TRUE, l_layout, &flag)) {
		int i,j;

		for(i = 0;i < MAX_LAYOUT_X;i++)
			for(j = 0;j < MAX_LAYOUT_Y;j++)
				layout->SetCode(i, j, l_layout->GetCode(i, j));
		layout->SetUWPFilter(l_layout->GetUWPFilter());
		if(flag) {
			for(i = 0;i < MAX_LAYOUT_X;i++) {
				for(j = 0;j < MAX_LAYOUT_Y;j++) {
					if((hd = sect->GetHex(i-1, j-1)) != NULL) {
						if(hd->layout != NULL) {
							delete hd->layout;
							hd->layout = NULL;
						}
					}
				}
			}
		}
#ifndef SEPERATE_WINDOWS
		canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
		map_frame->canvas->Refresh();
#endif
	}

	delete l_layout;
}

void
MainFrame::HexView(wxCommandEvent& event)
{
bool flag=FALSE;	// ignored in the the hex version....
int i,j;
HexLayout *l_layout;
HexData *hd;

	if((hd = sect->GetHex(cur_x-1, cur_y-1)) == NULL)
		// makes no sense to do this on an empty hex.....
		return;

	if(hd->layout != NULL)
		l_layout = new HexLayout(hd->layout);
	else
		l_layout = new HexLayout(sect->GetLayout());

	if(NULL == fmt_dialog)
		fmt_dialog = new FormatDialog(this, bitmaps, codes, l_layout);
	if(fmt_dialog->GetFormat(FALSE, l_layout, &flag)) {
		if(hd->layout != NULL) {
			for(i = 0;i < MAX_LAYOUT_X;i++)
				for(j = 0;j < MAX_LAYOUT_Y;j++)
					hd->layout->SetCode(i, j, l_layout->GetCode(i, j));
			hd->layout->SetUWPFilter(l_layout->GetUWPFilter());
		} else
			hd->layout = new HexLayout(l_layout);
#ifndef SEPERATE_WINDOWS
		canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
		map_frame->canvas->Refresh();
#endif
	}

	delete l_layout;
}

void
MainFrame::ChooseRoute(wxCommandEvent& event)
{
	if(NULL == ec_dialog)
		ec_dialog = new EditChoiceDialog(this);
	ec_dialog->DoChoice(CHOICE_ROUTE, colors);
#ifndef SEPERATE_WINDOWS
	canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
	map_frame->canvas->Refresh();
#endif
}

void
MainFrame::ChooseBorder(wxCommandEvent& event)
{
	if(NULL == ec_dialog)
		ec_dialog = new EditChoiceDialog(this);
	ec_dialog->DoChoice(CHOICE_BORDER, colors);
#ifndef SEPERATE_WINDOWS
	canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
	map_frame->canvas->Refresh();
#endif
}

void 
MainFrame::SearchTrade(wxCommandEvent& event)
{
	if(NULL == search_dlg)
		search_dlg = new SearchDialog(this);
	search_dlg->SearchTrade(sect, NULL, codes, dirs);
}

void 
MainFrame::SearchShort(wxCommandEvent& event)
{
	if(NULL == search_dlg)
		search_dlg = new SearchDialog(this);
	search_dlg->SearchShort(sect, NULL, codes, dirs);
}

void 
MainFrame::SearchRange(wxCommandEvent& event)
{
	if(NULL == search_dlg)
		search_dlg = new SearchDialog(this);
	search_dlg->SearchRange(sect, NULL, codes, dirs);
}

void
MainFrame::SelectHex(wxCommandEvent& event)
{
short x, y;
MapCanvas *c;

	c = (MapCanvas *)map_frame->canvas;
	if(c->GetLastXY(&x, &y)) {
		cur_x = x;
		cur_y = y;
		SetModeMenu();
	} else {
		if((cur_x < 1) && (cur_y < 1))
			x = y = 0;
		else {
			x = cur_x;
			y = cur_y;
		}
		if(NULL == hex_dialog)
			hex_dialog = new HexDialog(this);
		if(hex_dialog->GetHex(&x, &y)) {
			cur_x = x;
			cur_y = y;
			SetModeMenu();
		}
	}

	if((cur_x > 0) && (cur_y > 0)) {
		char lbuff[24],buffer[MAX_FILE_LENGTH],*ptr;

		sprintf(buffer, "%s", sect->GetSecName());
		if((ptr = strrchr(buffer, '/')) != NULL) {
			ptr++;
			*ptr = 0;
		} else {
			buffer[0] = 0;
			ptr = buffer;
		}

		sprintf(lbuff, "menu/p%02d%02d.menu", cur_x, cur_y);
		strcat(buffer, lbuff);
		user_hmenu = new Menu(dirs, buffer, ID_USER4, ID_USER3);
	}
}

#if 0
void
MainFrame::DoSelectCP(void)
{
HexData *hd;
char *ptr;
int x,y;

	x = cur_x - 1;
	y = cur_y - 1;
	if((hd = sect->GetHex(x, y)) == NULL)
		ptr = NULL;
	else
		ptr = hd->cp;

	if(NULL == cp_dialog)
		cp_dialog = new CpDialog(this);

	if(cp_dialog->GetCP(cur_x, cur_y, &ptr)) {
		hd = sect->AddOrGetHex(x, y);
		hd->AddCP(ptr);
#ifndef SEPERATE_WINDOWS
		canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
		map_frame->canvas->Refresh();
#endif
	}
}
#endif

void
MainFrame::DoExecute(EXECUTE_FLAG ef)
{
char buff[512],*ext,*exe=NULL,*dir=NULL;

	switch (ef) {
		case EF_SYS:
			ext = ".sys";
			exe = dirs->GetSystem();
			dir = dirs->GetSectSysDir();
			break;
		case EF_ENC:
			ext = ".enc";
			exe = dirs->GetEncTbl();
			dir = dirs->GetSectEncDir();
			break;
		case EF_TRADE:
			ext = ".trd";
			exe = dirs->GetTrade();
			dir = dirs->GetSectTradeDir();
			break;
	}

	if(NULL == ext) {
		// XXX error!
	} else {
		if(NULL == dir)
			sprintf(buff, "%s -F%s -l%02d%02d -o%02d%02d%s", 
				exe, sect->GetSecName(), cur_x, cur_y, 
				cur_x, cur_y, ext);
		else
			sprintf(buff, "%s -F%s -l%02d%02d -o%s/%02d%02d%s", 
				exe, sect->GetSecName(), cur_x, cur_y, 
				dir, cur_x, cur_y, ext);
	}

//fprintf(stderr, "%s\n", buff);
	wxExecute(buff, FALSE);
}

void
MainFrame::EditBorder(wxCommandEvent& event)
{
HexData *hd,*o_hd;
ColorTable *ct;
int x,y,i;

	x = cur_x - 1;
	y = cur_y - 1;
	hd = new HexData();
	if((o_hd = sect->GetHex(x, y)) != NULL) {
		for(i = 0;i < 6;i++)
			hd->border_ndx[i] = o_hd->border_ndx[i];
	}
	ct = sect->GetBorderTable();

	if(NULL == border_dialog)
		border_dialog = new HexBorderDialog(this);

	if(border_dialog->GetBorders(hd, colors, ct)) {
		o_hd = sect->AddOrGetHex(x, y);
		for(i = 0;i < 6;i++)
			o_hd->border_ndx[i] = hd->border_ndx[i];
#ifndef SEPERATE_WINDOWS
		canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
		map_frame->canvas->Refresh();
#endif
	}
	delete hd;
}

void
MainFrame::EditRoute(wxCommandEvent& event)
{
HexData *hd;
LinkedList *rtl;
ColorTable *ct;
int x,y;

	x = cur_x - 1;
	y = cur_y - 1;
	if((hd = sect->GetHex(x, y)) != NULL)
		rtl = hd->routes;
	else
		rtl = new LinkedList();

	if(NULL == ec_dialog)
		ec_dialog = new EditChoiceDialog(this);
	ct = sect->GetRouteTable();
	if(ec_dialog->DoRouteChoice(rtl, colors, ct)) {
		if(hd == NULL)
			hd = new HexData(rtl);
#ifndef SEPERATE_WINDOWS
		canvas->Refresh();
#endif
#ifdef SEPERATE_WINDOWS
		map_frame->canvas->Refresh();
#endif
	}
	else {
		if(hd == NULL)
			delete rtl;
	}
}

// ----------------------------------------------------------------------------
void
MainFrame::SetMapMode(SECTOR_MAPPING_MODE m)
{
int sel=-1;
HexChoiceDialog *dlg;

	// leaving border mode?
	if(MM_BORDER == mapping_mode) {
		AlphaDialog *ad;
		AD_CODE adc;

		ad = new AlphaDialog(this);
		adc = ad->GetAlpha();
		delete ad;

		if(ADC_RETURN == adc)
			return;
		if(ADC_ACCEPT == adc)
			DecodeBorderMap();
	}

	// border or route mode need a color
	if(m != MM_MAP) {
		if(MM_ROUTE == m) {
			dlg = new HexChoiceDialog(this, "Select A Route");
			sel = dlg->GetChoice(sect->GetRouteTable(), TRUE);
		} else {
			dlg = new HexChoiceDialog(this, "Select A Border");
			sel = dlg->GetChoice(sect->GetBorderTable(), TRUE);
		}
		delete dlg;

		if(sel < 0)
			return;

		if(MM_BORDER == m)
			BuildBorderMap();
	}

	mapping_mode = m;
	map_mode_color = sel;
	last_x_r = last_y_r = base_x_r = base_y_r = -1;

	SetMapTitle();
	SetModeMenu();
	map_frame->canvas->Refresh();
}

#define BOGUS_BORDER_CODE		-2
#define UNDEFINED_BORDER_CODE	-1

void
MainFrame::BuildBorderMap(void)
{
int x,y,h;
int x1,y1,h1;
int value1,value2,value3,color1,color2;
HexData *hd;

	// first pass, mark all hexes as 'bogus'
	for(x = 0;x < MAX_X_HEX;x++) {
		for(y = 0;y < MAX_Y_HEX;y++) {
			border_map[x][y] = BOGUS_BORDER_CODE;
		}
	}

	// second pass, decide which hexes are on a border...
	for(x = 0;x < MAX_X_HEX;x++) {
		for(y = 0;y < MAX_Y_HEX;y++) {
			value3 = value1 = value2 = BOGUS_BORDER_CODE;
			for(h = 0;h < 6;h++) {
				// assign colorN
				color1 = color2 = BOGUS_BORDER_CODE;
				if(sect->GetAdjCoord(x, y, h, &x1, &y1)) {
					color2 = border_map[x1][y1];
				}
				if((hd = sect->GetHex(x, y)) != NULL) {
					if(hd->border_ndx[h] >= 0)
						color1 = hd->border_ndx[h];
				}
				if((color1 == BOGUS_BORDER_CODE) && 
						(hd = sect->GetAdjHex(x, y, h)) != NULL) {
					h1 = h + 3;
					if(h1 > 5) 
						h1 -= 6;
					if(hd->border_ndx[h1] >= 0)
						color1 = hd->border_ndx[h1];
				}

				// assign valueN
				if(color2 >= 0) {
					if(color1 >= 0) {
						if(color1 == color2) {
							if(value2 < 0)
								value2 = UNDEFINED_BORDER_CODE;
						} else
							value1 = color1;
					} else {
						if(value2 < 0)
							value2 = color2;
					}
				} else if(UNDEFINED_BORDER_CODE == color2) {
					if(color1 >= 0) {
						if(color1 == color2) {
							if(value3 < 0)
								value3 = UNDEFINED_BORDER_CODE;
						} else {
							if(value2 < 0)
								value2 = color1;
						}
					} else {
						if(value2 < 0)
							value2 = color2;
					}
				} else {
					if(color1 >= 0)
						value3 = color1;
					else
						if(value3 < 0)
							value3 = UNDEFINED_BORDER_CODE;
				}
//if(((x < 2) && (y < 2)) ||
//		((9 == x) && (4 == y)) ||
//		((10 == x) && (2 == y)))
//	fprintf(stderr, "%d (%02d%02d) %d %d --> %d,%d,%d\n", h, x+1, y+1, color1, color2, value1, value2, value3);
//				if(value1 != BOGUS_BORDER_CODE)
//					break;
			}
			if(value1 != BOGUS_BORDER_CODE)
				border_map[x][y] = value1;
			else if(value2 != BOGUS_BORDER_CODE)
				border_map[x][y] = value2;
			else if(value3 != BOGUS_BORDER_CODE)
				border_map[x][y] = value3;
//if(((x < 2) && (y < 2)) ||
//		((9 == x) && (4 == y)) ||
//		((10 == x) && (2 == y)))
//	fprintf(stderr, "--->(%02d%02d): %d\n", x+1, y+1, border_map[x][y]);
		}
	}

	// third pass, fill in
	// hmmm, on second thought, doesn't help any......

//	for(y = 0;y < MAX_Y_HEX;y++) {
//		for(x = 0;x < MAX_X_HEX;x++) {
//			fprintf(stderr, "(%d %d): %d\n", x, y, border_map[x][y]);
//		}
//	}
}

void
MainFrame::SetMapTitle(void)
{
char *ptr1,*ptr2,*ptr3,buff[256],lbuff[20];
ColorTable *ct=NULL;

	ptr2 = ptr3 = "";
	lbuff[0] = 0;
	switch(mapping_mode) {
		case MM_MAP:
			ptr1 = "Map";
			if((ptr3 = sect->GetName()) != NULL) {
				ptr2 = ": ";
			} else
				ptr3 = "";
			break;
		case MM_ROUTE:
			ptr1 = "Route";
			ct = sect->GetRouteTable();
			break;
		case MM_BORDER2:
		case MM_BORDER:
			ptr1 = "Border";
			ct = sect->GetBorderTable();
			break;
	}
	
	if(ct != NULL) {
		ptr2 = ": ";
		ptr3 = ct->GetDesc(map_mode_color);
		if(MM_ROUTE == mapping_mode) {
			if((base_x_r < 0) || (base_y_r < 0))
				sprintf(lbuff, " (None)");
			else 
				sprintf(lbuff, " (%d %d)", base_x_r, base_y_r);
		}
	}

	sprintf(buff, "%s%s%s%s", ptr1, ptr2, ptr3, lbuff);

	map_frame->SetTitle(buff);
}

void
MainFrame::DecodeBorderMap(void)
{
int x,y,h,x1,y1;
HexData *hd;

	for(x = 0;x < MAX_X_HEX;x++) {
		for(y = 0;y < MAX_Y_HEX;y++) {
			for(h = 0;h < 6;h++) {
				if((hd = sect->GetHex(x, y)) != NULL)
					hd->AddBorder(h, UNDEFINED_BORDER_CODE);
				if((h > 0) && (h < 4))
					continue;
				if(sect->GetAdjCoord(x, y, h, &x1, &y1)) {
					if(border_map[x][y] != border_map[x1][y1]) {
						hd = sect->AddOrGetHex(x, y);
						if(border_map[x][y] >= 0)
							hd->AddBorder(h, border_map[x][y]);
						else
							hd->AddBorder(h, border_map[x1][y1]);
					}
				}
			}
		}
	}
}

void
MainFrame::BorderToggle2(int b, int x, int y)
{
	if(MM_BORDER2 == mapping_mode) {
		HexData *hd;

//fprintf(stderr, "(%02d%02d) %d --> %d\n", x+1, y+1, hd->border_ndx[b], map_mode_color);
		hd = sect->AddOrGetHex(x, y);
		if(hd->border_ndx[b] != map_mode_color)
			hd->border_ndx[b] = map_mode_color;
		else
			hd->border_ndx[b] = -1;
		map_frame->canvas->Refresh();
	}
}

void
MainFrame::BorderToggle(int x, int y, HIT_TEST_VAL val)
{
	if((MM_BORDER == mapping_mode) && (HT_HEX == val)) {
//fprintf(stderr, "(%02d%02d) %d --> %d\n", x+1, y+1, border_map[x][y], map_mode_color);
		if(map_mode_color == border_map[x][y])
			border_map[x][y] = -1;
		else
			border_map[x][y] = map_mode_color;
		map_frame->canvas->Refresh();
	}
}

void
MainFrame::RouteToggle(int x, int y, HIT_TEST_VAL val)
{
	if((MM_ROUTE == mapping_mode) && (HT_HEX == val)) {
		if((last_x_r == x) && (last_y_r == y)) {
			last_x_r = last_y_r = base_x_r = base_y_r = -1;
		} else {
			if((base_x_r > -1) && (base_y_r > -1)) {
				HexData *hd;

				hd = sect->AddOrGetHex(base_x_r, base_y_r);
				hd->AddRoute(x, y, map_mode_color);
				map_frame->canvas->Refresh();
			} else {
				base_x_r = x;
				base_y_r = y;
			}
			last_x_r = x;
			last_y_r = y;
		}
	}
	SetMapTitle();
}

// NOTE: x and y are screen coordinates, not map coordinates!
// XXX my current version of wxwin (gdk?) won't do the XOR
//  but, I'm leaving the code in place, in case it does
//  (this also means I haven't fixed GetMapCoordinates....)
void
MainFrame::RouteEcho(int x, int y)
{
	if(MM_ROUTE == mapping_mode) {
		int b_x,b_y;
		wxClientDC dc(map_frame->canvas);

    	PrepareDC(dc);
		GetMapCoordinates(base_x_r, base_y_r, &b_x, &b_y);
		dc.SetLogicalFunction(wxXOR);

		if((last_x_r > -1) && (last_y_r > -1)) {
			dc.DrawLine(b_x, b_y, last_x_r, last_y_r);
		}
		last_x_r = x;
		last_y_r = y;
		dc.DrawLine(b_x, b_y, last_x_r, last_y_r);
	}
}

void
MainFrame::GetMapCoordinates(int m_x, int m_y, int *n_x, int *n_y)
{
	*n_x = m_x;
	*n_y = m_y;
}

void
MainFrame::RefreshAll(void)
{
#ifdef SEPERATE_WINDOWS
	map_frame->canvas->Refresh();
	detail_frame->canvas->Refresh();
	list_frame->canvas->Refresh();
#else
	canvas->Refresh();
#endif
}

#ifdef TEST_FRAME
// ============================================================================
// ----------------------------------------------------------------------------
BEGIN_EVENT_TABLE(TestCanvas, wxScrolledWindow)
    EVT_PAINT(TestCanvas::OnPaint)
END_EVENT_TABLE()

TestCanvas::TestCanvas(wxWindow *frame, 
		int x, int y, int w, int h, long style) :
 	wxScrolledWindow(frame, -1, wxPoint(x, y), wxSize(w, h), style)
{
}

void 
TestCanvas::OnDraw(wxDC& dc)
{
	dc.Clear();

	frame->DrawFormatedSS(dc, 2);
}

#endif

#ifdef SEPERATE_WINDOWS
// ============================================================================
BEGIN_EVENT_TABLE(SectorText, wxScrolledWindow)
//	EVT_PAINT(SectorText::OnPaint)
//	EVT_MOUSE_EVENTS(SectorText::OnEvent)
//	EVT_RIGHT_DOWN(SectorText::OnRightDown)
END_EVENT_TABLE()

SectorText::SectorText(wxWindow *frame, 
		int x, int y, int w, int h, long style) :
 	wxScrolledWindow(frame, -1, wxPoint(x, y), wxSize(w, h), style)
{
}

void 
SectorText::OnDraw(wxDC& dc)
{
int x,y;
MainWorldDisplay *sd;

	dc.Clear();
	dc.SetFont(*textWindowFont);

	sd = new MainWorldDisplay(&dc);
// XXX
	for(x = 0;x < MAX_X_HEX;x++)
		for(y = 0;y < MAX_Y_HEX;y++)
			sd->DrawLine(frame->GetSector(), x, y);

    delete sd;
}

void
SectorText::OnEvent(wxMouseEvent& event)
{
}

void
SectorText::OnRightDown(wxMouseEvent& event)
{
//fprintf(stderr, "text: (%ld %ld)\n", event.GetX(), event.GetY());
}

// ==========================================================================
// ----------------------------------------------------------------------------
Sub_Frame::Sub_Frame(wxFrame *frame, const char *title, 
			int x, int y, int w, int h, long s) :
	SubFrame(frame, title, x, y, w, h, s)
{
}

Sub_Frame::~Sub_Frame()
{
}

void
Sub_Frame::MenuCheckCallBack(SubFrame *)
{
	frame->MenuCheckCallBack(this);
}

// ==========================================================================
BEGIN_EVENT_TABLE(MapFrame, wxFrame)
	EVT_MENU(SECTOR_ROUTE_MODE, MapFrame::RouteMode)
	EVT_MENU(SECTOR_BORDER_MODE, MapFrame::BorderMode)
	EVT_MENU(SECTOR_BORDER_MODE2, MapFrame::BorderMode2)
	EVT_MENU(SECTOR_MAP_MODE, MapFrame::ViewMode)
	EVT_MENU(SECTOR_HEX_VIEW, MapFrame::SectorView)
	EVT_MENU(SECTOR_HEX_BORDER, MapFrame::EditBorder)
	EVT_MENU(SECTOR_HEX_ROUTE, MapFrame::EditRoute)
	EVT_MENU(SECTOR_FEDIT_NOTES, MapFrame::SectorNotes)
	EVT_MENU(SECTOR_FEDIT_SS_NOTES, MapFrame::SSectorNotes)
	EVT_MENU(SECTOR_FEDIT_SS, MapFrame::EditSS)
	EVT_MENU(SECTOR_SEARCH_TRADE, MapFrame::SearchTrade)
	EVT_MENU(SECTOR_SEARCH_SHORT, MapFrame::SearchShort)
	EVT_MENU(SECTOR_SEARCH_RANGES, MapFrame::SearchRange)
	EVT_MENU(SECTOR_HEX_SELECT, MapFrame::SelectHex)
	EVT_MENU(SECTOR_HEX_DETAIL, MapFrame::ExecDetail)
	EVT_MENU(SECTOR_HEX_ENC, MapFrame::ExecEnc)
	EVT_MENU(SECTOR_HEX_TRADE, MapFrame::ExecTrade)
	EVT_MENU(SECTOR_FEDIT_VIEW, MapFrame::HexView)
	EVT_MENU(SECTOR_FEDIT_ROUTE, MapFrame::DoRoute)
	EVT_MENU(SECTOR_FEDIT_BORDER, MapFrame::DoBorder)
	EVT_MENU(SECTOR_EDIT_HEX, MapFrame::EditHex)
	EVT_MENU(SECTOR_ADD_HEX, MapFrame::AddHex)
	EVT_MENU(SECTOR_DEL_HEX, MapFrame::DelHex)
	EVT_MENU(SECTOR_HEX_NOTES, MapFrame::HexNotes)
//	EVT_MENU(SECTOR_HEX_CP, MapFrame::SelectCP)
	EVT_MENU_RANGE(ID_USER2, ID_USER2 + USER_ID_OFFSET, MapFrame::OnUser1)
	EVT_MENU_RANGE(ID_USER4, ID_USER4 + USER_ID_OFFSET, MapFrame::OnUser2)
END_EVENT_TABLE()
// ----------------------------------------------------------------------------
MapFrame::MapFrame(wxFrame *frame, const char *title, 
			int x, int y, int w, int h, long s) :
	Sub_Frame(frame, title, x, y, w, h, s)
{
}

MapFrame::~MapFrame()
{
}

// ----------------------------------------------------------------------------
void 
MapFrame::SelectHex(wxCommandEvent& event)
{
	frame->SelectHex(event);
}

#if 0
void 
MapFrame::SelectCP(wxCommandEvent& event)
{
	frame->DoSelectCP();
}
#endif

void
MapFrame::OnUser1(wxCommandEvent& event)
{
	frame->OnUser1(event);
}

void
MapFrame::OnUser2(wxCommandEvent& event)
{
	frame->OnUser2(event);
}

void 
MapFrame::ExecTrade(wxCommandEvent& event)
{
	frame->ExecTrade(event);
}

void 
MapFrame::ExecDetail(wxCommandEvent& event)
{
	frame->ExecDetail(event);
}

void 
MapFrame::ExecEnc(wxCommandEvent& event)
{
	frame->ExecEnc(event);
}

void 
MapFrame::EditBorder(wxCommandEvent& event)
{
	frame->EditBorder(event);
}

void 
MapFrame::EditRoute(wxCommandEvent& event)
{
	frame->EditRoute(event);
}

void MapFrame::SearchTrade(wxCommandEvent& event)
{
	frame->SearchTrade(event);
}

void MapFrame::SearchShort(wxCommandEvent& event)
{
	frame->SearchShort(event);
}

void MapFrame::SearchRange(wxCommandEvent& event)
{
	frame->SearchRange(event);
}

void 
MapFrame::EditSS(wxCommandEvent& event)
{
	frame->EditSS(event);
}

void 
MapFrame::DoRoute(wxCommandEvent& event)
{
	frame->ChooseRoute(event);
}

void 
MapFrame::HexView(wxCommandEvent& event)
{
	frame->HexView(event);
}

void 
MapFrame::SectorView(wxCommandEvent& event)
{
	frame->SectorView(event);
}

void 
MapFrame::DoBorder(wxCommandEvent& event)
{
	frame->ChooseBorder(event);
}

void 
MapFrame::RouteMode(wxCommandEvent& event)
{
	frame->SetMapMode(MM_ROUTE);
}

void 
MapFrame::BorderMode(wxCommandEvent& event)
{
	frame->SetMapMode(MM_BORDER);
}

void 
MapFrame::BorderMode2(wxCommandEvent& event)
{
	frame->SetMapMode(MM_BORDER2);
}

void 
MapFrame::ViewMode(wxCommandEvent& event)
{
	frame->SetMapMode(MM_MAP);
}

void 
MapFrame::SectorNotes(wxCommandEvent& event)
{
	frame->SectorNotes(event);
}

void 
MapFrame::SSectorNotes(wxCommandEvent& event)
{
	frame->SSectorNotes(event);
}

void 
MapFrame::HexNotes(wxCommandEvent& event)
{
	frame->HexNotes(event);
}

void 
MapFrame::EditHex(wxCommandEvent& event)
{
	frame->EditHex(event);
}

void 
MapFrame::AddHex(wxCommandEvent& event)
{
	frame->HexAdd(event);
}

void 
MapFrame::DelHex(wxCommandEvent& event)
{
	frame->HexDel(event);
}

// ===========================================================================
BEGIN_EVENT_TABLE(DetailText, wxScrolledWindow)
//	EVT_MOUSE_EVENTS(DetailText::OnEvent)
//  EVT_PAINT(DetailText::OnPaint)
END_EVENT_TABLE()

DetailText::DetailText(wxFrame *frame, int x, int y, int w, int h, long style):
	wxScrolledWindow(frame, -1, wxPoint(x, y), wxSize(w, h), style)
{
}

void
DetailText::OnDraw(wxDC& dc)
{
HexData *hd=NULL;

	hd = frame->GetCurrentHex();
	frame->DrawDetail(dc, hd);
}

//void
//DetailText::OnEvent(wxMouseEvent& event)
//{
//}
#endif

#ifndef SEPERATE_WINDOWS
// =========================================================================
BEGIN_EVENT_TABLE(SectorCanvas, wxScrolledWindow)
	EVT_RIGHT_DOWN(SectorCanvas::OnRightDown)
END_EVENT_TABLE()

SectorCanvas::SectorCanvas(wxFrame *frame) :
	wxScrolledWindow(frame, -1, wxPoint(0, 0), wxSize(480, 300), wxRETAINED)
{
}

void 
SectorCanvas::OnDraw(wxDC& dc)
{
HexData *hd=NULL;
MainWorldDisplay *sd;
//int start_x,start_y,end_x,end_y;

	dc.Clear();
	switch(frame->GetViewMode()) {
		case VM_map:
			frame->DrawMap(dc);
//			frame->DrawMap(dc, 0, 0, start_x, start_y, end_x, end_y);
			break;
		case VM_list:
			sd = new MainWorldDisplay(&dc);
			sd->DrawLines(TRUE);
    		delete sd;
			break;
		case VM_detail:
			hd = frame->GetCurrentHex();
			frame->DrawDetail(dc, hd);
			break;
	}
}

void 
SectorCanvas::OnRightDown(wxMouseEvent &event)
{
#ifdef POPUP_MENUS
	if(frame->GetViewMode() == VM_map)
		PopupMenu(frame->popup, event.GetX(), event.GetY());
#endif
}
#endif

#ifdef SEPERATE_WINDOWS
// =========================================================================
// Define a constructor for my canvas
BEGIN_EVENT_TABLE(MapCanvas, wxScrolledWindow)
//	EVT_MOUSE_EVENTS(MapCanvas::OnEvent)
	EVT_RIGHT_DOWN(MapCanvas::OnRightDown)
	EVT_MIDDLE_DOWN(MapCanvas::OnMiddleDown)
	EVT_LEFT_DOWN(MapCanvas::OnLeftDown)
// XXX see note at RouteEcho....
//	EVT_MOTION(MapCanvas::MouseMotion)
//	EVT_PAINT(MapCanvas::OnPaint)
END_EVENT_TABLE()

MapCanvas::MapCanvas(wxFrame *frame, int x, int y, int w, int h, long style):
	wxScrolledWindow(frame, -1, wxPoint(x, y), wxSize(w, h), style)
{
	last_x = last_y = -1;
}

HIT_TEST_VAL
MapCanvas::HitTest(long x_, long y_, int *r_x, int *r_y)
{
int x,y,norm_x,norm_y;
HIT_TEST_VAL ret=HT_NONE;

	BaseHitTest(x_, y_, &x, &y, &norm_x, &norm_y);

	if(norm_x < HEX_X_1)
		ret = HT_SECT;
	else if((y >= 0) && (y < MAX_Y_HEX))
		ret = HT_HEX;
	else
		ret = HT_GLOB;

// not exactly correct......
	*r_x = x;
	*r_y = y;

	return(ret);
}

// arbitrary space to allow a click....
#define Y_HIT_FUDGE			24

int
MapCanvas::BorderHitTest(long x_, long y_, int *r_x, int *r_y)
{
int ret=-1,x,y,norm_x,norm_y;

	BaseHitTest(x_, y_, &x, &y, &norm_x, &norm_y);

//fprintf(stderr,"--->BHT: (%ld %ld) H(%d %d) n:(%d %d)", x_, y_, x, y, norm_x, norm_y);
	// blindly set this
	*r_x = x;
	*r_y = y;

	if(norm_x < HEX_X_1) {
		if(norm_y < HEX_Y_3)
			ret = 5;
		else
			ret = 4;
	} else if(norm_x < HEX_X_2) {
		if(norm_y < Y_HIT_FUDGE)
			ret = 0;
		if(norm_y > (HEX_Y_4 - Y_HIT_FUDGE))
			ret = 3;
	} else {
		if(norm_y < HEX_Y_3)
			ret = 1;
		else
			ret = 2;
	}

	if((x < 0) || (y < 0) || (x >= MAX_X_HEX) || (y >= MAX_Y_HEX))
		ret = -1;
//fprintf(stderr, " %d\n", ret);
	return(ret);
}

void
MapCanvas::BaseHitTest(long x_, long y_, int *r_x, int *r_y, int *t_x, int *t_y)
{
int x,y,norm_x,norm_y,n_x,n_y;

	// convert to ints
	x = (int) x_;
	y = (int) y_;

	// adjust for scroll
	CalcUnscrolledPosition(x, y, &n_x, &n_y);
	// (x y) are the hex coordinates
	//   XXX 'cept the right edge gets shoved to the left
	x = n_x / HEX_X_2;
	y = n_y / HEX_Y_3;

	// (norm_x norm_y) are pixel coordinates within hex
	norm_x = n_x % HEX_X_2;
	if(x & 1) {
		y--;
		norm_y -= HEX_Y_3;
		norm_y = (n_y - HEX_Y_3) % HEX_Y_4;
	} else
		norm_y = n_y % HEX_Y_4;

	// hokey 'off the hex' checks
	if((MAX_X_HEX == x) && (norm_x < HEX_X_1)) {
		x--;
		y--;
		norm_x += HEX_X_2;
		norm_y = (n_y - HEX_Y_3) % HEX_Y_4;
	}

	if(y > -1)
		y /= 2;

	if((x >= 0) && (x < MAX_X_HEX)) {
		if((norm_x > -1)  && (norm_x <= HEX_X_1)) {
			if((x & 1) && (-1 == y)) {
				x--;
				y++;
				norm_y += HEX_Y_3;
				norm_x += HEX_X_2;
			} else if(((x & 1) == 0) && (MAX_Y_HEX == y)) {
				x--;
				y--;
				norm_y += HEX_Y_3;
				norm_x += HEX_X_2;
			}
		}
	}

	*r_x = x;
	*r_y = y;
	*t_x = norm_x;
	*t_y = norm_y;
}

void
MapCanvas::OnLeftDown(wxMouseEvent& event)
{
int x,y,i;
HIT_TEST_VAL val;

	if(frame->GetMapMode() == MM_MAP) {
		Menu *m;
		wxMenu *wx_m;

		if((m = frame->GetUserSectMenu()) != NULL) {
			if((wx_m = m->GetMenu()) != NULL) {
				PopupMenu(wx_m, event.GetX(), event.GetY());
			}
		}
	} else if(frame->GetMapMode() == MM_BORDER2) {
		i = BorderHitTest(event.GetX(), event.GetY(), &x, &y);
		if(i >= 0)
			frame->BorderToggle2(i, x, y);
	} else {
		val = HitTest(event.GetX(), event.GetY(), &x, &y);
		if(frame->GetMapMode() == MM_BORDER)
			frame->BorderToggle(x, y, val);
		else if(frame->GetMapMode() == MM_ROUTE)
			frame->RouteToggle(x, y, val);
	}
}

void
MapCanvas::MouseMotion(wxMouseEvent& event)
{
	frame->RouteEcho(event.GetX(), event.GetY());
}

void
MapCanvas::OnMiddleDown(wxMouseEvent& event)
{
Menu *m;
wxMenu *wx_m;

	if(frame->GetMapMode() == MM_MAP) {
		if((m = frame->GetUserHexMenu()) != NULL) {
			if((wx_m = m->GetMenu()) != NULL) {
				PopupMenu(wx_m, event.GetX(), event.GetY());
			}
		}
	}
}

void
MapCanvas::OnRightDown(wxMouseEvent& event)
{
int x,y;
HIT_TEST_VAL val;

	val = HitTest(event.GetX(), event.GetY(), &x, &y);
	if(HT_HEX == val) {
		last_x = x;
		last_y = y;
	} else
		last_x = last_y = -1;

#ifdef POPUP_MENUS
	PopupMenu(frame->popup, event.GetX(), event.GetY());
#endif
}

bool
MapCanvas::GetLastXY(short *x, short *y)
{
	if((last_x < 0) || (last_y < 0)) return(FALSE);

	*x = last_x + 1;
	*y = last_y + 1;
	last_x = last_y = -1;
	return(TRUE);
}


// Define the repainting behaviour
void
MapCanvas::OnDraw(wxDC& dc)
{
MapFrame *p;

	dc.Clear();
	p = (MapFrame *)GetParent();
	frame->DrawMap(dc);
}
#endif

// ==========================================================================
#define BITMAP_X_SIZE		(HEX_MAP_X_SIZE)
#define BITMAP_Y_SIZE		(HEX_MAP_Y_SIZE)

SectorBitmap::SectorBitmap(PRINT_TYPE t, SECTOR_PRINT_SOURCE s, int w, int h, 
		int s_x, int s_y, int e_x, int e_y) :
	wxBitmap(w, h)
{
	pt = t;
	ps = s;
	start_x = s_x;
	start_y = s_y;
	end_x = e_x;
	end_y = e_y;
}

SectorBitmap::~SectorBitmap()
{
}

void 
SectorBitmap::DrawWhatever(wxDC &dc, char *header_msg, int ss)
{
int w,h;
double s_w,s_h;

	// why isn't ther a @%#$@ Clear() ????
	dc.GetSize(&w, &h);
	dc.GetUserScale(&s_w, &s_h);
	w = (int) (w / s_w) + 1;
	h = (int) (h / s_h) + 1;
	dc.SetBrush(wxBrush(*frame->GetColors()->GetColor(WHITE_COLOR_INDEX), 
			wxSOLID));
	dc.SetPen(*wxWHITE_PEN);
	dc.DrawRectangle( 0, 0, w, h);
	switch(pt) {
		case PT_MAP:
			frame->DrawMapScaled(dc,  start_x, start_y, end_x, end_y,
					header_msg);
			break;
		case PT_LEGEND:
			frame->DrawLegend(dc);
			break;
		case PT_FORMAT:
			frame->DrawFormatedSS(dc, ss);
			break;
		default:
			break;
	}
}

// ==========================================================================

