/*
 * File:		t_dlg.h
 * Purpose:		general/generic dialogs
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: search.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 1999/06/13 16:25:26 $" */

#ifdef __GNUG__
#pragma interface
#endif

#ifndef SEARCH_H
#define SEARCH_H

#include "t_dlg.h"
#include "wx/toolbar.h"
#include "subframe.h"

typedef enum SEARCH_MODE {
	SEARCH_NONE=0,
	SEARCH_RANGE,
	SEARCH_TRADE,
	SEARCH_SHORT
	};

// ====================================================
class CompareClass
{ 
public:
	CompareClass();
	~CompareClass();

	bool Ok(main_world *mw);
	void Reset(void);

	void SetBases(char b) { bases = b; };
	void SetZone(char z) { zone = z; };
	void SetAlleg(const char *a);
	
	char GetBases(void) { return(bases); };
	char GetZone(void) { return(zone); };
	char *GetAlleg(void) { return(alleg); };
private:
	char bases;
	char zone;
	char *alleg;
};

// base class for the 2 min/max values
class MinMaxClass
{ 
friend class MinClass;
friend class MaxClass;
public: 
	MinMaxClass() { Reset(); };
	virtual ~MinMaxClass() {};

	bool Ok(main_world *mw);	

	void Reset(void);

	void SetPort(short v) { port = v; };
	void SetSize(short v) { size = v; };
	void SetAtmos(short v) { atmos = v; };
	void SetHydro(short v) { hydro = v; };
	void SetPop(short v) { pop = v; };
	void SetGovt(short v) { govt = v; };
	void SetLaw(short v) { law = v; };
	void SetTech(short v) { tech = v; };
	
	void SetNumGG(short v) { num_gg = v; };
	void SetNumBelt(short v) { num_belt = v; };
	
	void SetNumStar(short v) { num_star = v; };
	void SetStarType(short v) { star_type = v; };
	void SetStarSize(short v) { star_size = v; };
	void SetStarClass(short v) { star_class = v; };
	
private:            
	short 			port;
	short			size;
	short			atmos;
	short			hydro;
	short			pop;
	short			govt;
	short			law;
	short			tech;
	
	short			num_gg;
	short			num_belt;
	
	short			num_star;
	short			star_type;
	short			star_size;
	short			star_class;

	bool CompareVal(bool, short, short);
	// over ride this to get the appropriate min/max check:
	virtual bool Test(short b_val, short c_val) = 0;

};
                               
class MinClass : public MinMaxClass
{
public:
	MinClass();
	~MinClass() {};

private:
	bool Test(short b_val, short c_val) { return(CompareVal(FALSE, b_val, c_val)); };
};

class MaxClass : public MinMaxClass
{
public:
	MaxClass();
	~MaxClass() {};

private:
	bool Test(short b_val, short c_val) { return(CompareVal(TRUE, b_val, c_val)); };
	
};

// ====================================================
// SearchTradeDialog
#define MAX_TRADE_CB		32
class SearchTradeDialog : public OkCancelDialog
{
public:
	SearchTradeDialog(wxWindow *p, CodeTable *ct);
	~SearchTradeDialog() {};

	unsigned long GetTradeSearch(void);

private:

	wxCheckBox			*cb_s[MAX_TRADE_CB];

};

// ====================================================
// SearchRangeDialog
#define MAX_CHOICES		14
class SearchRangeDialog : public OkCancelDialog
{
public:
	SearchRangeDialog(wxWindow *p);
	~SearchRangeDialog() {};

	void GetRangeSearch(MinClass *min, MaxClass *max, CompareClass *comp);
	wxString GetChoiceStr(bool max, int ndx);

private:
	int InitArray(int which, wxString ptrs[]);
//					char **ptrs);

	wxChoice		*min_choices[MAX_CHOICES];
	wxChoice		*max_choices[MAX_CHOICES];

	wxTextCtrl		*bases;
	wxChoice		*zones;
	wxTextCtrl		*alleg;

};

// ====================================================
// SearchShortDialog
class SearchShortDialog : public OkCancelDialog
{
public:
	SearchShortDialog(wxWindow *p);
	~SearchShortDialog() {};

	void GetShortSearch(MinClass *min, MaxClass *max);

	wxString GetChoiceStr(int ndx);
	wxString GetHeaderStr(int ndx);

private:
	int BuildBuffers(const wxString& str1, const wxString& str2, 
					const wxString& str3, const wxString& str4, 
					const wxString& str5, const wxString& str6, 
					const wxString& str7, const wxString& str8);
	int BuildBuffer(wxString& dest, const wxString& src);
	void BuildChoice(int ndx, const wxString& title, 
					const wxString& str1, const wxString& str2, 
					const wxString& str3, const wxString& str4, 
					const wxString& str5, const wxString& str6, 
					const wxString& str7, const wxString& str8);

	wxChoice		*choices[8];

};

// ====================================================
// found worlds lists
class FoundEntry : public wxObject
{
public:
	FoundEntry(int x_, int y_);
	~FoundEntry() {};

	void GetValues(int *x_, int *y_);

private:
	short	x;
	short	y;
};

class FoundList : public wxList
{
public:
	FoundList();
	~FoundList();

	void Clear(void);

	bool GetFirst(int *x_, int *y_);
	bool GetPrev(int *x_, int *y_);
	bool GetCurrent(int *x_, int *y_);
	bool GetNext(int *x_, int *y_);
	bool GetLast(int *x_, int *y_);

	unsigned long GetIndex(void) { return(index); };
	int GetNumber(void) { return(Number()); };
	
//	unsigned long GetIndex(void) { return(index); };
	void SetIndex(unsigned long i) { index = i; };
	bool GetNextWCheck(int *x, int *y);

private:
	bool GetValues(int *x_, int *y_);
	unsigned long	index;
};

// ====================================================
// ====================================================
class ButtonPanel : public wxPanel
{
public:
//	SearchPanel(wxFrame *p, int x, int y);
	ButtonPanel(wxWindow *p);

	void SetMessage(char *msg) { text->SetLabel(msg); };

private:
//	wxBitmapButton		*first;
//	wxBitmapButton		*prev;
//	wxBitmapButton		*next;
//	wxBitmapButton		*last;
//	wxBitmapButton		*current;
//	wxBitmapButton		*close;

	wxStaticText	*text;
};

class SearchCanvas : public wxScrolledWindow
{
public:
	SearchCanvas(wxWindow *p);

	HexData *GetHexData(void);
	void OnDraw(wxDC& dc);

	DECLARE_EVENT_TABLE()
private:
};

#if 0
class SearchFrame : public wxFrame
{
public:
	SearchFrame(wxFrame *p, DetailSector *s);
	~SearchFrame();

//	bool OnClose(void);
//	void OnCloseWindow(wxCloseEvent &event);

	void DoTradeSearch(void);
	void DoShortSearch(void);
	void DoRangeSearch(void);

	void DoFirst(wxCommandEvent &event);
	void DoPrev(wxCommandEvent &event);
	void DoNext(wxCommandEvent &event);
	void DoLast(wxCommandEvent &event);
	void DoCurrent(wxCommandEvent &event);

	HexData *GetFirst(void);
	HexData *GetPrev(void);
	HexData *GetCurrent(void);
	HexData *GetNext(void);
	HexData *GetLast(void);

	void CloseDown(wxCommandEvent &event) { ClearSearch(); };
	
	ButtonPanel		*btns;
	SearchCanvas	*canvas;

	int GetCount(void);
	int GetHeaderCount(void);

	bool InitToolbar(wxToolBar *toolbar);

	int DrawHeader(DisplayMethod *dm);

	FoundList *GetSearchList(void) { return(found); };

	DECLARE_EVENT_TABLE()

private:
	bool OkToRun(void);
	void ClearSearch(void);
	void ResetSearch(void);

	void DoSearch(void);
	bool Search(void);
	bool TradeOk(main_world *mw);

// compare classes
	MinClass		*mins;
	MaxClass		*maxs;
	CompareClass	*comp;
	unsigned long	trades;

	SEARCH_MODE		mode;

	FoundList		*found;



// don't delete this:
	DetailSector			*sect;

// misc dialogs
	SearchTradeDialog		*TradeDlg;
	SearchShortDialog		*ShortDlg;
	SearchRangeDialog		*RangeDlg;

};
#endif

class SearchDialog : public wxDialog
{
public:
	SearchDialog(wxFrame *p, DetailSector *s);
	~SearchDialog();

	void DoTradeSearch(void);
	void DoShortSearch(void);
	void DoRangeSearch(void);

	void DoFirst(wxCommandEvent &event);
	void DoPrev(wxCommandEvent &event);
	void DoNext(wxCommandEvent &event);
	void DoLast(wxCommandEvent &event);
	void DoCurrent(wxCommandEvent &event);

	void DoTrade(wxCommandEvent &event);
	void DoShort(wxCommandEvent &event);
	void DoRange(wxCommandEvent &event);
	void DoDetail(wxCommandEvent &event);
	void DoList(wxCommandEvent &event);
	void DoPrint(wxCommandEvent &event);

	HexData *GetFirst(void);
	HexData *GetPrev(void);
	HexData *GetCurrent(void);
	HexData *GetNext(void);
	HexData *GetLast(void);

	void CloseDown(wxCommandEvent &event) { ClearSearch(); };
	
	ButtonPanel		*btns;
	SearchCanvas	*canvas;

	int GetCount(void);
	int GetHeaderCount(void);

	bool InitToolbar(wxToolBar *toolbar);

	int DrawHeader(DisplayMethod *dm);

	FoundList *GetSearchList(void) { return(found); };

	DECLARE_EVENT_TABLE()

private:
	bool OkToRun(void);
	void ClearSearch(void);
	void ResetSearch(void);

	void DoSearch(void);
	bool Search(void);
	bool TradeOk(main_world *mw);

// compare classes
	MinClass		*mins;
	MaxClass		*maxs;
	CompareClass	*comp;
	unsigned long	trades;

	SEARCH_MODE		mode;

	FoundList		*found;



// don't delete this:
	DetailSector			*sect;

// misc dialogs
	SearchTradeDialog		*TradeDlg;
	SearchShortDialog		*ShortDlg;
	SearchRangeDialog		*RangeDlg;

};

#endif

