/*
 * File:		search.cpp
 * Purpose:		simple searching for traveller sectors
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: search.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 1999/06/13 16:25:26 $" */

#ifdef __GNUG__
#pragma implementation
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "search.h"
#include "sect_dlg.h"

#include "str_util.h"

#ifdef __WXGTK__
#include "bitmaps/f_rev.xpm"
#include "bitmaps/rev.xpm"
#include "bitmaps/fwd.xpm"
#include "bitmaps/f_fwd.xpm"
#include "bitmaps/exit.xpm"
#include "bitmaps/print.xpm"
#include "bitmaps/mag.xpm"
#include "bitmaps/attr.xpm"
#endif

#define DUMMY_BUFFER_SIZE			120

// can't come up with a better way:
//SearchEngine *se=NULL;

//extern MainFrame *frame;

// yuch
//SearchDialog *s_frame;

CompareClass::CompareClass()
{
	bases = 0;
	zone = 0;
	alleg = NULL;
}

CompareClass::~CompareClass()
{
	Reset();
}

bool 
CompareClass::Ok(main_world *mw)
{
bool ret=TRUE;
char *ptr;

	if(bases != 0) {
		if(bases != mw->GetBase())
			ret = FALSE;
	}
	if(zone != 0) {
		if(zone != mw->GetZone())
			ret = FALSE;
	}
	if(alleg != NULL) {
		ptr = mw->GetAlleg();
		if(ptr == NULL)
			ret = FALSE;
		else if(strcmp(alleg, ptr))
			ret = FALSE;
	}

	return(ret);
}

void 
CompareClass::Reset(void)
{
	bases = 0;
	zone = 0;
	if(alleg != NULL)
		delete alleg;
	alleg = NULL;
}

void 
CompareClass::SetAlleg(const char *a)
{
	if(alleg != NULL)
		delete alleg;
	
	alleg = new char[strlen(a) + 1];
	strcpy(alleg, a);
}

// ===============================================================
void 
MinMaxClass::Reset()
{
	port = -1;;
	size = -1;;
	atmos = -1;;
	hydro = -1;;
	pop = -1;;
	govt = -1;;
	law = -1;;
	tech = -1;;
	
	num_gg = -1;;
	num_belt = -1;;
	
	num_star = -1;;
	star_type = -1;;
	star_size = -1;;
	star_class = -1;;
}

bool 
MinMaxClass::CompareVal(bool less_than, short b_val, short c_val)
{
bool ret=TRUE;

	if(c_val > -1) {
		// yes, the actual check is backwards
		//	but, look at the return val
		if(less_than) {
			if(b_val > c_val)
				ret = FALSE;
		}
		else {
			if(b_val < c_val)
				ret = FALSE;
		}
	}
	
	return(ret);
}

bool 
MinMaxClass::Ok(main_world *mw)
{
//short test_val;
int i,j;
bool ret=TRUE,temp_bool;
int temp;

	if(!Test(mw->get_port_val(), port))
		ret = FALSE;
		
	if(!Test(mw->get_size_val(), size))
		ret = FALSE;
		
	if(!Test(mw->get_atmos_val(), atmos))
		ret = FALSE;
		
	if(!Test(mw->get_hydro_val(), hydro))
		ret = FALSE;
		
	if(!Test(mw->get_pop_val(), pop))
		ret = FALSE;
		
	if(!Test(mw->get_govt_val(), govt))
		ret = FALSE;
		
	if(!Test(mw->get_law_val(), law))
		ret = FALSE;
		
	if(!Test(mw->get_tech_val(), tech))
		ret = FALSE;
		
	if(!Test(mw->GetNumGG(), num_gg))
		ret = FALSE;
		
	if(!Test(mw->GetNumBelts(), num_belt))
		ret = FALSE;

	j = mw->GetNumStars();

	if(!Test(j, num_star))
		ret = FALSE;

	temp_bool = FALSE;
	for(i = 0;i < j;i++) {
		if(temp_bool == TRUE)
			continue;
		temp = 0;
		if(Test(mw->GetStarType(i), star_type))
			temp |= 1;
		if(Test(mw->GetStarSize(i), star_size))
			temp |= 2;
		if(Test(mw->GetStarClass(i), star_class))
			temp |= 4;
		if((temp & 7) == 7)
			temp_bool = TRUE;
	}

	if(!temp_bool)
		ret = FALSE;
		
	return(ret);
}

// ===============================================================
MinClass::MinClass() :
	MinMaxClass()
{
}

MaxClass::MaxClass() :
	MinMaxClass()
{
}

// ===============================================================
// ===============================================================
#define BUTTON_PANEL_HEIGHT		(SML_BTN_SIZE + (2 * DLG_OFFSET))
#define BTN_ID_FIRST		501
#define BTN_ID_PREV			502
#define BTN_ID_NEXT			503
#define BTN_ID_LAST			504
#define BTN_ID_CLOSE		505
#define BTN_ID_TRADE		506
#define BTN_ID_SHORT		507
#define BTN_ID_RANGE		508
#define BTN_ID_DETAIL		509
#define BTN_ID_LIST			510
#define BTN_ID_PRINT		511


BEGIN_EVENT_TABLE(SearchDialog, wxDialog)
	EVT_BUTTON(BTN_ID_FIRST, DoFirst)
	EVT_BUTTON(BTN_ID_PREV, DoPrev)
	EVT_BUTTON(BTN_ID_NEXT, DoNext)
	EVT_BUTTON(BTN_ID_LAST, DoLast)
	EVT_BUTTON(BTN_ID_TRADE, DoTrade)
	EVT_BUTTON(BTN_ID_SHORT, DoShort)
	EVT_BUTTON(BTN_ID_RANGE, DoRange)
	EVT_BUTTON(BTN_ID_DETAIL, DoDetail)
	EVT_BUTTON(BTN_ID_LIST, DoList)
	EVT_BUTTON(BTN_ID_PRINT, DoPrint)

	EVT_BUTTON(BTN_ID_CLOSE, CloseDown)
	EVT_BUTTON(wxID_CANCEL, CloseDown)
END_EVENT_TABLE()

SearchDialog::~SearchDialog()
{
	delete mins;
	delete maxs;
	delete comp;
	delete found;
}

//bool 
//SearchDialog::OnClose(void)
//{
//	ClearSearch();
//	return(FALSE);
//}

SearchDialog::SearchDialog(wxFrame *p, DetailSector *s) :
	wxDialog(p, -1, "Delete this Title", 
			wxPoint(50, 50), wxSize(450, 340), 
			wxDEFAULT_DIALOG_STYLE | wxDIALOG_MODAL | wxTAB_TRAVERSAL)
{
//int x,y,x1,y1,x2,y2;
CodeTable *ct;
wxLayoutConstraints *c;

//	s_frame = this;

	btns = new ButtonPanel(this);
	canvas = new SearchCanvas(this);

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft);
	c->right.SameAs(this, wxRight);
	c->top.SameAs(this, wxTop);
//	c->height.Absolute(BUTTON_PANEL_HEIGHT);
	c->height.AsIs();
	btns->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft);
	c->right.SameAs(this, wxRight);
	c->bottom.SameAs(this, wxBottom);
	c->top.Below(btns);
	canvas->SetConstraints(c);

	SetAutoLayout(TRUE);
	Layout();

//	btns->GetPosition(&x, &y);
//	btns->GetSize(&x1, &y1);
//	canvas->Move(0, (y1 - y));
//	
//	canvas->GetSize(&x2, &y2);
//	btns->SetSize(x, y, x2, y1);	
//	
	Fit();

//	canvas->SetBackgroundColour(wxWHITE);
// internal workings
	mode = SEARCH_NONE;
	mins = new MinClass();
	maxs = new MaxClass();
	comp = new CompareClass();
	found = new FoundList();

// do the UI stuff
	sect = s;
	ct = s->GetTradeTable();

// create all the needed dialogs
	TradeDlg = new SearchTradeDialog(p, ct);
	ShortDlg = new SearchShortDialog(p);
	RangeDlg = new SearchRangeDialog(p);


	ClearSearch();
//	Show(TRUE);
};

bool 
SearchDialog::OkToRun(void)
{
	if(mode != SEARCH_NONE) {
		if(wxMessageBox("Discard Previous Search?", "Search Error", 
			wxCENTRE | wxYES_NO | wxICON_QUESTION) == wxNO)
			return(FALSE);

		ClearSearch();
		return(TRUE);
	}

	return(TRUE);
}

void 
SearchDialog::ResetSearch(void)
{
	found->Clear();
	
	mins->Reset();
	maxs->Reset();
	comp->Reset();
	trades = 0l;
	mode = SEARCH_NONE;
}

void
SearchDialog::ClearSearch(void)
{
	ResetSearch();
	EndModal(wxID_CANCEL);
	Show(FALSE);
}

bool 
SearchDialog::Search(void)
{
bool ret=FALSE;
int x,y;
HexData *hd;
FoundEntry *fe;
//int i=0;
bool f1, f2, f3, f4;

	for(x = 0; x < MAX_X_HEX;x++) {
		for(y = 0; y < MAX_Y_HEX;y++) {
			if(((hd = sect->GetHex(x, y)) != NULL) && (hd->world != NULL)) {
				f1 = mins->Ok(hd->world);
				f2 = maxs->Ok(hd->world);
				f3 = comp->Ok(hd->world);
				f4 = TradeOk(hd->world);
				if((mins->Ok(hd->world)) && (maxs->Ok(hd->world)) &&
					(comp->Ok(hd->world)) && (TradeOk(hd->world))) {
					ret = TRUE;
					fe = new FoundEntry(x, y);					
					found->Append((wxObject *) fe);
//					i++;
				}
			}
		}
	}

	return(ret);
}

bool
SearchDialog::InitToolbar(wxToolBar *tb)
{
wxBitmap* toolBarBitmaps[5];

  tb->SetMargins(5, 5);

  // Set up toolbar
#ifdef __WXMSW__
  toolBarBitmaps[0] = new wxBitmap("icon1");
  toolBarBitmaps[1] = new wxBitmap("icon2");
  toolBarBitmaps[2] = new wxBitmap("icon3");
  toolBarBitmaps[3] = new wxBitmap("icon4");
  toolBarBitmaps[4] = new wxBitmap("icon5");
#else
  toolBarBitmaps[0] = new wxBitmap( f_rev_xpm );
  toolBarBitmaps[1] = new wxBitmap( rev_xpm );
  toolBarBitmaps[2] = new wxBitmap( fwd_xpm );
  toolBarBitmaps[3] = new wxBitmap( f_fwd_xpm );
  toolBarBitmaps[4] = new wxBitmap( exit_xpm );
#endif

#ifdef __WXMSW__
  int width = 24;
#else
  int width = 16;
#endif
  int currentX = 5;

  tb->AddTool(wxID_NEW, *(toolBarBitmaps[0]), wxNullBitmap, FALSE, (float)currentX, -1, NULL, "First");
  currentX += width + 5;
  tb->AddTool(wxID_OPEN, *(toolBarBitmaps[1]), wxNullBitmap, FALSE, (float)currentX, -1, NULL, "Previous");
  currentX += width + 5;
  tb->AddTool(wxID_SAVE, *(toolBarBitmaps[2]), wxNullBitmap, FALSE, (float)currentX, -1, NULL, "Next");
  currentX += width + 5;
  tb->AddTool(wxID_COPY, *(toolBarBitmaps[3]), wxNullBitmap, FALSE, (float)currentX, -1, NULL, "Last");
  tb->AddSeparator();
  currentX += width + 5;
  tb->AddTool(wxID_CUT, *(toolBarBitmaps[4]), wxNullBitmap, FALSE, (float)currentX, -1, NULL, "Close");

  tb->Realize();

  // Can delete the bitmaps since they're reference counted
  int i;
  for (i = 0; i < 5; i++)
    delete toolBarBitmaps[i];

  return TRUE;
}

bool 
SearchDialog::TradeOk(main_world *mw)
{
bool ret=TRUE;

	if(trades != 0l)
		{
		if((mw->GetTradeCodes() & trades) != trades)
			ret = FALSE;
		}
	
	return(ret);
}

int 
SearchDialog::GetCount(void)
{
	return(found->GetNumber());
}

int 
SearchDialog::GetHeaderCount(void)
{
int ret_count=0;
unsigned long t;
int i;

	switch(mode)
		{
		case SEARCH_RANGE:
			{
			ret_count = 12;
			break;
			}
		case SEARCH_TRADE:
			{
			ret_count = 1;
			t = 1;
			for(i = 0;i < MAX_TRADE_CB;i++)
				{
				if(t & trades)
					{
					ret_count++;
					}
				t *= 2;
				}
			ret_count++;
			break;
			}
		case SEARCH_SHORT:
			{
			ret_count = 9;
			break;
			}
		case SEARCH_NONE:
			// ????
			break;
		}
	ret_count += 2;
	
	return(ret_count);
}

// ------------------------------------------------------------------------
//static char *RangeHeaderStr[] =
static const wxString RangeHeaderStr[] =
	{
	"Port:",
	"Size:",
	"Atmos:",
	"Hydro:",
	"Pop:",
	"Govt:",
	"Law:",
	"Tech:",
	"GG:",
	"Belts:",
	"Number:",
	"Type:",
	"Class:",
	"Size:"
	};
#if 0
int SearchDialog::DrawDetails(DisplayMethod *dm, char *msg, char *msg2, int start_count, int line_count)
{
	return(DrawBulk(FALSE, dm, msg, msg2, start_count, line_count));
}

int SearchDialog::DrawLines(DisplayMethod *dm, char *msg, char *msg2, int start_count, int line_count)
{
	return(DrawBulk(TRUE, dm, msg, msg2, start_count, line_count));
}

int SearchDialog::DrawBulk(bool lines, DisplayMethod *dm, char *msg, char *msg2, int start_count, int line_count)
{
unsigned long temp_ndx;
int x,y,i=1;
char buff[120];
int ret_count=0;
int disp_count=0;
int ndx_count = 0;
int temp_count;
bool stat=FALSE;

// this needs to be saved
	temp_ndx = found->GetIndex();

	if(lines)
		temp_count = 1;
	else
		temp_count = 25;

// do header info here:
	dm->Start(msg);
	if(start_count == 0) {
		disp_count = DrawHeader(dm);
	}

// go to the first one and find the 'start_count'th one
	found->GetFirst(&x, &y);
	while(ndx_count < start_count) {
		if((stat = found->GetNextWCheck(&x, &y)) == FALSE)
			break;
		ndx_count++;
	}

// draw what we can
	if(stat) {
		DrawWorld(lines, dm, x, y);
		disp_count += temp_count;
		ndx_count++;

		while(((disp_count + temp_count) < line_count) && 
				(stat = found->GetNextWCheck(&x, &y))) {
			DrawWorld(lines, dm, x, y);
			disp_count += temp_count;
			ndx_count++;
		}
	}

// end of page or end of run?
	if(!stat) {
		if((disp_count + 1) < line_count) {
			sprintf(buff, "Found %d Worlds.", i);
			dm->Line(buff);
			ndx_count = -1;
		}
	}

	dm->Finish(msg2);
// reset this
	found->SetIndex(temp_ndx);

	return(ndx_count);
}

void SearchDialog::DrawWorld(bool lines, DisplayMethod* dm, int x, int y)
{
char buff[120];

	if(lines) {
		sect->GetListing(x, y, buff);
		dm->Line(buff);
	}
	else {
		dm->DrawDetail(sect->get_hex(x, y));
		dm->Line("------------------------");
		dm->Line(" ");
	}
}
#endif

int 
SearchDialog::DrawHeader(DisplayMethod *dm)
{
char buff[120];
unsigned long t;
int i;
char *ptr1;
char lbuff[20];
int ret_count=0;

	switch(mode) {
		case SEARCH_RANGE: {
			dm->Line("Search for Ranges:");
			dm->Line("UWP     Min Max    Stars:  Min  Max");
			for(i = 0;i < 10;i++) {
				sprintf(buff, RangeHeaderStr[i]);
				strfixsize(buff, 8);
				strcat(buff, RangeDlg->GetChoiceStr(FALSE, i));
				strfixsize(buff, 12);
				strcat(buff, RangeDlg->GetChoiceStr(TRUE, i));
				strfixsize(buff, 19);
				if(i < 4) {
					strcat(buff, RangeHeaderStr[i+10]);
					strfixsize(buff, 27);
					strcat(buff, RangeDlg->GetChoiceStr(FALSE, i+10));
					strfixsize(buff, 32);
					strcat(buff, RangeDlg->GetChoiceStr(TRUE, i+10));
				}
				else if(i == 5) {
					strcat(buff, "Bases:");
					strfixsize(buff, 27);
					lbuff[0] = comp->GetBases();
					lbuff[1] = 0;
					strcat(buff, lbuff);
				}
				else if(i == 6) {
					strcat(buff, "Zone:");
					strfixsize(buff, 27);
					lbuff[0] = comp->GetZone();
					lbuff[1] = 0;
					strcat(buff, lbuff);
				}
				else if(i == 7) {
					strcat(buff, "Bases:");
					strfixsize(buff, 27);
					ptr1 = comp->GetAlleg();
					if(ptr1 != NULL)
						strcat(buff, ptr1);
				}

				dm->Line(buff);
			}
			ret_count = 12;
			break;
		}
		case SEARCH_TRADE: {
			dm->Line("Search for Trade Codes:");
			ret_count = 1;
			t = 1;
			for(i = 0;i < MAX_TRADE_CB;i++) {
				if(t & trades) {
					sect->FormatTrade(t, buff);
					dm->Line(buff);
					ret_count++;
				}
				t *= 2;
			}
			dm->Line(" ");
			ret_count++;
			break;
		}
		case SEARCH_SHORT: {
			dm->Line("Search for Simple Codes:");
			for(i = 0;i < 8;i++) {
				sprintf(buff, "%s %s", 
							ShortDlg->GetHeaderStr(i).c_str(),
							ShortDlg->GetChoiceStr(i).c_str());
//				ptr1 = ShortDlg->GetHeaderStr(i);
//				ptr2 = ShortDlg->GetChoiceStr(i);
//				sprintf(buff, "%s %s", ptr1, ptr2);
				dm->Line(buff);
			}
			ret_count = 9;
			break;
		}
		case SEARCH_NONE:
			// ????
			break;
	}
	dm->Line("========================");
	dm->Line(" ");
	ret_count += 2;

	return(ret_count);
}

// --------------------------------------------------------------------------
void 
SearchDialog::DoSearch(void)
{
	if(Search()) {
		SetTitle("Short Code Search");
//		Show(TRUE);
		ShowModal();
	} else {
		wxMessageBox("No Worlds Found.", "Search Error", 
			wxCENTRE | wxOK | wxICON_EXCLAMATION);
		mode = SEARCH_NONE;
	}
}

void 
SearchDialog::DoShortSearch(void)
{
	if(OkToRun()) {
		ShortDlg->GetShortSearch(mins, maxs);
		if(!ShortDlg->Canceled()) {
			mode = SEARCH_SHORT;
			SetTitle("Short Code Search");
			DoSearch();
		}
	}
}

void 
SearchDialog::DoTradeSearch(void)
{
	if(OkToRun()) {
		trades = TradeDlg->GetTradeSearch();
		if(!TradeDlg->Canceled()) {
			mode = SEARCH_TRADE;
			SetTitle("Trade Search");
			DoSearch();
		}
	}
}

void 
SearchDialog::DoRangeSearch(void)
{
	if(OkToRun()) {
		RangeDlg->GetRangeSearch(mins, maxs, comp);
		if(!RangeDlg->Canceled()) {
			mode = SEARCH_RANGE;
			SetTitle("Range Search");
			DoSearch();
		}
	}
}

// --------------------------------------------------------------------------
HexData *
SearchDialog::GetFirst(void)
{
int x,y;

	if(found->GetFirst(&x, &y)) {
		return(sect->GetHex(x, y));
	}

	return(NULL);	
}

HexData *
SearchDialog::GetPrev(void)
{
int x,y;

	if(found->GetPrev(&x, &y)) {
		return(sect->GetHex(x, y));
	}

	return(NULL);	
}

HexData *
SearchDialog::GetCurrent(void)
{
int x,y;
char buff[DUMMY_BUFFER_SIZE];

// making a gross assumption here that this comes in for the canvas' paint
	sprintf(buff, "Displaying %ld of %d", 
			found->GetIndex() + 1, found->GetNumber());
	btns->SetMessage(buff);
	if(found->GetCurrent(&x, &y)) {
		return(sect->GetHex(x, y));
	}

	return(NULL);
}

HexData *
SearchDialog::GetNext(void)
{
int x,y;

	if(found->GetNext(&x, &y)) {
		return(sect->GetHex(x, y));
	}

	return(NULL);	
}

HexData *
SearchDialog::GetLast(void)
{
int x,y;

	if(found->GetLast(&x, &y)) {
		return(sect->GetHex(x, y));
	}

	return(NULL);	
}

void 
SearchDialog::DoFirst(wxCommandEvent &event)
{
	GetFirst();
	canvas->Refresh();
}

void 
SearchDialog::DoPrev(wxCommandEvent &event)
{
	GetPrev();
	canvas->Refresh();
}

void 
SearchDialog::DoNext(wxCommandEvent &event)
{
	GetNext();
	canvas->Refresh();
}

void 
SearchDialog::DoLast(wxCommandEvent &event)
{
	GetLast();
	canvas->Refresh();
}

void 
SearchDialog::DoCurrent(wxCommandEvent &event)
{
}

void 
SearchDialog::DoTrade(wxCommandEvent &event)
{
	ResetSearch();
	trades = TradeDlg->GetTradeSearch();
	if(!TradeDlg->Canceled()) {
		mode = SEARCH_TRADE;
		SetTitle("Trade Search");
	}
	Search();
	Refresh();
}

void 
SearchDialog::DoShort(wxCommandEvent &event)
{
	ResetSearch();
	ShortDlg->GetShortSearch(mins, maxs);
	if(!ShortDlg->Canceled()) {
		mode = SEARCH_SHORT;
		SetTitle("Short Code Search");
		DoSearch();
	}
	Search();
	Refresh();
}

void 
SearchDialog::DoRange(wxCommandEvent &event)
{
	ResetSearch();
	RangeDlg->GetRangeSearch(mins, maxs, comp);
	if(!RangeDlg->Canceled()) {
		mode = SEARCH_RANGE;
		SetTitle("Range Search");
	}
	Search();
	Refresh();
}

void 
SearchDialog::DoDetail(wxCommandEvent &event)
{
}

void 
SearchDialog::DoList(wxCommandEvent &event)
{
}

void 
SearchDialog::DoPrint(wxCommandEvent &event)
{
}

// ===============================================================
BEGIN_EVENT_TABLE(SearchCanvas, wxScrolledWindow)
	EVT_PAINT(SearchCanvas::OnPaint)
END_EVENT_TABLE()

SearchCanvas::SearchCanvas(wxWindow *p) :
    wxScrolledWindow(p, -1, wxPoint(-1, -1), wxSize(500, 400), wxRETAINED)
{
}

HexData *
SearchCanvas::GetHexData(void)
{
HexData *hd;
SearchDialog *p;

	p = (SearchDialog *)GetParent();

	hd = p->GetCurrent();

	return(hd);
}

void 
SearchCanvas::OnDraw(wxDC& dc)
{
SectorDisplay *sd;
HexData *hd;

	dc.Clear();
	hd = GetHexData();
	sd = new SectorDisplay(&dc);
	sd->Start();
	sd->DrawDetail(hd);
//	sd->DrawDetails(FALSE);
	delete sd;
}

// ===============================================================
#if 0
void first_fcn(wxButton& but, wxCommandEvent& event)
{
SearchDialog *p;
	
	p = (SearchDialog *) but.GetParent()->GetParent();
	p->DoFirst();
}

void prev_fcn(wxButton& but, wxCommandEvent& event)
{
SearchDialog *p;
	
	p = (SearchDialog *) but.GetParent()->GetParent();
	p->DoPrev();
}

void next_fcn(wxButton& but, wxCommandEvent& event)
{
SearchDialog *p;
	
	p = (SearchDialog *) but.GetParent()->GetParent();
	p->DoNext();
}

void last_fcn(wxButton& but, wxCommandEvent& event)
{
SearchDialog *p;
	
	p = (SearchDialog *) but.GetParent()->GetParent();
	p->DoLast();
}

void current_fcn(wxButton& but, wxCommandEvent& event)
{
SearchDialog *p;
	
	p = (SearchDialog *) but.GetParent()->GetParent();
	p->DoCurrent();
}

void close_fcn(wxButton& but, wxCommandEvent& event)
{
SearchDialog *p;
	
	p = (SearchDialog *) but.GetParent()->GetParent();
	p->CloseDown();
}
#endif

ButtonPanel::ButtonPanel(wxWindow *p) :
	wxPanel(p) //, -1, wxPoint(0, 0), wxSize(400, 30))
{
int i;
wxBitmapButton		*detail;
wxBitmapButton		*list;
wxBitmapButton		*print;
wxBitmapButton		*first;
wxBitmapButton		*prev;
wxBitmapButton		*next;
wxBitmapButton		*last;
wxButton			*trade;
wxButton			*short_;
wxButton			*range;
wxButton			*close;
wxLayoutConstraints *c;
wxBitmap* bm[7];

// Set up my toolbar
#ifdef __WXMSW__
	bm[0] = new wxBitmap("icon1");
	bm[1] = new wxBitmap("icon2");
	bm[2] = new wxBitmap("icon3");
	bm[3] = new wxBitmap("icon4");
	bm[4] = new wxBitmap("icon5");
	bm[5] = new wxBitmap("icon6");
	bm[6] = new wxBitmap("icon7");
#else
	bm[0] = new wxBitmap(attr_xpm);
	bm[1] = new wxBitmap(mag_xpm);
	bm[2] = new wxBitmap(print_xpm);
	bm[3] = new wxBitmap(f_rev_xpm);
	bm[4] = new wxBitmap(rev_xpm);
	bm[5] = new wxBitmap(fwd_xpm);
	bm[6] = new wxBitmap(f_fwd_xpm);
#endif

	text = new wxStaticText(this, -1, "Displaying 0 of xxxxxxxxxxxx");

	detail = new wxBitmapButton(this, BTN_ID_DETAIL, *bm[0],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	list = new wxBitmapButton(this, BTN_ID_LIST, *bm[1],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	print = new wxBitmapButton(this, BTN_ID_PRINT, *bm[2],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));

	first = new wxBitmapButton(this, BTN_ID_FIRST, *bm[3],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	prev = new wxBitmapButton(this, BTN_ID_PREV, *bm[4],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	next = new wxBitmapButton(this, BTN_ID_NEXT, *bm[5],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));
	last = new wxBitmapButton(this, BTN_ID_LAST, *bm[6],
		wxPoint(-1, -1), wxSize(SML_BTN_SIZE, SML_BTN_SIZE));

	trade = new wxButton(this, BTN_ID_TRADE, "Trade");
	short_ = new wxButton(this, BTN_ID_SHORT, "Short");
	range = new wxButton(this, BTN_ID_RANGE, "Range");
	close = new wxButton(this, wxID_CANCEL, "Close");
  // Can delete the bitmaps since they're reference counted
	for (i = 0; i < 5; i++)
		delete bm[i];

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	detail->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(detail, wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	list->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(list, wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	print->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(print, wxRight, DLG_OFFSET * 2);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	first->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(first, wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	prev->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(prev, wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	next->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(next, wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	last->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(last, wxRight, DLG_OFFSET * 2);
	c->top.SameAs(this, wxTop, DLG_OFFSET * 2);
	c->height.AsIs();
	c->width.AsIs();
	text->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft, DLG_OFFSET);
	c->top.SameAs(detail, wxBottom, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	trade->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(trade, wxRight, DLG_OFFSET);
	c->top.SameAs(detail, wxBottom, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	short_->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(short_, wxRight, DLG_OFFSET);
	c->top.SameAs(detail, wxBottom, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	range->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(range, wxRight, DLG_OFFSET);
	c->top.SameAs(detail, wxBottom, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	close->SetConstraints(c);

	SetAutoLayout(TRUE);
	Layout();

//	close->SetDefault();

	Fit();
}

// ===============================================================
// dummy buffers......
#define MAX_BUFFER_NUM		8
#define MAX_BUFFER_LEN		24

//static char dummy_buffers[MAX_BUFFER_NUM][MAX_BUFFER_LEN];
static wxString dummy_buffers[MAX_BUFFER_NUM];//[MAX_BUFFER_LEN];

//static char *HeaderStr[8] =
static const wxString HeaderStr[8] =
	{
	"Port:       ",
	"Size:       ",
	"Atmosphere: ",
	"Hydrosphere:",
	"Population: ",
	"Government: ",
	"Law Level:  ",
	"Technology: "
	};

static char *port_str[] = {
	"Any",
	"A Excellent",
	"B Good",
	"C Routine",
	"D Poor",
	"E Frontier",
	"X None"
	};

static char *size_str[] = {
	"Any",
	"Asteroid",
	"Small",
	"Medium",
	"Large"
	};

static char *atmos_str[] = {
	"Any",
	"Vacuum",
	"Thin",
	"Standard",
	"Dense",
	"Exotic"
	};

static char *hydro_str[] = {
	"Any",
	"Desert World",
	"Dry World",
	"Wet World",
	"Water World"
	};

static char *pop_str[] = {
	"Any",
	"Incidental",
	"Low",
	"Moderate",
	"High"
	};

static char *govt_str[] = {
	"Any",
	"None",
	"Low",
	"Moderate",
	"High",
	"Extreme"
	};

static char *law_str[] = {
	"Any",
	"None",
	"Low",
	"Moderate",
	"High",
	"Extreme"
	};

static char *tech_str[] = {
	"Any",
	"Pre-Industrial",
	"Industrial",
	"Pre-Stellar",
	"Early Stellar",
	"Average Stellar",
	"High Stellar",
	"Extreme Stellar"
	};

SearchShortDialog::SearchShortDialog(wxWindow *p) :
	OkCancelDialog(p, "Search For Short Codes")
{
int i;
wxString ptrs[8];
wxStaticText *msg[8];
wxLayoutConstraints *c;

	msg[0] = new wxStaticText(this, -1, "Port:");
	msg[1] = new wxStaticText(this, -1, "Size:");
	msg[2] = new wxStaticText(this, -1, "Atmos:");
	msg[3] = new wxStaticText(this, -1, "Hydro:");
	msg[4] = new wxStaticText(this, -1, "Pop:");
	msg[5] = new wxStaticText(this, -1, "Govt:");
	msg[6] = new wxStaticText(this, -1, "Law:");
	msg[7] = new wxStaticText(this, -1, "Tech:");

	for(i = 0;i < 7;i++)
		ptrs[i] = port_str[i];
	choices[0] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			7, ptrs);
	for(i = 0;i < 5;i++)
		ptrs[i] = size_str[i];
	choices[1] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			5, ptrs);
	for(i = 0;i < 6;i++)
		ptrs[i] = atmos_str[i];
	choices[2] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			6, ptrs);
	for(i = 0;i < 5;i++)
		ptrs[i] = hydro_str[i];
	choices[3] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			5, ptrs);
	for(i = 0;i < 5;i++)
		ptrs[i] = pop_str[i];
	choices[4] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			5, ptrs);
	for(i = 0;i < 6;i++)
		ptrs[i] = govt_str[i];
	choices[5] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			6, ptrs);
	for(i = 0;i < 6;i++)
		ptrs[i] = law_str[i];
	choices[6] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			6, ptrs);
	for(i = 0;i < 8;i++)
		ptrs[i] = tech_str[i];
	choices[7] = new wxChoice(this, -1, 
			wxPoint(-1, -1), 
			wxSize(-1, -1),
			8, ptrs);

	CreateWidgets();

	for(i = 0;i < 8;i++) {
		c = new wxLayoutConstraints;
		c->left.SameAs(this, wxLeft, DLG_OFFSET);
		if(0 == i)
			c->top.SameAs(this, wxTop, DLG_OFFSET * 2);
		else
			c->top.SameAs(msg[i-1], wxBottom, DLG_OFFSET * 3);
		c->height.AsIs();
		c->width.AsIs();
		msg[i]->SetConstraints(c);

		c = new wxLayoutConstraints;
		c->left.SameAs(msg[3], wxRight, DLG_OFFSET);
		if(0 == i)
			c->top.SameAs(this, wxTop, DLG_OFFSET);
		else
			c->top.SameAs(choices[i-1], wxBottom, DLG_OFFSET);
		c->height.AsIs();
		c->width.AsIs();
		choices[i]->SetConstraints(c);
	}

	SetWidgets(choices[7]);
}

wxString
SearchShortDialog::GetHeaderStr(int ndx)
{
	return(HeaderStr[ndx]);
#if 0
char *ptr=NULL;

	if((ndx >= 0) && (ndx < 8))
		{
		ptr = HeaderStr[ndx];
		}

	return(ptr);
#endif
}

wxString
SearchShortDialog::GetChoiceStr(int ndx)
{
wxString ptr;

	if((ndx >= 0) && (ndx < 8))
		{
		ptr = choices[ndx]->GetStringSelection();
//		if((sel >= 0) && (sel < choices->Number(ndx))
//			{
//			ptr = choices->GetString(sel);
//			}
		}

	return(ptr);
}

void 
SearchShortDialog::GetShortSearch(MinClass *min, MaxClass *max)
{
int i;

	if(ShowModal() != wxID_CANCEL)
		{
		i = choices[0]->GetSelection();
		if(i > 0)
			{
			if(i < 5)
				{
				min->SetPort(i - 1);
				max->SetPort(i - 1);
				}
			else
				{
				min->SetPort(8);
				max->SetPort(8);
				}
			}

		i = choices[1]->GetSelection();
		if(i > 0)
			{
			switch(i)
				{
				case 1:
					{
					min->SetSize(0);
					max->SetSize(0);
					break;
					}
				case 2:
					{
					min->SetSize(1);
					max->SetSize(4);
					break;
					}
				case 3:
					{
					min->SetSize(5);
					max->SetSize(7);
					break;
					}
				case 4:
					{
					min->SetSize(8);
					max->SetSize(10);
					break;
					}
				}
			}

		i = choices[2]->GetSelection();
		if(i > 0)
			{
			switch(i)
				{
				case 1:
					{
					min->SetAtmos(0);
					max->SetAtmos(3);
					break;
					}
				case 2:
					{
					min->SetAtmos(4);
					max->SetAtmos(5);
					break;
					}
				case 3:
					{
					min->SetAtmos(6);
					max->SetAtmos(7);
					break;
					}
				case 4:
					{
					min->SetAtmos(8);
					max->SetAtmos(9);
					break;
					}
				case 5:
					{
					min->SetAtmos(10);
					max->SetAtmos(15);
					break;
					}
				}
			}

		i = choices[3]->GetSelection();
		if(i > 0)
			{
			switch(i)
				{
				case 1:
					{
					min->SetHydro(0);
					max->SetHydro(0);
					break;
					}
				case 2:
					{
					min->SetHydro(1);
					max->SetHydro(3);
					break;
					}
				case 3:
					{
					min->SetHydro(4);
					max->SetHydro(8);
					break;
					}
				case 4:
					{
					min->SetHydro(9);
					max->SetHydro(10);
					break;
					}
				}
			}

		i = choices[4]->GetSelection();
		if(i > 0)
			{
			switch(i)
				{
				case 1:
					{
					min->SetPop(0);
					max->SetPop(2);
					break;
					}
				case 2:
					{
					min->SetPop(3);
					max->SetPop(5);
					break;
					}
				case 3:
					{
					min->SetPop(6);
					max->SetPop(8);
					break;
					}
				case 4:
					{
					min->SetPop(9);
					max->SetPop(10);
					break;
					}
				}
			}

		i = choices[5]->GetSelection();
		if(i > 0)
			{
			switch(i)
				{
				case 1:
					{
					min->SetGovt(0);
					max->SetGovt(0);
					break;
					}
				case 2:
					{
					min->SetGovt(1);
					max->SetGovt(3);
					break;
					}
				case 3:
					{
					min->SetGovt(4);
					max->SetGovt(7);
					break;
					}
				case 4:
					{
					min->SetGovt(8);
					max->SetGovt(9);
					break;
					}
				case 5:
					{
					min->SetGovt(10);
					max->SetGovt(24);
					break;
					}
				}
			}

		i = choices[6]->GetSelection();
		if(i > 0)
			{
			switch(i)
				{
				case 1:
					{
					min->SetLaw(0);
					max->SetLaw(0);
					break;
					}
				case 2:
					{
					min->SetLaw(1);
					max->SetLaw(3);
					break;
					}
				case 3:
					{
					min->SetLaw(4);
					max->SetLaw(7);
					break;
					}
				case 4:
					{
					min->SetLaw(8);
					max->SetLaw(9);
					break;
					}
				case 5:
					{
					min->SetLaw(10);
					max->SetLaw(24);
					break;
					}
				}
			}

		i = choices[7]->GetSelection();
		if(i > 0)
			{
			switch(i)
				{
				case 1:
					{
					min->SetTech(0);
					max->SetTech(3);
					break;
					}
				case 2:
					{
					min->SetTech(4);
					max->SetTech(5);
					break;
					}
				case 3:
					{
					min->SetTech(6);
					max->SetTech(8);
					break;
					}
				case 4:
					{
					min->SetTech(9);
					max->SetTech(10);
					break;
					}
				case 5:
					{
					min->SetTech(11);
					max->SetTech(13);
					break;
					}
				case 6:
					{
					min->SetTech(14);
					max->SetTech(16);
					break;
					}
				case 7:
					{
					min->SetTech(17);
					max->SetTech(24);
					break;
					}
				}
			}

		}
}

void 
SearchShortDialog::BuildChoice(int ndx, const wxString& title, 
								const wxString& str1, const wxString& str2, 
								const wxString& str3, const wxString& str4, 
								const wxString& str5, const wxString& str6, 
								const wxString& str7, const wxString& str8)
{
int i,j=1;
//char *dummy_ptr[MAX_BUFFER_NUM] =
wxString dummy_ptr[MAX_BUFFER_NUM] =
				{ dummy_buffers[0],
				  dummy_buffers[1],
				  dummy_buffers[2],
				  dummy_buffers[3],
				  dummy_buffers[4],
				  dummy_buffers[5],
				  dummy_buffers[6],
				  dummy_buffers[7]};

	if(ndx & 1)
#ifdef __WINDOWS__
		j = 95;
#endif
#ifdef __WXGTK__
		j = 115;
#endif
	else
		j = 5;

	i = BuildBuffers(str1, str2, str3, str4, str5, str6, str7, str8);
//	choices[ndx] = new wxChoice(this, NULL, title, j, -1, -1, -1, 
//		i, dummy_ptr, wxFIXED_LENGTH);
	wxStaticText(this, -1, title);
	choices[ndx] = new wxChoice(this, -1, wxPoint(j, -1), wxSize(-1, -1),
			i, dummy_ptr);
	choices[ndx]->SetSelection(0);

////	if(ndx & 1)
////		NewLine();
}

int 
SearchShortDialog::BuildBuffers(const wxString& str1, const wxString& str2, 
								const wxString& str3, const wxString& str4, 
								const wxString& str5, const wxString& str6, 
								const wxString& str7, const wxString& str8)
{
int i,j=0,k=0;

	if((i = BuildBuffer(dummy_buffers[0], str1)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[1], str2)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[2], str3)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[3], str4)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[4], str5)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[5], str6)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[6], str7)) > j)
		j = i;
	if((i = BuildBuffer(dummy_buffers[7], str8)) > j)
		j = i;

	for(i = 0;i < MAX_BUFFER_NUM;i++) {
		if(dummy_buffers[i].Len() > 0)
			k++;
		dummy_buffers[i].Pad(j - dummy_buffers[i].Len());
//		if(strlen(dummy_buffers[i]) > 0)
//			k++;
//		strfixsize(dummy_buffers[i], j);
	}

	return(k);
}

int 
SearchShortDialog::BuildBuffer(wxString& dest, const wxString& src)
{
	if(src == NULL) {
		dest.Truncate(0);
		return(0);
	} else {
		dest = src;
		return(dest.Len());
	}
}

// ===============================================================
#ifdef __WINDOWS
#define GROUP_OFFSET		5

#define MSG_Y_OFFSET		24
#define MSG_Y_OFFSET2		(MSG_Y_OFFSET / 2)
#define MSG_Y_OFFSET3		(MSG_Y_OFFSET / 4)
#define MSG_Y_OFFSET4		0

#define GROUP_UWP_X1		GROUP_OFFSET
#define GROUP_UWP_Y1		0
#define GROUP_UWP_X2		135
#define GROUP_UWP_Y2		((MSG_Y_OFFSET * 9) + (MSG_Y_OFFSET / 2))

#define GROUP_STAR_X1		(GROUP_UWP_X1 + GROUP_UWP_X2 + GROUP_OFFSET)
#define GROUP_STAR_Y1		GROUP_UWP_Y1
#define GROUP_STAR_X2		150
#define GROUP_STAR_Y2		((MSG_Y_OFFSET * 5) + (MSG_Y_OFFSET / 2))

#define GROUP_SYS_X1		GROUP_UWP_X1
#define GROUP_SYS_Y1		(GROUP_UWP_Y1 + GROUP_UWP_Y2 + GROUP_OFFSET)
#define GROUP_SYS_X2		GROUP_UWP_X2
#define GROUP_SYS_Y2		((MSG_Y_OFFSET * 3) + (MSG_Y_OFFSET / 2))

#define GROUP_MISC_X1		GROUP_STAR_X1
#define GROUP_MISC_Y1		(GROUP_STAR_Y1 + GROUP_STAR_Y2 + GROUP_OFFSET)
#define GROUP_MISC_X2		GROUP_STAR_X2
#define GROUP_MISC_Y2		(MSG_Y_OFFSET * 4)//((MSG_Y_OFFSET * 4) - (MSG_Y_OFFSET / 2))

#define MSG_X_OFFSET		(GROUP_OFFSET * 3)
#define MSG_X_OFFSET2		(GROUP_STAR_X2 + (GROUP_OFFSET * 1))

#define MSG_X_HEADER1		5
#define MSG_X_HEADER2		145
#define MSG_X_HEADER3		55
#define MSG_X_HEADER4		200
#define MSG_X_HEADER5		5
#define MSG_X_HEADER6		145

#define CONTROL_X_OFFSET1	55
#define CONTROL_X_OFFSET2	95
#define CONTROL_X_OFFSET3	200
#define CONTROL_X_OFFSET4	245
#endif


#ifdef __WXGTK__
#define GROUP_OFFSET		5

#define MSG_Y_OFFSET		30
#define MSG_Y_OFFSET2		20
#define MSG_Y_OFFSET3		15
#define MSG_Y_OFFSET4		10

#define GROUP_UWP_X1		GROUP_OFFSET
#define GROUP_UWP_Y1		0
#define GROUP_UWP_X2		195
#define GROUP_UWP_Y2		((MSG_Y_OFFSET * 9) + (MSG_Y_OFFSET / 2) + 5)

#define GROUP_STAR_X1		(GROUP_UWP_X1 + GROUP_UWP_X2 + GROUP_OFFSET)
#define GROUP_STAR_Y1		GROUP_UWP_Y1
#define GROUP_STAR_X2		250
#define GROUP_STAR_Y2		((MSG_Y_OFFSET * 5) + (MSG_Y_OFFSET / 2) + 5)

#define GROUP_SYS_X1		GROUP_UWP_X1
#define GROUP_SYS_Y1		(GROUP_UWP_Y1 + GROUP_UWP_Y2 + GROUP_OFFSET)
#define GROUP_SYS_X2		GROUP_UWP_X2
#define GROUP_SYS_Y2		((MSG_Y_OFFSET * 3) + (MSG_Y_OFFSET / 2) + 5)

#define GROUP_MISC_X1		GROUP_STAR_X1
#define GROUP_MISC_Y1		(GROUP_STAR_Y1 + GROUP_STAR_Y2 + GROUP_OFFSET)
#define GROUP_MISC_X2		GROUP_STAR_X2
#define GROUP_MISC_Y2		(MSG_Y_OFFSET * 4)//((MSG_Y_OFFSET * 4) - (MSG_Y_OFFSET / 2) + 5)

#define MSG_X_OFFSET		(GROUP_OFFSET * 3)
//#define MSG_X_OFFSET2		(GROUP_STAR_X2 + (GROUP_OFFSET * 2))
#define MSG_X_OFFSET2		(GROUP_STAR_X1 + (GROUP_OFFSET * 3))

#define MSG_X_HEADER1		5
#define MSG_X_HEADER2		145
#define MSG_X_HEADER3		65
#define MSG_X_HEADER4		285
#define MSG_X_HEADER5		5
#define MSG_X_HEADER6		145

#define CONTROL_X_OFFSET1	50
#define CONTROL_X_OFFSET2	115
#define CONTROL_X_OFFSET3	270
#define CONTROL_X_OFFSET4	345
#endif

static char general_str[22][4] = {
	" 0 ",
	" 1 ",
	" 2 ",
	" 3 ",
	" 4 ",
	" 5 ",
	" 6 ",
	" 7 ",
	" 8 ",
	" 9 ",
	" A ",
	" B ",
	" C ",
	" D ",
	" E ",
	" F ",
	" G ",
	" H ",
	" J ",
	" K ",
	" L ",
	" X " };

static char type_str[7][4] = {
	" O ",
	" B ",
	" A ",
	" F ",
	" G ",
	" K ",
	" M " };

static char star_size_str[7][6] = {
	" Ia  ",
	" Ib  ",
	" II  ",
	" III ",
	" IV  ",
	" V   ",
	" VI  "};

static char zone_str[4][8] = {
	" Any ",
	" Green ",
	" Amber ",
	" Red   "};

static wxString dummy_ptr[22];

SearchRangeDialog::SearchRangeDialog(wxWindow *p) :
	OkCancelDialog(p, "Search For Worlds")
{
//char *dummy_ptr[22];
int i,max;
wxLayoutConstraints *c;
wxStaticBox *box[4];
wxStaticText *min_msg[3],*max_msg[3];
wxStaticText *uwp_msg[8],*star_msg[4],*misc_msg[3],*sys_msg[2];

	for(i = 0;i < 22;i++)
		dummy_ptr[i] = general_str[i];

	box[0] = new wxStaticBox(this, -1, "UWP");
//				wxPoint(GROUP_UWP_X1, GROUP_UWP_Y1),
//				wxSize(GROUP_UWP_X2, GROUP_UWP_Y2));
	box[1] = new wxStaticBox(this, -1, "Stars");
//				wxPoint(GROUP_STAR_X1, GROUP_STAR_Y1),
//				wxSize(GROUP_STAR_X2, GROUP_STAR_Y2));
	box[2] = new wxStaticBox(this, -1, "System");
//				wxPoint(GROUP_SYS_X1, GROUP_SYS_Y1),
//				wxSize(GROUP_SYS_X2, GROUP_SYS_Y2));
	box[3] = new wxStaticBox(this, -1, "Misc.", 
				wxPoint(GROUP_MISC_X1, GROUP_MISC_Y1),
				wxSize(GROUP_MISC_X2, GROUP_MISC_Y2));

	min_msg[0] = new wxStaticText(this, -1, "Min");
	min_msg[1] = new wxStaticText(this, -1, "Min");
	min_msg[2] = new wxStaticText(this, -1, "Min");
	max_msg[0] = new wxStaticText(this, -1, "Max");
	max_msg[1] = new wxStaticText(this, -1, "Max");
	max_msg[2] = new wxStaticText(this, -1, "Max");

	uwp_msg[0] = new wxStaticText(this, -1, "Port:");
	uwp_msg[1] = new wxStaticText(this, -1, "Size:");
	uwp_msg[2] = new wxStaticText(this, -1, "Atmos:");
	uwp_msg[3] = new wxStaticText(this, -1, "Hydro:");
	uwp_msg[4] = new wxStaticText(this, -1, "Pop:");
	uwp_msg[5] = new wxStaticText(this, -1, "Govt:");
	uwp_msg[6] = new wxStaticText(this, -1, "Law:");
	uwp_msg[7] = new wxStaticText(this, -1, "Tech:");

	sys_msg[0] = new wxStaticText(this, -1, "GG:");
	sys_msg[1] = new wxStaticText(this, -1, "Belts:");

	star_msg[0] = new wxStaticText(this, -1, "Number:");
	star_msg[1] = new wxStaticText(this, -1, "Type:");
	star_msg[2] = new wxStaticText(this, -1, "Class:");
	star_msg[3] = new wxStaticText(this, -1, "Size:");

	misc_msg[0] = new wxStaticText(this, -1, "Bases:");
	misc_msg[1] = new wxStaticText(this, -1, "Zone:");
	misc_msg[2] = new wxStaticText(this, -1, "Alleg:");

	for(i = 0;i < MAX_CHOICES;i++) {
		max = InitArray(i, dummy_ptr);

		min_choices[i] = new wxChoice(this, -1, 
				wxPoint(-1, -1), wxSize(COL_OFFSET * 1.75, -1),
				max, dummy_ptr);
		min_choices[i]->SetSelection(0);

		max_choices[i] = new wxChoice(this, -1, 
				wxPoint(-1, -1), wxSize(COL_OFFSET * 1.75, -1),
				max, dummy_ptr);
		max_choices[i]->SetSelection(max-1);
		}

	bases = new wxTextCtrl(this, -1, " X ");
	bases->SetValue("");

	max = InitArray(-1, dummy_ptr);
	zones = new wxChoice(this, -1, 
			wxPoint(-1, -1),
			wxSize(-1, -1), max, dummy_ptr);
	zones->SetSelection(0);

	alleg = new wxTextCtrl(this, -1, " XX ");
	alleg->SetValue("");

	CreateWidgets();

	// Constrain the boxes
	c = new wxLayoutConstraints;
	c->left.SameAs(this, wxLeft, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->right.SameAs(max_choices[7], wxRight, -DLG_OFFSET * 2);
	c->bottom.SameAs(max_choices[7], wxBottom, -DLG_OFFSET * 2);
//	c->height.AsIs();
//	c->width.AsIs();
	box[0]->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(box[0], wxRight, DLG_OFFSET);
	c->top.SameAs(this, wxTop, DLG_OFFSET);
	c->right.SameAs(this, wxRight, DLG_OFFSET);
	c->right.SameAs(max_choices[13], wxRight, -DLG_OFFSET * 2);
	c->bottom.SameAs(max_choices[13], wxBottom, -DLG_OFFSET * 2);
//	c->height.AsIs();
//	c->width.AsIs();
	box[1]->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(box[0], wxRight, DLG_OFFSET);
	c->top.SameAs(box[1], wxBottom, DLG_OFFSET);
	c->right.SameAs(max_choices[9], wxRight, -DLG_OFFSET * 2);
	c->bottom.SameAs(max_choices[9], wxBottom, -DLG_OFFSET * 2);
//	c->height.AsIs();
//	c->width.AsIs();
	box[2]->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(box[0], wxRight, DLG_OFFSET);
	c->top.SameAs(box[2], wxBottom, DLG_OFFSET);
	c->right.SameAs(this, wxRight, DLG_OFFSET);
	c->right.SameAs(alleg, wxRight, -DLG_OFFSET * 2);
	c->bottom.SameAs(alleg, wxBottom, -DLG_OFFSET * 2);
//	c->height.AsIs();
//	c->width.AsIs();
	box[3]->SetConstraints(c);

	// constrain the uwp
	c = new wxLayoutConstraints;
	c->left.SameAs(min_choices[0], wxLeft);
	c->top.SameAs(box[0], wxTop, DLG_OFFSET * 2);
	c->height.AsIs();
	c->width.AsIs();
	min_msg[0]->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(max_choices[0], wxLeft);
	c->top.SameAs(box[0], wxTop, DLG_OFFSET * 2);
	c->height.AsIs();
	c->width.AsIs();
	max_msg[0]->SetConstraints(c);

	for(i = 0;i < 8;i++) {
		c = new wxLayoutConstraints;
		c->left.SameAs(box[0], wxLeft, DLG_OFFSET * 2);
		if(0 == i)
			c->top.SameAs(min_msg[0], wxBottom, DLG_OFFSET * 2);
		else
			c->top.SameAs(uwp_msg[i-1], wxBottom, DLG_OFFSET * 3);
		c->height.AsIs();
		c->width.AsIs();
		uwp_msg[i]->SetConstraints(c);

		c = new wxLayoutConstraints;
		if(0 == i)
			c->top.SameAs(min_msg[0], wxBottom, DLG_OFFSET);
		else
			c->top.SameAs(min_choices[i-1], wxBottom, DLG_OFFSET);
		// atmos or hydro _should_ be the biggest ones.....
		c->left.SameAs(uwp_msg[2], wxRight, DLG_OFFSET);
		c->height.AsIs();
		c->width.AsIs();
		min_choices[i]->SetConstraints(c);

		c = new wxLayoutConstraints;
		if(0 == i)
			c->top.SameAs(max_msg[0], wxBottom, DLG_OFFSET);
		else
			c->top.SameAs(max_choices[i-1], wxBottom, DLG_OFFSET);
		c->left.SameAs(min_choices[i], wxRight, DLG_OFFSET);
		c->height.AsIs();
		c->width.AsIs();
		max_choices[i]->SetConstraints(c);
	}

	// constrain the stars
	c = new wxLayoutConstraints;
	c->left.SameAs(min_choices[10], wxLeft);
	c->top.SameAs(box[1], wxTop, DLG_OFFSET * 2);
	c->height.AsIs();
	c->width.AsIs();
	min_msg[1]->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(max_choices[10], wxLeft);
	c->top.SameAs(box[1], wxTop, DLG_OFFSET * 2);
	c->height.AsIs();
	c->width.AsIs();
	max_msg[1]->SetConstraints(c);

	for(i = 0;i < 4;i++) {
		c = new wxLayoutConstraints;
		c->left.SameAs(box[1], wxLeft, DLG_OFFSET * 2);
		if(0 == i)
			c->top.SameAs(min_msg[1], wxBottom, DLG_OFFSET * 2);
		else
			c->top.SameAs(star_msg[i-1], wxBottom, DLG_OFFSET * 3);
		c->height.AsIs();
		c->width.AsIs();
		star_msg[i]->SetConstraints(c);

		c = new wxLayoutConstraints;
		if(0 == i)
			c->top.SameAs(min_msg[1], wxBottom, DLG_OFFSET);
		else
			c->top.SameAs(min_choices[i+9], wxBottom, DLG_OFFSET);
		// atmos or hydro _should_ be the biggest ones.....
		c->left.SameAs(star_msg[0], wxRight, DLG_OFFSET);
		c->height.AsIs();
		c->width.AsIs();
		min_choices[i + 10]->SetConstraints(c);

		c = new wxLayoutConstraints;
		if(0 == i)
			c->top.SameAs(max_msg[1], wxBottom, DLG_OFFSET);
		else
			c->top.SameAs(max_choices[i+9], wxBottom, DLG_OFFSET);
//		c->right.SameAs(box[0], wxRight, DLG_OFFSET);
		c->left.SameAs(min_choices[i+10], wxRight, DLG_OFFSET);
		c->height.AsIs();
		c->width.AsIs();
		max_choices[i + 10]->SetConstraints(c);
	}
	// constrain system
	c = new wxLayoutConstraints;
	c->left.SameAs(min_choices[8], wxLeft);
	c->top.SameAs(box[2], wxTop, DLG_OFFSET * 2);
	c->height.AsIs();
	c->width.AsIs();
	min_msg[2]->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(max_choices[8], wxLeft);
	c->top.SameAs(box[2], wxTop, DLG_OFFSET * 2);
	c->height.AsIs();
	c->width.AsIs();
	max_msg[2]->SetConstraints(c);

	for(i = 0;i < 2;i++) {
		c = new wxLayoutConstraints;
		c->left.SameAs(box[2], wxLeft, DLG_OFFSET * 2);
		if(0 == i)
			c->top.SameAs(min_msg[2], wxBottom, DLG_OFFSET * 2);
		else
			c->top.SameAs(sys_msg[i-1], wxBottom, DLG_OFFSET * 3);
		c->height.AsIs();
		c->width.AsIs();
		sys_msg[i]->SetConstraints(c);

		c = new wxLayoutConstraints;
		if(0 == i)
			c->top.SameAs(min_msg[2], wxBottom, DLG_OFFSET);
		else
			c->top.SameAs(min_choices[i+7], wxBottom, DLG_OFFSET);
		// atmos or hydro _should_ be the biggest ones.....
		c->left.SameAs(sys_msg[1], wxRight, DLG_OFFSET);
		c->height.AsIs();
		c->width.AsIs();
		min_choices[i + 8]->SetConstraints(c);

		c = new wxLayoutConstraints;
		if(0 == i)
			c->top.SameAs(max_msg[2], wxBottom, DLG_OFFSET);
		else
			c->top.SameAs(max_choices[i+7], wxBottom, DLG_OFFSET);
//		c->right.SameAs(box[0], wxRight, DLG_OFFSET);
		c->left.SameAs(min_choices[i+8], wxRight, DLG_OFFSET);
		c->height.AsIs();
		c->width.AsIs();
		max_choices[i + 8]->SetConstraints(c);
	}
	// constrain misc
	for(i = 0;i < 3;i++) {
		c = new wxLayoutConstraints;
		c->left.SameAs(box[3], wxLeft, DLG_OFFSET * 2);
		if(0 == i)
			c->top.SameAs(box[3], wxTop, DLG_OFFSET * 4);
		else
			c->top.SameAs(misc_msg[i-1], wxBottom, DLG_OFFSET * 3);
		c->height.AsIs();
		c->width.AsIs();
		misc_msg[i]->SetConstraints(c);
	}

	c = new wxLayoutConstraints;
	c->left.SameAs(misc_msg[0], wxRight, DLG_OFFSET);
	c->top.SameAs(box[3], wxTop, DLG_OFFSET * 3);
	c->height.AsIs();
	c->width.AsIs();
	bases->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(misc_msg[0], wxRight, DLG_OFFSET);
	c->top.SameAs(bases, wxBottom, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	zones->SetConstraints(c);

	c = new wxLayoutConstraints;
	c->left.SameAs(misc_msg[0], wxRight, DLG_OFFSET);
	c->top.SameAs(zones, wxBottom, DLG_OFFSET);
	c->height.AsIs();
	c->width.AsIs();
	alleg->SetConstraints(c);

	SetWidgets(box[0]);
}

wxString 
SearchRangeDialog::GetChoiceStr(bool max, int ndx)
{
	if(max)
		return(max_choices[ndx]->GetStringSelection());
	else
		return(min_choices[ndx]->GetStringSelection());
#if 0
wxString ptr=NULL;

	if((ndx >= 0) && (ndx <= MAX_CHOICES))
		{
		if(max)
			ptr = max_choices[ndx]->GetStringSelection();
		else
			ptr = min_choices[ndx]->GetStringSelection();
//		if((sel >= 0) && (sel < min_choices->Number(ndx))
//			{
//			if(max)
//				ptr = max_choices->GetString(sel);
//			else
//				ptr = max_choices->GetString(sel);
//			}
		}

	return(ptr);
#endif
}

void 
SearchRangeDialog::GetRangeSearch(MinClass *n, MaxClass *x, CompareClass *comp)
{
int i;
int min,max;
//char *ptr;
wxString s;

	if(ShowModal() != wxID_CANCEL)
		{
		for(i = 0;i < MAX_CHOICES;i++)
			{
			min = min_choices[i]->GetSelection();
			max = max_choices[i]->GetSelection();
			switch(i)
				{
				case 0:
					{
					if(min < 5)
						n->SetPort(min);
					else
						n->SetPort(8);
					if(max < 5)
						x->SetPort(max);
					else
						x->SetPort(8);
					break;
					}
				case 1:
					{
					n->SetSize(min);
					x->SetSize(max);
					break;
					}
				case 2:
					{
					n->SetAtmos(min);
					x->SetAtmos(max);
					break;
					}
				case 3:
					{
					n->SetHydro(min);
					x->SetHydro(max);
					break;
					}
				case 4:
					{
					n->SetPop(min);
					x->SetPop(max);
					break;
					}
				case 5:
					{
					n->SetGovt(min);
					x->SetGovt(max);
					break;
					}
				case 6:
					{
					n->SetLaw(min);
					x->SetLaw(max);
					break;
					}
				case 7:
					{
					n->SetTech(min);
					x->SetTech(max);
					break;
					}
				case 8:
					{
					n->SetNumGG(min);
					x->SetNumGG(max);
					break;
					}
				case 9:
					{
					n->SetNumBelt(min);
					x->SetNumBelt(max);
					break;
					}
				case 10:
					{
					n->SetNumStar(min);
					x->SetNumStar(max);
					break;
					}
				case 11:
					{
					n->SetStarType(min);
					x->SetStarType(max);
					break;
					}
				case 12:
					{
					n->SetStarClass(min);
					x->SetStarClass(max);
					break;
					}
				case 13:
					{
					n->SetStarSize(min);
					x->SetStarSize(max);
					break;
					}
				}
			}
		
		s = bases->GetValue();
		if((s.c_str()[0] != 0) && (s.c_str()[0] != ' '))
			comp->SetBases(s.c_str()[0]);
//		ptr = bases->GetValue();
//		if((ptr != NULL) && (ptr[0] != 0))
//			comp->SetBases(ptr[0]);

		i = zones->GetSelection();
		if(i == 1)
			comp->SetZone(' ');
		else if(i == 2)
			comp->SetZone('A');
		else if(i == 3)
			comp->SetZone('R');

		s = bases->GetValue();
		if((s.c_str()[0] != 0) && (s.c_str()[0] != ' '))
			comp->SetAlleg(s.c_str());
//		ptr = alleg->GetValue();
//		if((ptr != NULL) && (ptr[0] != 0))
//			comp->SetAlleg(ptr);
		}
}

int 
SearchRangeDialog::InitArray(int which, wxString ptrs[])
{
int i;

	switch(which) {
		// # of stars
		case 10: {
			for(i = 0;i < 4;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// star type
		case 11: {
			for(i = 0;i < 7;i++)
				ptrs[i] = type_str[i];
			break;
		}
		// star class
		case 12: {
			for(i = 0;i < 10;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// star size
		case 13: {
			for(i = 0;i < 7;i++)
				ptrs[i] = star_size_str[i];
			break;
		}
		// port
		case 0: {
			ptrs[0] = general_str[10];
			ptrs[1] = general_str[11];
			ptrs[2] = general_str[12];
			ptrs[3] = general_str[13];
			ptrs[4] = general_str[14];
			ptrs[5] = general_str[21];
			i = 6;
			break;
		}
		// size
		case 1:
		// hydro
		case 3:
		// pop
		case 4: {
			for(i = 0;i < 11;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// atmos
		case 2:
		// govt
		case 5: {
			for(i = 0;i < 16;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// law
		case 6:
		// tech
		case 7: {
			for(i = 0;i < 21;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// gg
		case 8: {
			for(i = 0;i < 6;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// belts
		case 9: {
			for(i = 0;i < 4;i++)
				ptrs[i] = general_str[i];
			break;
		}
		// zone
		default: {
			for(i = 0;i < 4;i++)
				ptrs[i] = zone_str[i];
			break;
		}
	}

	return(i);
}

// ===============================================================
SearchTradeDialog::SearchTradeDialog(wxWindow *p, CodeTable *ct) :
	OkCancelDialog(p, "Search For Trade Codes")
{
int i,j=0;
ListNode *n;
CodeTableEntry *cte;
char *ptr;
wxLayoutConstraints *c;

	for(i = 0;i < MAX_TRADE_CB;i++)
		cb_s[i] = NULL;

	n = ct->First();
	while(n != NULL) {
		cte = (CodeTableEntry *) n->Data();
		ptr = cte->GetCode();
		cb_s[j] = new wxCheckBox(this, -1, ptr);

		n = n->Next();
		j++;
	}

	CreateWidgets();
	
	for(i = 0;i < j;i++) {
		c = new wxLayoutConstraints;
		if((i % 4) == 0)
			c->left.SameAs(this, wxLeft, DLG_OFFSET);
		else {
			if(i < 4)
				c->left.SameAs(cb_s[i-1], wxRight, 2 * DLG_OFFSET);
			else
				c->left.SameAs(cb_s[i-4], wxLeft);
		}
		if(i < 4)
			c->top.SameAs(this, wxTop, DLG_OFFSET);
		else
			c->top.SameAs(cb_s[i-4], wxBottom);
		c->height.AsIs();
		c->width.AsIs();
		cb_s[i]->SetConstraints(c);
	}

	SetWidgets(cb_s[j-1]);
}

unsigned long 
SearchTradeDialog::GetTradeSearch(void)
{
unsigned long l=0l,m=1l;
int i;

	if(ShowModal() != wxID_CANCEL)
		{
		for(i = 0;i < MAX_TRADE_CB;i++)
			{
			if(cb_s[i] != NULL)
				{
				if(cb_s[i]->GetValue())
					l |= m;
				m *= 2;
				}
			}
		}
	return(l);
}

// ===============================================================
FoundEntry::FoundEntry(int x_, int y_)
{
	x = x_;
	y = y_;
}

void 
FoundEntry::GetValues(int *x_, int *y_)
{
	*x_ = x;
	*y_ = y;
}

FoundList::FoundList() :
	wxList()
{
	index = 0;
}

FoundList::~FoundList()
{
	Clear();
}

void 
FoundList::Clear(void)
{
wxNode *n;
FoundEntry *fe;

	n = First();
	while(n != NULL)
		{
		fe = (FoundEntry *)n->Data();
		delete fe;
		delete n;
		n = First();
		}
	index = 0;
}

bool 
FoundList::GetValues(int *x_, int *y_)
{
wxNode *n;
FoundEntry *fe;

	n = Nth(index);
	if(n != NULL)
		{
		fe = (FoundEntry *) n->Data();
		fe->GetValues(x_, y_);
		return(TRUE);
		}
	return(FALSE);
}

bool 
FoundList::GetFirst(int *x, int *y)
{
	index = 0;
	return(GetValues(x, y));
}

bool 
FoundList::GetPrev(int *x, int *y)
{
	if(index > 0)
		index--;
	return(GetValues(x, y));
}

bool 
FoundList::GetCurrent(int *x, int *y)
{
	return(GetValues(x, y));
}

bool 
FoundList::GetNext(int *x, int *y)
{
	if((index + 1) < (unsigned long)Number())
		index++;
	return(GetValues(x, y));
}

bool 
FoundList::GetLast(int *x, int *y)
{
int temp_ndx;

	temp_ndx = Number() - 1;
	
	if(temp_ndx > 0)
		{
		index = temp_ndx;
		return(GetValues(x, y));
		}
	return(FALSE);
}

bool 
FoundList::GetNextWCheck(int *x, int *y)
{
	if((index + 1) < (unsigned long)Number())
		index++;
	else
		return(FALSE);
	return(GetValues(x, y));
}

// ===============================================================

