//
// File:		draw_hex.cpp
// Purpose:		draws a hex
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: draw_hex.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/10/07 17:10:37 $"

#include "draw_hex.h"

// defines for positions within a hex
#define HEX_D_X1		(HEX_CENTER_WIDTH + (HEX_CENTER_WIDTH / 2))
#define HEX_D_X2		(HEX_X_1 + (HEX_CENTER_WIDTH / 2))
#define HEX_D_X3		HEX_X_CENTER
#define HEX_D_X4		(HEX_X_2 - (HEX_CENTER_WIDTH / 2))
#define HEX_D_X5		(HEX_X_2 + (HEX_CENTER_WIDTH / 2))

#define HEX_D_Y1		(HEX_Y_1 + (HEX_CENTER_WIDTH / 2) + 2)
#define HEX_D_Y2		(HEX_Y_1 + (2 * HEX_CENTER_WIDTH))
#define HEX_D_Y3		HEX_Y_CENTER
#define HEX_D_Y4		(HEX_Y_5 - (2 * HEX_CENTER_WIDTH) - 2)
#define HEX_D_Y5		(HEX_Y_5 - (HEX_CENTER_WIDTH / 2) - 4)

// hex corner positions
#define ALT_HEX_X_1				(HEX_X_1 + BORDER_WIDTH - 1)
#define ALT_HEX_X_2				(HEX_X_2 - BORDER_WIDTH + 1)
#define ALT_HEX_X_3				(HEX_X_3 - BORDER_WIDTH)
#define ALT_HEX_X_4				(HEX_X_4 - BORDER_WIDTH + 1)
#define ALT_HEX_X_5				(HEX_X_5 + BORDER_WIDTH - 1)
#define ALT_HEX_X_6				(HEX_X_6 + BORDER_WIDTH)
#define ALT_HEX_Y_1				(HEX_Y_1 + BORDER_WIDTH)
#define ALT_HEX_Y_2				(HEX_Y_2 + BORDER_WIDTH)
#define ALT_HEX_Y_3				(HEX_Y_3)
#define ALT_HEX_Y_4				(HEX_Y_4 - BORDER_WIDTH)
#define ALT_HEX_Y_5				(HEX_Y_5 - BORDER_WIDTH)
#define ALT_HEX_Y_6				(HEX_Y_6)

// gg drawing helper
#define HEX_GG_DIAM				6
#define HEX_GG_X				62
#define HEX_GG_Y				22
#define HEX_GG_WIDTH			HEX_GG_DIAM
#define HEX_GG_HEIGHT			HEX_GG_DIAM

// relative text placement
#define HEX_TEXT_X1				40
#define HEX_TEXT_Y1				2
#define HEX_TEXT_X2				24
#define HEX_TEXT_Y2				68
#define HEX_TEXT_X3				47
#define HEX_TEXT_Y3				20
#define HEX_TEXT_X4				24
#define HEX_TEXT_Y4				54
#define HEX_TEXT_X5				74
#define HEX_TEXT_Y5				37

// belt drawing helpers
#define BELT_X_1				-6
#define BELT_Y_1				-2
#define BELT_X_2				-4
#define BELT_Y_2				5
#define BELT_X_3				-4
#define BELT_Y_3				-6
#define BELT_X_4				-1
#define BELT_Y_4				0
#define BELT_X_5				0
#define BELT_Y_5				4
#define BELT_X_6				4
#define BELT_Y_6				4
#define BELT_X_7				2
#define BELT_Y_7				-1
#define BELT_X_8				1
#define BELT_Y_8				10

// helpful defines
#define HEX_GLYPH_X1			25
#define HEX_GLYPH_Y1			20
#define HEX_GLYPH_X2			19
#define HEX_GLYPH_Y2			39

// misc
#define HEX_X_ALT_OFFSET		76
#define HEX_Y_ALT_OFFSET		44

// circles for amber and red zones
#define HEX_ZONE_RADIUS			(HEX_X_2 / 2)
#define HEX_ZONE_X				(HEX_X_CENTER - HEX_ZONE_RADIUS)
#define HEX_ZONE_Y				(HEX_Y_CENTER - HEX_ZONE_RADIUS)

// ============================================================================
WorldBitmapList *DrawnHex::world_bm_list = NULL;

// ============================================================================
static wxFont	*NormalFont=NULL;
static wxFont	*BoldFont=NULL;

// ============================================================================
int DrawnHex::hex_x_array[7] =
	{ HEX_X_1, HEX_X_2, HEX_X_3, HEX_X_4, HEX_X_5, HEX_X_6, HEX_X_1 };

int DrawnHex::hex_y_array[7] =
	{ HEX_Y_1, HEX_Y_2, HEX_Y_3, HEX_Y_4, HEX_Y_5, HEX_Y_6, HEX_Y_1 };

int DrawnHex::alt_hex_x_array[7] =
	{ ALT_HEX_X_1, ALT_HEX_X_2, ALT_HEX_X_3, ALT_HEX_X_4, ALT_HEX_X_5, ALT_HEX_X_6, ALT_HEX_X_1 };

int DrawnHex::alt_hex_y_array[7] =
	{ ALT_HEX_Y_1, ALT_HEX_Y_2, ALT_HEX_Y_3, ALT_HEX_Y_4, ALT_HEX_Y_5, ALT_HEX_Y_6, ALT_HEX_Y_1 };

int DrawnHex::coords[MAX_LAYOUT_Y][MAX_LAYOUT_X][2] = {
	{ { HEX_D_X2, HEX_D_Y1 }, { HEX_D_X3, HEX_D_Y1 }, { HEX_D_X4, HEX_D_Y1 } },
	{ { HEX_D_X2, HEX_D_Y2 }, { HEX_D_X3, HEX_D_Y2 }, { HEX_D_X4, HEX_D_Y2 } },
	{ { HEX_D_X1, HEX_D_Y3 }, { HEX_D_X3, HEX_D_Y3 }, { HEX_D_X5, HEX_D_Y3 } },
	{ { HEX_D_X2, HEX_D_Y4 }, { HEX_D_X3, HEX_D_Y4 }, { HEX_D_X4, HEX_D_Y4 } },
	{ { HEX_D_X2, HEX_D_Y5 }, { HEX_D_X3, HEX_D_Y5 }, { HEX_D_X4, HEX_D_Y5 } }
};

// ----------------------------------------------------------------------------
DrawnHex::DrawnHex()
{
	text_offset = 0;
	if(NULL == NormalFont) {
		NormalFont = new wxFont(12, wxSWISS, wxNORMAL, wxNORMAL);
		BoldFont = new wxFont(13, wxSWISS, wxNORMAL, wxBOLD);
	}
}

void
DrawnHex::Start(wxDC& dc)
{
	dc.SetFont(*NormalFont);
	dc.SetPen(*wxBLACK_PEN);
	dc.SetBrush(*wxBLACK_BRUSH);
}

// ----------------------------------------------------------------------------
// draw everything
void 
DrawnHex::DrawTotalHex(wxDC& dc, int x, int y, int start_x, int start_y,
			int last_x, int last_y, long off_x, long off_y, 
			BaseSector *sect, HexData *hd, ColorTable *ct, ColorArray *colors,
			BitmapList *bitmaps, TCodes *codes, HexLayout *ghl)
{
	DrawHex(dc, x, y, start_x, start_y, last_x, last_y, hd, ct, colors, 
					off_x, off_y);

	if(hd != NULL) {
		if(hd->world != NULL)
			DrawWorld(dc, x, y, start_x, start_y, sect, hd, 
					colors, bitmaps, codes, ghl, off_x, off_y);
		else if(hd->cp != NULL)
			DrawCP(dc, x, y, start_x, start_y, hd,
					bitmaps, ghl, off_x, off_y);
	}
}

// draw hex border/edge
void 
DrawnHex::DrawHex(wxDC& dc, int x, int y, int start_x, int start_y,
			int last_x, int last_y, HexData *hd, ColorTable *ct, 
			ColorArray *colors, long off_x, long off_y)
{
int color_flag;		// future.....
long alt_y=0,alt_x=0;
int i;
// usual windoze comments:
wxPen *p=NULL;
short color_ndx=-1;

	if(hd == NULL)
		color_flag = 0;
	else
		color_flag = 1;			// there _might_ be a border

	GetAltXY(x, y, start_x, start_y, off_x, off_y, &alt_x, &alt_y);

	for(i = 0;i < 6;i ++) {
		// check for color here:
		if((color_flag) && (hd->border_ndx[i] > -1)) {
			color_ndx = hd->border_ndx[i];
			if((color_ndx > -1)  && (color_ndx < colors->GetMaxColors())) {
				color_ndx = ct->GetColor(hd->border_ndx[i]);
//fprintf(stderr, "B%02d%02d: %d->%d\n", x, y, color_ndx, hd->border_ndx[i]);
				p = new wxPen(*colors->GetColor(color_ndx),
							  BORDER_WIDTH, BORDER_STYLE);
				dc.SetPen(*p);
			}
		}

		if((((last_y - 1) == y) && (4 == i)) || (color_ndx > -1) ||
			(1 == i) || (2 == i) || (3 == i) || 
			(start_x == x) || (start_y == y))
			dc.DrawLine(hex_x_array[i]   + alt_x, hex_y_array[i]   + alt_y, 
						hex_x_array[i+1] + alt_x, hex_y_array[i+1] + alt_y); 

		// reset the color
		if(p != NULL) {
			dc.SetPen(*wxBLACK_PEN);
			delete p;
			p = NULL;
		}
	}
}

// just draw a border
void
DrawnHex::DrawBorder(wxDC& dc, int x, int y, int start_x, int start_y,
				   int color_ndx, ColorTable *ct, ColorArray *colors,
				   long off_x, long off_y)
{
long alt_y=0,alt_x=0;
int i,c;
// usual windoze comments:
wxPen *p=NULL;

	if(color_ndx >= 0) {
		GetAltXY(x, y, start_x, start_y, off_x, off_y, &alt_x, &alt_y);
		c = ct->GetColor(color_ndx);
		p = new wxPen(*colors->GetColor(c), BORDER_WIDTH, BORDER_STYLE);
		dc.SetPen(*p);

		for(i = 0;i < 6;i++)
			dc.DrawLine(alt_hex_x_array[i] + alt_x, alt_hex_y_array[i] + alt_y, 
				alt_hex_x_array[i+1] + alt_x, alt_hex_y_array[i+1] + alt_y); 

		dc.SetPen(*wxBLACK_PEN);
		delete p;
		p = NULL;
	}
}

// draw specifics inside a hex
void
DrawnHex::DrawWorld(wxDC& dc, int x, int y, int start_x, int start_y,
		 BaseSector *sect, HexData *hd, ColorArray *colors, BitmapList *bitmaps,
		 TCodes *codes, HexLayout *ghl, long off_x, long off_y)
{
char z;
char buff[80],uwp_buff[12];
int i,j,draw_x,draw_y;
long alt_y=0,alt_x=0;
main_world *w;
BaseStar *bs;
wxBitmap *bm;
// windoze method (create and destroy the pen at each occurance):
wxPen *p;
HexLayout default_layout,*hl;

	// get the offsets
	GetAltXY(x, y, start_x, start_y, off_x, off_y, &alt_x, &alt_y);

	w = hd->world;
	if(hd->layout != NULL)
		hl = hd->layout;
	else if(ghl != NULL)
		hl = ghl;
	else
		hl = &default_layout;

	// set the zone color
	z = toupper(w->GetZone());
	if((z == 'A') || (z == 'R')) {
		dc.SetBrush(*wxTRANSPARENT_BRUSH);
		if(z == 'A')
			p = new wxPen(*colors->GetColor(AMBER_COLOUR_NDX),
						  BORDER_WIDTH, BORDER_STYLE);
		else
			p = new wxPen(*colors->GetColor(RED_COLOUR_NDX),
						  BORDER_WIDTH, BORDER_STYLE);

		dc.SetPen(*p);
		dc.DrawEllipse(HEX_ZONE_X + alt_x,
					   HEX_ZONE_Y + alt_y,
					   HEX_ZONE_RADIUS * 2,
					   HEX_ZONE_RADIUS * 2);
		dc.SetPen(*wxBLACK_PEN);
		dc.SetBrush(*wxBLACK_BRUSH);
		delete p;
	}

	// minor speed-up
	w->GetUWPStr(uwp_buff);
	for(i = 0;i < MAX_LAYOUT_X;i++) {
		for(j = 0;j < MAX_LAYOUT_Y;j++) {
			// get the center point
			draw_x = coords[j][i][0] + alt_x;
			draw_y = coords[j][i][1] + alt_y;

			switch(hl->GetCode(i, j)) {
				case HD_NONE:
					break;
				case HD_NUMBER:
					// try and shove it over....
					sprintf(buff, "   %02d%02d", x + 1, y + 1);
					DrawString(dc, buff, draw_x, draw_y);
					break;
				case HD_NAME:
					DrawString(dc, w->GetName(), draw_x, draw_y);
					break;
				case HD_NAME_POP:
					if(w->get_pop_val() >= 8)
						DrawStringBold(dc, w->GetName(), draw_x, draw_y);
					else
						DrawString(dc, w->GetName(), draw_x, draw_y);
					break;
				case HD_UWP_FILTERED:
					sprintf(buff, uwp_buff);
					DrawString(dc, ghl->FilterUWP(buff), draw_x, draw_y);
					break;
				case HD_UWP:
					DrawString(dc, uwp_buff, draw_x, draw_y);
					break;
				case HD_UWP_NO_PORT:
					DrawString(dc, &uwp_buff[2], draw_x, draw_y);
					break;
				case HD_TRADE_CODES:
					DrawString(dc, sect->GetCodeStr(w, buff), draw_x, draw_y);
					break;
				case HD_PORT:
					DrawChar(dc, uwp_buff[0], draw_x, draw_y);
					break;
				case HD_SIZE:
					DrawChar(dc, uwp_buff[1], draw_x, draw_y);
					break;
				case HD_ATMOS:
					DrawChar(dc, uwp_buff[2], draw_x, draw_y);
					break;
				case HD_HYDRO:
					DrawChar(dc, uwp_buff[3], draw_x, draw_y);
					break;
				case HD_POP:
					DrawChar(dc, uwp_buff[4], draw_x, draw_y);
					break;
				case HD_GOVT:
					DrawChar(dc, uwp_buff[4], draw_x, draw_y);
					break;
				case HD_LAW:
					DrawChar(dc, uwp_buff[6], draw_x, draw_y);
					break;
				case HD_TECH:
					DrawChar(dc, uwp_buff[7], draw_x, draw_y);
					break;
				case HD_BASE_CODE:
					DrawChar(dc, w->GetBase(), draw_x, draw_y);
					break;
				case HD_ALLEG:
				DrawString(dc, w->GetAlleg(), draw_x, draw_y);
					break;
				case HD_GG_NUM:
					sprintf(buff, "%d", w->GetNumGG());
					DrawString(dc, buff, draw_x, draw_y);
					break;
				case HD_BELTS_NUM:
					sprintf(buff, "%d", w->GetNumBelts());
					DrawString(dc, buff, draw_x, draw_y);
					break;
				case HD_POP_NDX:
					sprintf(buff, "%d", w->GetPopNdx());
					DrawString(dc, buff, draw_x, draw_y);
					break;
				case HD_NUM_STAR:
					sprintf(buff, "%d", w->GetNumStars());
					DrawString(dc, buff, draw_x, draw_y);
					break;
				case HD_BASE_BM1:
					sprintf(buff, "%c", w->GetBase());
					bm = bitmaps->NthBM(codes->GetBaseTable()->GetBMIndex(buff, 0), TRUE);
					if(bm != NULL)
						DrawBM(dc, bm, draw_x, draw_y);
					break;
				case HD_BASE_BM2:
					sprintf(buff, "%c", w->GetBase());
					bm = bitmaps->NthBM(codes->GetBaseTable()->GetBMIndex(buff, 1), TRUE);
					if(bm != NULL)
						DrawBM(dc, bm, draw_x, draw_y);
					break;
				case HD_GG_BM:
					DrawGG(dc, draw_x, draw_y);
					break;
				case HD_BELTS_BM:
					DrawAst(dc, draw_x, draw_y);
					break;
				case HD_STAR_BM1:
					buff[0] = 0;
					if((bs = w->GetStar(0)) != NULL)
						DrawStar(dc, bs->GetColor(buff), draw_x, draw_y);
					break;
				case HD_STAR_BM2:
					buff[0] = 0;
					if((bs = w->GetStar(1)) != NULL)
						DrawStar(dc, bs->GetColor(buff), draw_x, draw_y);
					break;
				case HD_STAR_BM3:
					buff[0] = 0;
					if((bs = w->GetStar(2)) != NULL)
						DrawStar(dc, bs->GetColor(buff), draw_x, draw_y);
					break;
				case HD_MW_BM:
					DrawMWBM(dc, uwp_buff, draw_x, draw_y);
					break;
				case HD_MW_PRESENT:
					DrawMW(dc, draw_x, draw_y);
					break;
				case HD_MW_HYDRO_BM:
					if(w->get_size_val() == 0) 			// belt
						DrawAstMW(dc, draw_x, draw_y);
					else  if(w->get_hydro_val() < 4) 
						DrawDryMW(dc, draw_x, draw_y);
					else
						DrawMW(dc, draw_x, draw_y);
					break;
			}
		}
	}
}

// draw any bases
void
DrawnHex::DrawBases(wxDC& dc, long alt_x, long alt_y, wxBitmap *bm1,
		wxBitmap *bm2)
{
	if(bm1 != NULL) {
		wxMemoryDC memDC;

		memDC.SelectObject(*bm1);
		dc.Blit(HEX_GLYPH_X1 + alt_x, HEX_GLYPH_Y1 + alt_y,
				bm1->GetWidth(), bm1->GetHeight(), & memDC, 0, 0,
				wxCOPY, FALSE);
		memDC.SelectObject(wxNullBitmap);
	}

	if(bm2 != NULL) {
		wxMemoryDC memDC;

		memDC.SelectObject(*bm2);
		dc.Blit(HEX_GLYPH_X2 + alt_x, HEX_GLYPH_Y2 + alt_y,
				bm2->GetWidth(), bm2->GetHeight(), & memDC, 0, 0,
				wxCOPY, FALSE);
		memDC.SelectObject(wxNullBitmap);
	}
}

// old cp code
void
DrawnHex::DrawCP(wxDC& dc, int x, int y, int start_x, int start_y, 
				  HexData *hd, BitmapList *bitmaps, HexLayout *ghl,
				  long off_x, long off_y)
{
char buff[24];
int i,j,draw_x,draw_y;
long alt_x,alt_y;
wxMemoryDC memDC;
wxBitmap *bm;
HexExtraData *cp;
HexLayout default_layout,*hl;

	cp = hd->cp;
	if(hd->layout != NULL)
		hl = hd->layout;
	else if(ghl != NULL)
		hl = ghl;
	else
		hl = &default_layout;

	// get the offsets
	GetAltXY(x, y, start_x, start_y, off_x, off_y, &alt_x, &alt_y);

	for(i = 0;i < MAX_LAYOUT_X;i++) {
		for(j = 0;j < MAX_LAYOUT_Y;j++) {
			// get the center point
			draw_x = coords[j][i][0] + alt_x;
			draw_y = coords[j][i][1] + alt_y;

			switch(hl->GetCode(i, j)) {
				case HD_NONE:
					break;
				case HD_NUMBER:
					// try and shove it over....
					sprintf(buff, "   %02d%02d", x + 1, y + 1);
					DrawString(dc, buff, draw_x, draw_y);
					break;
				case HD_NAME:
				case HD_NAME_POP:
					if(cp->GetTitle() != NULL)
						DrawString(dc, cp->GetTitle(), draw_x, draw_y);
					break;
				case HD_UWP:
				case HD_UWP_NO_PORT:
				case HD_UWP_FILTERED:
					if(cp->GetDesc() != NULL)
						DrawString(dc, cp->GetDesc(), draw_x, draw_y);
					break;
				case HD_TRADE_CODES:
				case HD_PORT:
				case HD_SIZE:
				case HD_ATMOS:
				case HD_HYDRO:
				case HD_POP:
				case HD_GOVT:
				case HD_LAW:
				case HD_TECH:
				case HD_BASE_CODE:
				case HD_ALLEG:
				case HD_GG_NUM:
				case HD_BELTS_NUM:
				case HD_POP_NDX:
				case HD_NUM_STAR:
				case HD_BASE_BM1:
				case HD_BASE_BM2:
				case HD_GG_BM:
				case HD_BELTS_BM:
				case HD_STAR_BM1:
				case HD_STAR_BM2:
				case HD_STAR_BM3:
					break;
				case HD_MW_BM:
				case HD_MW_PRESENT:
				case HD_MW_HYDRO_BM:
					bm = bitmaps->NthBM(cp->GetIndex());
					if(bm != NULL) {
						int s_x,s_y;

						s_x = bm->GetWidth() / 2;
						s_y = bm->GetHeight() / 2;
						memDC.SelectObject(*bm);
						dc.Blit(draw_x - s_x, draw_y - s_y, 
								bm->GetWidth(), bm->GetHeight(), 
								& memDC, 0, 0, wxCOPY, FALSE);
						memDC.SelectObject(wxNullBitmap);
					}
					break;
			}
		}
	}
}

// ----------------------------------------------------------------------------
// misc drawing primitives
// assumptions:  brush is wxBLACK_BRUSH; pen is wxBLACK_PEN; font is Normal
//   any changes to the above should reset the respected values
void
DrawnHex::DrawAstMW(wxDC& dc, int x, int y)
{
	dc.DrawRectangle(BELT_X_1 + x, BELT_Y_1 + y, 2, 2);
	dc.DrawRectangle(BELT_X_2 + x, BELT_Y_2 + y, 2, 2);
	dc.DrawRectangle(BELT_X_3 + x, BELT_Y_3 + y, 2, 2);
	dc.DrawRectangle(BELT_X_4 + x, BELT_Y_4 + y, 2, 2);
	dc.DrawRectangle(BELT_X_5 + x, BELT_Y_5 + y, 2, 2);
	dc.DrawRectangle(BELT_X_6 + x, BELT_Y_6 + y, 2, 2);
	dc.DrawRectangle(BELT_X_7 + x, BELT_Y_7 + y, 2, 2);
	dc.DrawRectangle(BELT_X_8 + x, BELT_Y_8 + y, 2, 2);
}

void
DrawnHex::DrawDryMW(wxDC& dc, int x, int y)
{
	dc.SetBrush(*wxWHITE_BRUSH);

	DrawMW(dc, x, y);

	// reset brush
	dc.SetBrush(*wxBLACK_BRUSH);
}

void
DrawnHex::DrawMWBM(wxDC& dc, char *uwp, int x, int y)
{
	// XXX world_bm_list needs to be a pointer and initialized after
	// wxWindows is all the way up.  To make sure of this, don't 
	// allocate it until the first time it is needed
	if(NULL == world_bm_list)
		world_bm_list = new WorldBitmapList();
	DrawBM(dc, world_bm_list->GetBM(uwp), x, y);
}

void
DrawnHex::DrawMW(wxDC& dc, int x, int y)
{
	dc.DrawEllipse(x - (HEX_CENTER_WIDTH / 2),
			y - (HEX_CENTER_WIDTH / 2),
			HEX_CENTER_WIDTH,
			HEX_CENTER_WIDTH);
}

void
DrawnHex::DrawGG(wxDC& dc, int x, int y)
{
	dc.DrawEllipse(x - 3, y - 3, HEX_GG_WIDTH, HEX_GG_WIDTH);
}

void
DrawnHex::DrawAst(wxDC& dc, int x, int y)
{
	dc.DrawRectangle(BELT_X_4 + x, BELT_Y_4 + y, 2, 2);
	dc.DrawRectangle(BELT_X_5 + x, BELT_Y_5 + y, 2, 2);
	dc.DrawRectangle(BELT_X_6 + x, BELT_Y_6 + y, 2, 2);
	dc.DrawRectangle(BELT_X_7 + x, BELT_Y_7 + y, 2, 2);
}

void
DrawnHex::DrawStar(wxDC& dc, char *s, int x, int y)
{
int i;
wxPen *p;
wxBrush *b;

	for(i = 0;i < (int) strlen(s);i++)
		s[i] = toupper(s[i]);
	if(strcmp(s, "WHITE") == 0) {
		p = wxThePenList->FindOrCreatePen("BLACK", 1, wxSOLID);
	} else {
		p = wxThePenList->FindOrCreatePen(s, 1, wxSOLID);
	}
	b = wxTheBrushList->FindOrCreateBrush(s, wxSOLID);
	dc.SetPen(*p);
	dc.SetBrush(*b);
	
	dc.DrawLine(x, y - 5, x, y + 6);
	dc.DrawLine(x - 5, y, x + 6, y);
	dc.DrawEllipse(x - 3, y - 3, HEX_GG_WIDTH, HEX_GG_WIDTH);

	dc.SetPen(*wxBLACK_PEN);
	dc.SetBrush(*wxBLACK_BRUSH);
}

void
DrawnHex::DrawBM(wxDC& dc, wxBitmap *bm, int x, int y)
{
wxMemoryDC memDC;

	memDC.SelectObject(*bm);
	dc.Blit(x - 6, y - 6, bm->GetWidth(), bm->GetHeight(), & memDC, 0, 0,
			wxCOPY, TRUE);
	memDC.SelectObject(wxNullBitmap);
}

void
DrawnHex::DrawChar(wxDC& dc, char c, int x, int y)
{
char buff[4];

	sprintf(buff, " %c", c);
	DrawString(dc, buff, x, y);
}

void
DrawnHex::DrawString(wxDC& dc, char *buff, int x, int y)
{
	dc.DrawText(buff, x - 6, y - 6);
}

void
DrawnHex::DrawStringBold(wxDC& dc, char *buff, int x, int y)
{
	dc.SetFont(*BoldFont);
	dc.DrawText(buff, x - 6, y - 6);
	dc.SetFont(*NormalFont);
}

// coordinate translation
void 
DrawnHex::GetAltXY(int x, int y, int start_x, int start_y,
				  long off_x, long off_y, long *alt_x, long *alt_y)
{
int x_,y_;

	x_ = x - start_x;
	y_ = y - start_y;

	*alt_x = ((HEX_X_OFFSET * (x_ >> 1)) + HEX_BORDER_X_OFFSET);
	*alt_y = ((HEX_Y_OFFSET * y_) + HEX_BORDER_Y_OFFSET);
	if(x & 1) {
		*alt_y += HEX_Y_ALT_OFFSET;
		*alt_x += HEX_X_ALT_OFFSET;
	}

	*alt_y += text_offset;

	*alt_x += off_x;
	*alt_y += off_y;
}

// ----------------------------------------------------------------------------
// just draw a hex
void 
DrawnHex::DrawHex(wxDC& dc, int x, int y)
{
int i;

	for(i = 0;i < 6;i ++)
		dc.DrawLine(hex_x_array[i] + x, hex_y_array[i] + y, 
						hex_x_array[i+1] + x, hex_y_array[i+1] + y);
}

void 
DrawnHex::DrawDummy(wxDC& dc, HexLayout *layout, BitmapList *bitmaps, 
				TCodes *codes, int x, int y)
{
HEX_DISPLAY hd;
char buff[80];
int i,j,draw_x,draw_y;

	DrawHex(dc, x, y);
	Start(dc);

// hex information
	for(i = 0;i < MAX_LAYOUT_X;i++) {
		for(j = 0;j < MAX_LAYOUT_Y;j++) {
			hd = layout->GetCode(i, j);
			if(HD_NONE == hd)
				continue;

			draw_x = coords[j][i][0] + x;
			draw_y = coords[j][i][1] + y;
			switch(hd) {
				case HD_NONE:
					break;
				case HD_NUMBER:
					// try and shove it over....
					DrawString(dc, "   0101", draw_x, draw_y);
					break;
				case HD_NAME:
				case HD_NAME_POP:
					DrawString(dc, "Tertius", draw_x, draw_y);
					break;
				case HD_UWP_FILTERED:
					sprintf(buff, "X-0000000");
					DrawString(dc, layout->FilterUWP(buff), draw_x, draw_y);
					break;
				case HD_UWP:
					DrawString(dc, "X-0000000", draw_x, draw_y);
					break;
				case HD_UWP_NO_PORT:
					DrawString(dc, "0000000", draw_x, draw_y);
					break;
				case HD_TRADE_CODES:
					DrawString(dc, "Ri Ag Ni", draw_x, draw_y);
					break;
				case HD_PORT:
					DrawChar(dc, 'X', draw_x, draw_y);
					break;
				case HD_SIZE:
				case HD_ATMOS:
				case HD_HYDRO:
				case HD_POP:
				case HD_GOVT:
				case HD_LAW:
				case HD_TECH:
					DrawChar(dc, '0', draw_x, draw_y);
					break;
				case HD_BASE_CODE:
					DrawChar(dc, 'B', draw_x, draw_y);
					break;
				case HD_ALLEG:
					DrawString(dc, "Im", draw_x, draw_y);
					break;
				case HD_GG_NUM:
				case HD_BELTS_NUM:
				case HD_POP_NDX:
				case HD_NUM_STAR:
					DrawChar(dc, '0', draw_x, draw_y);
					break;
				case HD_BASE_BM1: 
				case HD_BASE_BM2: {
					wxBitmap *bm;

					bm = bitmaps->NthBM(codes->GetBaseTable()->GetBMIndex("S", 0), TRUE);
					if(bm != NULL)
						DrawBM(dc, bm, draw_x, draw_y);
					}
					break;
				case HD_GG_BM:
					DrawGG(dc, draw_x, draw_y);
					break;
				case HD_BELTS_BM:
					DrawAst(dc, draw_x, draw_y);
					break;
				case HD_STAR_BM1:
				case HD_STAR_BM2:
				case HD_STAR_BM3:
					// XXX to be determined later
					sprintf(buff, "Yellow");
					DrawStar(dc, buff, draw_x, draw_y);
					break;
				case HD_MW_BM:
					DrawMWBM(dc, "X-8880000", draw_x, draw_y);
					break;
				case HD_MW_PRESENT:
				case HD_MW_HYDRO_BM:
					DrawMW(dc, draw_x, draw_y);
					break;
			}
		}
	}
}

void
DrawnHex::GetTextOffsets(int i, int j, int *x, int *y)
{
	*x = coords[j][i][0];
	*y = coords[j][i][1];
}

void
DrawnHex::GetHexCorner(int i, int *x, int *y)
{
	if((i < 0) || (i > 5))
		*x = *y = 0;
	else {
		*x = hex_x_array[i];
		*y = hex_y_array[i];
	}
}

// ============================================================================
#include "bitmaps/aa_world.b.xpm"
#include "bitmaps/dummy_world.b.xpm"
#include "bitmaps/h0a0_world.b.xpm"
#include "bitmaps/h0a4_world.b.xpm"
#include "bitmaps/h4a0_world.b.xpm"
#include "bitmaps/h4a4_world.b.xpm"
#include "bitmaps/h8_world.b.xpm"
#include "bitmaps/s0_world.b.xpm"


WorldBitmapList::WorldBitmapList() :
	LinkedList()
{
	world_bm[0] = new wxBitmap(s0_world_b_xpm);
	world_bm[1] = new wxBitmap(aa_world_b_xpm);
	world_bm[2] = new wxBitmap(h8_world_b_xpm);
	world_bm[3] = new wxBitmap(h4a4_world_b_xpm);
	world_bm[4] = new wxBitmap(h4a0_world_b_xpm);
	world_bm[5] = new wxBitmap(h0a4_world_b_xpm);
	world_bm[6] = new wxBitmap(h0a0_world_b_xpm);
	world_bm[7] = new wxBitmap(dummy_world_b_xpm);
}

WorldBitmapList::~WorldBitmapList()
{
#if 0
WorldBitmap *wb;
ListNode *n;

	n = First();
	while(n != NULL) {
		wb = (WorldBitmap *) n->Data();
		delete wb;
		DeleteNode(n);
		n = First();
	}
#endif
}

wxBitmap *
WorldBitmapList::GetBM(char *uwp)
{
	if('0' == uwp[2])
		return(world_bm[0]);
	if(uwp[3] > '9')
		return(world_bm[1]);
	if(uwp[4] > '8')
		return(world_bm[2]);
	if(uwp[4] > '4') {
		if(uwp[3] > '4')
			return(world_bm[3]);
		else
			return(world_bm[4]);
	}
	if(uwp[3] > '4')
		return(world_bm[5]);
	else
		return(world_bm[6]);
//fprintf(stderr, "d_mwbm: %s %d 0x%x\n", uwp, i, world_bm[i]);
	return(world_bm[7]);
}

