// File:        secgen.h
// Purpose:     sector generator
// Author:
// Created:
// Updated:
// Copyright:   LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
// 
// rcsid[] = "$RCSfile: secgen.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/06/05 04:51:07 $"


#ifndef SECGEN_H
#define SECGEN_H

#include "wx/timer.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "d_sect.h"
#include "sg_build.h"
#include "3d.h"
#include "t_word.h"
#include "misc.h"
#include "mtu_file.h"

// ====================================================
// import methods
typedef enum {
	IM_NONE=0,
	IM_PRES,
	IM_PORT
} IMPORT_METHOD;

// temporary..... this stuff should be somewhere else...
//  just something to pass around
struct secgen_conf {
	char			*name;
	char			*file_name;

	bool			no_sleep;
	bool			gen_stars;
	bool			gen_sys;
	bool			gen_routes;
	bool			gen_zone;
	bool			d3;

	IMPORT_METHOD	import;

	TCodes			*codes;

	PortGen			*ports;
	JumpRoute		*jumps;

	// refer to corners (1-4) and other 3d corners (5-7)
	SYSTEM_DENSITY	density[9];
	TRAVEL_MATURE	maturity[9];

	// 3D specific
	int min_x,min_y,min_z;
	int max_x,max_y,max_z;

	// system stuff
	sys_conf		sys;
};

// gen states
typedef enum GEN_STATES {
	GS_INIT=0,
	GS_NAMING,
	GS_PRES,
	GS_UWP,
//	GS_BASE,
	GS_TRADE,
	GS_PGB,
	GS_ZONE,
	GS_STARS,
	GS_ROUTE,
	GS_WRITE
};

typedef enum GALACTIC_DIRECTIONS {
	GD_COREWARD=0,
	GD_RIMWARD,
	GD_SPINWARD,
	GD_TRAILING
};

// ====================================================
// Define a new application
class App: public wxApp
{
public:
    bool OnInit(void);

	void CleanUp(void);

private:
	void ParseCommandLine(struct secgen_conf *cfg);
	bool ParseString(char **dest, char *src);
	bool CopyString(char *dest, char *src, unsigned int sz);
	void ProcessArgs(struct secgen_conf *cfg, char last_arg, char *buff);
	void Usage(void);
};

// ========================================================================
class Timer : public wxTimer
{
public:
    Timer();
	~Timer();

	void Notify(void);
};

// ========================================================================
class Frame : public wxFrame
{
public:
//    Frame(struct secgen_conf *c, int p);
    Frame(struct secgen_conf *c);
    ~Frame();

	void InitQuiet(void);

	void Proceed(void);

	bool NextState(void);

	// for handle a child process
	void OnIdle(wxIdleEvent& event);

private:
	// 3D specific:
	int Gen3D(void);
	bool CheckPresence3D(void);
	bool GenStar3D(void);



	// 2D specific:
	void SetNaming(void);
	bool CheckPresence(void);
	bool SetUWP(void);
//	void CheckBases(void);	// ???
	void CheckTrade(void);
	void SetPGB(void);
	void SetZone(void);
	bool SetStars(void);
	void SetRoute(void);	// ???
	void Write(void);

	// misc helpers
	bool ImportFile(void);
	void BuildMap(int v1, int v2, int v3, int v4);
	void FillInMap(int x1, int y1, int x2, int y2);
	void RunSysgen(int x, int y, char *n);
	void GenWorlds(int x, int y, char *n);
//	bool StartSysgen(bool misc);
//	bool StopSysgen(void);
	bool RollPresence(SYSTEM_DENSITY d);

	void FeedBack(int x, int y, int c_count, int t_count);
	void FeedBack3D(int x, int y, int z, int c_count, int t_count, 
				int aux_count);
	void ReflectState(void);

	// one-shot
	Timer				*timer;

	// input
    struct secgen_conf  *cfg;

	// where we're at
	GEN_STATES			state;

	// helper(s)
	Dice				dice;

	// actual sector to work on
	DetailSector		*sect;
	int					sec_map[MAX_X_HEX][MAX_Y_HEX];
	Sector3D			*sect3d;
	SystemGenerate		*sys_gen;

	// 
	int					world_count;

	// 3D specific:
	int 				cur_x,cur_y,cur_z;
	long				loc_tot,loc_count;

	// stuff on the screen
	wxGauge				*g1;
	wxGauge				*g2;
	wxStaticText		*msg1;
	wxStaticText		*msg2;

	DECLARE_EVENT_TABLE()
};

#endif

