// File:        misc.cpp
// Purpose:     misc. sector generation definitions
// Author:
// Created:
// Updated:
// Copyright:   LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
// 
// rcsid[] = "$RCSfile: misc.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $"

#include <stdio.h>
#include <stdlib.h>
#include "parse.h"
#include "t_dice.h"
#include "misc.h"

#if 0
// -----------------------------------------------------------------------
ParseClass::ParseClass() :
	LinkedList()
{
}

ParseClass::~ParseClass()
{
}

void
ParseClass::Init(char *f)
{
char buffer[256];
FILE *fp;

	if((fp = fopen(f, "r")) != NULL) {
		while(fgets(buffer, 256, fp) != NULL) {
			if('#' == buffer[0])
				continue;
			if(buffer[strlen(buffer) - 1] == '\n')
				buffer[strlen(buffer) - 1] = 0;
			if(strlen(buffer) == 0)
				continue;

			Load(buffer);
		}
	}
}
#endif

// ===========================================================================
GenCode::GenCode(char *str)
{
GenericParse gp;
char *ptrs[15],c;
int i;

	gp.Parse(str, ptrs, 15);
	code[0] = ptrs[0][0];
	code[1] = ptrs[0][1];
	code[2] = 0;
	for(i = 0;i < 6;i++) {
		c = ptrs[(i*2)+1][0];
		if((c >= '0') && (c <= '9')) mins[i] = c - '0';
		else if((c >= 'A') && (c <= 'Z')) mins[i] = c - 'A' + 10;
		else mins[i] = -1;
		c = ptrs[(i*2)+2][0];
		if((c >= '0') && (c <= '9')) maxs[i] = c - '0';
		else if((c >= 'A') && (c <= 'Z')) maxs[i] = c - 'A' + 10;
		else maxs[i] = -1;
	}

	special = (TRADE_GEN_CODE) (ptrs[13][0] - '0');
}

GenCode::~GenCode()
{
}

bool
GenCode::Check(char *u)
{
bool ret=FALSE;
int i,val;

	for(i = 0;i < 6;i++) {
		val = u[i+2];
		if(val < 'A') val -= '0';
		else val -= ('A' + 10);
		if((1 == i) && (special > TGC_NONE)) {
			if(TGC_IN == special) {
				if(((val >= 2) && (val <= 4)) || (7 == val) || (9 == val)) {
					ret = TRUE;
				}
			} else if(TGC_RI == special) {
				if((6 == val) || (8 == val)) {
					ret = TRUE;
				}
			}
		} else {
			if((mins[i] > -1) && (maxs[i] > -1)) {
				if((val >= mins[i]) && (val <= maxs[i])) {
					ret = TRUE;
				}
			}
		}
	}

	return(ret);
}

// -----------------------------------------------------------------------
#if 0
TradeGen::TradeGen(char *f) :
	ParseClass()
{
	Init(f);
}

TradeGen::~TradeGen()
{
GenCode *gc;
ListNode *n;

	n = First();
	while(n != NULL) {
		gc = (GenCode *)n->Data();
		delete(gc);
		DeleteNode(n);
		n = First();
	}
}

// XXX local flag
void
TradeGen::Load(char *buffer, bool local)
{
GenCode *gc;

	gc = new GenCode(buffer);
	Append(gc);
}

unsigned long
TradeGen::CheckTrade(char *u, CodeTable *ct)
{
unsigned long ret=0l;
GenCode *gc;
ListNode *n;

	n = First();
	while(n != NULL) {
		gc = (GenCode *)n->Data();
		if(gc->Check(u)) {
			ret |= ct->GetFlag(gc->GetCode());
		}
		n = Next();
	}

	return(ret);
}
#endif
// ===========================================================================
PortGenEntry::PortGenEntry(char *m) :
	ListData()
{
int i;

	for(i = 0;i < 12;i++)
		mat[i] = 0;
	if(strlen(m) > 11)
		strncpy(mat, m, 11);
	else
		strcpy(mat, m);
}

PortGenEntry::~PortGenEntry()
{
}

//char
//PortGenEntry::GenPort(void)
//{
//Dice d;
//
//	if(strlen(mat) != 11)
//		return(mat[d.Roll(strlen(mat), 1)]);
//	return(mat[d.Roll(6, 2) - 1]);
//}

// -----------------------------------------------------------------------
#define DEFAULT_PORT_STRING		"AAAABBCCDEX"

PortGen::PortGen(char *f) :
	ParseClass()
{
	Init(f);
}

PortGen::~PortGen()
{
}

char 
PortGen::GenPort(int ndx)
{
PortGenEntry *pge;
char *mat;
Dice d;

	if((pge = (PortGenEntry *) NthData(ndx)) != NULL)
		mat = pge->GetPorts();
	else 
		mat = DEFAULT_PORT_STRING;
	
	if(strlen(mat) != 11)
		return(mat[d.Roll(strlen(mat), 1)]);
	return(mat[d.Roll(6, 2) - 2]);
}

// XXX local flag
void 
PortGen::Load(char *buff, bool local)
{
PortGenEntry *pge;

	pge = new PortGenEntry(buff);
	Append(pge);
}

// ===========================================================================
JumpRouteEntry::JumpRouteEntry(char *j) :
	ListData()
{
GenericParse gp;
char *ptrs[5];
int i;

	gp.Parse(j, ptrs, 5);
	strcpy(pair, ptrs[0]);
	for(i = 0;i < 4;i++) {
		if('-' == ptrs[i+1][0])
			targs[i] = -1;
		else
			targs[i] = atoi(ptrs[i+1]);
	}
//fprintf(stderr, "Adding %c%c %d %d %d %d\n", pair[0], pair[1],
//	targs[0], targs[1], targs[2], targs[3]);
}

JumpRouteEntry::~JumpRouteEntry()
{
}

int
JumpRouteEntry::GetTarget(int ndx)
{
	// sanity check
	if((ndx < 0) || (ndx > 3))
		return(-1);
	return(targs[ndx]);
}

// -----------------------------------------------------------------------
JumpRoute::JumpRoute(char *f) :
	ParseClass()
{
	Init(f);
}

JumpRoute::~JumpRoute()
{
}

// XXX local flag
void
JumpRoute::Load(char *buff, bool local)
{
JumpRouteEntry *jre;

	jre = new JumpRouteEntry(buff);
	Append(jre);
}

bool
JumpRoute::CheckRoute(char p1, char p2, int d)
{
char *ptr;
int i=0,roll;
JumpRouteEntry *jre;
Dice dice;

//fprintf(stderr, "========================\n Checking %c:%c at %d", p1, p2, d);
	while((jre = (JumpRouteEntry *) NthData(i)) != NULL) {
		ptr = jre->GetPairs();
		if(((ptr[0] == p1) && (ptr[1] == p2)) ||
				((ptr[1] == p1) && (ptr[0] == p2))) {
			roll = dice.Roll(6,1);
//fprintf(stderr, " r:%d t:%d", roll, jre->GetTarget(d));
			if((jre->GetTarget(d) > -1) && (roll >= jre->GetTarget(d))) {
//fprintf(stderr, " TRUE\n");
				return(TRUE);
			} else {
//fprintf(stderr, " FALSE\n");
				return(FALSE);
			}
		}
		i++;
	}

//fprintf(stderr, " FALSE\n");
	return(FALSE);
}

