
/*
 * File:    map.h
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright:
 */

/* sccsid[] = "%W% %G%" */

#ifdef __GNUG__
#pragma interface
#endif

#ifndef MAP_H
#define MAP_H

#include "wx/timer.h"
#include "wx/print.h"
#include "t_frame.h"
#include "t_dice.h"

#include "iso_map.h"
//#include "flat_map.h"

// ====================================================
// Define a new application
class MapApp: public wxApp
{
public:
    MapApp(void) ;
    bool OnInit(void);

private:
#if 0
	void ParseCommandLine(struct conf_struct *cfg, char *cfg_ptr);
	bool ParseString(char **dest, char *src);
	bool ParseTerrain(TERRAIN_TYPE *t, char *src);
	bool CopyString(char *dest, char *src, unsigned int sz);
	void ProcessArgs(struct conf_struct *cfg, char last_arg, char *buff,
					 int star_count, char **sect_file);
#endif
};

// ========================================================================
//  gui stuff
class MapPanel : public wxPanel
{
public:
	MapPanel(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1);
	~MapPanel();
};

// ========================================================================
// display (print) handler
#if 0
class MapDisplay : public DisplayMethod
{
public:
	MapDisplay(wxDC *d, int x=0, int y=0, int len=-1) :
		DisplayMethod(d, x, y, len) {};
	MapDisplay(FILE *fpx, int len=-1) : DisplayMethod(fpx) {};
	~MapDisplay();
#if 0
	int DrawEnc(AnimalEncounter *ae, conf_struct *cfg,
			char *msg1=NULL, char *msg2=NULL,
			int start_count=0, int total_count=32000);
	int DrawTable(EncounterTable *et, conf_struct *cfg,
			char *msg1=NULL, char *msg2=NULL,
			int start_count=0, int total_count=32000);
	int DrawTables(EncounterTables *et, conf_struct *cfg,
			char *msg1=NULL, char *msg2=NULL,
			int start_count=0, int total_count=32000);

private:
	int DrawLine(AnimalEncounter *ae, TRAV_VER v, int die_roll=-1);
	int DrawHeader(conf_struct *cfg, TERRAIN_TYPE t, bool table=TRUE);

	int DrawSingleTable(EncounterTable *at, conf_struct *cfg, TERRAIN_TYPE t);
#endif
};
#endif

// ====================================================
// print out
class PrintOut : public wxPrintout
{
public:
//	PrintOut(conf_struct *cfg);
	PrintOut();
	~PrintOut() {};

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *minPage, int *maxPage,
					 int *selPageFrom, int *selPageTo);

private:
	int				page_max;
#if 0
	conf_struct		*cfg;
#endif
};

// ========================================================================
// general canvas
class MapCanvas : public wxScrolledWindow
{
public:
    MapCanvas(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1,
				 long style = wxRETAINED);
	~MapCanvas() {};

	void OnDraw(wxDC& dc);
	
	void OnKeyDown(wxKeyEvent& event);

	DECLARE_EVENT_TABLE()

};

// ========================================================================
#if 0
class MapFrame : public wxFrame
{
//friend class QuietFrame;
friend class MapFrame;
public:
	MapFrame(struct conf_struct *c, char *cfg_ptr, int w, int h);
	~MapFrame();

	bool OnCLose(void) { return(TRUE); };

	int CalcTableCount(void);

	EncounterTables *GetTables(void) { return(tables); };
	EncounterTable *GetTable(void) { return(table); };
	AnimalEncounter *GetEnc(void) { return(enc); };

private:
	void CleanUp(void);
    struct conf_struct  cfg;

	EncounterTables		*tables;
	EncounterTable		*table;
	AnimalEncounter		*enc;
};
#endif

// ----------------------------------------------------
#define MAX_ROTATION		5
#define MAX_AXIS			6

typedef enum MAP_VIEW {
	MV_BLANK=0,
	MV_PLATES,
	MV_ALTITUDE,
	MV_HEX,
	MV_LONG,
};

class MapFrame : public wxFrame
{
public:
//    MapFrame(struct conf_struct *c, char *cfg_ptr);
    MapFrame();
    ~MapFrame();

	bool OnClose(void) { return(TRUE); };
	
    void OnSize(wxSizeEvent& event);

	void Configure(wxCommandEvent& event);
	void Generate(wxCommandEvent& event);
	void Save(wxCommandEvent& event);
	void Print(wxCommandEvent& event);
	void Exit(wxCommandEvent& event);
	
	void Draw(wxDC *dc);

	void IncRot(int n_off);
	void HomeRot(void);
	void IncAxis(int n_off);
	void HomeAxis(void);
	void IncView(void);
	void DecView(void);

#ifdef PLATE_GROW_CODE
	void ExpandPlate(void);
#endif


	void InitButtons(wxToolBar *tb);

	DECLARE_EVENT_TABLE()

private:
	void DrawFilledVertex(wxDC *dc, int x, int y, int ndx);
	void DrawFilledHex(wxDC *dc, int x, int y, int ndx);
	void DrawFilledTriangle(wxDC *dc, int x1, int y1, int x2, int y2,
					int x3, int y3);
	void DoBackfill(wxDC *dc);


	void ClearEnc(void);
	void UpdateStatus(void);

	void DrawBaseMap(wxDC *dc);
//	void XlatCoords(int b_x, int b_y, int *x, int *y);

	void ViewStatus(void);

	MapCanvas			*canvas;
	MapPanel			*tool_bar;
//	MapDialog			*dlg;

	int 				axis;
	int					rotation;
	MAP_VIEW			view;
#ifdef PLATE_GROW_CODE
	int					plate_mag;
#endif

	IsoMap				*base_map;
//	FlatMap				*plates;

	wxBitmap			*dir_bms[6];
};

#endif
