/*
 * File:      mtu.cpp
 * Purpose:   MTU menu program
 * Author:    Mark A. Nordstrand
 * Created:   8/1/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: universe.cpp,v $ $Revision: 1.10 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

#include "universe.h"

#define MAX_FILE_LENGTH			256

#define MAX_FLAGS				5
#define MAX_VAR					3
#define MAX_PARAMS				(MAX_FLAGS + MAX_VAR)

// =======================================================================
BaseList::BaseList(char *dir, char *fname, char *title) :
	ListData()
{
	dir_name = new char[strlen(dir) + 1];
	strcpy(dir_name, dir);
	file_name = new char[strlen(fname) + 1];
	strcpy(file_name, fname);
	desc = new char[strlen(title) + 1];
	strcpy(desc, title);
}

BaseList::~BaseList()
{
	if(dir_name != NULL)
		delete dir_name;
	if(file_name != NULL)
		delete file_name;
	if(desc != NULL)
		delete desc;
}
// =======================================================================
// need the data dir
UList::UList(char *dir)
{
int i;
FILE *fpx;
char buffer1[MAX_FILE_LENGTH];
char buffer2[MAX_FILE_LENGTH];

	sprintf(buffer1, "%s/%s.dat", dir, "mtu");
	if((fpx = fopen(buffer1, "r")) != NULL) {
		GenericParse gp;

		// re-use buffer1
		sprintf(buffer1, "%s/", dir);
		while(TRUE) {
			char *ptrs[MAX_PARAMS];
			UListData *uld;

			for(i = 0;i < MAX_FILE_LENGTH;i++)
				buffer2[i] = 0;
			if(fgets(buffer2, MAX_FILE_LENGTH, fpx) == NULL) 
				break;

			if('#' == buffer2[0])
				continue;

			if(('\n' == buffer2[strlen(buffer2)-1]) || 
					('\r' == buffer2[strlen(buffer2)-1]))
				buffer2[strlen(buffer2)-1] = '\0';
			if(('\n' == buffer2[strlen(buffer2)-1]) || 
					('\r' == buffer2[strlen(buffer2)-1]))
				buffer2[strlen(buffer2)-1] = '\0';
			if(strlen(buffer2) < 1)
				continue;

//fprintf(stderr, "<%s>\n", buffer2);
			i = gp.Parse(buffer2, ptrs, MAX_PARAMS);

//fprintf(stderr, "<%s><%s><%s><%s>\n", buffer1, ptrs[0], ptrs[1], ptrs[2]);
			if((ptrs[2] != NULL) && ('3' == ptrs[2][0]))
				uld = new UListData(buffer1, ptrs[0], ptrs[1], TRUE);
			else
				uld = new UListData(buffer1, ptrs[0], ptrs[1]);
			Append(uld);
		}
		fclose(fpx);
	}
}

UList::~UList()
{
ListNode *n;
UListData *uld;

	n = First();
	while(n != NULL) {
		uld = (UListData *)n->Data();
		delete uld;
		DeleteNode(n);
		n = First();
	}
}

UListData *
UList::Find(char *name)
{
UListData *uld;
ListNode *n;

	n = First();
	while(n != NULL) {
		uld = (UListData *)n->Data();
		if(strcmp(name, uld->GetDesc()) == 0)
			return(uld);
		n = Next();
	}

	return(NULL);
}

// -----------------------------------------------------------------------
UListData::UListData(char *dir, char *fname, char *title, bool d3) :
	BaseList(dir, fname, title)
{
	sectors = NULL;
	sector_3d = NULL;
	ClearList();
	depth = d3;
}

UListData::~UListData()
{
}

bool
UListData::LoadList(TCodes *codes, char *dir)
{
	// strange case
	//  assume it's a re-load
	if(sectors != NULL) {
		delete sectors;
		sectors = NULL;
	}
	if(sector_3d != NULL) {
		delete sector_3d;
		sector_3d = NULL;
	}

	if(depth) {
		FILE *fpx;
		char buffer1[MAX_FILE_LENGTH];
		char buffer2[MAX_FILE_LENGTH];

		buffer2[0] = 0;
		sprintf(buffer1, "%s/%s/%s.dat", dir, GetFileName(), GetFileName());
		if((fpx = fopen(buffer1, "r")) != NULL) {
			GenericParse gp;

			while(fgets(buffer1, MAX_FILE_LENGTH, fpx) != NULL) {
				char *ptrs[2];

				if('#' == buffer1[0])
					continue;

				if(gp.Parse(buffer1, ptrs, 2) > 1) {
					sprintf(buffer2, "%s", buffer1);
					break;
				}
			}
			fclose(fpx);
		}

		sector_3d = new Sector3D(codes, buffer2);
		sprintf(buffer1, "%s/%s/%s/%s.sec", dir, GetFileName(), 
						buffer2, buffer2);
		sector_3d->Load(buffer1);
	} else
		sectors = new SectorList(codes, dir, GetFileName());

	return(TRUE);
}

bool
UListData::ClearList(void)
{
	if(sectors != NULL) {
		delete sectors;
		sectors = NULL;
		return(TRUE);
	}
	if(sector_3d != NULL) {
		delete sector_3d;
		sector_3d = NULL;
		return(TRUE);
	}

	return(FALSE);
}

BaseSector *
UListData::GetSector(int x, int y)
{
	if(sectors != NULL) {
		SectorData *sd;
		ListNode *n;

		n = sectors->First();
		while(n != NULL) {
			sd = (SectorData *)n->Data();
			if((sd->GetX() == x) && (sd->GetY() == y))
				return(sd->GetSector());
			n = sectors->Next();
		}
	}

	return(NULL);
}

// =======================================================================
SectorList::SectorList(TCodes *codes, char *dir, char *file_name) :
	LinkedList()
{
int i;
FILE *fpx;
char buffer1[MAX_FILE_LENGTH];
char buffer2[MAX_FILE_LENGTH];

	max_x = max_y = min_x = min_y = 0;

	sprintf(buffer1, "%s/%s/%s.dat", dir, file_name, file_name);
	if((fpx = fopen(buffer1, "r")) != NULL) {
		GenericParse gp;

		// re-use buffer1
//		sprintf(buffer1, "%s/%s", dir, "mtu");
		sprintf(buffer1, "%s/%s", dir, file_name);
		while(TRUE) {
			SectorData *sd;
			char *ptrs[7],code;
			int x,y;

			for(i = 0;i < MAX_FILE_LENGTH;i++)
				buffer2[i] = 0;
			if(fgets(buffer2, MAX_FILE_LENGTH, fpx) == NULL) 
				break;

			if('#' == buffer2[0])
				continue;

			if(('\n' == buffer2[strlen(buffer2)-1]) || 
					('\r' == buffer2[strlen(buffer2)-1]))
				buffer2[strlen(buffer2)-1] = '\0';
			if(('\n' == buffer2[strlen(buffer2)-1]) || 
					('\r' == buffer2[strlen(buffer2)-1]))
				buffer2[strlen(buffer2)-1] = '\0';

			if(strlen(buffer2) < 1)
				continue;

//fprintf(stderr, "<%s>\n", buffer2);
			i = gp.Parse(buffer2, ptrs, 7);
			x = atoi(ptrs[2]);
			y = atoi(ptrs[3]);
			code = ptrs[4][0];
//fprintf(stderr, "(%d %d)\n", x, y);
			if(x > max_x) max_x = x;
			if(y > max_y) max_y = y;
			if(x < min_x) min_x = x;
			if(y < min_y) min_y = y;
//fprintf(stderr, "%d %d %c <%s> <%s> <%s>\n",x,y,code,buffer1,buffer2,ptrs[0]);
			sd = new SectorData(codes, buffer1, ptrs[0], ptrs[1], 
					x, y, code);
			Append(sd);
		}
		fclose(fpx);
	}
}

SectorList::~SectorList()
{
}

// -----------------------------------------------------------------------
SectorData::SectorData(TCodes *codes, char *dir, char *fname, char *title, 
		int x_, int y_, char c) :
	BaseList(dir, fname, title)
{
char buff[MAX_FILE_LENGTH];

	x = x_;
	y = y_;
	code = c;
	// default
	sector = NULL;
	sprintf(buff, "%s/%s/%s.sec", GetDirName(), 
				GetFileName(), GetFileName());
	sector = new BaseSector(codes);

	if(sector->LoadFile(buff) < 1) {
		delete sector;
		sector = NULL;
	}

	sprintf(buff, "%s/%s", GetDirName(), GetFileName());
	ht = new HardTimes(buff);
}

SectorData::~SectorData()
{
	if(sector != NULL)
		delete sector;
	if(ht != NULL)
		delete ht;
}


