
/*
 * File:	
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_frame.cpp,v $ $Revision: 1.4 $ $Author: man $ $Date: 2001/06/19 16:50:16 $" */

#ifdef __GNUG__
#pragma implementation "t_frame.h"
#endif

#include "t_frame.h"

static wxFont	*textHeaderFont=NULL;
static wxFont	*textHeaderFont1=NULL;
static wxFont	*textWindowFont=NULL;
static wxFont	*textTextFont=NULL;

// ===========================================================================
BEGIN_EVENT_TABLE(SubFrame, wxFrame)
		EVT_CLOSE(SubFrame::OnCloseWindow)
END_EVENT_TABLE()

// define behaviour of all SubFrames
//SubFrame::SubFrame(wxFrame *frame, const char *title,
//				   int x, int y, int w, int h, long s) :
//	wxFrame(frame, title, x, y, w, h, s)
SubFrame::SubFrame(wxFrame *frame, const char *title,
					int x, int y, int w, int h, long s) :
	wxFrame(frame, -1, title, wxPoint(x, y), wxSize(w, h), s)
{
	recFlag = FALSE;
	isShown = FALSE;
//	main_frame = frame;
	if(textHeaderFont == NULL) {
		textHeaderFont = new wxFont(14, wxMODERN, wxNORMAL, wxBOLD);
		textHeaderFont1 = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL, TRUE);
		textWindowFont = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL);
		textTextFont = new wxFont(10, wxMODERN, wxNORMAL, wxNORMAL);
	}
}

SubFrame::~SubFrame()
{
}

bool
SubFrame::ToggleShow(void)
{
	if(isShown)
		isShown = FALSE;
	else
		isShown = TRUE;
	return(Show(isShown));
}

void
SubFrame::OnCloseWindow(wxCloseEvent &event)
{
//	frame->MenuCheckCallBack(this);
	MenuCheckCallBack(this);
	isShown = FALSE;
	Show(FALSE);
//	return(FALSE);
}

void
SubFrame::OnSize(int w, int h)
{
//int fx,fy,fw,fh;
//int sw,sh;
//int x,y;
int w1,h1;

	if(!recFlag) {
		// stop recursion
		recFlag = TRUE;
		// get our maxs

		// set the canvas
		GetClientSize(&w1, &h1);
		canvas->SetSize(0, 0, w1, h1);
		recFlag = FALSE;
	}
	Layout();
}

// ===========================================================================
#define DEFAULT_SPACE_SEARCH	50
DisplayMethod::DisplayMethod()
{
	fpx = NULL;
	dc = NULL;
	text = NULL;
	CommonInit(DEFAULT_SPACE_SEARCH);
}

DisplayMethod::DisplayMethod(wxDC *d, int x, int y, int len)
{
	fpx = NULL;
	dc = d;
	text = NULL;
	x_base = x;
	y_base = y;
	CommonInit(len);
}

DisplayMethod::DisplayMethod(FILE *f, int len)
{
	fpx = f;
	dc = NULL;
	text = NULL;
	CommonInit(len);
}

DisplayMethod::DisplayMethod(wxTextCtrl *t, int len)
{
	fpx = NULL;
	dc = NULL;
	text = t;
	CommonInit(len);
}

void
DisplayMethod::CommonInit(int len)
{
	cur_y = 0;
	if(len < 0)
		line_length = DEFAULT_SPACE_SEARCH;
	if(textHeaderFont == NULL) {
		textHeaderFont = new wxFont(14, wxMODERN, wxNORMAL, wxBOLD);
		textHeaderFont1 = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL, TRUE);
		textWindowFont = new wxFont(11, wxMODERN, wxNORMAL, wxNORMAL);
		textTextFont = new wxFont(10, wxMODERN, wxNORMAL, wxNORMAL);
	}
}
	
DisplayMethod::~DisplayMethod()
{
	if(fpx != NULL)
		fclose(fpx);
}


void
DisplayMethod::Start(char *msg)
{
	cur_y = 0;

	if(msg != NULL) {
		if(fpx != NULL)
			fprintf(fpx, "%s\n\n", msg);

		if(dc != NULL) {
			dc->SetFont(*textHeaderFont);
			dc->DrawText(msg, (TEXT_X_OFFSET + x_base), y_base);
			cur_y += (TEXT_Y_INCR * 2);
		}

		if(text != NULL) {
			text->SetFont(*textHeaderFont);
			text->AppendText(msg);
			text->AppendText("\n\n");
		}
	}

	if(dc != NULL)
		dc->SetFont(*textWindowFont);

	if(text != NULL)
		text->SetFont(*textTextFont);
}

void 
DisplayMethod::Header1(char *buff)
{
	if(fpx != NULL)
		fprintf(fpx, "%s\n\n", buff);

	if(dc != NULL) {
		dc->SetFont(*textHeaderFont);
		dc->DrawText(buff, (TEXT_X_OFFSET + x_base), 
					 (cur_y + y_base));
		cur_y += (TEXT_Y_INCR * 2);
		dc->SetFont(*textWindowFont);
	}

	if(text != NULL) {
		text->SetFont(*textHeaderFont);
		text->AppendText(buff);
		text->AppendText("\n\n");
		text->SetFont(*textTextFont);
	}
}

void 
DisplayMethod::Header2(char *buff)
{
	if(fpx != NULL)
		fprintf(fpx, "%s\n", buff);

	if(dc != NULL) {
		dc->SetFont(*textHeaderFont1);
		dc->DrawText(buff, (TEXT_X_OFFSET + x_base),
					 (cur_y + y_base));
		cur_y += TEXT_Y_INCR;
		dc->SetFont(*textWindowFont);
	}

	if(text != NULL) {
		text->SetFont(*textHeaderFont1);
		text->AppendText(buff);
		text->AppendText("\n");
		text->SetFont(*textTextFont);
	}
}

void
DisplayMethod::Line(char *buff)
{
	if(fpx != NULL)
		fprintf(fpx, "%s\n", buff);

	if(dc != NULL) {
		dc->DrawText(buff, (TEXT_X_OFFSET + x_base),
					 (cur_y + y_base));
		cur_y += TEXT_Y_INCR;
	}

	if(text != NULL) {
		text->AppendText(buff);
		text->AppendText("\n");
	}
}

void
DisplayMethod::Finish(char *msg)
{
	if(msg != NULL) {
		Line("");
		Line(msg);
	}

	if(fpx != NULL) {
		fclose(fpx);
		fpx = NULL;
	}
}

char *
DisplayMethod::SplitLine(char *buff)
{
char *ptr2;

	if((int)strlen(buff) < line_length) {
		ptr2 = &buff[strlen(buff)];
	} else {
		ptr2 = &buff[DEFAULT_SPACE_SEARCH];
		while(*ptr2 != ' ') {
			ptr2--;
		}
		*ptr2 = 0;
		ptr2++;
	}
	
	return(ptr2);
}

