/*
 * File:		t_dlg.cpp
 * Purpose:		general/generic dialogs
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: t_dlg.cpp,v $ $Revision: 1.16 $ $Author: man $ $Date: 2003/05/05 03:30:41 $" */

#ifdef __GNUG__
#pragma implementation "t_dlg.h"
#endif

#include "t_dlg.h"

#define DUMMY_BUFFER_SIZE			120
#define ID_USE_SCALE_CB				500

#if defined(__WXGTK__) || defined(__WXMOTIF__)
#include "bitmaps/apply_bm_text.xpm"
#include "bitmaps/apply_bm.xpm"
#include "bitmaps/cancel_bm_text.xpm"
#include "bitmaps/cancel_bm.xpm"
#include "bitmaps/ok_bm_text.xpm"
#include "bitmaps/ok_bm.xpm"
#endif

// ===========================================================================
BEGIN_EVENT_TABLE(GraphicDialog, wxDialog)
	EVT_CHECKBOX(ID_USE_SCALE_CB, GraphicDialog::OnUseScale)
END_EVENT_TABLE()

// ---------------------------------------------------------------------------
GraphicDialog::GraphicDialog(wxWindow *p) :
	StdDialog(p, "Graphic Format")
{
const wxString graphic_types[] = {
	"xpm",
	"jpeg",
	"gif",
	"png" };

    msg[0] = new wxStaticText(this, -1, "Scale:");
    msg[1] = new wxStaticText(this, -1, "Height:");
    msg[2] = new wxStaticText(this, -1, "Width:");

    type = new wxRadioBox(this, -1, "Format", 
			wxDefaultPosition, 
			wxDefaultSize, 
			4, graphic_types, 1, wxRA_SPECIFY_COLS);

    scale = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(DLG_OFFSET * 10, -1));
    height = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(DLG_OFFSET * 10, -1));
    width = new wxTextCtrl(this, -1, "",
			wxPoint(-1, -1),
			wxSize(DLG_OFFSET * 10, -1));
    use_scale = new wxCheckBox(this, ID_USE_SCALE_CB, "Use Scale");

    wxBoxSizer* sizer_13 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_14 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_15 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_16 = new wxBoxSizer(wxVERTICAL);
    wxFlexGridSizer* gs = new wxFlexGridSizer(3, 2, DLG_OFFSET, DLG_OFFSET);
    sizer_14->Add(type, 0, wxALL, DLG_OFFSET);
    gs->Add(msg[0], 0, wxALIGN_BOTTOM, 0);
    gs->Add(scale, 0, 0, 0);
    gs->Add(msg[1], 0, wxALIGN_BOTTOM, 0);
    gs->Add(height, 0, 0, 0);
    gs->Add(msg[2], 0, wxALIGN_BOTTOM, 0);
    gs->Add(width, 0, 0, 0);
    sizer_16->Add(gs, 1, wxALL|wxEXPAND, DLG_OFFSET);
    sizer_16->Add(use_scale, 0, wxALL, DLG_OFFSET);
    sizer_15->Add(sizer_16, 1, wxEXPAND, 0);
    sizer_14->Add(sizer_15, 1, wxEXPAND, 0);
    sizer_13->Add(sizer_14, 1, wxEXPAND, 0);
	
	DoLayout(wxALIGN_LEFT | wxALL, 2 * DLG_OFFSET, sizer_13);
}

GraphicDialog::~GraphicDialog()
{
}

static char *descs[] = {
	"*.xpm",
	"*.jpg",
	"*.gif",
	"*.png"
};
bool
GraphicDialog::GetGraphicInfo(int *t, bool *us, int *w, int *h, float *s,
				char **desc)
{
char buff[20];
int new_w,new_h;
float s_w,s_h;

	sprintf(buff, "%d", *w);
	width->SetValue(buff);
	sprintf(buff, "%d", *h);
	height->SetValue(buff);
	sprintf(buff, "%.3f", *s);
	scale->SetValue(buff);
	use_scale->SetValue(*us);
	switch(*t) {
    	case wxBITMAP_TYPE_JPEG:
			type->SetSelection(1);
			break;
    	case wxBITMAP_TYPE_GIF:
			type->SetSelection(2);
			break;
    	case wxBITMAP_TYPE_PNG:
			type->SetSelection(3);
			break;
		default:
			type->SetSelection(0);
			break;
	}
	ReflectState();

	if(ShowModal() == wxID_CANCEL)
		return(FALSE);

	switch(type->GetSelection()) {
		case 0:
    		*t = wxBITMAP_TYPE_XPM;
			*desc = descs[0];
			break;
		case 1:
    		*t = wxBITMAP_TYPE_JPEG;
			*desc = descs[1];
			break;
		case 2:
    		*t = wxBITMAP_TYPE_GIF;
			*desc = descs[2];
			break;
		case 3:
    		*t = wxBITMAP_TYPE_PNG;
			*desc = descs[3];
			break;
	}

	new_w = atoi(width->GetValue());
	new_h = atoi(height->GetValue());
	// try to preserve aspect
	if((new_w != *w) || (new_h != *h)) {
		s_w = (float)new_w / (float)*w;
		s_h = (float)new_h / (float)*h;
		if(s_w > s_h)
			s_h = s_w;
		else
			s_w = s_h;
		new_w = (int)(s_w * (float) new_w) + 1;
		new_h = (int)(s_h * (float) new_h) + 1;
	}
	*w = new_w;
	*h = new_h;
	*s = atof(scale->GetValue());
	*us = use_scale->GetValue();

	return(TRUE);
}

void 
GraphicDialog::OnUseScale(wxCommandEvent &event)
{
	ReflectState();
}

void 
GraphicDialog::ReflectState(void)
{
	if(use_scale->GetValue()) {
		msg[0]->Enable(TRUE);
		msg[1]->Enable(FALSE);
		msg[2]->Enable(FALSE);
		width->Enable(FALSE);
		height->Enable(FALSE);
		scale->Enable(TRUE);
	} else {
		msg[0]->Enable(FALSE);
		msg[1]->Enable(TRUE);
		msg[2]->Enable(TRUE);
		width->Enable(TRUE);
		height->Enable(TRUE);
		scale->Enable(FALSE);
	}
}

// ==========================================================================
void
NotImplemented(char *title)
{
	wxMessageBox("Sorry, Not Implemented Yet.\n(I'm typing as fast as I can)", 
				title, wxCENTRE | wxICON_EXCLAMATION);
}

// =======================================================================
BasePanel::BasePanel(wxWindow *w, bool horiz, bool use_apply, bool bm_only) :
		wxPanel(w)
{
wxBitmap *bm[3];

	if(bm_only) {
		bm[0] = new wxBitmap(ok_xpm);
		bm[1] = new wxBitmap(cancel_xpm);
		if(use_apply)
			bm[2] = new wxBitmap(apply_xpm);
	} else {
		bm[0] = new wxBitmap(ok_xpm_text);
		bm[1] = new wxBitmap(cancel_xpm_text);
		if(use_apply)
			bm[2] = new wxBitmap(apply_xpm_text);
	}

	ok_btn = new wxBitmapButton(this, wxID_OK, *bm[0]);
	cancel_btn = new wxBitmapButton(this, wxID_CANCEL, *bm[1]);
	if(use_apply)
		apply_btn = new wxBitmapButton(this, wxID_APPLY, *bm[2]);

	if(horiz) {
		sizer = new wxBoxSizer(wxHORIZONTAL);
	} else {
		sizer = new wxBoxSizer(wxVERTICAL);
		if(!bm_only) {
			ok_btn->SetSize(ok_btn->GetBestSize());
			cancel_btn->SetSize(cancel_btn->GetBestSize());
			if(use_apply)
				apply_btn->SetSize(apply_btn->GetBestSize());
		}
	}

	ok_btn->SetDefault();

	sizer->Add(ok_btn, 0, wxALL, DLG_OFFSET);
	sizer->Add(cancel_btn, 0, wxALL, DLG_OFFSET);
	if(use_apply)
		sizer->Add(apply_btn, 0, wxALL, DLG_OFFSET);
	SetAutoLayout(TRUE);
	SetSizer(sizer);
	sizer->Fit(this);
	sizer->SetSizeHints(this);
	Layout();
}

// =======================================================================
BEGIN_EVENT_TABLE(CoreDialog, wxDialog)
	EVT_BUTTON(wxID_OK, CoreDialog::OnOk)
	EVT_BUTTON(wxID_CANCEL, CoreDialog::OnCancel)
END_EVENT_TABLE()

CoreDialog::CoreDialog(wxWindow *p, char *t, bool horiz, bool use_apply,
				bool bm_only) :
	wxDialog(p, -1, t, wxDefaultPosition, wxDefaultSize, 
		wxDEFAULT_DIALOG_STYLE | wxDIALOG_MODAL | wxTAB_TRAVERSAL)
{
	sizer = new wxBoxSizer(wxHORIZONTAL);
	panel = new BasePanel(this, horiz, use_apply, bm_only);
	sizer->Add(panel);
	Centre(wxBOTH);
}

void 
CoreDialog::OnOk(wxCommandEvent &event)
{
	EndModal(wxID_OK);
	Show(FALSE);
}

void 
CoreDialog::OnCancel(wxCommandEvent &event)
{
	EndModal(wxID_CANCEL);
	Show(FALSE);
}

void
CoreDialog::DoLayout(int flags, int offset, wxSizer *main_sizer, 
				wxSizer *panel_sizer)
{
	if(panel_sizer != NULL)
    	panel_sizer->Add(sizer, 0, flags, offset);
	else
    	main_sizer->Add(sizer, 0, flags, offset);
    SetAutoLayout(TRUE);
    SetSizer(main_sizer);
    main_sizer->Fit(this);
    main_sizer->SetSizeHints(this);
    Layout();
}

