
/*
 * File:      
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_code.cpp,v $ $Revision: 1.8 $ $Author: man $ $Date: 2001/12/02 18:20:11 $" */



#include <stdio.h>
#include <stdlib.h>
#include "t_code.h"


#define CFG_HEADER_STR1             "################################################################################"
#define CFG_HEADER_STR2             "##"
#define CFG_TITLE                   "sector program config file"

#define BIG_BUFFER					120
#define REALBIG_BUFFER				256

#define ALLEG_FILE		"alleg.dat"
#define BASES_FILE		"bases.dat"
#define SCODES_FILE		"scodes.dat"
#define TCODES_FILE		"tcodes.dat"
#define UCODES_FILE		"ucodes.dat"


TCodes::TCodes(char *cfg_dir)
{
char lbuff[REALBIG_BUFFER];

	sprintf(lbuff, "%s/%s", cfg_dir, TCODES_FILE);
	trade_table = new TradeTable(lbuff);
	sprintf(lbuff, "%s/%s", cfg_dir, SCODES_FILE);
	syst_table = new CodeTable(lbuff);
	sprintf(lbuff, "%s/%s", cfg_dir, UCODES_FILE);
	other_table = new CodeTable(lbuff);
	sprintf(lbuff, "%s/%s", cfg_dir, ALLEG_FILE);
	alleg_table = new CodeTable(lbuff);
	sprintf(lbuff, "%s/%s", cfg_dir, BASES_FILE);
	base_table = new BaseTable(lbuff);
//	LoadCfg(cfg_dir);
#ifdef DEBUG_BASE_LIST
	base_table->DumpBT(stderr);
#endif
}

TCodes::~TCodes()
{
	delete trade_table;
	delete syst_table;
	delete other_table;
	delete alleg_table;
	delete base_table;
}

bool 
TCodes::LoadCfg(char *cfg_dir)
{
char lbuff[REALBIG_BUFFER];

	trade_table->Clear();
	sprintf(lbuff, "%s/%s", cfg_dir, TCODES_FILE);
	trade_table->Init(lbuff);

	syst_table->Clear();
	sprintf(lbuff, "%s/%s", cfg_dir, SCODES_FILE);
	syst_table->Init(lbuff);

	other_table->Clear();
	sprintf(lbuff, "%s/%s", cfg_dir, UCODES_FILE);
	other_table->Init(lbuff);

	alleg_table->Clear();
	sprintf(lbuff, "%s/%s", cfg_dir, ALLEG_FILE);
	alleg_table->Init(lbuff);

	base_table->Clear();
	sprintf(lbuff, "%s/%s", cfg_dir, BASES_FILE);
	base_table->Init(lbuff);

#ifdef DEBUG_BASE_LIST
	base_table->DumpBT(stderr);
#endif
   	return(TRUE);
}

void 
TCodes::WriteHeader(FILE *fpx, char *sect_str, char *format_str)
{
	fprintf(fpx, "%s\n", CFG_HEADER_STR1);
	fprintf(fpx, "%s\n", CFG_HEADER_STR2);
	fprintf(fpx, "%s %s section\n", CFG_HEADER_STR2, sect_str);
	fprintf(fpx, "%s format:\n", CFG_HEADER_STR2);
	fprintf(fpx, "%s %s\n", CFG_HEADER_STR2, format_str);
	fprintf(fpx, "%s\n", CFG_HEADER_STR2);
	fprintf(fpx, "%s\n", CFG_HEADER_STR1);
}

// XXX
bool 
TCodes::SaveCfg(char *cfg_name)
{
FILE *fpx;
ListNode *n;
BaseTableEntry *bte;
CodeTableEntry *cte;

	if((fpx = fopen(cfg_name, "w+")) != NULL) {
		// initial header
		fprintf(fpx, "%s\n", CFG_HEADER_STR1);
		fprintf(fpx, "%s %s\n", CFG_HEADER_STR2, CFG_TITLE);
		fprintf(fpx, "%s\n", CFG_HEADER_STR1);
		fprintf(fpx, "\n");
		fprintf(fpx, "\n");
		// bases
		//	bases header
		WriteHeader(fpx, "Bases", "E:c:text:bitmap code");
		//	bases data
		n = base_table->First();
		while(n != NULL) {
			char *bm1;

			bte = (BaseTableEntry *)n->Data();
			if(!bte->IsLocal()) {
				fprintf(fpx, "%c:%s:%s:", 'E', bte->GetCode(), bte->GetDesc());
				bm1 = bte->GetName(0);
				if(bm1 != NULL) 
					fprintf(fpx, bm1);
				fprintf(fpx, ":");
				bm1 = bte->GetName(1);
				if(bm1 != NULL) 
					fprintf(fpx, bm1);
				fprintf(fpx, "\n");
			}
			n = n->Next();
		}
		fprintf(fpx, "\n");
		fprintf(fpx, "\n");

		// codes
		//	codes header
		WriteHeader(fpx, "Codes", "C:co:text");
		//	codes data
		n = trade_table->First();
		while(n != NULL) {
			cte = (CodeTableEntry *)n->Data();
			if(!cte->IsLocal()) 
				fprintf(fpx, "%c:%s:%s\n", 'T', cte->GetCode(), cte->GetDesc());
			n = n->Next();
		}
		fprintf(fpx, "\n");
		//	other data
		n = other_table->First();
		while(n != NULL) {
			cte = (CodeTableEntry *)n->Data();
			if(!cte->IsLocal()) 
				fprintf(fpx, "%c:%s:%s\n", 'C', cte->GetCode(), cte->GetDesc());
			n = n->Next();
		}
		fprintf(fpx, "\n");
		//	syst data
		n = syst_table->First();
		while(n != NULL) {
			cte = (CodeTableEntry *)n->Data();
			if(!cte->IsLocal()) 
				fprintf(fpx, "%c:%s:%s\n", 'S', cte->GetCode(), cte->GetDesc());
			n = n->Next();
		}
		fprintf(fpx, "\n");
		fprintf(fpx, "\n");

		// allegiance
		//  alleg header
		WriteHeader(fpx, "Allegiance", "A:co:text");
		//	alleg data
		n = alleg_table->First();
		while(n != NULL) {
			cte = (CodeTableEntry *)n->Data();
			if(!cte->IsLocal()) 
				fprintf(fpx, "%c:%s:%s\n", 'A', cte->GetCode(), cte->GetDesc());
			n = n->Next();
		}
		fprintf(fpx, "\n");
		fprintf(fpx, "\n");

		fclose(fpx);
		return(TRUE);
	}

	return(FALSE);
}

void 
TCodes::ClearLocal(void)
{
	trade_table->Clear(TRUE);
	syst_table->Clear(TRUE);
	other_table->Clear(TRUE);
	alleg_table->Clear(TRUE);
	base_table->Clear(TRUE);
}

