//
// File:      systdisp.cpp
// Purpose:   Drawing system text
// Author:    Mark A. Nordstrand
// Created:   6/20/2000
// Updated:
// Copyright: LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: systdisp.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $"

#include "systdisp.h"

// ======================================================================
SystemDisplay::~SystemDisplay()
{
}

int
SystemDisplay::DrawDetails(System *sys, PRINT_SOURCE ps, char *msg1, char *msg2,
						   int start, int lines)
{
int world_count=0,line_count=0;

	Start(msg1);

	if(sys != NULL) {
		BaseOrbit *bo;
		
		if((ps == PS_CUR) || (ps == PS_SUB))
		    bo = sys->GetCurrentOrbit();
		else
		    bo = sys->GetPrimOrbit();

		if(ps == PS_CUR) {
			DrawDetail(sys, bo);
			world_count = 1;
	    } else
		    DrawDetails(sys, bo, &world_count, &line_count, start, lines, ps);
	}
	Finish(msg2);

    return(world_count);
}

int
SystemDisplay::DrawDetails(System *sys, BaseOrbit *bo, int *world_count,
						   int *line_count, int start, int lines,
						   PRINT_SOURCE ps)
{
int wcount,lcount,temp_count,ret=0;

    wcount = *world_count;
	lcount = *line_count;
	if(wcount >= start) {
		if(bo->IsLargeGG() || bo->IsSmallGG())
		    temp_count = (LINE_GG_RETURN + 1);
		else if(bo->IsStar())
		    temp_count = (LINE_STAR_RETURN + 1);
		else
		    temp_count = (LINE_OTHER_RETURN + 1);

		if((temp_count + lcount) <= lines) {
		    DrawDetail(sys, bo);
			Line(" ");
			lcount += temp_count;
		    ret = 1;
		} else
		    ret = -1;
	}
	wcount++;

	if(ret > -1) {
		if((bo->GetOrbType() & ORBIT_IS_STAR) ||
		   ((ps != PS_IGN) && (bo->GetOrbType() & ORBIT_IS_WORLD))) {
			int ndx=0;
			BaseOrbit *bo1;

			while((bo1 = bo->GetNthOrbit(ndx++)) != NULL) {
				temp_count = DrawDetails(sys, bo1, &wcount, &lcount,
										 start, lines, ps);
				if(temp_count < 0) {
					*world_count = wcount;
					*line_count = lcount;
					return(-1);
				}
			}
		}
	}

	*world_count = wcount;
	*line_count = lcount;
	return(ret);
}

int
SystemDisplay::DrawDetail(System *sys, BaseOrbit *b_orb)
{
bool ok=FALSE;
char buff[120];
char buff1[120];
char buff2[120];
char *ptr1,*ptr2;
char type;
int ret;
planet *p;
DetailStar *st;

	if(b_orb != NULL) {
		b_orb->GetFormatedOrbit(buff);
		sprintf(buff1, "    Orbit: %s", buff);
		Line(buff1);
		sprintf(buff, "     Name: %s", b_orb->FormatName(buff2, -1));
		Line(buff);
		  
		type = b_orb->GetOrbType();

		if(type & ORBIT_IS_STAR) {
			StarOrbit *so = (StarOrbit *) b_orb;
			st = so->GetStar();

			sprintf(buff, "First Orb: %d", st->GetFirstOrbit());
			Line(buff);
			sprintf(buff, "Habitible: %d", st->GetHabZone());
			Line(buff);

			sprintf(buff, "    Class: %s", st->GetClassDesc(buff2));
			Line(buff);
			sprintf(buff, "     Size: %s", st->GetSizeDesc(buff2));
			Line(buff);
			sprintf(buff, "    Lumin: %f Sol", st->GetLumin());
			Line(buff);
			sprintf(buff, "     Temp: %f K", st->GetTemp());
			Line(buff);
			sprintf(buff, "   Radius: %f Sol", st->GetRad());
			Line(buff);
			sprintf(buff, "     Mass: %f Sol", st->GetMass());
			Line(buff);

			ret = LINE_GG_RETURN;
			ok = TRUE;
		} else if(b_orb->IsLargeGG() || b_orb->IsSmallGG()) {
			WorldOrbit *w = (WorldOrbit *)b_orb;
			p = w->GetWorld();
			sprintf(buff, "     Size: %s", p->GetSizeDesc(buff1));
			Line(buff);

			ret = LINE_GG_RETURN;
			ok = TRUE;
		} else {
			if(type & ORBIT_IS_WORLD) {
				WorldOrbit *w = (WorldOrbit *)b_orb;
				p = w->GetWorld();
			} else if(type & ORBIT_IS_SAT) {
				SatOrbit *s = (SatOrbit *)b_orb;
				p = s->GetSat();
			}

			ptr1 = p->GetPortDesc(buff1);
			ptr2 = SplitLine(ptr1);
			sprintf(buff, "     Port:  %s", ptr1);
			Line(buff);
			sprintf(buff, "            %s", ptr2);
			Line(buff);
			
			sprintf(buff, "     Size: %s", p->GetSizeDesc(buff1));
			Line(buff);
			sprintf(buff, "    Atmos: %s", p->GetAtmosDesc(buff1));
			Line(buff);
			sprintf(buff, "    Hydro: %s", p->GetHydroDesc(buff1));
			Line(buff);
			sprintf(buff, "      Pop: %s", p->GetPopDesc(buff1));
			Line(buff);
			sprintf(buff, "     Govt: %s", p->GetGovtDesc(buff1));
			Line(buff);
			sprintf(buff, "      Law: %s", p->GetLawDesc(buff1));
			Line(buff);
			sprintf(buff, "     Tech: %s", p->GetTechDesc(buff1));
			Line(buff);
			sprintf(buff, "    Bases: %s", sys->FormatBase(p->GetBase(),
															buff1));
			Line(buff);

			ptr1 = sys->FormatSystem(p->GetSysFlags(), buff1);
			ptr2 = SplitLine(ptr1);
			sprintf(buff, "   System: %s", ptr1);
			Line(buff);
			sprintf(buff, "           %s", ptr2);
			Line(buff);
			
			ptr1 = sys->FormatTrade(p->GetTradeCodes(), buff1);
			ptr2 = SplitLine(ptr1);
			sprintf(buff, "    Trade: %s", ptr1);
			Line(buff);
			sprintf(buff, "           %s", ptr2);
			Line(buff);
			
			ptr1 = sys->FormatOther(p->GetOtherCodes(), buff1);
			ptr2 = SplitLine(ptr1);
			sprintf(buff, "    Other: %s", ptr1);
			Line(buff);
			sprintf(buff, "           %s", ptr2);
			Line(buff);
			
			sprintf(buff, "     Zone: %s", sys->FormatZone(p->GetZone(),
															buff1));
			Line(buff);
			
			sprintf(buff, "    Alleg: %s", sys->FormatAlleg(p->GetAlleg(), buff1));
			Line(buff);
			
			ret = LINE_OTHER_RETURN;
			ok = TRUE;
		}
		
	}

	if(!ok) {
		Line(" Orbit:");
		Line("  Name:");
		Line("  Port:");
		Line(" ");
		Line("  Size:");
		Line(" Atmos:");
		Line(" Hydro:");
		Line("   Pop:");
		Line("  Govt:");
		Line("   Law:");
		Line("  Tech:");
		Line(" Bases:");
		Line("System:");
		Line(" ");
		Line(" Trade:");
		Line(" ");
		Line(" Other:");
		Line(" ");
		Line("  Zone:");
		Line(" Alleg:");
		ret = LINE_OTHER_RETURN;
	}

	return(ret);
}

int
SystemDisplay::DrawLines(System *sys, char *msg1, char *msg2,
						 int start_count, int end_count)
{
int count=0;

	Start(msg1);

	if(sys != NULL)
	    count = DrawStarLine(sys, SI_PRIMARY,
							 &count, start_count, end_count);
	
	Finish(msg2);
	
	return(count);
}

	
// draw a sat
int
SystemDisplay::DrawSatLine(System *sys, STAR_INDEX st,int pl, int sat,
						   int *count, int start_count, int end_count)
{
int ret=0;

	ret = DrawLine(sys, st, pl, sat, count, start_count, end_count);
	return(ret);
}

// draw a world and all of _it's_ orbits
int
SystemDisplay::DrawWorldLine(System *sys, STAR_INDEX st, int pl,
							 int *count, int start_count, int end_count)
{
BaseOrbit *bo;
int sat=0,ret=-1;

    if((bo = sys->GetOrbit(st, pl, -1)) != NULL) {
		ret = DrawLine(sys, st, pl, -1, count, start_count, end_count);
		while(sys->GetOrbit(st, pl, sat) != NULL) {
			ret += DrawSatLine(sys, st, pl, sat, count,
							   start_count, end_count);
			sat++;
		}
	}
	return(ret);
}


// draw a star and all of _it's_ orbits
int
SystemDisplay::DrawStarLine(System *sys, STAR_INDEX st, int *count,
							int start_count, int end_count)
{
BaseOrbit *bo;
int pl=0,ret=-1;
int orb_type,st1;

    if(st == SI_PRIMARY)
	    st1 = (int) SI_1ST_COMP;
	else
		st1 = (int) st + 1;
		
	if((bo = sys->GetOrbit(st, -1, -1)) != NULL) {
		ret = DrawLine(sys, st, -1, -1, count,
						   start_count, end_count);  

		while((bo = sys->GetOrbit(st, pl, -1)) != NULL) {
			orb_type = bo->GetOrbType();
			if(orb_type & ORBIT_IS_STAR) {
				ret += DrawStarLine(sys, (STAR_INDEX) st1, count,
										start_count, end_count);
				st1 =+ 2;
			} else if(orb_type & ORBIT_IS_WORLD) {
				ret += DrawWorldLine(sys, st, pl, count, start_count,
										 end_count);
			}
			pl++;
		}
	}
	return(ret);
}

// just draw the indicated line
int
SystemDisplay::DrawLine(System *sys, STAR_INDEX st, int pl, int sat,
							int *count, int start_count, int end_count)
{
char buff[120];
int ret=0;

		if((sys->GetListing(st, pl, sat, buff) != NULL) && (buff[0] != 0)) {
		    if((*count >= start_count) && (*count <= end_count)) {
				strstrip(buff, FALSE);
				Line(buff);
				ret++;
			}
			*count++;
		}
	return(ret);
}

