//
// File:		hex_fmt.cpp
// Purpose:		misc hex layout code
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: hex_fmt.cpp,v $ $Revision: 1.1 $ $Author: man $ $Date: 2002/10/03 10:52:34 $"


#include <stdlib.h>
#include <string.h>
#include "hex_fmt.h"

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

static HEX_DISPLAY d_code[MAX_LAYOUT_X][MAX_LAYOUT_Y] = {
	{ HD_NUMBER, HD_BASE_BM1, HD_BASE_BM2, HD_NAME_POP, HD_UWP_NO_PORT },
	{ HD_NONE, HD_PORT, HD_MW_HYDRO_BM, HD_NONE, HD_NONE },
	{ HD_NONE, HD_GG_BM, HD_ALLEG, HD_NONE, HD_NONE }
};

// ==============================================================
HexLayout::HexLayout()
{
	Reset();
}

HexLayout::HexLayout(HexLayout *hl)
{
int x,y;

	for(x = 0;x < MAX_LAYOUT_X;x++)
		for(y = 0;y < MAX_LAYOUT_Y;y++)
			code[x][y] = hl->GetCode(x, y);
	uwp_filter = hl->GetUWPFilter();
}

HexLayout::~HexLayout()
{
}

// --------------------------------------------------------------
void
HexLayout::Reset(void)
{
	code[0][0] = HD_NUMBER;
	code[0][1] = HD_BASE_BM1;
	code[0][2] = HD_BASE_BM2;
	code[0][3] = HD_NAME_POP;
	code[0][4] = HD_UWP_NO_PORT;
	code[1][0] = HD_NONE;
	code[1][1] = HD_PORT;
	code[1][2] = HD_MW_HYDRO_BM;
	code[1][3] = HD_NONE;
	code[1][4] = HD_NONE;
	code[2][0] = HD_NONE;
	code[2][1] = HD_GG_BM;
	code[2][2] = HD_ALLEG;
	code[2][3] = HD_NONE;
	code[2][4] = HD_NONE;
	uwp_filter = 0;
}

HEX_DISPLAY
HexLayout::GetCode(int x, int y)
{
	if(ValidCoord(x, y))
		return(code[x][y]);
	return(HD_NONE);
}

HEX_DISPLAY
HexLayout::GetDefaultCode(int x, int y)
{
	if(ValidCoord(x, y))
		return(d_code[x][y]);
	return(HD_NONE);
}

void
HexLayout::SetCode(int x, int y, HEX_DISPLAY c)
{
	if(ValidCoord(x, y))
		code[x][y] = c;
}

bool
HexLayout::ValidCoord(int x, int y)
{
	if((x < 0) || (x >= MAX_LAYOUT_X) ||
		(y < 0) || (y >= MAX_LAYOUT_Y))
		return(FALSE);

	return(TRUE);
}

// alt => a simple description
char *
HexLayout::GetString(HEX_DISPLAY hd, bool alt)
{
	switch(hd) {
		case HD_NONE:
			return("None");
			break;
		case HD_NUMBER:
			return("Hex Number");
			break;
		case HD_NAME:
			return("World Name");
			break;
		case HD_NAME_POP:
			if(alt)
				return("World Name");
			else
				return("Name w/ pop.");
			break;
		case HD_UWP_NO_PORT:
			if(alt)
				return("UWP");
			else
				return("UWP less Port");
			break;
		case HD_UWP_FILTERED:
			return("UWP Filtered");
			break;
		case HD_UWP:
			return("UWP");
			break;
		case HD_TRADE_CODES:
			return("Trade Codes");
			break;
		case HD_PORT:
			return("Port");
			break;
		case HD_SIZE:
			return("Size");
			break;
		case HD_ATMOS:
			return("Atmos");
			break;
		case HD_HYDRO:
			return("Hydro");
			break;
		case HD_POP:
			return("Pop");
			break;
		case HD_GOVT:
			return("Govt");
			break;
		case HD_LAW:
			return("Law");
			break;
		case HD_TECH:
			return("Tech");
			break;
		case HD_BASE_CODE:
			return("Base Code");
			break;
		case HD_ALLEG:
			return("Alleg");
			break;
		case HD_GG_NUM:
			return("# of GG");
			break;
		case HD_BELTS_NUM:
			return("# of Belts");
			break;
		case HD_POP_NDX:
			return("Pop. Index");
			break;
		case HD_NUM_STAR:
			return("# of Stars");
			break;
		case HD_BASE_BM1:
			if(alt)
				return("Base 1");
			else
				return("Base BM 1");
			break;
		case HD_BASE_BM2:
			if(alt)
				return("Base 2");
			else
				return("Base BM 2");
			break;
		case HD_GG_BM:
			if(alt)
				return("GG");
			else
				return("GG BM");
			break;
		case HD_BELTS_BM:
			if(alt)
				return("Belts");
			else
				return("Belts BM");
			break;
		case HD_STAR_BM1:
			if(alt)
				return("Star 1");
			else
				return("Star BM 1");
			break;
		case HD_STAR_BM2:
			if(alt)
				return("Star 2");
			else
				return("Star BM 2");
			break;
		case HD_STAR_BM3:
			if(alt)
				return("Star 3");
			else
				return("Star BM 3");
			break;
		case HD_MW_BM:
			if(alt)
				return("Main World");
			else
				return("MW BM");
			break;
		case HD_MW_PRESENT:
			if(alt)
				return("Main World");
			else
				return("MW Present");
			break;
		case HD_MW_HYDRO_BM:
			if(alt)
				return("Main World");
			else
				return("MW Hydro BM");
			break;
	}

	return(NULL);
}

char *
HexLayout::FilterUWP(char *buff)
{
unsigned char mask;
int i,j;

	mask = 1;
	j = 0;
	for(i = 0;i < 8;i++) {
		if(!(uwp_filter & mask))
			buff[i+j] = '_';
		if(0 == i)
			j++;
		mask *= 2;
	}

	return(buff);
}

bool
HexLayout::IsDefault(int x, int y)
{
	if(GetCode(x, y) == GetDefaultCode(x, y))
		return(TRUE);
	return(FALSE);
}

