//
// File:		hardtimes.cpp
// Purpose:		tracking hardtimes info
// Author:		Mark A. Nordstrand
// Created:		Sat Mar 30 09:30:51 CST 2002
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: hardtimes.cpp,v $ $Revision: 1.1 $ $Author: man $ $Date: 2002/03/30 16:10:32 $"

#ifdef DEBUG_HT
#include <stdio.h>
#endif
#include <libgen.h>
#include "hardtimes.h"

#define BUFFER_SIZE			256

// ============================================================================
// the 'map' class
HardTimes::HardTimes(char *dir)
{
char buffer[BUFFER_SIZE];
int x,y,x1;
FILE *fp;

	for(x = 0;x < MAX_X_HEX;x++) {
		for(y = 0;y < MAX_Y_HEX;y++) {
			area[x][y] = HTA_SAFE;
			war[x][y] = HTW_PEACE;
		}
	}

	sprintf(buffer, "%s/%s.ht", dir, basename(dir));
	if((fp = fopen(buffer, "r")) != NULL) {
		// read area map
		y = 0;
		while(fgets(buffer, BUFFER_SIZE, fp) != NULL) {
			if(strlen(buffer) > MAX_X_HEX)
				x1 = MAX_X_HEX;
			else
				x1 = strlen(buffer);
			for(x = 0;x < x1;x++) {
				switch(buffer[x]) {
					default:
					case 'S':
					case 's':
						area[x][y] = HTA_SAFE;
						break;
					case 'F':
					case 'f':
						area[x][y] = HTA_FRONTIER;
						break;
					case 'O':
					case 'o':
						area[x][y] = HTA_OUTLANDS;
						break;
					case 'W':
					case 'w':
						area[x][y] = HTA_WILDS;
						break;
				}
			}
			y++;
			if(y >= MAX_Y_HEX)
				break;
		}
		// read war map
		y = 0;
		while(fgets(buffer, BUFFER_SIZE, fp) != NULL) {
			if(strlen(buffer) > MAX_X_HEX)
				x1 = MAX_X_HEX;
			else
				x1 = strlen(buffer);
			for(x = 0;x < x1;x++) {
				switch(buffer[x]) {
					default:
					case 'P':
					case 'p':
						war[x][y] = HTW_PEACE;
						break;
					case 'W':
					case 'w':
						war[x][y] = HTW_WAR;
						break;
					case 'I':
					case 'i':
						war[x][y] = HTW_INTENSE;
						break;
					case 'B':
					case 'b':
						war[x][y] = HTW_BLACK;
						break;
				}
			}
			y++;
			if(y >= MAX_Y_HEX)
				break;
		}
	}
}

HT_AREA 
HardTimes::GetArea(int x, int y)
{
	if((x < 0) || (x >= MAX_X_HEX) || (y < 0) || (y >= MAX_Y_HEX)) 
		return(HTA_SAFE);
	return(area[x][y]);
}

HT_WAR 
HardTimes::GetWar(int x, int y)
{
	if((x < 0) || (x >= MAX_X_HEX) || (y < 0) || (y >= MAX_Y_HEX)) 
		return(HTW_PEACE);
	return(war[x][y]);
}

#ifdef DEBUG_HT
void
HardTimes::Dump(void)
{
int x,y;

	for(y = 0;y < MAX_Y_HEX;y++) {
		for(x = 0;x < MAX_X_HEX;x++) {
			switch(area[x][y]) {
				case HTA_SAFE:
					fprintf(stderr, "S");
					break;
				case HTA_FRONTIER:
					fprintf(stderr, "F");
					break;
				case HTA_OUTLANDS:
					fprintf(stderr, "O");
					break;
				case HTA_WILDS:
					fprintf(stderr, "W");
					break;
			}
		}
		fprintf(stderr, "\n");
	}
	for(y = 0;y < MAX_Y_HEX;y++) {
		for(x = 0;x < MAX_X_HEX;x++) {
			switch(war[x][y]) {
				case HTW_PEACE:
					fprintf(stderr, "P");
					break;
				case HTW_WAR:
					fprintf(stderr, "W");
					break;
				case HTW_INTENSE:
					fprintf(stderr, "I");
					break;
				case HTW_BLACK:
					fprintf(stderr, "B");
					break;
			}
		}
		fprintf(stderr, "\n");
	}
//exit(0);
}
#endif

