
/*
 * File:      d_star.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: d_star.cpp,v $ $Revision: 1.6 $ $Author: man $ $Date: 2003/11/02 01:51:46 $" */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "d_star.h"

// NOTE:  I had a hard time finding good info on class O values, most of
// the source I could find where at best, conflicting.  As such the values
// below are very fudged (or fudged up).  If any reliable sources are
// available, I would like to see 'em.

/* size,half class => first and habitible */
struct StarZones DetailStar::StarOrbits[MAX_STAR_SIZES+1][MAX_HALF_CLASS] = {
 {{ 8,13 },{ 8,13 },{ 7,12 },{ 7,12 },{ 7,12 },{ 6,12 },{ 6,11 },
  { 7,12 },{ 7,12 },{ 7,12 },{ 7,12 },{ 7,12 },{ 8,12 },{ 8,12 }},	// Ia
 {{ 8,13 },{ 8,13 },{ 6,11 },{ 5,11 },{ 5,10 },{ 5,10 },{ 4,10 },
  { 4,10 },{ 5,10 },{ 5,10 },{ 6,11 },{ 6,11 },{ 7,12 },{ 8,12 }},  // Ib
 {{ 8,12 },{ 7,12 },{ 5,11 },{ 3, 9 },{ 2, 8 },{ 2, 8 },{ 2, 8 },
  { 2, 8 },{ 2, 8 },{ 2, 9 },{ 3, 9 },{ 4,10 },{ 6,11 },{ 6,11 }},  // II
 {{ 8,12 },{ 7,12 },{ 4,10 },{ 1, 8 },{ 1, 7 },{ 1, 6 },{ 1, 6 },
  { 1, 6 },{ 1, 7 },{ 1, 7 },{ 1, 8 },{ 2, 8 },{ 4, 9 },{ 5, 9 }},  // III
 {{ 7,12 },{ 7,12 },{ 3, 9 },{ 1, 7 },{ 0, 6 },{ 0, 6 },{ 0, 5 },
  { 0, 5 },{ 0, 5 },{ 0, 4 },{-1,-1 },{-1,-1 },{-1,-1 },{-1,-1 }},  // IV
 {{ 7,12 },{ 6,12 },{ 4, 9 },{ 0, 7 },{ 0, 6 },{ 0, 5 },{ 0, 4 },
  { 0, 3 },{ 0, 2 },{ 0, 2 },{ 0, 0 },{ 0, 0 },{ 0,-1 },{ 0,-1 }},  // V
 {{-1,-1 },{-1,-1 },{-1,-1 },{-1,-1 },{-1,-1 },{-1,-1 },{ 0, 3 },
  { 0, 2 },{ 0, 1 },{ 0, 1 },{ 0,-1 },{ 0,-1 },{ 0,-1 },{ 0,-1 }},  // VI
 {{ 0, 0 },{ 0, 0 },{ 0, 0 },{ 0,-1 },{ 0,-1 },{ 0,-1 },{ 0,-1 },
  { 0,-1 },{ 0,-1 },{ 0,-1 },{ 0,-1 },{ 0,-1 },{ 0,-1 },{ 0,-1 }}   // D
};

double DetailStar::StarMag[MAX_STAR_SIZES+1][MAX_HALF_CLASS] = {
 {-13.23, -9.60, -8.50, -7.80, -7.50, -7.20, -7.00,
   -7.30, -7.60, -7.70, -7.80, -7.90, -8.00, -8.10 }, // Ia
 {-12.45, -8.80, -6.90, -5.70, -5.40, -4.90, -4.50,
   -4.70, -5.00, -5.40, -6.00, -6.90, -7.60, -7.90 }, // Ib
 { 99.99, -8.30, -5.90, -3.60, -2.55, -2.18, -2.00,
   -2.10, -2.40, -2.60, -3.70, -4.40, -5.65, -5.75 }, // II
 { 99.99, -7.80, -3.50, -1.36, -0.10,  0.45,  0.70,
    0.52,  0.08, -0.17, -1.50, -1.90, -3.60, -3.80 }, // III
 { 99.99, -7.50, -3.10, -0.70,  0.85,  1.58,  2.10,
    2.74,  3.04,  3.10, 99.99, 99.99, 99.99, 99.99 }, // IV
 { -9.87, -7.10, -2.71, -0.10,  1.80,  2.50,  3.40,
    4.57,  5.20,  5.70,  7.40,  8.25, 10.20, 13.90 }, // V
 { 99.99, 99.99, 99.99, 99.99, 99.99, 99.99,  4.80,
    5.97,  6.60,  7.10,  8.80,  9.65, 11.60, 15.30 }, // VI
 { 99.99,  8.10,  8.10, 10.50, 10.50, 13.60, 13.60,
   15.30, 15.30, 15.60, 15.60, 15.90, 15.90, 15.90 }  // D
};

double DetailStar::StarLumin[MAX_STAR_SIZES+1][MAX_HALF_CLASS] = {
{ 1200000.0, 560000.0, 204000.0, 107000.0,  81000.0,  61000.0,  51000.0,
    67000.0,  89000.0,  97000.0, 107000.0, 117000.0, 129000.0, 141000.0 },//Ia
{  980000.0, 270000.0,  46700.0,  15000.0,  11700.0,   7400.0,   5100.0,
     6100.0,   8100.0,  11700.0,  20400.0,  46000.0,  89000.0, 117000.0 },//Ib
{       0.0, 170000.0,  18600.0,   2200.0,    850.0,    600.0,    510.0,
      560.0,    740.0,    890.0,   2450.0,   4600.0,  14900.0,  16200.0 },//II
{       0.0, 107000.0,   6700.0,    280.0,     90.0,     53.0,     43.0,
       50.0,     75.0,     95.0,    320.0,    470.0,   2280.0,   2690.0 },//III
{       0.0,  81000.0,   2000.0,    156.0,     37.0,     19.0,     12.0,
        6.5,      4.9,      4.67,     0.0,      0.0,      0.0,      0.0 },//IV
{  790000.0,  56000.0,   1400.0,     90.0,     16.0,      8.1,      3.5,
        1.21,     0.67,     0.42,     0.08,     0.04,     0.007,    0.001},//V
{       0.0,      0.0,      0.0,      0.0,      0.0,      0.0,      0.977,
        0.322,    0.186,    0.117,    0.025,    0.011,    0.002,  0.00006 },//VI
{       0.0,      0.046,    0.046,    0.005,    0.005,    0.0003,   0.0003,
  	    0.00006,  0.00006,  0.00004,  0.00004,  0.00003,  0.00003, 0.00003 } //D
};

double DetailStar::StarTemp[MAX_STAR_SIZES+1][MAX_HALF_CLASS] = {
 { 44000.0, 22000.0, 14200.0,  9000.0,  8000.0,  6900.0,  6100.0,
    5400.0,  4700.0,  4000.0,  3300.0,  2800.0,  2000.0,  1900.0 },  // Ia
 { 45000.0, 24000.0, 14500.0,  9100.0,  8100.0,  7000.0,  6300.0,
    5600.0,  4850.0,  4100.0,  3500.0,  2900.0,  2200.0,  2000.0 },  // Ib
 {     0.0, 25000.0, 15100.0,  9300.0,  8200.0,  7100.0,  6400.0,
    5700.0,  5000.0,  4300.0,  3650.0,  3100.0,  2400.0,  2100.0 },  // II
 {     0.0, 26000.0, 15200.0,  9500.0,  8300.0,  7200.0,  6500.0,
    5800.0,  5100.0,  4500.0,  3800.0,  3400.0,  2650.0,  2200.0 },  // III
 {     0.0, 27000.0, 15400.0,  9700.0,  8400.0,  7300.0,  6600.0,
    5900.0,  5200.0,  4700.0,     0.0,     0.0,     0.0,     0.0 },  // IV
 { 46000.0, 28000.0, 15500.0,  9900.0,  8500.0,  7400.0,  6700.0,
    6000.0,  5500.0,  4900.0,  4100.0,  3500.0,  2800.0,  2300.0 },  // V
 {     0.0,     0.0,     0.0,     0.0,     0.0,     0.0,  6800.0,
    6100.0,  5600.0,  5000.0,  4200.0,  3600.0,  2900.0,  2400.0 },  // VI
 {     0.0, 25000.0, 25000.0, 14000.0, 14000.0,  6600.0,  6600.0,
    4500.0,  4500.0,  3500.0,  3500.0,  2700.0,  2700.0,  2700.0 }   // D
};

double DetailStar::StarRad[MAX_STAR_SIZES+1][MAX_HALF_CLASS] = {
 {   27.0,   52.0,   75.0,  135.0,  149.0,  174.0,  204.0,
    298.0,  454.0,  654.0, 1010.0, 1467.0, 3020.0, 3499.0  }, // Ia
 {   16.0,   30.0,   35.0,   50.0,   55.0,   59.0,   60.0,
     84.0,  128.0,  216.0,  392.0,  857.0, 2073.0, 2876.0  }, // Ib
 {    0.0,   22.0,   20.0,   18.0,   14.0,   16.0,   18.0,
     25.0,   37.0,   54.0,  124.0,  237.0,  712.0,  931.0  }, // II
 {    0.0,   16.0,   10.0,    6.2,    4.6,    4.7,    5.2,
      7.1,   11.0,   16.0,   42.0,   63.0,  228.0,  360.0  }, // III
 {    0.0,   13.0,    5.3,    4.5,    2.7,    2.7,    2.6,
      2.5,    2.8,    3.3,    0.0,    0.0,    0.0,    0.0  }, // IV
 {   15.0,   10.0,    4.4,    3.2,    1.8,    1.7,    1.4,
      1.03,   0.91,   0.908,  0.566,  0.549,  0.358,  0.201}, // V
 {    0.0,    0.0,    0.0,    0.0,    0.0,    0.0,    1.14,
      1.02,   0.55,   0.4,    0.308,  0.256,  0.104,  0.053}, // VI
 {    0.0,    0.018,  0.018,  0.017,  0.017,  0.013,  0.013,
      0.012,  0.012,  0.009,  0.009,  0.006,  0.006,  0.006}  // D
};

double DetailStar::StarMass[MAX_STAR_SIZES+1][MAX_HALF_CLASS] = {
 { 70.0,   60.0,   30.0,   18.0,   15.0,   13.0,   12.0,
   12.0,   13.0,   14.0,   18.0,   20.0,   25.0,   30.0    }, // Ia
 { 60.0,   50.0,   25.0,   16.0,   13.0,   12.0,   10.0,
   10.0,   12.0,   13.0,   16.0,   16.0,   20.0,   25.0    }, // Ib
 {  0.0,   30.0,   20.0,   14.0,   11.0,   10.0,    8.1,
    8.1,   10.0,   11.0,   14.0,   14.0,   16.0,   18.0    }, // II
 {  0.0,   25.0,   15.0,   12.0,    9.0,    8.0,    5.0,
    2.5,    3.2,    4.0,    5.0,    6.3,    7.4,    9.2    }, // III
 {  0.0,   20.0,   10.0,    6.0,    4.0,    2.5,    2.0,
    1.75,   2.0,    2.3,    0.0,    0.0,    0.0,    0.0    }, // IV
 { 50.0,   18.0,    6.5,    3.2,    2.1,    1.7,    1.3,
    1.04,   0.94,   0.825,  0.570,  0.489,  0.231,  0.215  }, // V
 {  0.0,    0.0,    0.0,    0.0,    0.0,    0.0,    0.8,
    0.6,    0.528,  0.430,  0.330,  0.154,  0.104,  0.058  }, // VI
 {  0.0,    0.26,   0.26,   0.36,   0.36,   0.42,   0.42, 
    0.63,   0.63,   0.83,   0.83,   1.11,   1.11,   1.11   }  // D
};

char *DetailStar::StarNames[MAX_STAR_SIZES+1] = {
   "Brightest Supergiant",
   "Weaker Supergiat",
   "Bright Giant",
   "Normal Giant",
   "Subgiant",
   "Main Sequence Star",
   "Subdwarf",
   "White Dwarf"
};

// ---------------------------------------------------------------------------
DetailStar::DetailStar() :
	BaseStar()
{
	name = NULL;
}

DetailStar::DetailStar(char *n, int t, int c, int s) :
	BaseStar(t, c, s)
{
	if((n != NULL) && (n[0] != 0)) {
        name = new char[strlen(n) + 1];
        strcpy(name, n);
	} else
        name = NULL;
}

DetailStar::DetailStar(char *n, char *p) :
	BaseStar(p)
{
	if((n != NULL) && (n[0] != 0)) {
        name = new char[strlen(n) + 1];
        strcpy(name, n);
	} else
        name = NULL;
}

DetailStar::~DetailStar()
{
    if(name != NULL)
	    delete name;
}

int
DetailStar::GetIndex(void)
{
int ret;

	ret = (GetStarType() * 2) - 1;
	if(GetStarClass() > 2) {
		ret++;
		if(GetStarClass() > 7)
			ret++;
	}

	return(ret);
}

int
DetailStar::GetIndex2(void)
{
int ret;

	if(GetStarType() == 0)
		return(0);
	ret = (GetStarType() * 2) - 1;
	if(GetStarClass() > 4) {
		ret++;
	}

	return(ret);
}

char *
DetailStar::GetName(char *buff)
{
    buff[0] = 0;
    if(name != NULL)
        sprintf(buff, name);
    return(buff);
}

void
DetailStar::SetName(char *buff)
{
    if(name != NULL) {
	    delete name;
		name = NULL;
	}
	if((buff != NULL) && (buff[0] != 0)) {
		name = new char[strlen(buff) + 1];
		strcpy(name, buff);
	}
}

// --------------------------------------------------------------------------
int
DetailStar::GetFirstOrbit(void)
{
int class_ndx;

	class_ndx = GetIndex();
    return(StarOrbits[size][class_ndx].first);
}

int
DetailStar::GetHabZone(void)
{
int class_ndx;

	class_ndx = GetIndex();
    return(StarOrbits[size][class_ndx].habital);
}

HAB_ZONE
DetailStar::CheckHabit(double orbnum)
{
int orb,class_ndx;

	class_ndx = GetIndex();
    orb = (int) (orbnum + 0.5);
	if(orb > (StarOrbits[size][class_ndx].habital + 1))
	    return(HAB_OUTER_2);
	else if(orb > StarOrbits[size][class_ndx].habital)
	    return(HAB_OUTER);
	else if(orb == StarOrbits[size][class_ndx].habital)
	    return(HAB_HABIT);
	else if(orb < StarOrbits[size][class_ndx].first)
	    return(HAB_IN_STAR);
	else if(orb < StarOrbits[size][class_ndx].habital)
	    return(HAB_INNER);
	return(HAB_UNKNOWN);
}

double
DetailStar::GetMag(void)
{
int class_ndx;
double val,mult;

	class_ndx = GetIndex();
    val = StarMag[size][(cls * 2) + 1] - StarMag[size][cls * 2];
	switch(cls) {
	  case 0:
	  case 5:
		mult = 0.0;
		break;
	  case 1:
	  case 6:
		mult = 0.2;
		break;
	  case 2:
	  case 7:
		mult = 0.2;
		break;
	  case 3:
	  case 8:
		mult = 0.2;
		break;
	  case 4:
	  case 9:
		mult = 0.2;
		break;
	}

	
    return(StarMag[size][class_ndx]);
}

double
DetailStar::GetLumin(void)
{
    return(Interpolate(StarLumin[size][GetIndex2()],
					   StarLumin[size][GetIndex2() + 1]));
}

double
DetailStar::GetTemp(void)
{
    return(Interpolate(StarTemp[size][GetIndex2()],
					   StarTemp[size][GetIndex2() + 1]));
}

double
DetailStar::GetRad(void)
{
    return(Interpolate(StarRad[size][GetIndex2()],
					   StarRad[size][GetIndex2() + 1]));
}

double
DetailStar::GetMass(void)
{
    return(Interpolate(StarMass[size][GetIndex2()],
					   StarMass[size][GetIndex2() + 1]));
}

double
DetailStar::Interpolate(double v1, double v2)
{
double mult=0.0;

    // trap the 'specialest' cases
    if((cls == 0) || (cls == 5))
		return(v1);
	if((0 == type) && (cls < 5))
		return(v1);
	if((type == 6) && (cls == 9))
	    return(v2);

    if((type > 5) && (cls > 5)) {
		switch(cls) {
			case 1:
			case 6:
			  mult = 0.25;
			  break;
			case 2:
			case 7:
			  mult = 0.5;
			  break;
			case 3:
			case 8:
			  mult = 0.75;
			  break;
		}
	} else {
		switch(cls) {
			case 1:
			case 6:
			  mult = 0.2;
			  break;
			case 2:
			case 7:
			  mult = 0.4;
			  break;
			case 3:
			case 8:
			  mult = 0.6;
			  break;
			case 4:
			case 9:
			  mult = 0.8;
			  break;
		}
	}
		
	return(v1 + (mult * (v2 - v1)));
}

// --------------------------------------------------------------------------
char *
DetailStar::GetSizeName(void)
{
  return(StarNames[size]);
}

char *
DetailStar::GetClassDesc(char *buff)
{
	sprintf(buff, "%c%d ", types[type], cls);
	GetColor(buff);
	return(buff);
}

char *
DetailStar::GetSizeDesc(char *buff)
{
  sprintf(buff, "%s %s", sizes[size], StarNames[size]);
  return(buff);
}

// --------------------------------------------------------------------------
double 
DetailStar::GetInnerLimit(void)
{
double val1,val2;

	val1 = 0.2 * GetMass();
	val2 = 0.0088 * sqrt(GetLumin());

	if(val2 > val1)
		return(val2);
	return(val1);
}

double 
DetailStar::GetInnerLifeZone(void)
{
	return(0.95 * sqrt(GetLumin()));
}

double 
DetailStar::GetOuterLifeZone(void)
{
	return(1.3 * sqrt(GetLumin()));
}

double 
DetailStar::GetSnowLine(void)
{
	return(5.0 * sqrt(GetLumin()));
}

double 
DetailStar::GetOuterLimit(void)
{
	return(40.0 * GetMass());
}

