/*
 * File:      color.cpp
 * Purpose:   misc color
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: color.cpp,v $ $Revision: 1.8 $ $Author: man $ $Date: 2001/12/14 22:32:15 $" */

#include "color.h"

// =================================================================
ColorTable::ColorTable() :
	LookupTable()
{
}

ColorTable::~ColorTable() 
{
	Clear();
}

void 
ColorTable::Clear(void)
{
ColorTableEntry *cte;
ListNode *n;

	n = First();
	while(n != NULL) {
		cte = (ColorTableEntry *)n->Data();
		delete cte;
		DeleteNode(n);
		n = First();
	}	
}

ColorTableEntry *
ColorTable::Find(int ndx)
{
ColorTableEntry *cte;
ListNode *n;

	n = First();
	while(n != NULL) {
		cte = (ColorTableEntry *)n->Data();
		if(cte->GetIndex() == ndx)
			return(cte);
		n = n->Next();
	}
	
	return(NULL);
}

int 
ColorTable::GetIndex(short c)
{
ColorTableEntry *cte;
ListNode *n;

	n = First();
	while(n != NULL) {
		cte = (ColorTableEntry *)n->Data();
		if(cte->GetColor() == c)
			return(cte->GetIndex());
		n = n->Next();
	}
	
	return(-1);
}

int 
ColorTable::AddColor(short c, char *d)
{
ColorTableEntry *cte;
ListNode *n;
int ndx=0;

	n = First();
	while(n != NULL) {
		cte = (ColorTableEntry *)n->Data();
		if(ndx <= cte->GetIndex())
			ndx = cte->GetIndex() + 1;
		n = n->Next();
	}

	cte = new ColorTableEntry(ndx, c, d);
	Append(cte);
	return(1);
}

short 
ColorTable::GetColor(int n)
{
ColorTableEntry *cte;

	if((cte = Find(n)) != NULL) {
		return(cte->GetColor());
	}
	return(0);		// black?
}

char *
ColorTable::GetDesc(int n)
{
ColorTableEntry *cte;

	if((cte = Find(n)) == NULL)
		return(NULL);
	else
		return(cte->GetDesc());	
}

void 
ColorTable::Load(char *buff, bool local)
{
#if 0
GenericParse gp;		// create it each time.....
ColorTableEntry *ct;
char *buffs[3];

//fprintf(stderr, "From:<%s>\n", buff);
	gp.Parse(buff, buffs, 3);
	// create a new element
	ct = new ColorTableEntry(buffs[1], buffs[2], local);
//fprintf(stderr, "Adding Code:<%s><%s>\n", buffs[1], buffs[2]);
	// 'local' entries should be loaded after global.
	//  by putting them in front (Insert()), they will be looked up first
	Insert(ct);
#endif
}

#ifdef DEBUG_COLOR_LIST
void 
ColorTable::Dump(FILE *fp)
{
ColorTableEntry *cte;
ListNode *ln;

	ln = First();
	while(ln != NULL) {
		cte = (ColorTableEntry *)ln->Data();
		cte->Dump(fp);
		ln = ln->Next();
	}
}
#endif

// ---------------------------------------------------------------------
ColorTableEntry::ColorTableEntry() :
	LookupEntry(FALSE)
{
	ndx = -1;
	color_ndx = -1;
	desc = NULL;
}

ColorTableEntry::~ColorTableEntry()
{
	Clear();
}

ColorTableEntry::ColorTableEntry(int n, short c, char *d) :
	LookupEntry(FALSE)
{
	color_ndx = -1;
	ndx = n;
	desc = NULL;
	SetValues(c, d);
}

void 
ColorTableEntry::Clear(void)
{
	ndx = -1;
	color_ndx = -1;
	if(desc != NULL) {
		delete desc;
		desc = NULL;
	}
}

void 
ColorTableEntry::SetValues(short c, char *d)
{
	color_ndx = c;
	if(desc != NULL) {
		delete desc;
		desc = NULL;
	}
	desc = new char[strlen(d) + 1];
	strcpy(desc, d);
}

// XXX
char *
ColorTableEntry::GetFormated(char *buff)
{
	sprintf(buff, "%s", desc);
	return(NULL);
}

char *
ColorTableEntry::GetSaveFormated(char *buff)
{
	sprintf(buff, "%s", desc);
	return(buff);
}

#ifdef DEBUG_COLOR_LIST
void 
ColorTableEntry::Dump(FILE *fp)
{
	fprintf(fp, "%s: %d %d\n", desc, ndx, color_ndx);
}
#endif

