
/*
 * File:      codetbl.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: codetbl.cpp,v $ $Revision: 1.14 $ $Author: man $ $Date: 2002/04/03 16:42:19 $" */

#include "codetbl.h"

#define READ_BUFFER	256

// =================================================================
ParseClass::ParseClass() :
	LinkedList()
{
}

ParseClass::~ParseClass()
{
}

void
ParseClass::Init(char *f)
{
char buffer[READ_BUFFER];
FILE *fp;

//fprintf(stderr, "========================================\n");
//fprintf(stderr, "<%s>\n", f);
	if((fp = fopen(f, "r")) != NULL) {
		while(fgets(buffer, READ_BUFFER, fp) != NULL) {
			if('#' == buffer[0])
				continue;
			if(buffer[strlen(buffer) - 1] == '\n')
				buffer[strlen(buffer) - 1] = 0;
			if(strlen(buffer) == 0)
				continue;

//fprintf(stderr, "<%s>\n", buffer);
			Load(buffer, FALSE);
		}
	}
}

// =================================================================
LookupTable::LookupTable() :
	ParseClass()
{
	hokey_counter = -1;
}

LookupTable::~LookupTable()
{
}

char *
LookupTable::GetFormated(char *buff)
{
ListNode *n;
LookupEntry *lt;

	if(hokey_counter < 0) {
		n = First();
		hokey_counter = 1;
	} else {
		n = Nth(hokey_counter);
		hokey_counter++;
	}

	if(n != NULL) {
		lt = (LookupEntry *) n->Data();
		lt->GetFormated(buff);
	} else
		hokey_counter = -1;

	return(buff);
}

// -----------------------------------------------------------------
LookupEntry::LookupEntry(bool l) :
	ListData()
{
	local = l;
}

LookupEntry::~LookupEntry()
{
}

// =================================================================
SimpleCodeTable::SimpleCodeTable() :
	LookupTable()
{
}

SimpleCodeTable::~SimpleCodeTable() 
{
	Clear();
}

char *
SimpleCodeTable::GetDesc(char *key)
{
CodeTableEntry *ct;
ListNode *n;

	n = First();
	while(n != NULL) {
		ct = (CodeTableEntry *)n->Data();
		if(strcmp(ct->GetCode(), key) == 0)
			return(ct->GetDesc());
		n = n->Next();
	}

	// fell through
	return(NULL);
}

void
SimpleCodeTable::Clear(bool local_only)
{
CodeTableEntry *cte;
ListNode *n;

	n = First();
	while(n != NULL) {
		cte = (CodeTableEntry *)n->Data();
//fprintf(stderr, "n:0x%x cte:0x%x\n", n, cte);
		if(local_only) {
			ListNode *next_n;

			next_n = Next();
			if(cte->IsLocal()) {
				delete cte;
				DeleteNode(n);
			} 
			n = next_n;
		} else {
			delete cte;
			DeleteNode(n);
			n = First();
		}
	}
}

unsigned long
SimpleCodeTable::GetFlag(char *c)
{
unsigned long ret=1l;
CodeTableEntry *cte;
ListNode *n;

	n = First();
	while(n != NULL) {
		cte = (CodeTableEntry *)n->Data();
		if(strcasecmp(c, cte->GetCode()) == 0) {
			return(ret);
		}
		ret *= 2;
		n = Next();
	}

	return(0l);
}

// =================================================================
CodeTable::CodeTable(char *file) :
	SimpleCodeTable()
{
	Init(file);
}

CodeTable::~CodeTable() 
{
	Clear();
}

void 
CodeTable::Load(char *buff, bool local)
{
GenericParse gp;		// create it each time.....
CodeTableEntry *ct;
char *buffs[3];

//fprintf(stderr, "From:<%s>\n", buff);
	gp.Parse(buff, buffs, 3);
	// create a new element
	ct = new CodeTableEntry(buffs[0], buffs[1], local);
//fprintf(stderr, "Adding Code:<%s><%s>\n", buffs[1], buffs[2]);
	// 'local' entries should be loaded after global.
	//  by putting them in front (Insert()), they will be looked up first
	Insert(ct);
}

// -----------------------------------------------------------------
CodeTableEntry::CodeTableEntry(bool l) :
	LookupEntry(l)
{
	code = NULL;
	desc = NULL;
}

CodeTableEntry::~CodeTableEntry()
{
	Clear();
}

CodeTableEntry::CodeTableEntry(char *c, char *d, bool l) :
	LookupEntry(l)
{
	code = desc = NULL;
	SetValues(c, d);
}

char *
CodeTableEntry::GetFormated(char *buff)
{
	sprintf(buff, "%s %s", code, desc);
	return(buff);
}

void 
CodeTableEntry::NewEntry(char *c, char *d)
{
	Clear();
	SetValues(c, d);
}

void 
CodeTableEntry::Clear(void)
{
	if(code != NULL) {
		delete[] code;
		code = NULL;
	}
	if(desc != NULL) {
		delete[] desc;
		desc = NULL;
	}
}

void 
CodeTableEntry::SetValues(char *c, char *d)
{
	Clear();
	if((c != NULL) && (c[0] != 0)) {
		code = new char[strlen(c) + 1];
		strcpy(code, c);
	} else {
		code = new char[2];
		strcpy(code, " ");
	}
	if((d != NULL) && (d[0] != 0)) {
		desc = new char[strlen(d) + 1];
		strcpy(desc, d);
	} else {
		desc = new char[2];
		strcpy(desc, " ");
	}
}

char *
CodeTableEntry::GetSaveFormated(char *buff)
{
	sprintf(buff, "%s:%s", code, desc);
	return(buff);
}

// =================================================================
TradeTable::TradeTable(char *f) :
	SimpleCodeTable()
{
	Init(f);
}

TradeTable::~TradeTable()
{
TradeTableEntry *gc;
ListNode *n;

	n = First();
	while(n != NULL) {
		gc = (TradeTableEntry *)n->Data();
		delete(gc);
		DeleteNode(n);
		n = First();
	}
}

void
TradeTable::Load(char *buffer, bool local)
{
TradeTableEntry *gc;

	gc = new TradeTableEntry(buffer, local);
	Append(gc);
}

unsigned long
TradeTable::CheckTrade(char *u)
{
unsigned long ret=0l;
TradeTableEntry *gc;
ListNode *n;

	n = First();
	while(n != NULL) {
		gc = (TradeTableEntry *)n->Data();
		if(gc->Check(u)) {
			ret |= GetFlag(gc->GetCode());
		}
		n = Next();
	}

	return(ret);
}

// -----------------------------------------------------------------------
TradeTableEntry::TradeTableEntry(char *str, bool l) :
	CodeTableEntry(l)
{
GenericParse gp;
char *ptrs[15],c;
int i;

	gp.Parse(str, ptrs, 15);
	SetValues(ptrs[0], ptrs[1]);
	for(i = 0;i < 6;i++) {
		c = ptrs[(i*2)+2][0];
		if((c >= '0') && (c <= '9')) mins[i] = c - '0';
		else if((c >= 'A') && (c <= 'Z')) mins[i] = c - 'A' + 10;
		else mins[i] = -1;
		c = ptrs[(i*2)+3][0];
		if((c >= '0') && (c <= '9')) maxs[i] = c - '0';
		else if((c >= 'A') && (c <= 'Z')) maxs[i] = c - 'A' + 10;
		else maxs[i] = -1;
	}

	special = (TRADE_GEN_CODE) (ptrs[14][0] - '0');
	if(special < 1)
		special = TGC_NONE;
}

TradeTableEntry::~TradeTableEntry()
{
}

TradeTableEntry::TradeTableEntry(char *c, char *d, int *n, int *x, 
				TRADE_GEN_CODE s, bool l) :
	CodeTableEntry(c, d, l)
{
int i;

	for(i = 0;i < 6;i++) {
		mins[i] = n[i];
		maxs[i] = x[i];
	}
	special = s;
}

bool
TradeTableEntry::Check(char *u)
{
bool ret=FALSE;
int i,val;

	for(i = 0;i < 6;i++) {
		val = u[i+2];
		if(val < 'A') val -= '0';
		else val -= ('A' + 10);
		if((1 == i) && (special > TGC_NONE)) {
			if(TGC_IN == special) {
				if(((val >= 2) && (val <= 4)) || (7 == val) || (9 == val)) {
					ret = TRUE;
				}
			} else if(TGC_RI == special) {
				if((6 == val) || (8 == val)) {
					ret = TRUE;
				}
			}
		} else {
			if((mins[i] > -1) && (maxs[i] > -1)) {
				if((val >= mins[i]) && (val <= maxs[i])) {
					ret = TRUE;
				} else {
					ret = FALSE;
				}
			}
		}
	}

	return(ret);
}

char *
TradeTableEntry::GetSaveFormated(char *buff)
{
char lbuff[24],val1,val2;
int i;

	sprintf(buff, "%s:%s", code, desc);
	for(i = 0;i < 6;i++) {
		if(mins[i] > 9)
			val1 = mins[i] - 10 + 'A';
		else
			val1 = mins[i] + '0';
		if(maxs[i] > 9)
			val2 = maxs[i] - 10 + 'A';
		else
			val2 = maxs[i] + '0';
		sprintf(lbuff, ":%c:%c", val1, val2);
		strcat(buff, lbuff);
	}
	sprintf(lbuff, ":%c", (int)(special + '0'));
	strcat(buff, lbuff);
	return(buff);
}

void 
TradeTableEntry::NewEntry(char *c, char *d, int *n, int *x, TRADE_GEN_CODE s)
{
int i;

	SetValues(c, d);
	for(i = 0;i < 6;i++) {
		mins[i] = n[i];
		maxs[i] = x[i];
	}
	special = s;
}

// =================================================================
BaseTable::BaseTable(char *file) :
	SimpleCodeTable()
{
	Init(file);
}

BaseTable::~BaseTable() 
{
BaseTableEntry *bte;
ListNode *n;

	n = First();
	while(n != NULL) {
		bte = (BaseTableEntry *)n->Data();
		delete bte;
		DeleteNode(n);
		n = First();
	}	
}

void 
BaseTable::Load(char *buff, bool local)
{
GenericParse gp;
BaseTableEntry *bt;
char *buffs[5];

	gp.Parse(buff, buffs, 5);

	// create a new element
	bt = new BaseTableEntry(buffs[0], buffs[1], buffs[2], buffs[3], local);
//fprintf(stderr, "Adding Base:<%s><%s><%s><%s>\n", 
//	buffs[1], buffs[2], buffs[3], buffs[4]);
	// 'local' entries should be loaded after global.
	//  by putting them in front (Insert()), they will be looked up first
	Insert(bt);
}

int
BaseTable::GetBMIndex(char *key, int ndx)
{
BaseTableEntry *bt;
ListNode *n;

	n = First();
	while(n != NULL) {
		bt = (BaseTableEntry *)n->Data();
		if(strcmp(bt->GetCode(), key) == 0)
			return(bt->GetIndex(ndx));
		n = n->Next();
	}
	// fell through
	return(-1);
}

#ifdef DEBUG_BASE_LIST
void
BaseTable::DumpBT(FILE *fp)
{
int i=0;
BaseTableEntry *bt;
ListNode *n;

	n = First();
	while(n != NULL) {
		bt = (BaseTableEntry *)n->Data();
		fprintf(fp, "==========< %d >==============\n", i);
		bt->DumpBTE(fp);
		n = n->Next();
		i++;
	}
}
#endif

// -----------------------------------------------------------------
BaseTableEntry::BaseTableEntry(bool l) :
	CodeTableEntry(l)
{
	index[0] = index[1] = -1;
	name[0] = name[1] = NULL;
}

BaseTableEntry::BaseTableEntry(char *c, char *d, char *bm1, char *bm2, bool l) :
	CodeTableEntry(c, d, l)
{
	index[0] = index[1] = -1;
	name[0] = name[1] = NULL;
	SetValues(c, d, bm1, bm2);
}

BaseTableEntry::~BaseTableEntry()
{
	Clear();
}

void 
BaseTableEntry::NewEntry(char *c, char *d, char *bm1, char *bm2)
{
	SetValues(c, d, bm1, bm2);	
}

void 
BaseTableEntry::Clear(void)
{
int i;

	CodeTableEntry::Clear();
	for(i = 0;i < 2;i++) {
		if(name[i] != NULL) {
			delete name[i];
			name[i] = NULL;
		}
	}
	index[0] = index[1] = -1;
}

void 
BaseTableEntry::SetValues(char *c, char *d, char *bm1, char *bm2)
{
	Clear();
	CodeTableEntry::SetValues(c, d);
	if((bm1 != NULL) && (bm1[0] != 0)) {
		name[0] = new char[strlen(bm1) + 1];
		strcpy(name[0], bm1);
	}
	if((bm2 != NULL) && (bm2[0] != 0)) {
		name[1] = new char[strlen(bm2) + 1];
		strcpy(name[1], bm2);
	}
}

char *
BaseTableEntry::GetName(int ndx)
{
int n;

	n = VerifyIndex(ndx);
	return(name[ndx]);
}

int
BaseTableEntry::GetIndex(int ndx)
{
int n;

	n = VerifyIndex(ndx);
	return(index[ndx]);
}

void
BaseTableEntry::SetIndex(int ndx, int i)
{
int n;

	n = VerifyIndex(ndx);
	index[ndx] = i;
}

int 
BaseTableEntry::VerifyIndex(int n)
{
	if(0 == n)
		return(0);
	return(1);
}

char *
BaseTableEntry::GetSaveFormated(char *buff)
{
	sprintf(buff, "%s:%s", code, desc);
	strcat(buff, ":");
	if(name[0] != NULL)
		strcat(buff, name[0]);
	strcat(buff, ":");
	if(name[1] != NULL)
		strcat(buff, name[1]);
	return(buff);
}

#ifdef DEBUG_BASE_LIST
void
BaseTableEntry::DumpBTE(FILE *fp)
{
	fprintf(fp, "<%s> <%s> %d\n", code, desc, IsLocal());
	if(name[0] != NULL)
		fprintf(fp, "1: <%s> %d\n", name[0], index[0]);
	if(name[1] != NULL)
		fprintf(fp, "2: <%s> %d\n", name[1], index[1]);
}
#endif

