/*
 * File:      clr_dlg.cpp
 * Purpose:   color dialogs
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: clr_dlg.cpp,v $ $Revision: 1.7 $ $Author: man $ $Date: 2003/11/07 03:44:51 $" */

#include <wx/defs.h>
#include "clr_dlg.h"
#include "t_res.h"


#define WIDGET_SIZE			15
#define WIDGET_OFFSET		1
#define WIDGET_DELTA		3
#define WIDGET_SPACING		(WIDGET_OFFSET + WIDGET_DELTA)

#define TOTAL_WIDGET_SIZE	(WIDGET_SIZE + (2 * WIDGET_SPACING))

#define BASE_BITMAP_ID		600

// ==================================================================
BaseColorDialog::BaseColorDialog(wxWindow *p, char *title) :
	StdDialog(p, title)
{
}

BaseColorDialog::~BaseColorDialog()
{
}

// ==================================================================
BEGIN_EVENT_TABLE(SelectColorDialog, wxDialog)
//	EVT_LEFT_DOWN(SelectColorDialog::OnMouseEvent)
	EVT_BUTTON(BASE_BITMAP_ID + 0, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 1, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 2, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 3, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 4, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 5, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 6, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 7, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 8, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 9, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 10, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 11, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 12, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 13, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 14, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 15, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 16, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 17, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 18, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 19, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 20, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 21, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 22, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 23, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 24, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 25, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 26, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 27, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 28, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 29, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 30, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 31, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 32, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 33, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 34, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 35, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 36, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 37, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 38, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 39, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 40, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 41, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 42, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 43, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 44, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 45, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 46, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 47, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 48, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 49, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 50, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 51, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 52, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 53, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 54, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 55, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 56, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 57, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 58, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 59, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 60, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 61, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 62, SelectColorDialog::OnButton)
	EVT_BUTTON(BASE_BITMAP_ID + 63, SelectColorDialog::OnButton)
END_EVENT_TABLE()

// ------------------------------------------------------------------
SelectColorDialog::SelectColorDialog(wxWindow *parent, ColorArray *c) :
	BaseColorDialog(parent, "Select A Color")
{
bool state;
int i;
wxBitmap *bitmap;
wxMemoryDC m_dc;
wxBrush *b;
wxPen *p;
wxColour *color;
wxBoxSizer *main_sizer;
wxFlexGridSizer *color_sizer;

	color_array = c;
	for(i = 0;i < TOTAL_COLORS;i++) {
		bitmap = new wxBitmap(TOTAL_WIDGET_SIZE, TOTAL_WIDGET_SIZE);
		m_dc.SelectObject(*bitmap);

		// kinda' clunky way to do this...
		m_dc.SetBrush(*wxLIGHT_GREY_BRUSH);
		m_dc.SetPen(*wxLIGHT_GREY_PEN);
		m_dc.DrawRectangle(0, 0, TOTAL_WIDGET_SIZE, TOTAL_WIDGET_SIZE);

		if(i < c->GetMaxColors()) {
			color = c->GetColor(i);
			state = TRUE;
		} else {
			color = c->GetColor(BLACK_COLOR_INDEX);
			state = FALSE;
		}
		b = new wxBrush(*color, wxSOLID);
		m_dc.SetBrush(*b);
		p = new wxPen(*color, 1, wxSOLID);
		m_dc.SetPen(*p);
		m_dc.DrawRectangle(WIDGET_SPACING, WIDGET_SPACING, 
						WIDGET_SIZE, WIDGET_SIZE);
		colors[i] = new wxBitmapButton(this, BASE_BITMAP_ID + i, *bitmap,
				wxPoint(-1, -1),
				wxSize(TOTAL_WIDGET_SIZE, TOTAL_WIDGET_SIZE),
				wxBU_EXACTFIT);
		colors[i]->Enable(state);
		delete bitmap;
	}

	main_sizer = new wxBoxSizer(wxVERTICAL);
	color_sizer = new wxFlexGridSizer(8, 8, 0, 0);

	for(i = 0;i < TOTAL_COLORS;i++)
		color_sizer->Add(colors[i], 0, 0, 0);
	main_sizer->Add(color_sizer, 0, wxALL, 2);
	DoLayout(wxALL, DLG_OFFSET, main_sizer);

	selection = 0;
}

SelectColorDialog::~SelectColorDialog()
{
}

// ------------------------------------------------------------------
bool
SelectColorDialog::SelectColor(int *ndx)
{
	selection = *ndx;
	DoSelection(selection, TRUE);

	if(ShowModal() == wxID_CANCEL)
		return(FALSE);

	*ndx = selection;
	return(TRUE);
}

void
SelectColorDialog::OnButton(wxCommandEvent &event)
{
	DoSelection(selection, FALSE);
	selection = event.GetId() - BASE_BITMAP_ID;
	DoSelection(selection, TRUE);
}

void
SelectColorDialog::DoSelection(int ndx, bool draw)
{
wxBitmap *bitmap;
wxMemoryDC m_dc;
wxBrush *b;
wxPen *p;
wxColour *color;

//fprintf(stderr, "--->%d: %d\n", ndx, draw);
	if(ndx >= color_array->GetMaxColors())
		return;

	bitmap = new wxBitmap(TOTAL_WIDGET_SIZE, TOTAL_WIDGET_SIZE);
	m_dc.SelectObject(*bitmap);

	m_dc.SetBrush(*wxLIGHT_GREY_BRUSH);
	m_dc.SetPen(*wxLIGHT_GREY_PEN);
	m_dc.DrawRectangle(0, 0, TOTAL_WIDGET_SIZE, TOTAL_WIDGET_SIZE);

	color = color_array->GetColor(ndx);

	b = new wxBrush(*color, wxSOLID);
	m_dc.SetBrush(*b);
	p = new wxPen(*color, 1, wxSOLID);
	m_dc.SetPen(*p);
	m_dc.DrawRectangle(WIDGET_SPACING, WIDGET_SPACING, 
					WIDGET_SIZE, WIDGET_SIZE);

	if(draw) {
		m_dc.SetBrush(*wxTRANSPARENT_BRUSH);
		m_dc.SetPen(*wxBLACK_PEN);
		m_dc.DrawRectangle(0, 0, TOTAL_WIDGET_SIZE, TOTAL_WIDGET_SIZE);
	}

	colors[ndx]->SetBitmapLabel(*bitmap);
	colors[ndx]->SetBitmapFocus(*bitmap);
	colors[ndx]->SetBitmapSelected(*bitmap);

	delete bitmap;
}

// ==================================================================
ColorArray::ColorArray(wxConfig *config)
{
int i;
unsigned char col_tab[BASE_COLORS][3] = {
		{   0,   0,   0 },
		{   0,   0, 255 },
		{   0, 255,   0 },
		{   0, 255, 255 },
		{ 255,   0,   0 },
		{ 255,   0, 255 },
		{ 255, 255,   0 },
		{ 255, 255, 255 } };
static char *n[BASE_COLORS] = {
		"Black",
		"Blue",
		"Green",
		"Cyan",
		"Red",
		"Purple",
		"Yellow",
		"White" };


	for(i = 0;i < BASE_COLORS;i++) {
		colors[i] = new wxColour(col_tab[i][0], col_tab[i][1], col_tab[i][2]);
		names[i] = new char[strlen(n[i]) + 1];
		strcpy(names[i], n[i]);
	}

	for(i = BASE_COLORS;i < TOTAL_COLORS;i++) {
		colors[i] = NULL;
		names[i] = NULL;
	}

	max_colors = BASE_COLORS;
	LoadColors(config);
}

ColorArray::~ColorArray()
{
int i;

	for(i = 0;i < TOTAL_COLORS;i++) {
		if(colors[i] != NULL)
			delete colors[i];
		if(names[i] != NULL)
			delete names[i];
	}
}

wxColour *
ColorArray::GetColor(int ndx)
{
	if((ndx < 0) || (ndx > max_colors))
		return(colors[BLACK_COLOR_INDEX]);
	return(colors[ndx]);
}

char *
ColorArray::GetName(int ndx)
{
	if((ndx < 0) || (ndx > max_colors))
		return(NULL);
	return(names[ndx]);
}

bool
ColorArray::AddColor(unsigned char r, unsigned char g, unsigned char b, char *n)
{
bool stat=FALSE;
int i;

	for(i = BASE_COLORS;i < TOTAL_COLORS;i++) {
		if(NULL == names[i]) {
			colors[i] = new wxColour(r, g, b);
			names[i] = new char[strlen(n) + 1];
			strcpy(names[i], n);
			if(i >= max_colors)
				max_colors++;
			stat = TRUE;
			break;
		}
	}

	return(stat);
}

bool 
ColorArray::WriteColors(wxConfig *config)
{
int i,j;
char buff[MAX_FILE_LENGTH],str[MAX_FILE_LENGTH];

	j = 0;
	for(i = BASE_COLORS;i < max_colors;i++) {
		sprintf(str, "/%s/%s%d", SECTION_COLOR, ENTRY_CUSTOM_COLOR, j+1);
		sprintf(buff, "%d:%d:%d", colors[i]->Red(), colors[i]->Green(),
			colors[i]->Blue());
		config->Write((const wxString) str, (const wxString) buff);
//fprintf(stderr, "%s: %s", str, buff);
		sprintf(str, "/%s/%s%d", SECTION_COLOR, ENTRY_BITMAP_NAME, j + 1);
		config->Write((const wxString)str, (const wxString)names[i]);
//fprintf(stderr, "(%s: %s)\n", str, names[i]);
		j++;
	}

	config->Flush();
	return(TRUE);
}

bool 
ColorArray::LoadColors(wxConfig *config)
{
unsigned char r_val,g_val,b_val;
char *buffs[3],buff[MAX_FILE_LENGTH],str[MAX_FILE_LENGTH];
int i,j;
GenericParse gp;
wxString ptr;

	Clear();
	j = 0;
	for(i = BASE_COLORS;i < CUSTOM_COLORS;i++) {
		ptr = "";
		sprintf(str, "/%s/%s%d", SECTION_COLOR, ENTRY_CUSTOM_COLOR, j+1);
		if(!config->Read((const wxString) str, &ptr))
			break;
		sprintf(buff, "%s", ptr.GetData());
		gp.Parse(buff, buffs, 3);
//fprintf(stderr, "%d: %s", i, ptr.GetData());
		r_val = atoi(buffs[0]);
		g_val = atoi(buffs[1]);
		b_val = atoi(buffs[2]);
//fprintf(stderr, " --> %d %d %d\n", r_val, g_val, b_val);
		colors[i] = new wxColour(r_val, g_val, b_val);
		max_colors++;
		ptr = "";
		sprintf(str, "/%s/%s%d", SECTION_COLOR, ENTRY_BITMAP_NAME, j + 1);
		if(!config->Read((const wxString) str, &ptr)) {
			names[i] = new char[12];
			sprintf(names[i], "Custom %d", j + 1);
		} else {
			names[i] = new char[strlen(ptr.GetData()) + 1];
			strcpy(names[i], ptr.GetData());
		}
//fprintf(stderr, "%d: %s\n", j + 1, names[i]);
		j++;
	}

	return(TRUE);
}

void
ColorArray::Clear(void)
{
int i;

	for(i = BASE_COLORS;i < CUSTOM_COLORS;i++) {
		if(colors[i] != NULL)
			delete colors[i];
		colors[i] = NULL;
	}
}

bool
ColorArray::DeleteColor(int ndx)
{
	if((ndx < BASE_COLORS) || (ndx > max_colors))
		return(FALSE);
	if(NULL == names[ndx])
		return(FALSE);

	delete names[ndx];
	names[ndx] = NULL;
	// doesn't wx keep track of these?
	delete colors[ndx];
	colors[ndx] = NULL;
	return(TRUE);
}

bool
ColorArray::EditColor(int ndx, unsigned char r, unsigned char g,
			unsigned char b, char *n)
{
	if((ndx < BASE_COLORS) || (ndx > max_colors))
		return(FALSE);
	if(NULL == names[ndx])
		return(FALSE);

	delete names[ndx];
	if(NULL == n)
		names[ndx] = NULL;
	else {
		names[ndx] = new char[strlen(n) + 1];
		strcpy(names[ndx], n);
	}
	colors[ndx] = new wxColour(r, g, b);
	return(TRUE);
}

