//
// File:		uwpgen.h
// Purpose:		global declarations for uwpgen
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: uwpgen.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/11/02 03:01:40 $"

#ifndef UWPGEN_H
#define UWPGEN_H

#include "uwp.h"
#include "tech_gen.h"
#include "t_dice.h"

#define UWP_BUFFER_SIZE			12

class UWPGen //: public uwp
{
public:
	UWPGen(TECH_GEN tg, int n=-1, int x=-1);
	~UWPGen();

	void GenUWP(char p, char *uwp);
	
	void GenSystem1(int orb, int zone, char *p_uwp, char *uwp, bool type_m_st);
	void GenSystem2(char p, char *b, char *uwp);	
	void GenSystem3(char *m_uwp, char *b, char *uwp, bool b_pres);

	char GenPop(int zone, char *uwp);

private:
	char GenPort(void);
	char GenGovt(char *u);
	char GenLaw(char *u);
	char GenerateTech(char *u, int ext_dm, bool mw);

	void ClearUWP(char *u);
	char SimpleConv(int v);
	char SizeConv(int v, bool for_sat=FALSE);

	Dice		dice;
	GenTech		*tech_gen;
};

#if 0
// handy enum
typedef enum {
	UWPI_PORT=0,
	UWPI_SIZE,
	UWPI_ATMOS,
	UWPI_HYDRO,
	UWPI_POP,
	UWPI_GOVT,
	UWPI_LAW,
	UWPI_TECH
} UWP_INDEX;
#endif

#endif

