/*
 * File:      universe.h
 * Purpose:   
 * Author:    Mark A. Nordstrand
 * Created:   
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

#ifndef UNIVERSE_H
#define UNIVERSE_H

#include "3d.h"
#include "hardtimes.h"

// ========================================================================
// base list element (common to 2D and 3D)
class BaseList : public ListData
{
public:
	BaseList(char *dir, char *fname, char *title);
	virtual ~BaseList();

	char *GetDirName(void) { return(dir_name); };
	char *GetFileName(void) { return(file_name); };
	char *GetDesc(void) { return(desc); };
private:
	char *dir_name;
	char *file_name;
	char *desc;
};

// ========================================================================
// forward reference
class SectorList;

// ========================================================================
// universe list
class UListData : public BaseList
{
public:
	UListData(char *dir, char *fname, char *title, bool d3=FALSE);
//	UListData(UListData *uld);
	~UListData();

	bool Get3D(void) { return(depth); };
	unsigned long GetFlags(void) { return(flags); };

	void SetFlags(unsigned long f) { flags = f; };

	SectorList *GetSectors(void) { return(sectors); };
	Sector3D *Get3DSector(void) { return(sector_3d); };
	bool LoadList(TCodes *codes, char *dir);
	bool ClearList(void);

	float GetScale(void) { return(scale); };
	int GetXRot(void) { return(x_rot); };
	int GetYRot(void) { return(y_rot); };
	int GetZRot(void) { return(z_rot); };

	void SetScale(float s) { scale = s; };
	void SetRot(int x, int y, int z) { x_rot=x;y_rot=y;z_rot=z; };

	BaseSector *GetSector(int x, int y);

private:
	// oh-oh should this just be a flag?
	bool depth;			// aka 3D

	// display flags
	unsigned long	flags;

	// we are either one of these
	SectorList		*sectors;
	Sector3D		*sector_3d;
	// for 3D
	int			x_rot;
	int			y_rot;
	int			z_rot;

	float		scale;
};

class UList : public LinkedList
{
public:
	UList(char *dir);
	~UList();

	UListData *Find(char *);

private:
};

// ========================================================================
// sector list aka the universe we're working on
//  (simple wrapper for sectors)
class SectorData : public BaseList
{
public:
	SectorData(TCodes *codes, char *dir, char *fname, char *title, 
			int x_, int y_, char c);
	~SectorData();

	int GetX(void) { return(x); };
	int GetY(void) { return(y); };
	char GetCode(void) { return(code); };
	BaseSector *GetSector(void) { return(sector); };

	HT_AREA GetArea(int x, int y) { return(ht->GetArea(x, y)); };
	HT_WAR GetWar(int x, int y) { return(ht->GetWar(x, y)); };

private:
	int			x;
	int			y;
	char		code;
	BaseSector	*sector;
	HardTimes	*ht;
};

class SectorList : public LinkedList
{
public:
	SectorList(TCodes *codes, char *dir, char *file_name);
	~SectorList();

	int GetMaxX(void) { return(max_x); };
	int GetMinX(void) { return(min_x); };
	int GetMaxY(void) { return(max_y); };
	int GetMinY(void) { return(min_y); };

private:
	int			max_x;
	int			max_y;
	int			min_x;
	int			min_y;

};

#endif

