// File:        tech_gen.h
// Purpose:     methods for generating technology
// Author:
// Created:
// Updated:
// Copyright:   LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
// 
// rcsid[] = "$RCSfile: tech_gen.h,v $ $Revision: 1.4 $ $Author: man $ $Date: 2002/06/05 04:51:07 $"

#ifndef TECH_GEN_H
#define TECH_GEN_H

#include "t_dice.h"

#ifndef FALSE
#define FALSE	0
#endif

typedef enum {
	TG_STANDARD=0,		// per rules....
	TG_MIN_MAX,			// as above w/ min/max
	TG_DM,				// as std, w/ a dm
	TG_NO_DM,			// ignore ext. dm (??)
	TG_FLAT_RANGE,		// flat roll (=> min/max)
	TG_RANGE,			// bell curve (=> min/max)
	TG_VALUE,			// single value
} TECH_GEN;

class GenTech
{
public:
	GenTech(TECH_GEN tg, int n=-1, int x=-1);
	~GenTech();

	char Generate(char *uwp, int dm, bool mw=FALSE);

private:
	TECH_GEN		method;
	int				min,max;		// other uses...
	Dice			*dice;
};

#endif

