//
// File:		t_menu.h
// Purpose:		keep track of user menus
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: t_menu.h,v $ $Revision: 1.4 $ $Author: man $ $Date: 2003/04/28 18:52:59 $"

#ifndef T_MENU_H
#define T_MENU_H

#include <wx/app.h>
#include <wx/menu.h>
#include "llist.h"
#include "mtu_file.h"



typedef enum {
	MT_INFO=0,
	MT_MENU,
	MT_TEXT,
	MT_GRAPHICS,
	MT_HTML,
	MT_PS,
	MT_EXE
} MENU_TYPE;

// ==========================================================================
class MenuItem : public ListData
{
public:
	MenuItem(char *a, int i, MENU_TYPE t);
	virtual ~MenuItem();

	int GetID(void) { return(id); };
	char *GetAction(void) { return(action); };
	MENU_TYPE GetType(void) {return(type); };

private:
	MENU_TYPE	type;
	char		*action;
	int			id;
};

// ==========================================================================
class Menu : public LinkedList
{
public:
	Menu(MTUFile *dirs, char *filename, int base_menu_id, int base_label_id);
	~Menu();

	wxMenu *GetMenu(void) { return(menu); };

	MenuItem *GetMenu(int id);

	bool HandleEvent(MTUFile *dirs, int id);

private:
	wxMenu *BuildMenu(MTUFile *dirs, char *filename);
	wxMenu 		*menu;
	// id's to use while building menus
	int			real_id;
	int			bogus_id;
};

#endif

