/*
 * File:		t_dlg.h
 * Purpose:		general/generic dialogs
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_dlg.h,v $ $Revision: 1.15 $ $Author: man $ $Date: 2003/05/05 03:30:41 $" */

#ifndef T_DLG_H
#define T_DLG_H

#ifdef __GNUG__
#pragma interface
#endif

#include "wx/wx.h"
#include "wx/dialog.h"
#include "wx/button.h"
#include "wx/bmpbuttn.h"
//#include "wx/layout.h"

#define DLG_OFFSET		5
#define COL_OFFSET		30
#define ROW_OFFSET		27

#define SML_BTN_SIZE	20

// ====================================================
// handy little function.....
void NotImplemented(char *title);

// =======================================================================
// a panel for ok & cancel buttons
class BasePanel : public wxPanel
{
public:
	BasePanel(wxWindow *p, bool horiz, bool use_apply, bool bm_only);
	~BasePanel() {};

	void OnCancel(wxCommandEvent &event);
	wxBoxSizer *GetSizer(void) { return(sizer); };

	wxSize GetBestSize(void) { return(ok_btn->GetBestSize()); };

private:
	wxBitmapButton 	*ok_btn;
	wxBitmapButton	*cancel_btn;
	wxBitmapButton	*apply_btn;
	wxBoxSizer		*sizer;
};

// =======================================================================
class ApplyDialog;
class StdDialog;
class CoreDialog : public wxDialog
{
friend class ApplyDialog;
friend class StdDialog;
public:
	CoreDialog(wxWindow *p, char *t, bool horiz, bool use_apply, bool bm_only);
	~CoreDialog() {};

	wxBoxSizer *GetSizer(void) { return(sizer); };
	wxSize GetBestSize() { return(panel->GetBestSize()); };

	void DoLayout(int flags, int offset, wxSizer *main_sizer, 
					wxSizer *panel_sizer=NULL);

private:
	void OnOk(wxCommandEvent &event);
	void OnCancel(wxCommandEvent &event);

	wxBoxSizer		*sizer;
	BasePanel		*panel;

	DECLARE_EVENT_TABLE()
};

// -----------------------------------------------------------------------
class ApplyDialog : public CoreDialog
{
public:
	ApplyDialog(wxWindow *p, char *t, bool horiz=TRUE, bool bm_only=FALSE) :
		CoreDialog(p, t, horiz, TRUE, bm_only) {};
	~ApplyDialog() {};

private:
};

// -----------------------------------------------------------------------
class StdDialog : public CoreDialog
{
public:
	StdDialog(wxWindow *p, char *t, bool horiz=TRUE, bool bm_only=FALSE) :
		CoreDialog(p, t, horiz, FALSE, bm_only) {};
	~StdDialog() {};

private:
};

// ====================================================
class GraphicDialog : public StdDialog
{
public:
	GraphicDialog(wxWindow *p);
	~GraphicDialog();

	bool GetGraphicInfo(int *t, bool *us,int *w, int *h, float *s, char **desc);

private:
	void OnUseScale(wxCommandEvent &event);
	void ReflectState(void);
	DECLARE_EVENT_TABLE()

	wxStaticText	*msg[3];
	wxRadioBox		*type;
	wxTextCtrl		*width;
	wxTextCtrl		*height;
	wxCheckBox		*use_scale;
	wxTextCtrl		*scale;
};


#endif

