//
// File:      systdisp.h
// Purpose:   Drawing system text
// Author:    Mark A. Nordstrand
// Created:   6/20/2000
// Updated:
// Copyright: LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: systdisp.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $"

#ifndef SYSTDISP_H
#define SYSTDISP_H

#include <stdio.h>
#include "t_frame.h"
#include "syst.h"

// ===========================================================================
// XXX these need to be common someplace (and consolidated)
typedef enum PRINT_SOURCE {
    PS_ALL=0,
	PS_CUR,
	PS_SUB,
	PS_IGN };

// ===========================================================================
// XXX should these be here?
#define LINE_STAR_RETURN       10
#define LINE_GG_RETURN         3
#define LINE_OTHER_RETURN      20

// ===========================================================================
class SystemDisplay : public DisplayMethod
{
public:
    SystemDisplay(wxDC *d, int x=0, int y=0, int len=-1) :
	  DisplayMethod(d,x,y) {};
    SystemDisplay(FILE *fpx, int len=-1) : DisplayMethod(fpx) {};
	SystemDisplay(wxTextCtrl *t, int len=-1) : DisplayMethod(t) {};
    ~SystemDisplay();

	
// also old (but, useful):
    int DrawDetail(System *, BaseOrbit *);

// new:
	int DrawLines(System *sys, char *msg1=NULL, char *msg2=NULL,
				  int start_count=0, int end_count=32000);
	int DrawDetails(System *sys, PRINT_SOURCE ps=PS_ALL, char *msg1=NULL, 
			char *msg2=NULL, int start_count=0, int end_count=32000);
//	int DrawLine(BaseOrbit *, STAR_INDEX st, short pl, short sat);

private:
    void DrawWorldText(bool line, char *msg1, char *msg2, int start_count,
        int end_count, int start_x, int start_y, int end_x, int end_y);

	int DrawSatLine(System *sys, STAR_INDEX st, int pl, int sat, int *count,
								 int start_count, int end_count);
	int DrawWorldLine(System *sys, STAR_INDEX st, int pl, int *count,
					  int start_count, int end_count);
	int DrawStarLine(System *sys, STAR_INDEX st, int *count,
					 int start_count, int end_count);
	int DrawLine(System *sys, STAR_INDEX st, int pl, int sat, int *count,
				 int start_count, int end_count);
	int DrawDetails(System *sys, BaseOrbit *bo, int *wcount, int *lcount,
					int start, int lines,
					PRINT_SOURCE ps);

};

#endif

