// File:        sg_cmd.h
// Purpose:     commands between sectgen and sysgen
// Author:
// Created:
// Updated:
// Copyright:   LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
// 
// rcsid[] = "$RCSfile: sg_cmd.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/06/05 04:51:07 $"


#ifndef GEN_CMD_H
#define GEN_CMD_H

#include "wx/socket.h"

// commands secgen --> sysgen
// primary commands
typedef enum {
	PCMD_SOCKET_ERROR=0x80,
	PCMD_ERROR,
	PCMD_QUIT,
	PCMD_STARS,
	PCMD_SYSTEM,
	PCMD_UWP
} PRIMARY_COMMANDS;

// secondary commands 
typedef enum {
	SCMD_NAME=0x90,
	SCMD_SECT_NAME,
	SCMD_SSECT_NAME,
	SCMD_LOC,
	SCMD_PORT,
	SCMD_OUT_FILE,
	SCMD_3D,
	SCMD_GO
} SYSTEM_GEN_COMMANDS;

// commands sysgen --> secgen
typedef enum {
	RCMD_SOCKET_ERROR=0xa0,
	RCMD_ERROR,
	RCMD_NAME,
	RCMD_UWP,
	RCMD_GG,
	RCMD_BELTS,
	RCMD_STAR,
	RCMD_DONE
} RESPONSE_COMMANDS;


// sysgen(server) <--> secgen(client) interface
// ===========================================================================
class GenServer
{
public:
	GenServer(wxWindow *p, int id, int cport);
	~GenServer();

	bool HandleServerEvent(wxWindow *p, int id, wxSocketEvent& event);
	PRIMARY_COMMANDS GetCommand(wxSocketEvent& event);
	SYSTEM_GEN_COMMANDS GetCommand(void);

//	void Quit(void);
	void SendName(char *n) { SendResp(RCMD_NAME, n); };
	void SendUWP(char *u) { SendResp(RCMD_UWP, u); };
	void SendGG(int g);
	void SendBelts(int b);
	void SendStar(char *st) { SendResp(RCMD_STAR, st); };

	void SendDone(void) { SendResp(RCMD_DONE); };

	void GrabParam(char **dest);

private:
	wxSocketServer	*server;
	wxSocketBase	*sock;

	void SendResp(RESPONSE_COMMANDS cmd, char *str=NULL);
};

class GenClient
{
public:
	GenClient(wxWindow *p, int id, int c_port);
	~GenClient();

	void GenStars(void) { WriteCmd((char) PCMD_STARS); };
	void GenSystem(void) { WriteCmd((char) PCMD_SYSTEM); };
	void GenUWP(void) { WriteCmd((char) PCMD_UWP); };

	void SendSectName(char *s) { WriteCmd((char) SCMD_SECT_NAME, s); };
	void SendSSectName(char *s) { WriteCmd((char) SCMD_SSECT_NAME, s); };
	void SendLoc(char *l) { WriteCmd((char) SCMD_LOC, l); };
	void SendPort(char c);
	void SendOutFile(char *f) { WriteCmd((char) SCMD_OUT_FILE, f); };
	void Send3D(void) { WriteCmd((char) SCMD_3D); };
	void SendGo(void) { WriteCmd((char) SCMD_GO); };

	RESPONSE_COMMANDS ReadResponse(char *buff);

	void Quit(void);

private:
	wxSocketClient *sock;

	void WriteCmd(PRIMARY_COMMANDS pc) { WriteCmd((char) pc); };
	void WriteCmd(SYSTEM_GEN_COMMANDS pc, char *str=NULL) 
			{ WriteCmd((char)pc, str); };
	void WriteCmd(char pc, char *str=NULL);
};

#endif

