/*
 * File:		sectdisp.h
 * Purpose:		general purpose sector related printing.
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sectdisp.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2001/12/02 18:11:58 $" */

#ifndef SECTDISP_H
#define SECTDISP_H

#include <stdio.h>
#include "t_frame.h"
#include "basesect.h"

// ====================================================
// this should be broken out.....
class BasePlanetDisplay : public DisplayMethod
{
public:
	BasePlanetDisplay(wxDC *d, int x=0, int y=0, int len=-1);
	BasePlanetDisplay(FILE *fp, int len=-1);
	BasePlanetDisplay(wxTextCtrl *t, int len=-1);
	virtual ~BasePlanetDisplay();

	int DrawBaseDetail(base_planet *bp, TCodes *codes);
	int DrawStarDetail(BaseStar *bs1, BaseStar *bs2, BaseStar *bs3);

	int DrawCode(char *title, SimpleCodeTable *ct, unsigned long code);
	int DrawCode(char *title, SimpleCodeTable *ct, char *code);
	int DrawZone(char zone);

	int DrawOtherDetail(int pop_ndx, int gg, int belts);

	char *DrawBaseLine(base_planet *bp, char *buff);

	char *FormatCode(SimpleCodeTable *ct, unsigned long code, char *buff);
	char *FormatCode(SimpleCodeTable *table, char *code, char *buff);
	char *FormatZone(char code, char *buff);
private:
};

// ====================================================
class MainWorldDisplay : public BasePlanetDisplay
{
public:
	MainWorldDisplay(wxDC *d, int x=0, int y=0, int len=-1);
	MainWorldDisplay(FILE *fpx, int len=-1);
	MainWorldDisplay(wxTextCtrl *t, int len=-1);
	virtual ~MainWorldDisplay();

	int DrawDetail(HexData *hd, TCodes *codes, char *sect_name=NULL);

	bool DrawLine(BaseSector *bs, int x, int y, char *sect_name=NULL);

private:
};

#endif
