//
// File:		hardtimes.h
// Purpose:		common stuff for tracking hardtimes info
// Author:		Mark A. Nordstrand
// Created:		Sat Mar 30 09:29:45 CST 2002
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: hardtimes.h,v $ $Revision: 1.1 $ $Author: man $ $Date: 2002/03/30 16:09:15 $"

#ifndef HARDTIMES_H
#define HARDTIMES_H

#include "basesect.h"

typedef enum {
	HTM_HARD_TIMES=0,
	HTM_COLLAPSE,
	HTM_REBUILD
} HARD_TIMES_METHOD;

typedef enum {
	HTA_SAFE=0,
	HTA_FRONTIER,
	HTA_OUTLANDS,
	HTA_WILDS
} HT_AREA;

typedef enum {
	HTW_PEACE=0,
	HTW_WAR,
	HTW_INTENSE,
	HTW_BLACK
} HT_WAR;

class HardTimes 
{
public:
	HardTimes(char *dir);
	~HardTimes() {};

	HT_AREA GetArea(int x, int y);
	HT_WAR GetWar(int x, int y);

#ifdef DEBUG_HT
	void Dump(void);
#endif

private:
	HT_AREA		area[MAX_X_HEX][MAX_Y_HEX];
	HT_WAR		war[MAX_X_HEX][MAX_Y_HEX];
};

#endif

