/*
 * File:      d_sect.h
 * Purpose:   detail (gui) sectors
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: d_sect.h,v $ $Revision: 1.8 $ $Author: man $ $Date: 2001/12/11 00:36:07 $" */

#ifndef D_SECT_H
#define D_SECT_H

#include "basesect.h"

// full sector
class DetailSector : public BaseSector
{
public:
	DetailSector(TCodes *tc);
	~DetailSector();

// random gen params:
//	set_gen_params(SYSTEM_DENSITY pres, TRAVEL_MATURE trav);
// parsing params:
//	set_parse_params(int, int, int, int, int, int, int, int, int);

	// should these be in the base class???
	HexData *AddOrGetHex(int, int);
	HexData *CopyHex(int x, int y, HexData *hd);

	void WriteDat(TCodes *codes);
	void WriteSec(void);

	int GetCount(int start_x, int start_y, int end_x, int end_y);

	char *FormatBase(char code, char *buff);
	char *FormatTrade(unsigned long code, char *buff) 
		{ return(FormatCode(codes->GetTradeTable(), code, buff)); };
	char *FormatOther(unsigned long code, char *buff) 
		{ return(FormatCode(codes->GetOtherTable(), code, buff)); };
	char *FormatSystem(unsigned long code, char *buff) 
		{ return(FormatCode(codes->GetSystTable(), code, buff)); };
	char *FormatZone(char code, char *buff);
	char *FormatAlleg(char *code, char *buff);

	void SetSecName(char *buff);
	void SetDatName(char *buff);

private:
	char	border_map[MAX_X_HEX][MAX_Y_HEX];

	char *FormatCode(SimpleCodeTable *ct, unsigned long code, char *buff);
	void WriteHeader(FILE *fpx, char *sect_str, char *format_str);

	void BuildParseParams(void);
	void WriteSecHeader(FILE *fp);
};

#endif

