/*
 * File:      codetbl.h
 * Purpose:   general code table
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: codetbl.h,v $ $Revision: 1.10 $ $Author: man $ $Date: 2003/04/26 19:53:30 $" */

#ifndef CODETBL_H
#define CODETBL_H

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "str_util.h"
#include "llist.h"
#include "parse.h"

// =============================================================================
// base linked list class, mostly just a wrapper for file parsing
class ParseClass : public LinkedList
{
public:
	ParseClass();
	virtual ~ParseClass();

	// XXX Init/Load are hokey kludges!!!!
	void Init(char *f);

	virtual void Load(char *buff, bool local=FALSE)=0;
};


// =============================================================================
// general lookup table class
class LookupTable : public ParseClass
{
public:
	LookupTable();
	virtual ~LookupTable();

	char *GetFormated(char *);

private:
	long hokey_counter;
};

class LookupEntry : public ListData
{
public:
	LookupEntry(bool l);
	virtual ~LookupEntry();

	virtual char *GetSaveFormated(char *)=0;
	virtual char *GetFormated(char *)=0;
	bool IsLocal(void) { return(local); };

private:
	bool		local;		// flag for sector based (non-global) codes
};

// =============================================================================
// simple code table
//  intermediate class (avoid conflicts w/ Load())
//  for CodeTable BaseTable and TradeTable
class SimpleCodeTable : public LookupTable
{
public:
	SimpleCodeTable();
	virtual ~SimpleCodeTable();

	char *GetDesc(char *);

//	bool ParseAndAddCode(char *buff, bool local=FALSE);

	void Clear(bool local_only=FALSE);

	unsigned long GetFlag(char *c);

private:
};

// =============================================================================
// general CodeTable classes
//	for 'other' codes, bases, and allegances
//	Note that trade and bases are derived from the general code
//	entry since they have extra elements
class TradeTableEntry;
class BaseTableEntry;
class CodeTable : public SimpleCodeTable
{
public:
	CodeTable(char *file);
	virtual ~CodeTable();

	void Load(char *buff, bool local=FALSE);

private:
};

class CodeTableEntry : public LookupEntry
{
friend class TradeTableEntry;
friend class BaseTableEntry;
public:
	CodeTableEntry(bool l=FALSE);
	CodeTableEntry(char *, char *, bool l=FALSE);
	virtual ~CodeTableEntry();

	char *GetDesc(void) { return(desc); };
	char *GetCode(void) { return(code); };

	char *GetFormated(char *);
	char *GetSaveFormated(char *);
	void NewEntry(char *, char *);

	void Clear(void);
	void SetValues(char *, char *);

private:
	char		*code;
	char		*desc;
};

// =============================================================================
// the trade table has extra members to handle generation
// enumeration to handle the industrial and rich special cases
typedef enum {
	TGC_NONE=0,
	TGC_IN,			// 2-4,7,9
	TGC_RI			// 6,8
} TRADE_GEN_CODE;

class TradeTable : public SimpleCodeTable
{
public:
	TradeTable(char *f);
	~TradeTable();

	unsigned long CheckTrade(char *u);

	void Load(char *buff, bool local=FALSE);

private:
};

class TradeTableEntry : public CodeTableEntry
{
public:
	TradeTableEntry(bool l=FALSE);
	TradeTableEntry(char *, bool l=FALSE);
	TradeTableEntry(char *c, char *d, int *n, int *x, 
				TRADE_GEN_CODE s, bool l=FALSE);
	~TradeTableEntry();

	bool Check(char *u);
	char *GetCode(void) { return(code); };

	char *GetSaveFormated(char *);

	void NewEntry(char *c, char *d, int *n, int *x, TRADE_GEN_CODE s);

	TRADE_GEN_CODE GetSpecial(void) { return(special); };
	int GetMin(int ndx) { return(mins[ndx]); };
	int GetMax(int ndx) { return(maxs[ndx]); };

private:
	TRADE_GEN_CODE	special;
	int				mins[6];
	int				maxs[6];
};

// =============================================================================
// the base table has two pairs of extra members for the named bitmap
// and indexing for the application for those bitmaps
class BaseTable : public SimpleCodeTable
{
public:
	BaseTable(char *file);
	virtual ~BaseTable();

//	bool ParseAndAddBase(char *buff, bool local=FALSE);

	int GetBMIndex(char *buff, int ndx);

	void Load(char *buff, bool local=FALSE);
#ifdef DEBUG_BASE_LIST
	void DumpBT(FILE *);
#endif
};

// -----------------------------------------------------------------------------
class BaseTableEntry : public CodeTableEntry
{
public:
	BaseTableEntry(bool l=FALSE);
	BaseTableEntry(char *, char *, char *, char *, bool l=FALSE);
	virtual ~BaseTableEntry();

	void NewEntry(char *, char *, char *, char *);

	void Clear(void);
	void SetValues(char *, char *, char *, char *);

	char *GetName(int ndx);
	int GetIndex(int ndx);

	void SetIndex(int ndx, int index);

	char *GetSaveFormated(char *);

#ifdef DEBUG_BASE_LIST
	void DumpBTE(FILE *);
#endif

private:
	int VerifyIndex(int ndx);

	char		*name[2];
	int			index[2];
};

#endif

