/*
 * File:      code_dlg.h
 * Purpose:   header for code (base, et al) dialogs
 * Author:    Mark A. Nordstrand
 * Created:   9/18/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: code_dlg.h,v $ $Revision: 1.8 $ $Author: man $ $Date: 2003/05/01 12:02:13 $" */

#ifndef CODE_DLG_H
#define CODE_DLG_H

#include "wx/notebook.h"
#include "wx/listctrl.h"
#include "t_code.h"
#include "t_dlg.h"
#include "t_bm.h"

#define DUMMY_BUFFER_SIZE	120
#define BITMAP_SIZE			15

// =======================================================================
// special list control
//  sort of a bitmap selector
class BitmapControl : public wxListCtrl
{
public:
	BitmapControl(wxWindow *p, wxWindowID i);
	~BitmapControl();

	void DisplayBitmaps(BitmapList *bl);
	int GetSelection(void);
	void SetSelection(int s);

private:
	wxImageList *images;
};

// ========================================================================
class SelectBitmapDialog : public StdDialog
{
public:
	SelectBitmapDialog(wxWindow *p);
	~SelectBitmapDialog();

	int GetBitmap(BitmapList *b, int i);

private:
	void DisplayBitmaps(BitmapList *bl);
	int GetSelection(void);
	void SetSelection(int s);

	BitmapControl		*bm;
};

// ========================================================================
// base code edit dialog (semi-generic)
//  common class for bases, alleg, and code codes
class BaseCodeDialog : public StdDialog
{
friend class BaseDialog;
friend class CodeDialog;
friend class TradeDialog;
public:
    BaseCodeDialog(wxWindow *p);
    ~BaseCodeDialog(void);

    void SetTexts(char *title, char *code, char *capt);
//    void GetTexts(char **code, char **capt);
    void GetTexts(char *code, char *capt);

private:
    wxTextCtrl      *CodeEdit;
    wxTextCtrl      *CaptEdit;

	wxFlexGridSizer	*code_sizer;
};

// ----------------------------------------------------
// Code edit dialog
//  edits alleg and codes
class CodeDialog : public BaseCodeDialog
{
public:
    CodeDialog(wxWindow *p);
    ~CodeDialog(void);

    bool EditCode(bool al, CodeTableEntry *cte);
    bool NewCode(bool al, SimpleCodeTable *ct);

private:
	DECLARE_EVENT_TABLE()
};

// ----------------------------------------------------
// trade edit dialog
//  edits alleg and codes
class TradeDialog : public BaseCodeDialog
{
public:
    TradeDialog(wxWindow *p);
    ~TradeDialog(void);

    bool EditTrade(TradeTableEntry *tte);
    bool NewTrade(TradeTable *tt);

private:
	wxTextCtrl		*mins[6];
	wxTextCtrl		*maxs[6];
	wxChoice		*special;
	
	DECLARE_EVENT_TABLE()

};

// ----------------------------------------------------
// Base edit dialog
//  edits bases
class BaseDialog : public BaseCodeDialog
{
public:
    BaseDialog(wxWindow *p);
    ~BaseDialog(void);

    bool EditBase(BitmapList *b, BaseTableEntry *cte);
    bool NewBase(BitmapList *b, BaseTable *ct);

	void OnPaint(wxPaintEvent& event);

private:
	void UpdateBitmaps(void);
	void Btn1(wxCommandEvent& event);
	void Btn2(wxCommandEvent& event);
	void DoBtn(int ndx);

	void Cb1(wxCommandEvent& event);
	void Cb2(wxCommandEvent& event);
	void DoCb(int ndx);

	SelectBitmapDialog	*select_dlg;
	int					bm_ndx[2];

	wxCheckBox		*bases[2];
	wxButton		*load[2];
	wxStaticBitmap	*bitmap[2];
	wxBitmap		*default_bitmap;

	// pointer used while executing (don't delete!)
	BaseTableEntry	*bte;
	BitmapList		*bl;

	DECLARE_EVENT_TABLE()
};

// ----------------------------------------------------
// code editor
class TCodeDialog : public StdDialog
{
public:
	TCodeDialog(wxWindow *p, bool l=TRUE);
	~TCodeDialog();

	// returning TRUE here means things have changed
	//  it's up to the caller to save/reload
	bool EditCodes(TCodes *codes, BitmapList *bl);

private:
	void New(wxCommandEvent& event);
	void Edit(wxCommandEvent& event);
	void Del(wxCommandEvent& event);
	
	void BuildList(SimpleCodeTable *ct, wxListBox *dest);

	wxListBox *BuildNBPage(char *title);

	wxNotebook		*nb;
	wxListBox		*bases;
	wxListBox		*alleg;
	wxListBox		*sector;
	wxListBox		*system;
	wxListBox		*other;

	CodeDialog		*code_dialog;
	BaseDialog		*base_dialog;
	TradeDialog		*trade_dialog;

	TCodes			*codes;
	bool			local;
	BitmapList		*bl;				// reference do not delete

	DECLARE_EVENT_TABLE()
};

// ========================================================================

#endif

