/*
 * File:      basesect.h
 * Purpose:   base sector class
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: basesect.h,v $ $Revision: 1.12 $ $Author: man $ $Date: 2002/10/07 17:08:58 $" */


#ifndef BASESECT_H
#define BASESECT_H

#include "planet.h"
#include "llist.h"
#include "t_code.h"
#include "hex_fmt.h"
#include "color.h"

// these should never change:
#define MAX_X_HEX		32
#define MAX_Y_HEX		40

#define MAX_SS			16

// some handy enums
// (the first two could be used for generation)
typedef enum SYSTEM_DENSITY {
	RIFT_DENSITY=0,
	SPARSE_DENSITY,
	SCATTERED_DENSITY,
	STANDARD_DENSITY,
	DENSE_DENSITY
};

typedef enum TRAVEL_MATURE {
	BACKWATER_MATURE=0,
	STANDARD_MATURE,
	MATURE_MATURE,
	CLUSTER_MATURE
};

// handy parsing stuff
#define NAME_LENGTH			0
#define HEX_START			1
#define UWP_START			2
#define BASE_POS			3
#define CODE_START			4
#define ZONE_POS			5
#define PBG_START			6
#define ALLEG_START			7
#define STELLAR_START		8

// ==========================================================================
class Route : public ListData
{
public:
	Route(short x, short y, short color);

	// other end of route
	short x;
	short y;

	// color index (where needed)
	short color;
};

// ==========================================================================
class HexExtraData
{
public:
	HexExtraData(char *t, char *d, char *b);
	HexExtraData(HexExtraData *hd);
	~HexExtraData();

	char *GetTitle(void) { return(title); };
	char *GetDesc(void) { return(desc); };
	char *GetBM(void) { return(bm); };
	int GetIndex(void) { return(bm_index); };

	void SetIndex(int i) { bm_index = i; };

private:
	char		*title;
	char		*desc;
	char		*bm;
	int			bm_index;
};

// ==========================================================================
// HexData
class HexData
{
public:
	HexData();
	HexData(HexData *hd);
	HexData(LinkedList *r);
	~HexData();

	void AddRoute(short x_, short y_, short col);
	void AddBorder(short which, short col);
	void AddCP(char *t, char *d, char *b);

	main_world		*world;
	LinkedList		*routes;
	HexLayout		*layout;
// keep track of each side (-1 => no border)
	short			border_ndx[6];
	HexExtraData	*cp;
};

// ==========================================================================
// BaseSector
class BaseSector
{
friend class DetailSector;
//friend class GuiSector;
public:
	BaseSector(TCodes *sc);
	virtual ~BaseSector();

	void Clear(void);

	bool HasWorld(int x, int y);

	int LoadFile(char *file_name);

	char *GetListing(short x_, short y_, char *buff);

	HexData *GetHex(int x, int y);

	SimpleCodeTable *GetTradeTable(void) { return(codes->GetTradeTable()); };
	SimpleCodeTable *GetCodeTable(void) { return(codes->GetOtherTable()); };
	SimpleCodeTable *GetSystTable(void) { return(codes->GetSystTable()); };
	ColorTable *GetRouteTable(void) { return(route_list); };
	ColorTable *GetBorderTable(void) { return(border_list); };

	char *GetName(void) { return(name); };
	char *GetAltName(void) { return(alt_name); };
	char *GetSSName(int s);
	char *GetSecName(void) { return(sec_name); };

	void SetSSName(int n, char *buff);
	void SetName(char *s);

	// handy hex translation stuff
	HexData *GetAdjHex(int, int, int);
	bool GetAdjCoord(int x, int y, int h, int *_x, int *_y);
	bool TranslateCoord(int x, int y, int dir, int mag, int *_x, int *_y);

	char *GetDataDir(char *);
	char *GetNotesDir(char *);
	char *GetSysDir(char *);
	char *GetEncDir(char *);
	char *GetWorldDir(char *);

	// formating helper
	char *GetCodeStr(main_world *, char *);

	HexLayout *GetLayout(void) { return(&layout); };

private:
	char				*name;				// name of sector
	char				*alt_name;			// alternate name of sector
	char				*dat_name;			// file name of extensions
	char				*sec_name;			// file name of main listing
	char				*ss_names[MAX_SS];	// subsector names

// parsing params (for .sec file):
	short				parse_params[10];

// world data
	HexData				*hexes[MAX_X_HEX][MAX_Y_HEX];
// for drawing.....
	HexLayout			layout;				// global one

// misc lookup tables
	TCodes				*codes;

// (file level) look up tables
	ColorTable			*border_list;
	ColorTable			*route_list;

	void InitSector(void);

	int ParseFirst(char *buff);
	int ParseSecond(char *buff);

	// for main (.sec) file:
	int LoadSector(FILE *fpx);
	char *ParseStar(char *src, char *dest);
	void ParseCodes(char *, unsigned long *, unsigned long *);
	int ParseAndAddWorld(char *buff);
	int ValidLoc(char *, short *, short *);

	// for aux (.dat) file:
// XXX need some of these:
	void LoadAuxSector(FILE *fpx);
	void ParseAndAddBorder(char *buff);
	void ParseAndAddRoute(char *buff);
	void ParseAndAddSS(char *buff);
	void ParseAndAddCP(char *buff);
	void ParseAndAddBorderList(char *buff);
	void ParseAndAddRouteList(char *buff);
	void ParseAndAddColor(char *buff);
	void ParseAndAddLayout(char *buff);
	void ParseAndAddRBFilter(char *buff);
};

#endif

