/*
 * File:    enc_tbl.h
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: enc_tbl.h,v $ $Revision: 1.4 $ $Author: man $ $Date: 2000/09/05 03:45:12 $" */

#ifndef END_TBL_DLG
#define END_TBL_DLG

#include "wx/timer.h"
#include "wx/print.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "t_frame.h"
#include "enc.h"
#include "enc_dlg.h"
#include "t_dice.h"

// ====================================================
// Define a new application
class EncTableApp: public wxApp
{
public:
//    EncTableApp(void) ;
    bool OnInit(void);

	void CleanUp(void);

	wxConfig	*config;

private:
	void ParseCommandLine(struct conf_struct *cfg, char *cfg_ptr);
	bool ParseString(char **dest, char *src);
	bool ParseTerrain(TERRAIN_TYPE *t, char *src);
	bool CopyString(char *dest, char *src, unsigned int sz);
	void ProcessArgs(struct conf_struct *cfg, char last_arg, char *buff,
					 int star_count, char **sect_file);
};

// ========================================================================
//  gui stuff
class EncPanel : public wxPanel
{
public:
	EncPanel(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1);
	~EncPanel();
};

// ========================================================================
// display (print) handler
class EncDisplay : public DisplayMethod
{
public:
	EncDisplay(wxDC *d, int x=0, int y=0, int len=-1) :
		DisplayMethod(d, x, y, len) {};
	EncDisplay(FILE *fpx, int len=-1) : DisplayMethod(fpx) {};
	~EncDisplay();

	int DrawEnc(AnimalEncounter *ae, conf_struct *cfg,
			char *msg1=NULL, char *msg2=NULL,
			int start_count=0, int total_count=32000);
	int DrawTable(EncounterTable *et, conf_struct *cfg,
			char *msg1=NULL, char *msg2=NULL,
			int start_count=0, int total_count=32000);
	int DrawTables(EncounterTables *et, conf_struct *cfg,
			char *msg1=NULL, char *msg2=NULL,
			int start_count=0, int total_count=32000);

private:
	int DrawLine(AnimalEncounter *ae, TRAV_VER v, int die_roll=-1);
	int DrawHeader(conf_struct *cfg, TERRAIN_TYPE t, bool table=TRUE);

	int DrawSingleTable(EncounterTable *at, conf_struct *cfg, TERRAIN_TYPE t);
};

// ====================================================
// print out
class PrintOut : public wxPrintout
{
public:
	PrintOut(conf_struct *cfg);
	~PrintOut() {};

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *minPage, int *maxPage,
					 int *selPageFrom, int *selPageTo);

private:
	int				page_max;
	conf_struct		*cfg;
};

// ========================================================================
// general canvas
class EncTableCanvas : public wxScrolledWindow
{
public:
    EncTableCanvas(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1,
				 long style = wxRETAINED);
	~EncTableCanvas() {};

	void OnDraw(wxDC& dc);
	
};

// ========================================================================
class EncTableFrame : public wxFrame
{
//friend class QuietFrame;
friend class EncFrame;
public:
	EncTableFrame(struct conf_struct *c, char *cfg_ptr, int w, int h);
	~EncTableFrame();

	bool OnCLose(void) { return(TRUE); };

	int CalcTableCount(void);

	EncounterTables *GetTables(void) { return(tables); };
	EncounterTable *GetTable(void) { return(table); };
	AnimalEncounter *GetEnc(void) { return(enc); };

private:
	void CleanUp(void);
    struct conf_struct  cfg;

	EncounterTables		*tables;
	EncounterTable		*table;
	AnimalEncounter		*enc;
};

// ----------------------------------------------------
class EncFrame : public EncTableFrame
{
public:
    EncFrame(struct conf_struct *c, char *cfg_ptr);
    ~EncFrame();

	void Draw(wxDC *dc);

	void InitButtons(wxToolBar *tb);

private:
	void Configure(wxCommandEvent& event);
	void Generate(wxCommandEvent& event);
	void Save(wxCommandEvent& event);
	void Print(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	void Exit(wxCommandEvent& event);
	
	void OnToolEnter(wxCommandEvent& event);
	void ClearEnc(void);
	void UpdateStatus(void);

	EncTableCanvas		*canvas;
//	EncPanel			*tool_bar;
	EncDialog			*dlg;

	DECLARE_EVENT_TABLE()
};

#endif
