/*
 * File:		enc_dlg.cpp
 * Purpose:		get animal encounter params from user
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: enc_dlg.cpp,v $ $Revision: 1.6 $ $Author: man $ $Date: 2003/05/04 16:30:56 $" */

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "enc_dlg.h"
#include "str_util.h"

#define DUMMY_INIT_STR      " XXXXXXXXXXXXXX "

#define ID_TERR_CB			701
#define ID_DICE_CB			702

static wxString ver_str[] = {
	"CT",
	"MT",
	"TNE",
	"T4"
};
static wxString meth_str[] = {
	"Entry Only",
	"Single Table",
	"All Tables"
};
static wxString dice_strs[] = {
	"1D6",
	"2D6",
	"1D20"
};


// ===============================================================
BEGIN_EVENT_TABLE(EncDialog, wxDialog)
	EVT_RADIOBOX(ID_TERR_CB, EncDialog::DoTerr)
	EVT_CHOICE(ID_TERR_CB, EncDialog::DoTerr)
	EVT_RADIOBOX(ID_DICE_CB, EncDialog::DoDice)
END_EVENT_TABLE()

// ---------------------------------------------------------------
EncDialog::EncDialog(wxWindow *p) :
	StdDialog(p, "Configure Animal Encounters", FALSE)
{
int i;
wxStaticText *msg[13];
wxBoxSizer *panel_sizer;

	ready = FALSE;

	uwp_box = new UWPBox(this, "UWP");

	msg[8] =  new wxStaticText(this, -1, "Name:");
	msg[9] =  new wxStaticText(this, -1, "Location:");
	msg[10] = new wxStaticText(this, -1, "Sector:");
	msg[11] = new wxStaticText(this, -1, "SubSector:");

	name = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	name->SetValue("");
	loc = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	loc->SetValue("");
	sect = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	sect->SetValue("");
	ss = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize((COL_OFFSET * 5), -1));
	ss->SetValue("");

	method = new wxRadioBox(this, ID_TERR_CB, "Gen. Method",
			wxPoint(-1, -1),
			wxSize(-1, -1),
			3, meth_str, 1, wxRA_SPECIFY_COLS);


	msg[12] = new wxStaticText(this , -1, "Terrain:");
	terrain = new wxChoice(this, ID_TERR_CB, 
			wxPoint(-1, -1),
			wxSize(3 * COL_OFFSET, -1),
			0, NULL);

	for(i = 0;i < MAX_TERRAIN;i++) {
		char *ptr;

		ptr = terrain_table.GetTerrain((TERRAIN_TYPE) i);
		terrain->Append(ptr);
	}
	terrain->SetSelection(0);

	equiv = new wxStaticText(this, -1, DUMMY_INIT_STR);
	SetTerrain();

	vers = new wxRadioBox(this, -1, "Version",
			wxPoint(-1, -1),
			wxSize(-1, -1),
			4, ver_str, 1, wxRA_SPECIFY_COLS);

	dice = new wxRadioBox(this, ID_DICE_CB, "Format",
			wxPoint(-1, -1),
			wxSize(-1, -1),
			3, dice_strs, 1, wxRA_SPECIFY_COLS);
	
	dice_str[0] = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize(4 * COL_OFFSET, -1));
	dice_str[0]->SetValue("");
	dice_str[1] = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize(4 * COL_OFFSET, -1));
	dice_str[1]->SetValue("");
	dice_str[2] = new wxTextCtrl(this, -1, DUMMY_INIT_STR, 
			wxPoint(-1, -1),
			wxSize(4 * COL_OFFSET, -1));
	dice_str[2]->SetValue("");

	DoFormat();

	wxBoxSizer* sizer_24 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_27 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_31 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_32 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_29 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_30 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_28 = new wxStaticBoxSizer(new wxStaticBox(this, -1, "World Identification"), wxHORIZONTAL);
    wxGridSizer* grid_sizer_4 = new wxFlexGridSizer(4, 2, 0, 0);
    wxBoxSizer* sizer_25 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_26 = uwp_box->GetSizer();
    sizer_25->Add(sizer_26, 0, wxALL, DLG_OFFSET);

	panel_sizer = GetSizer();
	sizer_25->Add(panel_sizer, 0, wxALL, DLG_OFFSET * 3);

    sizer_24->Add(sizer_25, 0, 0, 0);
    grid_sizer_4->Add(msg[8], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_4->Add(name, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_4->Add(msg[9], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_4->Add(loc, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_4->Add(msg[10], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_4->Add(sect, 0, wxALL, DLG_OFFSET/2);
    grid_sizer_4->Add(msg[11], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET/2);
    grid_sizer_4->Add(ss, 0, wxALL, DLG_OFFSET/2);
    sizer_28->Add(grid_sizer_4, 0, 0, 0);
    sizer_27->Add(sizer_28, 0, wxALL, DLG_OFFSET);
    sizer_29->Add(method, 0, wxALL, DLG_OFFSET);
    sizer_30->Add(msg[12], 0, wxALL|wxALIGN_BOTTOM, DLG_OFFSET);
    sizer_30->Add(terrain, 0, wxALL, DLG_OFFSET);
    sizer_30->Add(equiv, 0, wxALL, DLG_OFFSET);
    sizer_29->Add(sizer_30, 0, 0, 0);
    sizer_27->Add(sizer_29, 0, 0, 0);
    sizer_31->Add(vers, 0, wxALL, DLG_OFFSET);
    sizer_31->Add(dice, 0, wxALL, DLG_OFFSET);
    sizer_32->Add(dice_str[0], 0, wxALL, DLG_OFFSET);
    sizer_32->Add(dice_str[1], 0, wxALL, DLG_OFFSET);
    sizer_32->Add(dice_str[2], 0, wxALL, DLG_OFFSET);
    sizer_31->Add(sizer_32, 0, 0, 0);
    sizer_27->Add(sizer_31, 0, 0, 0);
    sizer_24->Add(sizer_27, 0, 0, 0);
    SetAutoLayout(TRUE);
    SetSizer(sizer_24);
    sizer_24->Fit(this);
    sizer_24->SetSizeHints(this);
    Layout();

	ready = TRUE;
}

bool 
EncDialog::GetConfig(struct conf_struct *cfg)
{
int i,j,k;
char *ptr;

	if(cfg->name != NULL)
	    name->SetValue(cfg->name);
	else
	    name->SetValue("");
	if(cfg->sect != NULL)
	    sect->SetValue(cfg->sect);
	else
	    sect->SetValue("");
	if(cfg->ssect != NULL)
	    ss->SetValue(cfg->ssect);
	else
	    ss->SetValue("");
	if(cfg->loc != NULL)
	    loc->SetValue(cfg->loc);
	else
	    loc->SetValue("");

    if(cfg->uwp[0] != 0) {
		uwp_box->SetUWP(cfg->uwp);
	} else
		uwp_box->SetUWP("A0000000");
	
	vers->SetSelection(cfg->trav_version);

	method->SetSelection(cfg->method);

	terrain->SetSelection(cfg->ter);
	SetTerrain();

	dice_str[0]->SetValue(cfg->table_1d6);
	dice_str[1]->SetValue(cfg->table_2d6);
	dice_str[2]->SetValue(cfg->table_1d20);
	if(6 == cfg->die_size) {
		if(1 == cfg->num_die)
			i = 0;
		else
			i = 1;
	} else
		i = 2;

	dice->SetSelection(i);
	DoFormat();

	while(TRUE) {
		int l;
		bool ok=TRUE;

		if(wxID_CANCEL == ShowModal())
			return(FALSE);

		for(i = 0;i < 3;i++) {
			ptr = (char *)dice_str[i]->GetValue().GetData();
			switch(i) {
				case 0:
					l = 6;
					break;
				case 1:
					l = 11;
					break;
				case 2:
					l = 20;
					break;
			}

			if(((int)strlen(ptr) != l) || (strspn(ptr, "SHOC") != strlen(ptr)))
				ok = FALSE;
		}

		if(ok)
			break;

		wxMessageBox("Bad Dice Format!\n Please Re-enter!", "Error", 
			wxOK | wxCENTRE | wxICON_EXCLAMATION, this);
	}

	i = dice->GetSelection();
	switch(i) {
		case 0:
			j = 1;
			k = 6;
			break;
		case 1:
			j = 2;
			k = 6;
			break;
		case 2:
			j = 1;
			k = 20;
			break;
	}
	cfg->die_size = k;
	cfg->num_die = j;

	ptr = (char *)dice_str[i]->GetValue().GetData();

// should delete the old and issue new.....
	strcpy(cfg->table_1d6, dice_str[0]->GetValue());
	strcpy(cfg->table_2d6, dice_str[1]->GetValue());
	strcpy(cfg->table_1d20, dice_str[2]->GetValue());

	if(cfg->name != NULL) {
		delete cfg->name;
		cfg->name = NULL;
	}
	ptr = (char *)name->GetValue().GetData();
	cfg->name = new char[strlen(ptr)+1];
	strcpy(cfg->name, ptr);
	
	if(cfg->sect != NULL) {
		delete cfg->sect;
		cfg->sect = NULL;
	}
	ptr = (char *)sect->GetValue().GetData();
	cfg->sect = new char[strlen(ptr)+1];
	strcpy(cfg->sect, ptr);
	
	if(cfg->ssect != NULL) {
		delete cfg->ssect;
		cfg->ssect = NULL;
	}
	ptr = (char *)ss->GetValue().GetData();
	cfg->ssect = new char[strlen(ptr)+1];
	strcpy(cfg->ssect, ptr);
	
	if(cfg->loc != NULL) {
		delete cfg->loc;
		cfg->loc = NULL;
	}
	ptr = (char *)loc->GetValue().GetData();
	cfg->loc = new char[strlen(ptr)+1];
	strcpy(cfg->loc, ptr);

	uwp_box->GetUWP(cfg->uwp);

	cfg->trav_version = (TRAV_VER) vers->GetSelection();

	cfg->method = (ENC_GEN) method->GetSelection();
	cfg->ter = (TERRAIN_TYPE) terrain->GetSelection();

	return(TRUE);
}

void
EncDialog::SetTerrain(void)
{
bool state;
TERRAIN_TYPE t;
char buff[120];

	if(ready) {
		if(method->GetSelection() == 2) state = FALSE;
		else state = TRUE;

		terrain->Enable(state);
		equiv->Enable(state);
		
		t = (TERRAIN_TYPE) terrain->GetSelection();
		if(t < 0) t = (TERRAIN_TYPE) 0;
		sprintf(buff, "Equiv: %s", terrain_table.GetEquiv(t));
		equiv->SetLabel(buff);
	}
}

void
EncDialog::DoFormat(void)
{
int i;

	for(i = 0;i < 3;i++)
		dice_str[i]->Enable(FALSE);
	
	dice_str[dice->GetSelection()]->Enable(TRUE);
}

