//
// File:		sys-conv.cpp
// Purpose:		converts old system files
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2003 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: sys-conv.cpp,v $ $Revision: 1.1 $ $Author: man $ $Date: 2003/05/07 12:11:36 $"


#include <stdio.h>
#include "old-sys.h"
#include <unistd.h>

int
main(int argc, char *argv[])
{
char *in_file=NULL,*out_file=NULL;
int ret=0,opt;
TCodes *t_codes=NULL;
System *s;

	do {
		opt = getopt(argc, argv, "c:i:o:h");
		switch(opt) {
			case 'c':
				if(NULL == t_codes)
					t_codes = new TCodes(optarg);
				else {
					fprintf(stderr, "only 1 code directory is allowed.\n");
					ret = 5;
				}
				break;
			case 'i':
				if(NULL == in_file)
					in_file = optarg;
				else {
					fprintf(stderr, "only 1 code directory is allowed.\n");
					ret = 5;
				}
				break;
			case 'o':
				if(NULL == out_file)
					out_file = optarg;
				else {
					fprintf(stderr, "only 1 code directory is allowed.\n");
					ret = 5;
				}
				break;
			case 'h':
				ret = 1;
				break;
		}
	} while (opt > 0);

	if(NULL == t_codes) {
		fprintf(stderr, "codes directory is required.\n");
		ret = 2;
	}

	if(NULL == in_file) {
		fprintf(stderr, "in file is required.\n");
		ret = 3;
	}

	if(NULL == out_file) {
		fprintf(stderr, "out file is required.\n");
		ret = 4;
	}

	if(0 == ret) {
		s = new System(t_codes);
		s->LoadFile(in_file);
		s->SaveSystem(out_file);
	}

	if(ret > 0) {
		fprintf(stderr, "Usage:\n");
		fprintf(stderr, 
			"%s -c<code directory> -i<input file> -o<output file>\n",
			argv[0]);
	}
	
	if(t_codes != NULL)
		delete t_codes;
	if(s != NULL)
		delete s;

	return(ret);
}

