/*
 * File:      sec_conf.c
 * Purpose:   an attemt to transfer (some of) galactic sector files to
				Mark's Traveller Utilities (MTU)
 * Author:	
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: ssec2sec.c,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/10/07 19:08:31 $" */



#include "conv.h"


main(int argc, char *argv[])
{
char buffer[256],*n,*p;
FILE *gal=NULL,*sec=NULL,*dat=NULL;
int err=1;
int i;

/*fprintf(stderr, "argc=%d\n", argc);
for(i = 0;i < argc;i++)
	fprintf(stderr, "  %s\n", argv[i]);
*/
	if(3 == argc) {
		for(i = 1;i < 3;i++) {
			if('-' == argv[i][0]) {
				if('i' == argv[i][1]) {
					if(NULL == gal) {
						if((gal = fopen(&argv[i][2], "r")) == NULL)
							fprintf(stderr, "Cannot open %s for reading.\n",
									&argv[i][2]);
						else
							p = &argv[i][2];
					} else
						fprintf(stderr, "Cannot use multiple input files.\n");
				} else if('o' == argv[i][1]) {
					n = &argv[i][2];
					if(NULL == sec) {
						sprintf(buffer, "%s.sec", &argv[i][2]);
						if((sec = fopen(buffer, "w")) == NULL)
							fprintf(stderr, "Cannot open %s for writing.\n",
									buffer);
						sprintf(buffer, "%s.dat", &argv[i][2]);
						if((dat = fopen(buffer, "w")) == NULL)
							fprintf(stderr, "Cannot open %s for writing.\n",
									buffer);
					} else
						fprintf(stderr, "Cannot use multiple output files.\n");
				}
			}
		}

		if((gal != NULL) && (sec != NULL) && (dat != NULL)) {
			char *o;

			if((o = rindex(p, '/')) == NULL) {
				p = "";
			} else {
				*o = 0;
			}

			parse_galactic(p, gal, sec, dat, "", n);

			err = 0;
		}
	}


	if(err) {
		fprintf(stderr, "%s: Usage:\n\t%s -i<galactic file> -o<mtu file>\n",
			argv[0], argv[0]);
		fprintf(stderr, "where:\n");
		fprintf(stderr, "  galactic file is the galactic file.\n");
		fprintf(stderr, "  mtu file is the MTU file (without an extension.\n");
		exit(1);
	}
}

