/*
 * File:		menu.c
 * Purpose:		functions for gal->mtu menu conversion
 * Author:		Mark A. Nordstrand
 * Created:
 * Updated:	
 * Copyright:	LGPL
 * Traveller is a registered trademark of Far Future Enterprises.
 * Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */
/* rcsid[] = "$RCSfile: menu.c,v $ $Revision: 1.1 $ $Author: man $ $Date: 2002/10/07 19:08:31 $" */

#include "conv.h"
#include <ctype.h>

/* special string copy -- make the following substitutions:
 *   '\' with '/' 
 *   'gen' with 'menu'
 *   'loc' with 'desc'
 *   'sys' with 'old_sys'
 * also creates dirs as neccassary....
 */
static void
copy_strings(char *src, char *gal, char *mtu, char *dir)
{
int i,j,k;
char lbuff[BUFFER_SIZE];		/* kludgy dummy one */

	i = strlen(mtu);
	j = strlen(gal);
	if(dir != NULL)
		k = strlen(dir);
	else {
		dir = lbuff;
		k = 0;
	}
//fprintf(stderr, "==>0123456789012345678901234567890123456789\n");
//fprintf(stderr, "==><%s>\n", src);
	while(*src != 0) {
//fprintf(stderr, "--> %c <%s><%s> <%s> %d", *src, gal, mtu, src, k);
		errno = 0;
		if(strncmp(src, "gen", 3) == 0) {
			src += 2;
			strcat(mtu, "menu");
			i += 3;
			strcat(gal, "gen");
			j += 2;
			strcat(dir, "menu");
			k += 3;
			mkdir(mtu, 0755);
//fprintf(stderr, " mkdir(%d)! ", errno);
		} else if(strncmp(src, "loc", 3) == 0) {
			src += 2;
			strcat(mtu, "desc");
			i += 3;
			strcat(gal, "loc");
			j += 2;
			strcat(dir, "desc");
			k += 3;
			mkdir(mtu, 0755);
//fprintf(stderr, " mkdir(%d)! ", errno);
		} else if(strncmp(src, "sys", 3) == 0) {
			src += 2;
			strcat(mtu, "old_desc");
			i += 6;
			strcat(gal, "sys");
			j += 2;
			strcat(dir, "old_desc");
			k += 6;
			mkdir(mtu, 0755);
//fprintf(stderr, " mkdir(%d)! ", errno);
		} else if('\\' == *src) {
			mkdir(mtu, 0755);
//fprintf(stderr, " mkdir(%d)! ", errno);
			mtu[i] = gal[j] = dir[k] = '/';
		} else
			mtu[i] = gal[j] = dir[k] = tolower(*src);
		i++;
		j++;
		k++;
		mtu[i] = gal[j] =  dir[k] = 0;
		src++;
//fprintf(stderr, "  <%s><%s> <%s> %d\n", gal, mtu, src, k);
	}
}

int 
convert_menu(FILE *in, char *gal_dir, FILE *out, char *mtu_dir)
{
char buffer[BUFFER_SIZE],gal_buff[BUFFER_SIZE],mtu_buff[BUFFER_SIZE];
char dir_buffer[BUFFER_SIZE];
char *ptr;
int i,j,k;
FILE *gal_fp,*mtu_fp;

//fprintf(stderr, "===><%s><%s>\n", gal_dir, mtu_dir);
	sprintf(gal_buff, "%s/", gal_dir);
	sprintf(mtu_buff, "%s/", mtu_dir);
	fprintf(out, "## mtu menu\n");
	while(read_line(in, buffer) != NULL) {
		if(strncmp(buffer, "@dir", 4) == 0) {
			strstrip(buffer, 1);
			strstrip(buffer, 0);
			ptr = &buffer[10];		/* should be the right spot... */
			dir_buffer[0] = 0;
			copy_strings(ptr, gal_buff, mtu_buff, dir_buffer);
			fprintf(out, "D:%s\n", dir_buffer);
		} else if('@' == buffer[0]) {
			/* color stuff -- ignore this line */
		} else if(((ptr = strchr(buffer, '@')) != NULL) &&
				// XXX what is the best way to trap this???
				(strstr(buffer, " @") != NULL)) {
//				(strchr(buffer, '>') == NULL) &&
//				(strstr(buffer, " <") == NULL) &&
//				(strchr(buffer, ')') == NULL) &&
//				(strstr(buffer, " (") == NULL)) {
			int is_menu=FALSE,is_text=FALSE;
			char lbuff1[BUFFER_SIZE],lbuff2[BUFFER_SIZE];

			if((strstr(buffer, ".txt") != NULL) || 
					(strstr(buffer, ".asc") != NULL))
				is_text = TRUE;
			else if(strstr(buffer, ".mnu") != NULL) {
				/* this is handled elsewhere.... */
				if(strstr(buffer, "map\\data.mnu") != NULL) {
					continue;
				}
				is_menu = TRUE;
			} else {
				fprintf(stderr, "Cannot convert <%s>.\n", buffer);
				continue;
			}

			*ptr = 0;
			ptr++;
			strstrip(buffer, 1);
			strstrip(buffer, 0);
			strstrip(ptr, 1);
			strstrip(ptr, 0);

			strcpy(lbuff1, gal_buff);
			strcpy(lbuff2, mtu_buff);
			strcat(lbuff1, "/");
			strcat(lbuff2, "/");
			dir_buffer[0] = 0;
			copy_strings(ptr, lbuff1, lbuff2, dir_buffer);
//fprintf(stderr, "---><%s><%s><%s>\n", lbuff1, lbuff2, ptr);
//			sprintf(lbuff1, "%s/%s", gal_buff, ptr);
//			sprintf(lbuff2, "%s/%s", mtu_buff, ptr);
			if(is_text) {
				fprintf(out, "T:%s:%s\n", buffer, dir_buffer);
				conv_text_file(lbuff1, lbuff2, 1);
			} else {
				FILE *gal_fp,*mtu_fp;
				int ret;

				ptr = strstr(dir_buffer, ".mnu");
				strcpy(ptr, ".menu");

				fprintf(out, "M:%s:%s\n", buffer, dir_buffer);

				if((gal_fp = fopen(lbuff1, "r")) == NULL) {
					fprintf(stderr, "Cannot open %s for reading(%d).\n", 
						lbuff1, errno);
					return(0);
				}
				ptr = strstr(lbuff2, ".mnu");
				strcpy(ptr, ".menu");
				if((mtu_fp = fopen(lbuff2, "a+")) == NULL) {
					fprintf(stderr, "Cannot open %s for writing(%d).\n", 
						lbuff2, errno);
					return(0);
				}

				/* recursion time */
				ret = convert_menu(gal_fp, gal_dir, mtu_fp, mtu_dir);
				fclose(gal_fp);
				fclose(mtu_fp);
				if(!ret)
					return(0);
			}
		} else if(strlen(buffer) > 0) {
			strstrip(buffer, 1);
			strstrip(buffer, 0);
			fprintf(out, "I:%s\n", buffer);
		}
		/* all others ignored */
	}

	return(1);
}

