/*
 * File:	b_gen.c 
 * Purpose:	attempts to add borders to a sec
 * Author:	Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: b_gen.c,v $ $Revision: 1.4 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "str_util.h"

/* where is this being trounced upon????? */
char *strcasestr();

#define BORDER_THRESHOLD		4

#define DEFAULT_BORDER_COLOR	0

#define BUFFER_SIZE				256

#define MAX_X					32
#define MAX_Y					40

struct ALLEG_STRUCT {
	char		alleg[3];		/* actual allegance */
	int			present;		/* was a world here? */
	int			pass;			/* when did this get filled-in?
								    < 0 means at load time */
};

/* hideous global */
struct ALLEG_STRUCT alleg[MAX_X][MAX_Y];

/*
 * transpose coordinates
 *  determine a new hex given direction and distance
 */
void
transpose_coord(int direction, int mag, int *x, int *y)
{
int x1,y1;

	x1 = *x;
	y1 = *y;
	switch(direction) {
		case 0:
			*y -= mag;
			break;
		case 1:
			*x += mag;
			*y -= (mag / 2);
			if((0 == (x1 & 1)) && (mag & 1))
				*y -= 1;
			else if((x1 & 1) && (0 == (mag & 1)))
				*y -= 1;
			break;
		case 2:
			*x += mag;
			*y += (mag / 2);
			if((0 == (x1 & 1)) && (0 == (mag & 1)))
				*y += 1;
			else if((x1 & 1) && (mag & 1))
				*y += 1;
			break;
		case 3:
			*y += mag;
			break;
		case 4:
			*x -= mag;
			*y -= (mag / 2);
			if((0 == (x1 & 1)) && (0 == (mag & 1)))
				*y += 1;
			else if((x1 & 1) && (mag & 1))
				*y += 1;
			break;
		case 5:
			*x -= mag;
			*y += (mag / 2);
			if((0 == (x1 & 1)) && (mag & 1))
				*y -= 1;
			else if((x1 & 1) && (0 == (mag & 1)))
				*y -= 1;
			break;
	}
}

/*
 * shrink borders
 */
void
collapse_border(int x, int y, int pass)
{
int i,x1,y1,x2,y2;
int middle=0;

	/* Na worlds don't count */
	if(strcmp(alleg[x][y].alleg, "Na") == 0)
		return;

	/* don't remove current worlds */
	if(alleg[x][y].present)
		return;

	/* 
	 * look for *this* hex between 2 other hexes
	 *  special cases are the corners and each edge
	 */
/* for now, ignore the corners */
	if((0 == y) && (0 == x)) {
		middle = 1;
	} else if(((MAX_Y - 1) == y) && (0 == x)) {
		middle = 1;
	} else if((0 == y) && ((MAX_X - 1) == x)) {
		middle = 1;
	} else if(((MAX_Y - 1) == y) && ((MAX_X - 1) == x)) {
		middle = 1;
	} else if(0 == y) {
		if(x & 1) {
			for(i = 1;i < 3;i++) {
				x1 = x2 = x;
				y1 = y2 = y;
				transpose_coord(i, 1, &x1, &y1);
				transpose_coord(i+3, 1, &x2, &y2);
				if((strcmp(alleg[x][y].alleg, alleg[x1][y1].alleg) == 0) &&
					(strcmp(alleg[x][y].alleg, alleg[x2][y2].alleg) == 0))
					middle = 1;
			}
		} else {
			x1 = x2 = x;
			y1 = y2 = y;
			transpose_coord(2, 1, &x1, &y1);
			transpose_coord(4, 1, &x2, &y2);
			if((strcmp(alleg[x][y].alleg, alleg[x1][y1].alleg) == 0) &&
				(strcmp(alleg[x][y].alleg, alleg[x2][y2].alleg) == 0))
				middle = 1;
		}
	} else if((MAX_Y - 1) == y) {
		if(x & 1) {
			x1 = x2 = x;
			y1 = y2 = y;
			transpose_coord(1, 1, &x1, &y1);
			transpose_coord(5, 1, &x2, &y2);
			if((strcmp(alleg[x][y].alleg, alleg[x1][y1].alleg) == 0) &&
				(strcmp(alleg[x][y].alleg, alleg[x2][y2].alleg) == 0))
				middle = 1;
		} else {
			for(i = 1;i < 3;i++) {
				x1 = x2 = x;
				y1 = y2 = y;
				transpose_coord(i, 1, &x1, &y1);
				transpose_coord(i+3, 1, &x2, &y2);
				if((strcmp(alleg[x][y].alleg, alleg[x1][y1].alleg) == 0) &&
					(strcmp(alleg[x][y].alleg, alleg[x2][y2].alleg) == 0))
					middle = 1;
			}
		}
	} else if((0 == x) || ((MAX_X - 1) == x)) {
		x1 = x2 = x;
		y1 = y2 = y;
		transpose_coord(0, 1, &x1, &y1);
		transpose_coord(3, 1, &x2, &y2);
		if((strcmp(alleg[x][y].alleg, alleg[x1][y1].alleg) == 0) &&
			(strcmp(alleg[x][y].alleg, alleg[x2][y2].alleg) == 0))
			middle = 1;
	} else {
		for(i = 0;i < 3;i++) {
			x1 = x2 = x;
			y1 = y2 = y;
			transpose_coord(i, 1, &x1, &y1);
			transpose_coord(i+3, 1, &x2, &y2);

			/* see if this world is in the middle of two others */
			if((strcmp(alleg[x][y].alleg, alleg[x1][y1].alleg) == 0) &&
				(strcmp(alleg[x][y].alleg, alleg[x2][y2].alleg) == 0))
				middle = 1;

		}
	}

	if(!middle)
		strcpy(alleg[x][y].alleg, "Na");
}

/* 
 * grow borders
 */
void
expand_border(int x, int y, int pass)
{
int i,x1,y1;

	/* don't grow Na worlds */
	if(strcmp(alleg[x][y].alleg, "Na") == 0)
		return;

	/* zero'th pass, we only want 'present' worlds */
	if(pass < 1) {
		if(0 == alleg[x][y].present)
			return;
	} else {
		/* this one was already set, ignore it..... */
		if(pass == alleg[x][y].pass)
			return;
	}

	/* check each side */
	for(i = 0;i < 6;i++) {
		x1 = x;
		y1 = y;
		transpose_coord(i, 1, &x1, &y1);
		/* off map, ignore */
		if((x1 < 0) || (x1 >= MAX_X) || (y1 < 0) || (y1 >= MAX_Y))
			continue;
		/* already the same, ignore */
		if(strcmp(alleg[x1][y1].alleg, alleg[x][y].alleg) == 0)
			continue;
		/* can't change one from map */
		if(alleg[x1][y1].present)
			continue;
		/* is a Na location, make it the same */
		if(strcmp(alleg[x1][y1].alleg, "Na") == 0) {
			alleg[x1][y1].alleg[0] = alleg[x][y].alleg[0];
			alleg[x1][y1].alleg[1] = alleg[x][y].alleg[1];
			alleg[x1][y1].alleg[2] = 0;
			alleg[x1][y1].pass = pass;
		} else {
		/* we're hitting another border, set it back to Na */
			alleg[x1][y1].alleg[0] = 'N';
			alleg[x1][y1].alleg[1] = 'a';
			alleg[x1][y1].alleg[2] = 0;
			alleg[x1][y1].pass = pass;
		}
	}
}

/*
 * fill in alleg codes
 */
void
fill_in_hex_1(int x, int y)
{
int i,x1,y1;
int have_alleg=0;

	if(0 == alleg[x][y].present) {
		for(i = 0;i < 6;i++) {
			alleg[x][y].pass = 0;
			x1 = x;
			y1 = y;
			transpose_coord(i, 1, &x1, &y1);
			if((x1 > -1) && (x1 < MAX_X) && (y1 > -1) && (y1 < MAX_Y)) {
				if(strcmp(alleg[x1][y1].alleg, alleg[x][y].alleg) != 0) {
					if(!have_alleg) {
						if(alleg[x1][y1].present) {
							have_alleg = 1;
							strcpy(alleg[x][y].alleg, alleg[x1][y1].alleg);
						}
/*					} else if((alleg[x1][y1].present) &&
						(strcmp(alleg[x1][y1].alleg, alleg[x][y].alleg) != 0)) {
*/
					} else if(alleg[x1][y1].present) {
						strcpy(alleg[x][y].alleg, "Na");
					}
				}
			}
		}
	}
}

void 
conv_sector(int threshold)
{
int i,x,y;

	for(i = 0;i < threshold + 1;i++) {
		for(x = 0;x < MAX_X;x++) {
			for(y = 0;y < MAX_Y;y++) {
				expand_border(x, y, i);
			}
		}
	}
	
	for(i = 0;i < (2 * threshold);i++) {
		for(x = 0;x < MAX_X;x++) {
			for(y = 0;y < MAX_Y;y++) {
				collapse_border(x, y, i);
			}
		}
	}
}

void 
init_sector(void)
{
int x,y;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			alleg[x][y].present = 0;
			alleg[x][y].pass = 0;
			strcpy(alleg[x][y].alleg, "Na");
		}
	}
}

void
print_sector(FILE *fp, int default_color)
{
int x,y,x1,y1,i;
char buff[20];
int j;
#ifdef DUMP_ALL_ALLEG
char buff1[BUFFER_SIZE],buff2[BUFFER_SIZE],*ptr1,*ptr2,temp[3];
	
	for(y = 0;y < MAX_Y;y++) {
		buff1[0] = buff2[0] = 0;
		for(x = 0;x < MAX_X;x++) {
			if(x & 1) {
				ptr1 = buff2;
				ptr2 = buff1;
			}
			else {
				ptr1 = buff1;
				ptr2 = buff2;
			}

			temp[0] = alleg[x][y].alleg[0];
			temp[1] = alleg[x][y].alleg[1];
			temp[2] = 0;
			strcat(ptr1, temp);
			strcat(ptr2, "  ");
		}
		fprintf(fp, "%s\n", buff1);
		fprintf(fp, "%s\n", buff2);
	}
#endif

	fprintf(fp, "##############################################################################\n");
	fprintf(fp, "##\n");
	fprintf(fp, "## Border section\n");
	fprintf(fp, "## format:\n");
	fprintf(fp, "## B:hex:side(0-5):border index\n");
	fprintf(fp, "##\n");
	fprintf(fp, "##############################################################################\n");

	for(y = 0;y < MAX_Y;y++) {
		for(x = 0;x < MAX_X;x++) {
			/* due to the way hexes are drawn (and to avoid duplicate
			 *  borders), just look do sides 0,4,5 */
			for(i = 0;i < 3;i++) {
				if(0 == i) j = 0;
				if(1 == i) j = 4;
				if(2 == i) j = 5;
				x1 = x;
				y1 = y;
				transpose_coord(j, 1, &x1, &y1);
				if((x1 > -1) && (x1 < MAX_X) && (y1 > -1) && (y1 < MAX_Y)) {
					if(strcmp(alleg[x1][y1].alleg, alleg[x][y].alleg) != 0) {
						fprintf(fp, "B:%02d%02d:%d:%d\n", x+1, y+1, j,
								default_color);
					}
				}
			}
		}
	}
}

void
grab_offsets(char *buff, int *start, int *end)
{
char *ptr;
int s=0,e=0;

	ptr = buff;
	while(!isdigit(*ptr))
		ptr++;

	while(isdigit(*ptr)) {
		s *= 10;
		s += (*ptr - '0');
		ptr++;
	}
	ptr++;
	while(isdigit(*ptr)) {
		e *= 10;
		e += (*ptr - '0');
		ptr++;
	}

	*start = s-1;
	*end = e-1;
}

int
load_sector(FILE *fp)
{
int count=0,i,temp,x,y;
int hex_start=14,hex_end=17,alleg_start=55,alleg_end=56;
char buff[BUFFER_SIZE];

	while(1) {
		for(i = 0;i < BUFFER_SIZE;i++)
			buff[i] = 0;
		if(fgets(buff, BUFFER_SIZE, fp) == NULL)
			return(count);
		if(strcasestr(buff, "HexNbr") != NULL) {
			grab_offsets(buff, &hex_start, &hex_end);
			continue;
		} 
		if(strcasestr(buff, "Allegiance") != NULL) {
			grab_offsets(buff, &alleg_start, &alleg_end);
			continue;
		} 

		x = ((buff[hex_start + 0] - '0') * 10) + 
				(buff[hex_start + 1] - '0') - 1;
		y = ((buff[hex_start + 2] - '0') * 10) + 
			(buff[hex_start + 3] - '0') - 1;
		if((x > -1) && (x < MAX_X) && (y > -1) && (y < MAX_Y)) {
			alleg[x][y].present = 1;
			alleg[x][y].pass = -1;
			alleg[x][y].alleg[0] = buff[alleg_start];
			alleg[x][y].alleg[1] = buff[alleg_start + 1];
			alleg[x][y].alleg[2] = 0;
		} else
			continue;

		count++;
	}

	return(count);
}

main(int argc, char *argv[])
{
FILE *fp=NULL;
int thresh,color,err=0;
#ifdef TEST_CONV
int x,y,x1,y1,i;

	for(x = 0;x < 5;x++) {
		for(y = 0;y < 5;y++) {
			fprintf(stderr, "(%d %d) ", x+1, y+1);
			for(i = 0;i < 6;i++) {
				x1 = x;
				y1 = y;
				transpose_coord(i, 1, &x1, &y1);
				fprintf(stderr, "%d:(%d %d) ", i, x1+1, y1+1);
			}
			fprintf(stderr, "\n");
		}
	}

#endif

	thresh = BORDER_THRESHOLD;
	color = DEFAULT_BORDER_COLOR;
	while(argc > 1) {
		argc--;
		if('-' == argv[argc][0]) {
			if('d' == argv[argc][1]) {
				thresh = atoi(&argv[argc][2]);
			} else if('c' == argv[argc][1]) {
				color = atoi(&argv[argc][2]);
			} else {
				err = 1;
			}
		} else if (NULL == fp) {
			if((fp = fopen(argv[argc], "r")) == NULL) {
				fprintf(stderr, "Cannot open %s for reading (%d).\n",
					argv[argc], errno);
				err = 1;
			}
		}
	}

	if(err || (NULL == fp)) {
		fprintf(stderr, "%s: Usage:\n\t%s <-d#> <-c#> sector_file\n",
			argv[0], argv[0]);
		fprintf(stderr, "where:\n");
		fprintf(stderr, "  sector_file is the sector file.\n");
		fprintf(stderr, "  -d# sets the 'depth' for searching for neighbors.\n");
		fprintf(stderr, "  -c# sets the color to print.\n");
		exit(1);
	}

	/* fell through, everything's ok */
	init_sector();
	load_sector(fp);
	fclose(fp);
	conv_sector(thresh);
	print_sector(stdout, color);
	exit(0);
}

