/*
 * Decompiled with CFR 0.152.
 */
package surgegen;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultCaret;
import surgegen.GeneralDefinitions;
import surgegen.Quality;
import surgegen.QualitySelector;

public class SURGEGenMainForm
extends JFrame {
    int languageConstant = 0;
    int surgeClass = 1;
    int currentPosKarma = 0;
    int currentNegKarma = 0;
    int maxKarma = 0;
    int maxNegKarma = 0;
    boolean isPositive;
    private JButton addNegQual;
    private JButton addPosQual;
    private JLabel classLabel;
    private JComboBox classSelector;
    private JRadioButtonMenuItem deviantOption;
    private JMenuItem discalimerInfo;
    private JRadioButtonMenuItem englishOption;
    private JButton exportToChum;
    private JMenuItem freaksInfo;
    private JButton generateButton;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JMenu languageMenu;
    private JLabel negKarma;
    private JLabel negLabel;
    private JList negQualitiesList;
    private JRadioButtonMenuItem pirateOption;
    private JLabel posKarma;
    private JLabel posLabel;
    private JList posQualitiesList;
    private JButton remNegQual;
    private JButton remPosQual;
    private JTextArea selectedQualityDesc;
    private JLabel selectedQualityName;

    public SURGEGenMainForm() {
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.negQualitiesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel && value instanceof Quality) {
                    ((JLabel)renderer).setText(((Quality)value).getName());
                }
                return renderer;
            }
        });
        this.posQualitiesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel && value instanceof Quality) {
                    ((JLabel)renderer).setText(((Quality)value).getName());
                }
                return renderer;
            }
        });
        this.posQualitiesList.setModel(new DefaultListModel(){

            @Override
            public void clear() {
                int size = ((DefaultListModel)SURGEGenMainForm.this.posQualitiesList.getModel()).getSize();
                for (int i = 0; i < size; ++i) {
                    if (!SURGEGenMainForm.this.updateKarma(-1, ((Quality)((DefaultListModel)SURGEGenMainForm.this.posQualitiesList.getModel()).elementAt(0)).getKarma(), true)) continue;
                    ((DefaultListModel)SURGEGenMainForm.this.posQualitiesList.getModel()).remove(0);
                }
            }
        });
        this.negQualitiesList.setModel(new DefaultListModel(){

            @Override
            public void clear() {
                int size = ((DefaultListModel)SURGEGenMainForm.this.negQualitiesList.getModel()).getSize();
                for (int i = 0; i < size; ++i) {
                    if (!SURGEGenMainForm.this.updateKarma(-1, ((Quality)((DefaultListModel)SURGEGenMainForm.this.negQualitiesList.getModel()).elementAt(0)).getKarma(), false)) continue;
                    ((DefaultListModel)SURGEGenMainForm.this.negQualitiesList.getModel()).remove(0);
                }
            }
        });
        this.updateForm();
        this.posQualitiesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = SURGEGenMainForm.this.posQualitiesList.getSelectedIndex();
                if (index != -1) {
                    SURGEGenMainForm.this.selectedQualityName.setText(((Quality)((DefaultListModel)SURGEGenMainForm.this.posQualitiesList.getModel()).elementAt(index)).getName());
                    SURGEGenMainForm.this.selectedQualityDesc.setText(((Quality)((DefaultListModel)SURGEGenMainForm.this.posQualitiesList.getModel()).elementAt(index)).getDesc());
                }
            }
        });
        this.negQualitiesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = SURGEGenMainForm.this.negQualitiesList.getSelectedIndex();
                if (index != -1) {
                    SURGEGenMainForm.this.selectedQualityName.setText(((Quality)((DefaultListModel)SURGEGenMainForm.this.negQualitiesList.getModel()).elementAt(index)).getName());
                    SURGEGenMainForm.this.selectedQualityDesc.setText(((Quality)((DefaultListModel)SURGEGenMainForm.this.negQualitiesList.getModel()).elementAt(index)).getDesc());
                }
            }
        });
        DefaultCaret caret = (DefaultCaret)this.selectedQualityDesc.getCaret();
        caret.setUpdatePolicy(1);
        this.langaugeUpdate();
        this.buildIncompatables();
    }

    @Override
    public String getTitle() {
        return GeneralDefinitions.MAIN_FORM_TITLES[this.languageConstant];
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.posQualitiesList = new JList();
        this.posLabel = new JLabel();
        this.addPosQual = new JButton();
        this.remPosQual = new JButton();
        this.negLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.negQualitiesList = new JList();
        this.addNegQual = new JButton();
        this.remNegQual = new JButton();
        this.posKarma = new JLabel();
        this.negKarma = new JLabel();
        this.exportToChum = new JButton();
        this.jPanel1 = new JPanel();
        this.selectedQualityName = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.selectedQualityDesc = new JTextArea();
        this.jPanel2 = new JPanel();
        this.classLabel = new JLabel();
        this.classSelector = new JComboBox();
        this.generateButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.languageMenu = new JMenu();
        this.englishOption = new JRadioButtonMenuItem();
        this.deviantOption = new JRadioButtonMenuItem();
        this.pirateOption = new JRadioButtonMenuItem();
        this.freaksInfo = new JMenuItem();
        this.discalimerInfo = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle(this.getTitle());
        this.setResizable(false);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane1.setPreferredSize(new Dimension(243, 121));
        this.posQualitiesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.posQualitiesList);
        this.posLabel.setText("Positive Qualities:");
        this.addPosQual.setText("Add Quality");
        this.addPosQual.setToolTipText("Add a new positive quailty");
        this.addPosQual.setEnabled(false);
        this.addPosQual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.addPosQualActionPerformed(evt);
            }
        });
        this.remPosQual.setText("Remove Quality");
        this.remPosQual.setToolTipText("Remove the selected positive quality");
        this.remPosQual.setEnabled(false);
        this.remPosQual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.remPosQualActionPerformed(evt);
            }
        });
        this.negLabel.setText("Negative Qualities:");
        this.jScrollPane2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane2.setPreferredSize(new Dimension(243, 121));
        this.negQualitiesList.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.negQualitiesList);
        this.addNegQual.setText("Add Quality");
        this.addNegQual.setToolTipText("Add a new negative quailty");
        this.addNegQual.setEnabled(false);
        this.addNegQual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.addNegQualActionPerformed(evt);
            }
        });
        this.remNegQual.setText("Remove Quality");
        this.remNegQual.setToolTipText("Remove the selected negative quality");
        this.remNegQual.setEnabled(false);
        this.remNegQual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.remNegQualActionPerformed(evt);
            }
        });
        this.posKarma.setText("Karma: 0");
        this.posKarma.setHorizontalTextPosition(2);
        this.negKarma.setText("Karma: 0");
        this.negKarma.setHorizontalTextPosition(2);
        this.exportToChum.setText("Export sue to Chummer");
        this.exportToChum.setEnabled(false);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.selectedQualityName.setText("Selected Quality");
        this.selectedQualityDesc.setEditable(false);
        this.selectedQualityDesc.setColumns(20);
        this.selectedQualityDesc.setLineWrap(true);
        this.selectedQualityDesc.setRows(5);
        this.selectedQualityDesc.setName("selectedQualityDesc");
        this.jScrollPane3.setViewportView(this.selectedQualityDesc);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.selectedQualityName).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.selectedQualityName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3)));
        this.jPanel2.setMaximumSize(new Dimension(273, 134));
        this.jPanel2.setMinimumSize(new Dimension(273, 89));
        this.classLabel.setText("What class of SURGE do you want to be?");
        this.classSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Class I", "Class II", "Class III"}));
        this.classSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.classSelectorActionPerformed(evt);
            }
        });
        this.generateButton.setFont(new Font("Tahoma", 0, 18));
        this.generateButton.setText("Create Fursona");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.generateButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.classLabel, -1, 231, Short.MAX_VALUE).addGap(32, 32, 32)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.generateButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.classSelector, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.classLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.classSelector, -2, 20, -2).addGap(55, 55, 55).addComponent(this.generateButton, -1, -1, Short.MAX_VALUE).addGap(8, 8, 8)));
        this.jMenu1.setText("File");
        this.languageMenu.setText("Language");
        this.englishOption.setSelected(true);
        this.englishOption.setText("English");
        this.englishOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.englishOptionActionPerformed(evt);
            }
        });
        this.languageMenu.add(this.englishOption);
        this.deviantOption.setText("Deviant Art");
        this.deviantOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.deviantOptionActionPerformed(evt);
            }
        });
        this.languageMenu.add(this.deviantOption);
        this.pirateOption.setText("Pirate");
        this.pirateOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.pirateOptionActionPerformed(evt);
            }
        });
        this.languageMenu.add(this.pirateOption);
        this.jMenu1.add(this.languageMenu);
        this.freaksInfo.setText("Freaks Info");
        this.freaksInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.freaksInfoActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.freaksInfo);
        this.discalimerInfo.setText("Disclaimer");
        this.discalimerInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SURGEGenMainForm.this.discalimerInfoActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.discalimerInfo);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.exportToChum).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.posKarma)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.addNegQual, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remNegQual, -2, 117, -2)).addGroup(layout.createSequentialGroup().addComponent(this.negLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.negKarma)).addGroup(layout.createSequentialGroup().addComponent(this.addPosQual, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remPosQual, -2, 117, -2))).addComponent(this.posLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.posKarma).addComponent(this.posLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 121, -2)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addPosQual).addComponent(this.remPosQual)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.negLabel).addComponent(this.negKarma)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 121, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addNegQual).addComponent(this.remNegQual).addComponent(this.exportToChum)).addContainerGap()));
        this.pack();
    }

    private void addPosQualActionPerformed(ActionEvent evt) {
        if (this.surgeClass == 2) {
            ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        }
        this.addQuality(true);
    }

    private void addNegQualActionPerformed(ActionEvent evt) {
        this.addQuality(false);
    }

    private void classSelectorActionPerformed(ActionEvent evt) {
        this.surgeClass = this.classSelector.getSelectedIndex() + 1;
        ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        ((DefaultListModel)this.posQualitiesList.getModel()).clear();
        this.updateForm();
    }

    private void remPosQualActionPerformed(ActionEvent evt) {
        if (this.posQualitiesList.getSelectedIndex() != -1 && this.updateKarma(-1, ((Quality)((DefaultListModel)this.posQualitiesList.getModel()).elementAt(this.posQualitiesList.getSelectedIndex())).getKarma(), true)) {
            ((DefaultListModel)this.posQualitiesList.getModel()).remove(this.posQualitiesList.getSelectedIndex());
            System.out.println(this.surgeClass);
            if (this.surgeClass == 2) {
                ((DefaultListModel)this.negQualitiesList.getModel()).clear();
                this.maxNegKarma = this.currentPosKarma;
            }
        }
    }

    private void remNegQualActionPerformed(ActionEvent evt) {
        if (this.negQualitiesList.getSelectedIndex() != -1 && this.updateKarma(-1, ((Quality)((DefaultListModel)this.negQualitiesList.getModel()).elementAt(this.negQualitiesList.getSelectedIndex())).getKarma(), false)) {
            ((DefaultListModel)this.negQualitiesList.getModel()).remove(this.negQualitiesList.getSelectedIndex());
        }
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        this.generateCharacter();
    }

    private void englishOptionActionPerformed(ActionEvent evt) {
        this.englishOption.setSelected(true);
        this.deviantOption.setSelected(false);
        this.pirateOption.setSelected(false);
        this.languageConstant = 0;
        ((DefaultListModel)this.posQualitiesList.getModel()).clear();
        ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        this.langaugeUpdate();
    }

    private void deviantOptionActionPerformed(ActionEvent evt) {
        this.englishOption.setSelected(false);
        this.deviantOption.setSelected(true);
        this.pirateOption.setSelected(false);
        this.languageConstant = 1;
        ((DefaultListModel)this.posQualitiesList.getModel()).clear();
        ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        this.langaugeUpdate();
    }

    private void pirateOptionActionPerformed(ActionEvent evt) {
        this.englishOption.setSelected(false);
        this.deviantOption.setSelected(false);
        this.pirateOption.setSelected(true);
        this.languageConstant = 2;
        ((DefaultListModel)this.posQualitiesList.getModel()).clear();
        ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        this.langaugeUpdate();
    }

    private void freaksInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Many of the Negative Metagenic Qualities provide serious\nsocial issues for characters since they look so strange. In a\nworld of cookie-cutter corporate employees and ever-present\nsurveillance, being different makes you stick out like a pink\nmohawk at a black trench coat convention. That, and everybody\nlooks at you like you have two heads\u2014which may well be one\nof the things you have.\nGetting down to chrome tacks, what this means is every\ntime you take a quality that mentions this menu, you face a\n\u20131 dice pool modifier for all Social based tests, and for every\nthree qualities, your Social limit decreases by 1. That\u2019s the\nstraight rules mechanic, but what does it mean to a character?\nWell, the character is going to be treated like an outsider or\nan eyesore, no matter where they go. Staring will be expected,\nwhispers and pointing will occur, and frequent jeers are par for\nthe course.\nCertain aspects of a characters freakish appearance may\ndraw violent attention to them from more than just Humanis\nschmucks. Many changelings who ended up with insectoid or\ndraconic features have suffered from the bug spirit attention\n(since the bugs often assume them to be rivals) and attacks\nfrom dragon-haters during the dragon civil war, pushing them\nto go into hiding. Some who hid poorly ended up being killed for\ntheir appearance alone.", "Freaks", 1);
    }

    private void discalimerInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Technically the way that SURGEn randomly generates characters is not legal by RAW,\n it does not use the table system found in Run Faster because it's a clusterfuck of \ncontradicting information. Instead SURGEn uses a basic RNG to determine your random qualities.\n You should check if using SURGEn is okay with your GM before using it.\nOr don't, I'm not a cop.", "Disclaimer", 2);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SURGEGenMainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SURGEGenMainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SURGEGenMainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SURGEGenMainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SURGEGenMainForm().setVisible(true);
            }
        });
    }

    private void updateForm() {
        if (this.surgeClass == 1) {
            this.maxNegKarma = 0;
            this.maxKarma = 30;
            this.addPosQual.setEnabled(false);
            this.addNegQual.setEnabled(false);
            this.remPosQual.setEnabled(false);
            this.remNegQual.setEnabled(false);
            this.generateButton.setEnabled(true);
            ((DefaultListModel)this.posQualitiesList.getModel()).clear();
            ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        } else if (this.surgeClass == 2) {
            this.maxNegKarma = 0;
            this.maxKarma = 30;
            this.addPosQual.setEnabled(true);
            this.addNegQual.setEnabled(false);
            this.remPosQual.setEnabled(true);
            this.remNegQual.setEnabled(false);
            this.generateButton.setEnabled(true);
            ((DefaultListModel)this.posQualitiesList.getModel()).clear();
            ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        } else if (this.surgeClass == 3) {
            this.maxNegKarma = 0;
            this.maxKarma = 30;
            this.addPosQual.setEnabled(true);
            this.addNegQual.setEnabled(true);
            this.remPosQual.setEnabled(true);
            this.remNegQual.setEnabled(true);
            this.generateButton.setEnabled(false);
            ((DefaultListModel)this.posQualitiesList.getModel()).clear();
            ((DefaultListModel)this.negQualitiesList.getModel()).clear();
        }
    }

    public boolean updateKarma(int addOrRemove, int karma, boolean isPosQualityKarma) {
        if (isPosQualityKarma) {
            if (this.currentPosKarma + karma * addOrRemove > this.maxKarma) {
                return false;
            }
            this.currentPosKarma += karma * addOrRemove;
        } else {
            if (this.currentNegKarma + karma * addOrRemove > this.maxNegKarma) {
                return false;
            }
            this.currentNegKarma += karma * addOrRemove;
        }
        if (isPosQualityKarma) {
            this.posKarma.setText("Karma: " + this.currentPosKarma);
        } else {
            this.negKarma.setText("Karma: " + this.currentNegKarma);
        }
        return true;
    }

    private void addQuality(boolean isPositive) {
        this.isPositive = isPositive;
        QualitySelector qualitySelector = new QualitySelector((Frame)this, true);
        qualitySelector.setVisible(true);
        if (isPositive && this.surgeClass != 1) {
            this.maxNegKarma = this.currentPosKarma;
        }
    }

    public JList getList(boolean isPostive) {
        if (this.isPositive) {
            return this.posQualitiesList;
        }
        return this.negQualitiesList;
    }

    public void langaugeUpdate() {
        this.setTitle(this.getTitle());
        this.classLabel.setText(GeneralDefinitions.CLASS_LABEL_TEXTS[this.languageConstant]);
        this.generateButton.setText(GeneralDefinitions.GENERATE_BUTTON_TEXTS[this.languageConstant]);
        this.exportToChum.setText(GeneralDefinitions.EXPORT_TO_CHUM_TEXTS[this.languageConstant]);
        this.posLabel.setText(GeneralDefinitions.POSITIVE_QUALITY_LABEL_TEXTS[this.languageConstant]);
        this.posKarma.setText(GeneralDefinitions.POSITIVE_KARMA_LABEL_TEXTS[this.languageConstant] + this.currentPosKarma);
        this.negLabel.setText(GeneralDefinitions.NEGATIVE_QUALITY_LABEL_TEXTS[this.languageConstant]);
        this.negKarma.setText(GeneralDefinitions.NEGATIVE_KARMA_LABEL_TEXTS[this.languageConstant] + this.currentNegKarma);
        this.addPosQual.setText(GeneralDefinitions.ADD_POSITIVE_QUALITY_BUTTON_TEXTS[this.languageConstant]);
        this.remPosQual.setText(GeneralDefinitions.REMOVE_POSITIVE_QUALITY_BUTTON_TEXTS[this.languageConstant]);
        this.addNegQual.setText(GeneralDefinitions.ADD_NEGATIVE_QUALITY_BUTTON_TEXTS[this.languageConstant]);
        this.remNegQual.setText(GeneralDefinitions.REMOVE_NEGATIVE_QUALITY_BUTTON_TEXTS[this.languageConstant]);
        this.classSelector.removeAllItems();
        this.classSelector.addItem(GeneralDefinitions.CLASS_SELECTOR_TEXTS[0][this.languageConstant]);
        this.classSelector.addItem(GeneralDefinitions.CLASS_SELECTOR_TEXTS[1][this.languageConstant]);
        this.classSelector.addItem(GeneralDefinitions.CLASS_SELECTOR_TEXTS[2][this.languageConstant]);
        this.classSelector.setSelectedIndex(0);
    }

    private void generateCharacter() {
        int index;
        ArrayList<Quality> qualities = new ArrayList<Quality>();
        boolean done = false;
        Random rand = new Random();
        if (this.surgeClass == 2) {
            ((DefaultListModel)this.negQualitiesList.getModel()).clear();
            qualities.addAll(Arrays.asList(GeneralDefinitions.NEGATIVE_QUALITY_ARRAY));
            do {
                ((DefaultListModel)this.negQualitiesList.getModel()).clear();
                qualities.clear();
                qualities.addAll(Arrays.asList(GeneralDefinitions.NEGATIVE_QUALITY_ARRAY));
                while (!done && !(qualities = this.cleanArray(qualities, false)).isEmpty()) {
                    index = rand.nextInt(qualities.size());
                    this.updateKarma(1, qualities.get((int)index).karma, false);
                    ((DefaultListModel)this.negQualitiesList.getModel()).addElement(qualities.get(index));
                }
            } while (this.currentNegKarma != this.maxNegKarma && this.currentNegKarma != this.maxNegKarma - 1);
        }
        if (this.surgeClass == 1) {
            ((DefaultListModel)this.negQualitiesList.getModel()).clear();
            ((DefaultListModel)this.posQualitiesList.getModel()).clear();
            qualities.addAll(Arrays.asList(GeneralDefinitions.POSITIVE_QUALITY_ARRAY));
            while (!done && !(qualities = this.cleanArray(qualities, true)).isEmpty()) {
                index = rand.nextInt(qualities.size());
                this.updateKarma(1, qualities.get((int)index).karma, true);
                ((DefaultListModel)this.posQualitiesList.getModel()).addElement(qualities.get(index));
                int result = JOptionPane.showConfirmDialog(this, "Added quality " + qualities.get((int)index).name + ", current karma " + this.currentPosKarma + ", add another quality?", "Quality added!", 0);
                if (result != 1) continue;
                break;
            }
            this.maxNegKarma = this.currentPosKarma;
            do {
                ((DefaultListModel)this.negQualitiesList.getModel()).clear();
                qualities.clear();
                qualities.addAll(Arrays.asList(GeneralDefinitions.NEGATIVE_QUALITY_ARRAY));
                while (!done && !(qualities = this.cleanArray(qualities, false)).isEmpty()) {
                    index = rand.nextInt(qualities.size());
                    this.updateKarma(1, qualities.get((int)index).karma, false);
                    ((DefaultListModel)this.negQualitiesList.getModel()).addElement(qualities.get(index));
                }
            } while (this.currentNegKarma != this.maxNegKarma && this.currentNegKarma != this.maxNegKarma - 1);
        }
    }

    private ArrayList<Quality> cleanArray(ArrayList<Quality> qualities, boolean isPositive) {
        ArrayList<Quality> listToReturn = new ArrayList<Quality>();
        ArrayList<Quality> usedQualities = new ArrayList<Quality>();
        if (isPositive) {
            int i;
            for (i = 0; i < ((DefaultListModel)this.posQualitiesList.getModel()).getSize(); ++i) {
                usedQualities.add((Quality)((DefaultListModel)this.posQualitiesList.getModel()).get(i));
            }
            for (i = 0; i < ((DefaultListModel)this.negQualitiesList.getModel()).getSize(); ++i) {
                usedQualities.add((Quality)((DefaultListModel)this.negQualitiesList.getModel()).get(i));
            }
            for (Quality quality : qualities) {
                if (quality.karma > this.maxKarma - this.currentPosKarma || !this.checkCompatable(quality, usedQualities) || Collections.frequency(usedQualities, quality) >= quality.maxUses) continue;
                listToReturn.add(quality);
            }
        } else {
            int i;
            for (i = 0; i < ((DefaultListModel)this.negQualitiesList.getModel()).getSize(); ++i) {
                usedQualities.add((Quality)((DefaultListModel)this.negQualitiesList.getModel()).get(i));
            }
            for (i = 0; i < ((DefaultListModel)this.posQualitiesList.getModel()).getSize(); ++i) {
                usedQualities.add((Quality)((DefaultListModel)this.posQualitiesList.getModel()).get(i));
            }
            for (Quality quality : qualities) {
                if (quality.karma > this.maxNegKarma - this.currentNegKarma || !this.checkCompatable(quality, usedQualities) || Collections.frequency(usedQualities, quality) >= quality.maxUses) continue;
                listToReturn.add(quality);
            }
        }
        return listToReturn;
    }

    private boolean checkCompatable(Quality quality, ArrayList<Quality> usedQualities) {
        ArrayList<Quality> incompatables = new ArrayList<Quality>();
        for (Quality currentQuality : usedQualities) {
            incompatables.addAll(Arrays.asList(currentQuality.incompatable));
        }
        return !incompatables.contains(quality);
    }

    private void buildIncompatables() {
        GeneralDefinitions.VISION_360.incompatable = new Quality[]{GeneralDefinitions.CYCLOPEAN_EYE, GeneralDefinitions.THIRD_EYE};
        GeneralDefinitions.CYCLOPEAN_EYE.incompatable = new Quality[]{GeneralDefinitions.THIRD_EYE, GeneralDefinitions.VISION_360};
        GeneralDefinitions.THIRD_EYE.incompatable = new Quality[]{GeneralDefinitions.CYCLOPEAN_EYE, GeneralDefinitions.VISION_360};
        GeneralDefinitions.ANIMAL_PELAGE_CAMO.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE};
        GeneralDefinitions.ANIMAL_PELAGE_INSULATING.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.ANIMAL_PELAGE_QUILLS.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.CAMO_BASIC.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.CAMO_DYNAMIC.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.CLIMATE_ARCTIC.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.CLIMATE_DESERT.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.DERMAL_BARK.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.DERMAL_BLUBBER.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.DERMAL_DEPOSISTS.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.DERMAL_DRAGON.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.DERMAL_GRANITE.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.DERMAL_RHINO.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.GREASY_SKIN.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.PHOTOMETABOLISM.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.NOCTURNAL, GeneralDefinitions.FEATHERS, GeneralDefinitions.SCALE, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.NOCTURNAL.incompatable = new Quality[]{GeneralDefinitions.PHOTOMETABOLISM};
        GeneralDefinitions.FEATHERS.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.SCALE, GeneralDefinitions.UNUSUAL_HAIR, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.SCALE.incompatable = new Quality[]{GeneralDefinitions.ANIMAL_PELAGE_INSULATING, GeneralDefinitions.ANIMAL_PELAGE_QUILLS, GeneralDefinitions.CAMO_BASIC, GeneralDefinitions.CAMO_DYNAMIC, GeneralDefinitions.CLIMATE_ARCTIC, GeneralDefinitions.CLIMATE_DESERT, GeneralDefinitions.DERMAL_BARK, GeneralDefinitions.DERMAL_BLUBBER, GeneralDefinitions.DERMAL_DEPOSISTS, GeneralDefinitions.DERMAL_DRAGON, GeneralDefinitions.DERMAL_GRANITE, GeneralDefinitions.DERMAL_RHINO, GeneralDefinitions.GREASY_SKIN, GeneralDefinitions.PHOTOMETABOLISM, GeneralDefinitions.FEATHERS, GeneralDefinitions.UNUSUAL_HAIR, GeneralDefinitions.ANIMAL_PELAGE_CAMO};
        GeneralDefinitions.UNUSUAL_HAIR.incompatable = new Quality[]{GeneralDefinitions.SCALE, GeneralDefinitions.FEATHERS, GeneralDefinitions.MOOD_HAIR};
        GeneralDefinitions.MOOD_HAIR.incompatable = new Quality[]{GeneralDefinitions.SCALE, GeneralDefinitions.FEATHERS, GeneralDefinitions.UNUSUAL_HAIR};
        GeneralDefinitions.STUBBY_ARMS.incompatable = new Quality[]{GeneralDefinitions.ELONGATED_LIMBS};
        GeneralDefinitions.ELONGATED_LIMBS.incompatable = new Quality[]{GeneralDefinitions.STUBBY_ARMS};
        GeneralDefinitions.GILLS_BOTH.incompatable = new Quality[]{GeneralDefinitions.GILLS_AIR, GeneralDefinitions.GILLS_WATER};
        GeneralDefinitions.GILLS_AIR.incompatable = new Quality[]{GeneralDefinitions.GILLS_BOTH, GeneralDefinitions.GILLS_WATER};
        GeneralDefinitions.GILLS_WATER.incompatable = new Quality[]{GeneralDefinitions.GILLS_AIR, GeneralDefinitions.GILLS_BOTH};
        GeneralDefinitions.FUNCTIONAL_TAIL_BALANCE.incompatable = new Quality[]{GeneralDefinitions.FUNCTIONAL_TAIL_PADDLE, GeneralDefinitions.FUNCTIONAL_TAIL_PREHENSILE, GeneralDefinitions.FUNCTIONAL_TAIL_THAGOMIZER, GeneralDefinitions.VESTIGIAL_TAIL};
        GeneralDefinitions.FUNCTIONAL_TAIL_THAGOMIZER.incompatable = new Quality[]{GeneralDefinitions.FUNCTIONAL_TAIL_PADDLE, GeneralDefinitions.FUNCTIONAL_TAIL_PREHENSILE, GeneralDefinitions.FUNCTIONAL_TAIL_BALANCE, GeneralDefinitions.VESTIGIAL_TAIL};
        GeneralDefinitions.FUNCTIONAL_TAIL_PADDLE.incompatable = new Quality[]{GeneralDefinitions.FUNCTIONAL_TAIL_BALANCE, GeneralDefinitions.FUNCTIONAL_TAIL_PREHENSILE, GeneralDefinitions.FUNCTIONAL_TAIL_THAGOMIZER, GeneralDefinitions.VESTIGIAL_TAIL};
        GeneralDefinitions.FUNCTIONAL_TAIL_PREHENSILE.incompatable = new Quality[]{GeneralDefinitions.FUNCTIONAL_TAIL_PADDLE, GeneralDefinitions.FUNCTIONAL_TAIL_BALANCE, GeneralDefinitions.FUNCTIONAL_TAIL_THAGOMIZER, GeneralDefinitions.VESTIGIAL_TAIL};
        GeneralDefinitions.LARGER_TUSKS.incompatable = new Quality[]{GeneralDefinitions.FANGS, GeneralDefinitions.FROG_TONGUE};
        GeneralDefinitions.FANGS.incompatable = new Quality[]{GeneralDefinitions.LARGER_TUSKS};
        GeneralDefinitions.FROG_TONGUE.incompatable = new Quality[]{GeneralDefinitions.LARGER_TUSKS};
        GeneralDefinitions.CLAWS_DIG.incompatable = new Quality[]{GeneralDefinitions.CLAWS_RAZOR, GeneralDefinitions.CLAWS_RETRACT};
        GeneralDefinitions.CLAWS_RAZOR.incompatable = new Quality[]{GeneralDefinitions.CLAWS_DIG, GeneralDefinitions.CLAWS_RETRACT};
        GeneralDefinitions.CLAWS_RETRACT.incompatable = new Quality[]{GeneralDefinitions.CLAWS_RAZOR, GeneralDefinitions.CLAWS_DIG};
        GeneralDefinitions.LOW_LIGHT_VISION.incompatable = new Quality[]{GeneralDefinitions.LOW_LIGHT_VISION_FELINE};
        GeneralDefinitions.LOW_LIGHT_VISION_FELINE.incompatable = new Quality[]{GeneralDefinitions.LOW_LIGHT_VISION};
        GeneralDefinitions.CORROSIVE_SPIT.incompatable = new Quality[]{GeneralDefinitions.NATURAL_VENOM_CONDED, GeneralDefinitions.NATURAL_VENOM_CONMIL, GeneralDefinitions.NATURAL_VENOM_CONMOD, GeneralDefinitions.NATURAL_VENOM_CONSER, GeneralDefinitions.NATURAL_VENOM_INHDED, GeneralDefinitions.NATURAL_VENOM_INHMIL, GeneralDefinitions.NATURAL_VENOM_INHMOD, GeneralDefinitions.NATURAL_VENOM_INHSEV, GeneralDefinitions.NATURAL_VENOM_INJDED, GeneralDefinitions.NATURAL_VENOM_INJMIL, GeneralDefinitions.NATURAL_VENOM_INJMOD, GeneralDefinitions.NATURAL_VENOM_INJSEV};
        GeneralDefinitions.NATURAL_VENOM_CONDED.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_CONMOD.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_CONMIL.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_CONSER.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INHDED.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INHMIL.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INHMOD.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INHSEV.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INJDED.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INJMIL.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INJMOD.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.NATURAL_VENOM_INJSEV.incompatable = new Quality[]{GeneralDefinitions.CORROSIVE_SPIT};
        GeneralDefinitions.CELERITY.incompatable = new Quality[]{GeneralDefinitions.SATYR_LEGS};
        GeneralDefinitions.SATYR_LEGS.incompatable = new Quality[]{GeneralDefinitions.CELERITY};
        GeneralDefinitions.IMPAIRED_AGI.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_AGI};
        GeneralDefinitions.IMPAIRED_BOD.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_BOD};
        GeneralDefinitions.IMPAIRED_STR.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_STR};
        GeneralDefinitions.IMPAIRED_REA.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_REA};
        GeneralDefinitions.IMPAIRED_LOG.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_LOG};
        GeneralDefinitions.IMPAIRED_INT.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_INT};
        GeneralDefinitions.IMPAIRED_WIL.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_WIL};
        GeneralDefinitions.IMPAIRED_CHA.incompatable = new Quality[]{GeneralDefinitions.METAGENETIC_CHA};
        GeneralDefinitions.METAGENETIC_AGI.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_AGI};
        GeneralDefinitions.METAGENETIC_BOD.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_BOD};
        GeneralDefinitions.METAGENETIC_STR.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_STR};
        GeneralDefinitions.METAGENETIC_REA.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_REA};
        GeneralDefinitions.METAGENETIC_LOG.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_LOG};
        GeneralDefinitions.METAGENETIC_INT.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_INT};
        GeneralDefinitions.METAGENETIC_WIL.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_WIL};
        GeneralDefinitions.METAGENETIC_CHA.incompatable = new Quality[]{GeneralDefinitions.IMPAIRED_CHA};
    }
}

