/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.net.URL;

public class UriLikePathHelper {
    private final ClassLoader classLoader;

    public UriLikePathHelper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public URL getResource(String ref) {
        URL url = this.classLoader.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = this.classLoader.getResource(ref.substring(1));
        }
        return url;
    }

    public String getUriLikePath() {
        return this.createUri("/.jrubydir");
    }

    public String getUriLikePath(String ref) {
        return this.createUri(ref);
    }

    String createUri(String ref) {
        URL url = this.getResource(ref);
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on classloader " + this.classLoader);
        }
        return "uri:" + url.toString().replaceFirst(ref + "$", "");
    }
}

