/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.ast.CallNoArgBlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class CallNoArgNode
extends CallNode {
    public CallNoArgNode(ISourcePosition position, Node receiverNode, String name2) {
        super(position, receiverNode, name2, null, null);
    }

    public CallNoArgNode(ISourcePosition position, Node receiverNode, Node args2, String name2) {
        super(position, receiverNode, name2, args2, null);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return this.callAdapter.call(context, self2, this.getReceiverNode().interpret(runtime, context, self2, aBlock));
    }

    @Override
    public Node setIterNode(Node iterNode) {
        return new CallNoArgBlockNode(this.getPosition(), this.getReceiverNode(), this.getName(), this.getArgsNode(), (IterNode)iterNode);
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        if (this.getReceiverNode().definition(runtime, context, self2, aBlock) != null) {
            try {
                IRubyObject receiver2 = this.getReceiverNode().interpret(runtime, context, self2, aBlock);
                return Helpers.getDefinedCall(context, self2, receiver2, this.getName());
            }
            catch (JumpException jumpException) {
                // empty catch block
            }
        }
        return null;
    }
}

