/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.util.ByteList;

public class ConvertDouble {
    private static final long[] LONG_10_POWERS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L};
    private static final double[] SMALL_10_POWERS = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final int MAX_SMALL_10 = SMALL_10_POWERS.length - 1;
    private static final int MAX_DECIMAL_DIGITS = 15;

    public static final double byteListToDouble(ByteList bytes2, boolean strict) {
        return ConvertDouble.byteArrayToDouble(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length(), strict, false);
    }

    public static final double byteListToDouble19(ByteList bytes2, boolean strict) {
        return ConvertDouble.byteArrayToDouble(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length(), strict, true);
    }

    /*
     * Unable to fully structure code
     */
    private static final double byteArrayToDouble(byte[] bytes, int begin, int buflen, boolean strict, boolean is19) {
        SCOMPLETE = false;
        SBEGIN = true;
        SSIGN = 2;
        SOPTDIGIT = 3;
        SOPTDECDIGIT = 4;
        SOPTEXP = 9;
        SOPTDIGIT_STRICT = 6;
        SOPTDECDIGIT_STRICT = 7;
        SOPTEXP_STRICT = 8;
        SOPTCALC = 5;
        SDIGIT = 10;
        SDECDIGIT = 11;
        SEXP = 12;
        SDIGIT_STRICT = 13;
        SDECDIGIT_STRICT = 14;
        SEXP_STRICT = 15;
        SERR_NOT_STRICT = 16;
        MAX_EXP = 15 + ConvertDouble.MAX_SMALL_10;
        if (bytes == null) {
            throw new IllegalArgumentException("null bytes");
        }
        if (buflen < 0 || buflen > bytes.length) {
            throw new IllegalArgumentException("invalid buflen specified");
        }
        if (buflen == 0) {
            throw new NumberFormatException();
        }
        i = begin;
        buflen += begin;
        ival = -1;
        negative = false;
        nDigits = 0;
        nTrailingZeroes = 0;
        decPos = -1;
        significand = 0L;
        exponent = 0;
        startPos = 0;
        chars = null;
        offset = 0;
        lastValidOffset = 0;
        state = 1;
        while (state != 0) {
            block0 : switch (state) {
                case 1: {
                    if (strict) {
                        while (i < buflen && ConvertDouble.isWhitespace(bytes[i])) {
                            ++i;
                        }
                    } else {
                        while (i < buflen && (ConvertDouble.isWhitespace(ival = bytes[i]) || !is19 && ival == 95)) {
                            ++i;
                        }
                    }
                    if (i >= buflen) {
                        state = strict != false ? 16 : 0;
                        break;
                    }
                }
                case 2: {
                    switch (bytes[i]) {
                        case 45: {
                            negative = true;
                        }
                        case 43: {
                            if (++i >= buflen) {
                                state = strict != false ? 16 : 0;
                                break;
                            }
                        }
                        default: {
                            startPos = i;
                            if (strict) {
                                state = 6;
                                break;
                            }
                            ** GOTO lbl68
                        }
                    }
                    break;
                }
lbl68:
                // 2 sources

                case 3: {
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            significand = ival - 48;
                            nDigits = 1;
                            break;
                        }
                        case 46: {
                            state = 4;
                            break block0;
                        }
                        default: {
                            state = 5;
                            break block0;
                        }
                    }
                    block143: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits <= 0) continue block143;
                                ++nTrailingZeroes;
                                continue block143;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= ConvertDouble.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block143;
                                }
                                state = 10;
                                break;
                            }
                            case 46: {
                                state = 4;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 9;
                                break;
                            }
                            case 95: {
                                continue block143;
                            }
                            default: {
                                state = 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 5;
                    break;
                }
                case 4: {
                    decPos = nDigits + nTrailingZeroes;
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits > 0) {
                                    ++nTrailingZeroes;
                                    break;
                                }
                                --exponent;
                                break;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= ConvertDouble.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    break;
                                }
                                state = 10;
                                break block0;
                            }
                            default: {
                                state = 5;
                                break block0;
                            }
                        }
                    }
                    block145: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits > 0) {
                                    ++nTrailingZeroes;
                                    continue block145;
                                }
                                --exponent;
                                continue block145;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= ConvertDouble.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block145;
                                }
                                state = 10;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 9;
                                break;
                            }
                            case 95: {
                                continue block145;
                            }
                            default: {
                                state = 5;
                                break;
                            }
                        }
                        break block0;
                    }
                }
                case 5: {
                    if (nDigits == 0) {
                        if (i + 1 < buflen) {
                            if (!(ival != 110 && ival != 78 || bytes[i] != 97 && bytes[i] != 65 || bytes[i + 1] != 110 && bytes[i + 1] != 78)) {
                                return NaN;
                            }
                            if (!(ival != 105 && ival != 73 || bytes[i] != 110 && bytes[i] != 78 || bytes[i + 1] != 102 && bytes[i + 1] != 70)) {
                                return negative != false ? -Infinity : Infinity;
                            }
                        }
                        return negative != false ? -0.0 : 0.0;
                    }
                    exponent = decPos < 0 ? (exponent += nTrailingZeroes) : (exponent += decPos - nDigits);
                    dValue = significand;
                    if (exponent == 0 || dValue == 0.0) {
                        return negative != false ? -dValue : dValue;
                    }
                    if (exponent >= 0) {
                        if (exponent <= ConvertDouble.MAX_SMALL_10) {
                            return negative != false ? -dValue : (dValue *= ConvertDouble.SMALL_10_POWERS[exponent]);
                        }
                        slop = 15 - nDigits;
                        if (exponent <= ConvertDouble.MAX_SMALL_10 + slop) {
                            dValue = dValue * ConvertDouble.SMALL_10_POWERS[slop] * ConvertDouble.SMALL_10_POWERS[exponent - slop];
                            return negative != false ? -dValue : dValue;
                        }
                    } else if (exponent >= -ConvertDouble.MAX_SMALL_10) {
                        return negative != false ? -dValue : (dValue /= ConvertDouble.SMALL_10_POWERS[-exponent]);
                    }
                    state = 10;
                    break;
                }
                case 9: {
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i >= buflen) {
                        state = 5;
                        break;
                    }
                    expSign = 1;
                    expSpec = 0;
                    block44 : switch (bytes[i]) {
                        case 45: {
                            expSign = -1;
                        }
                        case 43: {
                            if (++i >= buflen) {
                                state = 5;
                                break;
                            }
                        }
                        default: {
                            block147: while (i < buflen) {
                                ival = bytes[i++];
                                switch (ival) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        if ((expSpec = expSpec * 10 + (ival - 48)) < MAX_EXP) continue block147;
                                        state = 10;
                                        break block44;
                                    }
                                    case 95: {
                                        continue block147;
                                    }
                                }
                                exponent += expSign * expSpec;
                                state = 5;
                                break block44;
                            }
                            exponent += expSign * expSpec;
                            state = 5;
                            break;
                        }
                    }
                    break;
                }
                case 6: {
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            significand = ival - 48;
                            nDigits = 1;
                            break;
                        }
                        case 46: {
                            state = 7;
                            break block0;
                        }
                        default: {
                            state = 16;
                            break block0;
                        }
                    }
                    block148: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits <= 0) continue block148;
                                ++nTrailingZeroes;
                                continue block148;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= ConvertDouble.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block148;
                                }
                                state = 10;
                                break;
                            }
                            case 46: {
                                state = 7;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 8;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block148;
                                state = 16;
                                break;
                            }
                            default: {
                                --i;
                                while (i < buflen && ConvertDouble.isWhitespace(bytes[i])) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 5;
                    break;
                }
                case 7: {
                    decPos = nDigits + nTrailingZeroes;
                    if (i >= buflen) ** GOTO lbl298
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            if (nDigits > 0) {
                                ++nTrailingZeroes;
                            } else {
                                --exponent;
                            }
                            ** GOTO lbl300
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                significand *= ConvertDouble.LONG_10_POWERS[nTrailingZeroes];
                                nTrailingZeroes = 0;
                            }
                            if (nDigits++ >= 15) ** GOTO lbl292
                            significand = significand * 10L + (long)(ival - 48);
                            ** GOTO lbl300
lbl292:
                            // 1 sources

                            state = 10;
                            break;
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl298:
                    // 1 sources

                    state = 16;
                    break;
lbl300:
                    // 7 sources

                    block150: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                if (nDigits > 0) {
                                    ++nTrailingZeroes;
                                    continue block150;
                                }
                                --exponent;
                                continue block150;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (nTrailingZeroes > 0 && (nDigits += nTrailingZeroes) < 15) {
                                    significand *= ConvertDouble.LONG_10_POWERS[nTrailingZeroes];
                                    nTrailingZeroes = 0;
                                }
                                if (nDigits++ < 15) {
                                    significand = significand * 10L + (long)(ival - 48);
                                    continue block150;
                                }
                                state = 10;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 8;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block150;
                                state = 16;
                                break;
                            }
                            default: {
                                --i;
                                while (i < buflen && ConvertDouble.isWhitespace(bytes[i])) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 5;
                    break;
                }
                case 8: {
                    expSign = 1;
                    expSpec = 0;
                    if (i < buflen) {
                        switch (bytes[i]) {
                            case 45: {
                                expSign = -1;
                            }
                            case 43: {
                                if (++i >= buflen) {
                                    state = 16;
                                    break block0;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        state = 16;
                        break;
                    }
                    if (i >= buflen) ** GOTO lbl359
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            expSpec = ival - 48;
                            ** GOTO lbl361
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl359:
                    // 1 sources

                    state = 16;
                    break;
lbl361:
                    // 3 sources

                    block152: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if ((expSpec = expSpec * 10 + (ival - 48)) < MAX_EXP) continue block152;
                                state = 10;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block152;
                                state = 16;
                                break;
                            }
                            default: {
                                exponent += expSign * expSpec;
                                --i;
                                while (i < buflen && ConvertDouble.isWhitespace(bytes[i])) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    exponent += expSign * expSpec;
                    state = 5;
                    break;
                }
                case 10: {
                    i = startPos;
                    if (negative) {
                        chars = new char[buflen - i + 1];
                        chars[0] = 45;
                        offset = 1;
                    } else {
                        chars = new char[buflen - i];
                    }
                    if (strict) {
                        state = 13;
                        break;
                    }
                    if (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: {
                                break;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                break;
                            }
                            case 46: {
                                state = 11;
                                break block0;
                            }
                            default: {
                                state = 0;
                                break block0;
                            }
                        }
                    }
                    block154: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block154;
                            }
                            case 46: {
                                state = 11;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 12;
                                break;
                            }
                            case 95: {
                                continue block154;
                            }
                            default: {
                                state = 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 11: {
                    chars[offset++] = 46;
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                break;
                            }
                            default: {
                                state = 0;
                                break block0;
                            }
                        }
                    }
                    block156: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block156;
                            }
                            case 69: 
                            case 101: {
                                state = 12;
                                break;
                            }
                            case 95: {
                                continue block156;
                            }
                            default: {
                                state = 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    chars[offset++] = 69;
                    while (i < buflen && bytes[i] == 95) {
                        ++i;
                    }
                    if (i >= buflen) {
                        state = 0;
                        break;
                    }
                    block104 : switch (bytes[i]) {
                        case 43: 
                        case 45: {
                            chars[offset++] = (char)bytes[i];
                            if (++i >= buflen) {
                                state = 0;
                                break;
                            }
                        }
                        default: {
                            block158: while (i < buflen) {
                                ival = bytes[i++];
                                switch (ival) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        chars[offset++] = (char)ival;
                                        lastValidOffset = offset;
                                        continue block158;
                                    }
                                    case 95: {
                                        continue block158;
                                    }
                                }
                                state = 0;
                                break block104;
                            }
                            state = 0;
                            break;
                        }
                    }
                    break;
                }
                case 13: {
                    if (i >= buflen) ** GOTO lbl510
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: {
                            ** GOTO lbl512
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            chars[offset++] = (char)ival;
                            lastValidOffset = offset;
                            ** GOTO lbl512
                        }
                        case 46: {
                            state = 14;
                            break;
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl510:
                    // 1 sources

                    state = 16;
                    break;
lbl512:
                    // 4 sources

                    block159: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block159;
                            }
                            case 46: {
                                state = 14;
                                break;
                            }
                            case 69: 
                            case 101: {
                                state = 15;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block159;
                                state = 16;
                                break;
                            }
                            default: {
                                --i;
                                while (i < buflen && ConvertDouble.isWhitespace(bytes[i])) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 14: {
                    chars[offset++] = 46;
                    if (i >= buflen) ** GOTO lbl552
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            chars[offset++] = (char)ival;
                            lastValidOffset = offset;
                            ** GOTO lbl554
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl552:
                    // 1 sources

                    state = 16;
                    break;
lbl554:
                    // 3 sources

                    block161: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block161;
                            }
                            case 69: 
                            case 101: {
                                state = 15;
                                break;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block161;
                                state = 16;
                                break;
                            }
                            default: {
                                --i;
                                while (i < buflen && ConvertDouble.isWhitespace(bytes[i])) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 15: {
                    chars[offset++] = 69;
                    if (i < buflen) {
                        switch (bytes[i]) {
                            case 43: 
                            case 45: {
                                chars[offset++] = (char)bytes[i];
                                if (++i >= buflen) {
                                    state = 16;
                                    break block0;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        state = 16;
                        break;
                    }
                    if (i >= buflen) ** GOTO lbl601
                    ival = bytes[i++];
                    switch (ival) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            chars[offset++] = (char)ival;
                            lastValidOffset = offset;
                            ** GOTO lbl603
                        }
                        default: {
                            state = 16;
                            break;
                        }
                    }
                    break;
lbl601:
                    // 1 sources

                    state = 16;
                    break;
lbl603:
                    // 3 sources

                    block163: while (i < buflen) {
                        ival = bytes[i++];
                        switch (ival) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                chars[offset++] = (char)ival;
                                lastValidOffset = offset;
                                continue block163;
                            }
                            case 95: {
                                if (i < buflen && bytes[i] >= 48 && bytes[i] <= 57) continue block163;
                                state = 16;
                                break;
                            }
                            default: {
                                --i;
                                while (i < buflen && ConvertDouble.isWhitespace(bytes[i])) {
                                    ++i;
                                }
                                state = i < buflen ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    state = 0;
                    break;
                }
                case 16: {
                    throw new NumberFormatException("does not meet strict criteria");
                }
            }
        }
        if (chars == null || lastValidOffset == 0) {
            return 0.0;
        }
        return Double.parseDouble(new String(chars, 0, lastValidOffset));
    }

    private static final boolean isWhitespace(byte b) {
        return b == 32 || b <= 13 && b >= 9 && b != 11;
    }
}

