/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.CompatVersion;
import org.jruby.RubyInstanceConfig;
import org.jruby.parser.LocalStaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;

public class ParserConfiguration {
    private DynamicScope existingScope = null;
    private boolean asBlock = false;
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean extraPositionInformation = false;
    private boolean isDubyExtensionsEnabled = SafePropertyAccessor.getBoolean("jruby.duby.enabled", false);
    private boolean isDebug = false;
    private CompatVersion version;
    private KCode kCode;

    public ParserConfiguration(KCode kCode, int lineNumber, boolean inlineSource, CompatVersion version) {
        this(kCode, lineNumber, false, inlineSource, version);
    }

    public ParserConfiguration(KCode kCode, int lineNumber, boolean extraPositionInformation, boolean inlineSource, CompatVersion version) {
        this(kCode, lineNumber, extraPositionInformation, inlineSource, true, version);
    }

    public ParserConfiguration(KCode kCode, int lineNumber, boolean extraPositionInformation, boolean inlineSource, boolean isFileParse, CompatVersion version) {
        this.kCode = kCode;
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.extraPositionInformation = extraPositionInformation;
        this.isEvalParse = !isFileParse;
        this.version = version;
    }

    public ParserConfiguration(KCode kCode, int lineNumber, boolean extraPositionInformation, boolean inlineSource, boolean isFileParse, RubyInstanceConfig config) {
        this(kCode, lineNumber, extraPositionInformation, inlineSource, isFileParse, config.getCompatVersion());
        this.isDebug = config.isParserDebug();
    }

    public void setEvalParse(boolean isEvalParse) {
        this.isEvalParse = isEvalParse;
    }

    public void setExtraPositionInformation(boolean extraPositionInformation) {
        this.extraPositionInformation = extraPositionInformation;
    }

    public boolean hasExtraPositionInformation() {
        return this.extraPositionInformation;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public KCode getKCode() {
        return this.kCode;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void parseAsBlock(DynamicScope existingScope) {
        this.asBlock = true;
        this.existingScope = existingScope;
    }

    public DynamicScope getScope() {
        if (this.asBlock) {
            return this.existingScope;
        }
        return new ManyVarsDynamicScope(new LocalStaticScope(null), this.existingScope);
    }

    public CompatVersion getVersion() {
        return this.version;
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }

    public boolean isDubyExtensionsEnabled() {
        return this.isDubyExtensionsEnabled;
    }
}

