/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    private Util() {
    }

    public static final byte int8Value(IRubyObject parameter) {
        long value2 = Util.longValue(parameter);
        if (value2 < -128L || value2 > 127L) {
            throw parameter.getRuntime().newRangeError("Value " + value2 + " outside char range");
        }
        return (byte)value2;
    }

    public static final short uint8Value(IRubyObject parameter) {
        long value2 = Util.longValue(parameter);
        if (value2 < 0L || value2 > 255L) {
            throw parameter.getRuntime().newRangeError("Value " + value2 + " outside unsigned char range");
        }
        return (short)value2;
    }

    public static final short int16Value(IRubyObject parameter) {
        long value2 = Util.longValue(parameter);
        if (value2 < -32768L || value2 > 32767L) {
            throw parameter.getRuntime().newRangeError("Value " + value2 + " outside short range");
        }
        return (short)value2;
    }

    public static final int uint16Value(IRubyObject parameter) {
        long value2 = Util.longValue(parameter);
        if (value2 < 0L || value2 > 65535L) {
            throw parameter.getRuntime().newRangeError("Value " + value2 + " outside unsigned short range");
        }
        return (int)value2;
    }

    public static final int int32Value(IRubyObject parameter) {
        long value2 = Util.longValue(parameter);
        if (value2 < Integer.MIN_VALUE || value2 > 0xFFFFFFFFL) {
            throw parameter.getRuntime().newRangeError("Value " + value2 + " outside integer range");
        }
        return (int)value2;
    }

    public static final long uint32Value(IRubyObject parameter) {
        long value2 = Util.longValue(parameter);
        if (value2 < 0L || value2 > 0xFFFFFFFFL) {
            throw parameter.getRuntime().newRangeError("Value " + value2 + " outside unsigned integer range");
        }
        return value2;
    }

    public static final long int64Value(IRubyObject parameter) {
        return Util.longValue(parameter);
    }

    public static final long uint64Value(IRubyObject parameter) {
        long value2 = parameter instanceof RubyBignum ? ((RubyBignum)parameter).getValue().longValue() : Util.longValue(parameter);
        return value2;
    }

    public static final float floatValue(IRubyObject parameter) {
        return (float)RubyNumeric.num2dbl(parameter);
    }

    public static final double doubleValue(IRubyObject parameter) {
        return RubyNumeric.num2dbl(parameter);
    }

    public static final long longValue(IRubyObject parameter) {
        if (parameter instanceof RubyNumeric) {
            return ((RubyNumeric)parameter).getLongValue();
        }
        if (parameter.isNil()) {
            return 0L;
        }
        if (parameter instanceof RubyString) {
            return Util.longValue((RubyString)parameter);
        }
        throw parameter.getRuntime().newRangeError("Value " + parameter + " is not an integer");
    }

    private static final long longValue(RubyString parameter) {
        String cs = parameter.asJavaString();
        if (cs.length() == 1) {
            return cs.charAt(0);
        }
        throw parameter.getRuntime().newRangeError("Value " + parameter + " is not an integer");
    }

    public static final IRubyObject newSigned8(Ruby runtime2, int value2) {
        return runtime2.newFixnum((value2 &= 0xFF) < 128 ? value2 : -128 + (value2 - 128));
    }

    public static final IRubyObject newUnsigned8(Ruby runtime2, int value2) {
        return runtime2.newFixnum(value2 < 0 ? ((long)value2 & 0x7FL) + 128L : (long)value2);
    }

    public static final IRubyObject newSigned16(Ruby runtime2, int value2) {
        return runtime2.newFixnum((value2 &= 0xFFFF) < 32768 ? value2 : Short.MIN_VALUE + (value2 - 32768));
    }

    public static final IRubyObject newUnsigned16(Ruby runtime2, int value2) {
        return runtime2.newFixnum(value2 < 0 ? ((long)value2 & 0x7FFFL) + 32768L : (long)value2);
    }

    public static final IRubyObject newSigned32(Ruby runtime2, int value2) {
        return runtime2.newFixnum(value2);
    }

    public static final IRubyObject newUnsigned32(Ruby runtime2, int value2) {
        return runtime2.newFixnum(value2 < 0 ? ((long)value2 & Integer.MAX_VALUE) + 0x80000000L : (long)value2);
    }

    public static final IRubyObject newSigned64(Ruby runtime2, long value2) {
        return runtime2.newFixnum(value2);
    }

    public static final IRubyObject newUnsigned64(Ruby runtime2, long value2) {
        return value2 < 0L ? RubyBignum.newBignum(runtime2, BigInteger.valueOf(value2 & Long.MAX_VALUE).add(UINT64_BASE)) : runtime2.newFixnum(value2);
    }

    @Deprecated
    public static final <T> T convertParameter(IRubyObject parameter, Class<T> paramClass) {
        return paramClass.cast(parameter instanceof JavaObject ? ((JavaObject)parameter).getValue() : parameter.toJava(paramClass));
    }

    public static final ByteBuffer slice(ByteBuffer buf, int offset2) {
        ByteBuffer tmp = buf.duplicate();
        tmp.position(offset2);
        return tmp.slice();
    }

    public static final void checkStringSafety(Ruby runtime2, IRubyObject value2) {
        RubyString s = value2.asString();
        if (runtime2.getSafeLevel() > 0 && s.isTaint()) {
            throw runtime2.newSecurityError("Unsafe string parameter");
        }
        ByteList bl = s.getByteList();
        byte[] array = bl.getUnsafeBytes();
        int end2 = bl.length();
        for (int i = bl.begin(); i < end2; ++i) {
            if (array[i] != 0) continue;
            throw runtime2.newSecurityError("string contains null byte");
        }
    }

    public static final void checkBounds(Ruby runtime2, long size2, long off, long len) {
        if ((off | len | off + len | size2 - (off + len)) < 0L) {
            throw runtime2.newIndexError("Memory access offset=" + off + " size=" + len + " is out of bounds");
        }
    }
}

