/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Enum;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructByValue;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"StructLayoutBuilder"}, parent="Object")
public final class StructLayoutBuilder
extends RubyObject {
    public static final String CLASS_NAME = "StructLayoutBuilder";
    private final List<RubySymbol> fieldNames = new LinkedList<RubySymbol>();
    private final Map<IRubyObject, StructLayout.Member> fields = new LinkedHashMap<IRubyObject, StructLayout.Member>();
    private int size = 0;
    private int minAlign = 1;
    private int fieldCount = 0;
    private boolean isUnion = false;

    public static RubyClass createStructLayoutBuilderClass(Ruby runtime2, RubyModule module) {
        RubyClass result = runtime2.defineClassUnder(CLASS_NAME, runtime2.getObject(), Allocator.INSTANCE, module);
        result.defineAnnotatedMethods(StructLayoutBuilder.class);
        result.defineAnnotatedConstants(StructLayoutBuilder.class);
        return result;
    }

    StructLayoutBuilder(Ruby runtime2) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass(CLASS_NAME));
    }

    StructLayoutBuilder(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static StructLayoutBuilder newInstance(ThreadContext context, IRubyObject recv2) {
        return new StructLayoutBuilder(context.getRuntime());
    }

    @JRubyMethod(name={"build"})
    public StructLayout build(ThreadContext context) {
        return new StructLayout(context.getRuntime(), this.fieldNames, this.fields, this.minAlign + (this.size - 1 & ~(this.minAlign - 1)), this.minAlign);
    }

    @JRubyMethod(name={"size"})
    public IRubyObject get_size(ThreadContext context) {
        return context.getRuntime().newFixnum(this.size);
    }

    @JRubyMethod(name={"size="})
    public IRubyObject set_size(ThreadContext context, IRubyObject sizeArg) {
        int newSize = RubyNumeric.num2int(sizeArg);
        if (newSize > this.size) {
            this.size = newSize;
        }
        return context.getRuntime().newFixnum(this.size);
    }

    private static final int alignMember(int offset2, int align) {
        return align + (offset2 - 1 & ~(align - 1));
    }

    private static final RubySymbol createSymbolKey(Ruby runtime2, IRubyObject key2) {
        if (key2 instanceof RubySymbol) {
            return (RubySymbol)key2;
        }
        return runtime2.getSymbolTable().getSymbol(key2.asJavaString());
    }

    private static IRubyObject createStringKey(Ruby runtime2, IRubyObject key2) {
        return RubyString.newString(runtime2, key2.asJavaString());
    }

    private final IRubyObject storeField(Ruby runtime2, IRubyObject name2, StructLayout.Member field2, int align, int size2) {
        this.fields.put(StructLayoutBuilder.createStringKey(runtime2, name2), field2);
        this.fields.put(StructLayoutBuilder.createSymbolKey(runtime2, name2), field2);
        this.fieldNames.add(StructLayoutBuilder.createSymbolKey(runtime2, name2));
        this.size = Math.max(this.size, (int)field2.offset + size2);
        this.minAlign = Math.max(this.minAlign, align);
        return this;
    }

    @JRubyMethod(name={"union="})
    public IRubyObject set_union(ThreadContext context, IRubyObject isUnion) {
        this.isUnion = isUnion.isTrue();
        return this;
    }

    private final int calculateOffset(IRubyObject[] args2, int index2, int alignment2) {
        return args2.length > index2 && args2[index2] instanceof RubyInteger ? Util.int32Value(args2[index2]) : (this.isUnion ? 0 : StructLayoutBuilder.alignMember(this.size, alignment2));
    }

    private static final boolean checkFieldName(Ruby runtime2, IRubyObject fieldName) {
        if (!(fieldName instanceof RubyString) && !(fieldName instanceof RubySymbol)) {
            throw runtime2.newTypeError("wrong argument type " + fieldName.getMetaClass().getName() + " (expected String or Symbol)");
        }
        return true;
    }

    @JRubyMethod(name={"add_field"}, required=2, optional=1)
    public IRubyObject add(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject fieldName = args2[0];
        StructLayoutBuilder.checkFieldName(runtime2, fieldName);
        if (!(args2[1] instanceof Type)) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected FFI::Type)");
        }
        Type type2 = (Type)args2[1];
        int offset2 = this.calculateOffset(args2, 2, type2.getNativeAlignment());
        StructLayout.Member field2 = null;
        if (type2 instanceof Type.Array) {
            Type.Array arrayType = (Type.Array)type2;
            field2 = new StructLayout.ArrayMember(fieldName, arrayType, this.fieldCount, offset2, MemoryOp.getMemoryOp(arrayType.getComponentType()));
        } else if (type2 instanceof StructByValue) {
            StructByValue sbv = (StructByValue)type2;
            field2 = new StructLayout.StructMember(fieldName, sbv.getStructLayout(), sbv.getStructClass(), this.fieldCount, offset2);
        } else if (type2 instanceof CallbackInfo) {
            field2 = new StructLayout.CallbackMember(fieldName, (CallbackInfo)type2, this.fieldCount, (long)offset2);
        } else if (type2 instanceof Enum) {
            field2 = new StructLayout.EnumMember(fieldName, (Enum)type2, this.fieldCount, (long)offset2);
        }
        if (type2 instanceof Type.Builtin) {
            field2 = StructLayoutBuilder.createBuiltinMember(fieldName, (Type.Builtin)type2, this.fieldCount, offset2);
        }
        if (field2 == null) {
            throw runtime2.newArgumentError("Unknown field type: " + type2);
        }
        ++this.fieldCount;
        return this.storeField(runtime2, fieldName, field2, type2.getNativeAlignment(), type2.getNativeSize());
    }

    @JRubyMethod(name={"add_struct"}, required=2, optional=1)
    public IRubyObject add_struct(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject fieldName = args2[0];
        StructLayoutBuilder.checkFieldName(runtime2, fieldName);
        if (!(args2[1] instanceof RubyClass) || !((RubyClass)args2[1]).isKindOfModule(runtime2.fastGetModule("FFI").fastGetClass("Struct"))) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected FFI::Struct subclass)");
        }
        StructLayout layout = Struct.getStructLayout(runtime2, args2[1]);
        int offset2 = this.calculateOffset(args2, 2, layout.getNativeAlignment());
        StructLayout.StructMember field2 = new StructLayout.StructMember(fieldName, layout, (RubyClass)args2[1], this.fieldCount++, offset2);
        return this.storeField(runtime2, fieldName, field2, layout.getNativeAlignment(), layout.getNativeSize());
    }

    @JRubyMethod(name={"add_array"}, required=3, optional=1)
    public IRubyObject add_array(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject fieldName = args2[0];
        StructLayoutBuilder.checkFieldName(runtime2, fieldName);
        if (!(args2[1] instanceof Type)) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected FFI::Type)");
        }
        if (!(args2[2] instanceof RubyInteger)) {
            throw runtime2.newTypeError("wrong argument type " + args2[2].getMetaClass().getName() + " (expected Integer)");
        }
        Type type2 = (Type)args2[1];
        int offset2 = this.calculateOffset(args2, 3, type2.getNativeAlignment());
        int length2 = Util.int32Value(args2[2]);
        MemoryOp op = MemoryOp.getMemoryOp(type2);
        if (op == null) {
            throw context.getRuntime().newNotImplementedError("Unsupported array field type: " + type2);
        }
        StructLayout.ArrayMember field2 = new StructLayout.ArrayMember(fieldName, new Type.Array(runtime2, type2, length2), this.fieldCount++, offset2, op);
        return this.storeField(runtime2, fieldName, field2, type2.getNativeAlignment(), type2.getNativeSize() * length2);
    }

    @JRubyMethod(name={"add_char_array"}, required=2, optional=1)
    public IRubyObject add_char_array(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject fieldName = args2[0];
        StructLayoutBuilder.checkFieldName(runtime2, fieldName);
        if (!(args2[1] instanceof RubyInteger)) {
            throw runtime2.newTypeError("wrong argument type " + args2[1].getMetaClass().getName() + " (expected Integer)");
        }
        int strlen = Util.int32Value(args2[1]);
        int offset2 = this.calculateOffset(args2, 2, 1);
        Type type2 = (Type)context.getRuntime().fastGetModule("FFI").fastGetClass("Type").fastFetchConstant("INT8");
        return this.storeField(runtime2, args2[0], new StructLayout.CharArrayMember(fieldName, type2, this.fieldCount++, offset2, strlen), 1, strlen);
    }

    static StructLayout.Member createBuiltinMember(IRubyObject name2, Type.Builtin type2, int index2, long offset2) {
        switch (type2.getNativeType()) {
            case BOOL: 
            case CHAR: 
            case UCHAR: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: 
            case LONG_LONG: 
            case ULONG_LONG: 
            case LONG: 
            case ULONG: 
            case FLOAT: 
            case DOUBLE: {
                return new StructLayout.PrimitiveMember(name2, type2, index2, offset2);
            }
            case POINTER: {
                return new StructLayout.PointerMember(name2, type2, index2, offset2);
            }
            case STRING: 
            case RBXSTRING: {
                return new StructLayout.StringMember(name2, type2, index2, offset2);
            }
        }
        return null;
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StructLayoutBuilder(runtime2, klass);
        }
    }
}

