/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;

public class IOModule {
    public static void createIOModule(Ruby runtime2, RubyModule ffi2) {
        RubyModule module = ffi2.defineModuleUnder("IO");
        module.defineAnnotatedMethods(IOModule.class);
    }

    @JRubyMethod(name={"native_read"}, module=true)
    public static final IRubyObject native_read(ThreadContext context, IRubyObject self, IRubyObject src, IRubyObject dst, IRubyObject rbLength) {
        if (!(src instanceof RubyIO)) {
            throw context.getRuntime().newTypeError("wrong argument (expected IO)");
        }
        if (!(dst instanceof AbstractMemory)) {
            throw context.getRuntime().newTypeError("wrong argument (expected FFI memory)");
        }
        Ruby runtime2 = context.getRuntime();
        try {
            OpenFile openFile = ((RubyIO)src).getOpenFile();
            openFile.checkClosed(runtime2);
            openFile.checkReadable(runtime2);
            ChannelStream stream = (ChannelStream)openFile.getMainStream();
            ByteBuffer buffer = ((AbstractMemory)dst).getMemoryIO().asByteBuffer();
            int count2 = RubyNumeric.num2int(rbLength);
            if (count2 > buffer.remaining()) {
                throw runtime2.newIndexError("read count too big for output buffer");
            }
            if (count2 < buffer.remaining()) {
                buffer = buffer.duplicate();
                buffer.limit(count2);
            }
            return runtime2.newFixnum(stream.read(buffer));
        }
        catch (PipeException ex) {
            throw runtime2.newErrnoEPIPEError();
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        catch (EOFException e) {
            return runtime2.newFixnum(-1);
        }
        catch (BadDescriptorException e) {
            throw runtime2.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
    }
}

