/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.math.BigInteger;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.operands.Constant;
import org.jruby.compiler.ir.operands.Float;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;

public class Fixnum
extends Constant {
    public final Long _value;

    public Fixnum(Long val) {
        this._value = val;
    }

    public Fixnum(BigInteger val) {
        this._value = val.longValue();
    }

    public String toString() {
        return this._value + ":fixnum";
    }

    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        return argIndex == 0 ? this : Nil.NIL;
    }

    public IR_Class getTargetClass() {
        return IR_Class.getCoreClass("Fixnum");
    }

    public Constant computeValue(String methodName, Constant arg2) {
        if (arg2 instanceof Fixnum) {
            if (methodName.equals("+")) {
                return new Fixnum(this._value + ((Fixnum)arg2)._value);
            }
            if (methodName.equals("-")) {
                return new Fixnum(this._value - ((Fixnum)arg2)._value);
            }
            if (methodName.equals("*")) {
                return new Fixnum(this._value * ((Fixnum)arg2)._value);
            }
            if (methodName.equals("/")) {
                Long divisor = ((Fixnum)arg2)._value;
                return divisor == 0L ? null : new Fixnum(this._value / divisor);
            }
        } else if (arg2 instanceof Float) {
            if (methodName.equals("+")) {
                return new Float((double)this._value.longValue() + ((Float)arg2)._value);
            }
            if (methodName.equals("-")) {
                return new Float((double)this._value.longValue() - ((Float)arg2)._value);
            }
            if (methodName.equals("*")) {
                return new Float((double)this._value.longValue() * ((Float)arg2)._value);
            }
            if (methodName.equals("/")) {
                Double divisor = ((Float)arg2)._value;
                return divisor == 0.0 ? null : new Float((double)this._value.longValue() / divisor);
            }
        }
        return null;
    }
}

