/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.HashMap;
import java.util.Map;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IR_Class;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.IR_ScopeImpl;
import org.jruby.compiler.ir.instructions.ReceiveArgumentInstruction;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;

public class IR_Module
extends IR_ScopeImpl {
    private static final String ROOT_METHOD_PREFIX = ":_ROOT_:";
    private static Map<String, IR_Class> _coreClasses;
    public final String _name;
    private IRMethod _rootMethod;
    private CodeVersion _version;

    private static IR_Class addCoreClass(String name2, IR_Scope parent, String[] coreMethods) {
        IR_Class c = new IR_Class(parent, null, null, name2);
        _coreClasses.put(c.getName(), c);
        if (coreMethods != null) {
            for (String m : coreMethods) {
                IRMethod meth = new IRMethod(c, null, m, true);
                meth.setCodeModificationFlag(false);
                c.addMethod(meth);
            }
        }
        return c;
    }

    public static void bootStrap() {
        _coreClasses = new HashMap<String, IR_Class>();
        IR_Class obj = IR_Module.addCoreClass("Object", null, null);
        IR_Module.addCoreClass("Class", IR_Module.addCoreClass("Module", obj, null), null);
        IR_Module.addCoreClass("Fixnum", obj, new String[]{"+", "-", "/", "*"});
        IR_Module.addCoreClass("Float", obj, new String[]{"+", "-", "/", "*"});
        IR_Module.addCoreClass("Array", obj, new String[]{"[]", "each", "inject"});
        IR_Module.addCoreClass("Range", obj, new String[]{"each"});
        IR_Module.addCoreClass("Hash", obj, new String[]{"each"});
        IR_Module.addCoreClass("String", obj, null);
        IR_Module.addCoreClass("Proc", obj, null);
    }

    public static IR_Class getCoreClass(String n) {
        return _coreClasses.get(n);
    }

    public static boolean isAClassRootMethod(IRMethod m) {
        return m.getName().startsWith(ROOT_METHOD_PREFIX);
    }

    private void addRootMethod() {
        String n = ROOT_METHOD_PREFIX + this._name;
        this._rootMethod = new IRMethod(this, new MetaObject(this), n, false);
        this._rootMethod.addInstr(new ReceiveArgumentInstruction(this._rootMethod.getSelf(), 0));
        this.addMethod(this._rootMethod);
    }

    public IR_Module(IR_Scope lexicalParent, Operand container, String name2) {
        super(lexicalParent, container);
        this._name = name2;
        this.addRootMethod();
        this.updateVersion();
    }

    public void updateVersion() {
        this._version = CodeVersion.getClassVersionToken();
    }

    public CodeVersion getVersion() {
        return this._version;
    }

    public IRMethod getRootMethod() {
        return this._rootMethod;
    }

    public IRMethod getInstanceMethod(String name2) {
        for (IRMethod m : this.methods) {
            if (!m.isInstanceMethod || !m.getName().equals(name2)) continue;
            return m;
        }
        return null;
    }

    public IRMethod getClassMethod(String name2) {
        for (IRMethod m : this.methods) {
            if (m.isInstanceMethod || !this._name.equals(name2)) continue;
            return m;
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return "Module: " + this.getName() + super.toString();
    }

    static {
        IR_Module.bootStrap();
    }
}

