/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Random;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Random"})
public class RubyRandom
extends RubyObject {
    private static final Random random = new Random();
    private IRubyObject seed;
    private static ObjectAllocator RANDOM_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyRandom(runtime2, klass);
        }
    };

    public static RubyClass createRandomClass(Ruby runtime2) {
        RubyClass randomClass = runtime2.defineClass("Random", runtime2.getObject(), RANDOM_ALLOCATOR);
        runtime2.setRandomClass(randomClass);
        randomClass.defineAnnotatedMethods(RubyRandom.class);
        return randomClass;
    }

    private RubyRandom(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        this.seed = RubyBignum.newBignum(runtime2, random.nextLong());
        return this;
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        this.seed = arg2 instanceof RubyFloat ? RubyBignum.num2fix(((RubyFloat)arg2).truncate()) : arg2.convertToInteger();
        return this;
    }

    @JRubyMethod(name={"seed"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject seed(ThreadContext context) {
        return this.seed;
    }
}

