/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.Qsort;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Array"})
public class RubyArray
extends RubyObject
implements List {
    private static ObjectAllocator ARRAY_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyArray(runtime2, klass, IRubyObject.NULL_ARRAY);
        }
    };
    public static final int ARRAY_DEFAULT_SIZE = 16;
    private volatile IRubyObject[] values;
    private static final int TMPLOCK_ARR_F = 512;
    private static final int TMPLOCK_OR_FROZEN_ARR_F = 516;
    private volatile boolean isShared = false;
    private int begin = 0;
    private int realLength = 0;
    private static int SORTED_THRESHOLD = 10;

    public static RubyClass createArrayClass(Ruby runtime2) {
        RubyClass arrayc = runtime2.defineClass("Array", runtime2.getObject(), ARRAY_ALLOCATOR);
        runtime2.setArray(arrayc);
        arrayc.index = 3;
        arrayc.setReifiedClass(RubyArray.class);
        arrayc.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyArray;
            }
        };
        arrayc.includeModule(runtime2.getEnumerable());
        arrayc.defineAnnotatedMethods(RubyArray.class);
        return arrayc;
    }

    @Override
    public int getNativeTypeIndex() {
        return 3;
    }

    private final void concurrentModification() {
        throw this.getRuntime().newConcurrencyError("Detected invalid array contents due to unsynchronized modifications with concurrent users");
    }

    @JRubyMethod(name={"[]"}, rest=true, frame=true, meta=true)
    public static IRubyObject create(IRubyObject klass, IRubyObject[] args2, Block block) {
        RubyArray arr = (RubyArray)((RubyClass)klass).allocate();
        if (args2.length > 0) {
            arr.values = new IRubyObject[args2.length];
            System.arraycopy(args2, 0, arr.values, 0, args2.length);
            arr.realLength = args2.length;
        }
        return arr;
    }

    public static final RubyArray newArray(Ruby runtime2, long len) {
        RubyArray.checkLength(runtime2, len);
        return RubyArray.newArray(runtime2, (int)len);
    }

    public static final RubyArray newArrayLight(Ruby runtime2, long len) {
        RubyArray.checkLength(runtime2, len);
        return RubyArray.newArrayLight(runtime2, (int)len);
    }

    public static final RubyArray newArray(Ruby runtime2, int len) {
        RubyArray array = new RubyArray(runtime2, len);
        RuntimeHelpers.fillNil(array.values, 0, array.values.length, runtime2);
        return array;
    }

    public static final RubyArray newArrayLight(Ruby runtime2, int len) {
        RubyArray array = new RubyArray(runtime2, len, false);
        RuntimeHelpers.fillNil(array.values, 0, array.values.length, runtime2);
        return array;
    }

    public static final RubyArray newArray(Ruby runtime2) {
        return RubyArray.newArray(runtime2, 16);
    }

    public static final RubyArray newArrayLight(Ruby runtime2) {
        return RubyArray.newArrayLight(runtime2, 16);
    }

    public static RubyArray newArray(Ruby runtime2, IRubyObject obj) {
        return new RubyArray(runtime2, new IRubyObject[]{obj});
    }

    public static RubyArray newArrayLight(Ruby runtime2, IRubyObject obj) {
        return new RubyArray(runtime2, new IRubyObject[]{obj}, false);
    }

    public static RubyArray newArrayLight(Ruby runtime2, IRubyObject ... objs) {
        return new RubyArray(runtime2, objs, false);
    }

    public static RubyArray newArray(Ruby runtime2, IRubyObject car, IRubyObject cdr) {
        return new RubyArray(runtime2, new IRubyObject[]{car, cdr});
    }

    public static RubyArray newEmptyArray(Ruby runtime2) {
        return new RubyArray(runtime2, NULL_ARRAY);
    }

    public static RubyArray newArray(Ruby runtime2, IRubyObject[] args2) {
        RubyArray arr = new RubyArray(runtime2, new IRubyObject[args2.length]);
        System.arraycopy(args2, 0, arr.values, 0, args2.length);
        arr.realLength = args2.length;
        return arr;
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2) {
        return new RubyArray(runtime2, args2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2, int begin2) {
        return new RubyArray(runtime2, args2, begin2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2, int begin2, int length2) {
        assert (begin2 >= 0) : "begin must be >= 0";
        assert (length2 >= 0) : "length must be >= 0";
        return new RubyArray(runtime2, args2, begin2, length2);
    }

    public static RubyArray newArrayNoCopyLight(Ruby runtime2, IRubyObject[] args2) {
        RubyArray arr = new RubyArray(runtime2, false);
        arr.values = args2;
        arr.realLength = args2.length;
        return arr;
    }

    public static RubyArray newArray(Ruby runtime2, Collection<? extends IRubyObject> collection) {
        return new RubyArray(runtime2, collection.toArray(new IRubyObject[collection.size()]));
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals) {
        super(runtime2, runtime2.getArray());
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals, boolean objectSpace) {
        super(runtime2, runtime2.getArray(), objectSpace);
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals, int begin2) {
        super(runtime2, runtime2.getArray());
        this.values = vals;
        this.begin = begin2;
        this.realLength = vals.length - begin2;
        this.isShared = true;
    }

    private RubyArray(Ruby runtime2, IRubyObject[] vals, int begin2, int length2) {
        super(runtime2, runtime2.getArray());
        this.values = vals;
        this.begin = begin2;
        this.realLength = length2;
        this.isShared = true;
    }

    private RubyArray(Ruby runtime2, int length2) {
        super(runtime2, runtime2.getArray());
        this.values = new IRubyObject[length2];
    }

    private RubyArray(Ruby runtime2, int length2, boolean objectspace) {
        super(runtime2, runtime2.getArray(), objectspace);
        this.values = new IRubyObject[length2];
    }

    private RubyArray(Ruby runtime2, boolean objectSpace) {
        super(runtime2, runtime2.getArray(), objectSpace);
    }

    private RubyArray(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, int length2) {
        super(runtime2, klass);
        this.values = new IRubyObject[length2];
    }

    private RubyArray(Ruby runtime2, RubyClass klass, IRubyObject[] vals, boolean objectspace) {
        super(runtime2, klass, objectspace);
        this.values = vals;
    }

    private RubyArray(Ruby runtime2, RubyClass klass, boolean objectSpace) {
        super(runtime2, klass, objectSpace);
    }

    private RubyArray(Ruby runtime2, RubyClass klass, RubyArray original) {
        super(runtime2, klass);
        this.realLength = original.realLength;
        this.values = new IRubyObject[this.realLength];
        try {
            System.arraycopy(original.values, original.begin, this.values, 0, this.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
    }

    private RubyArray(Ruby runtime2, RubyClass klass, IRubyObject[] vals) {
        super(runtime2, klass);
        this.values = vals;
        this.realLength = vals.length;
    }

    private void alloc(int length2) {
        IRubyObject[] newValues = new IRubyObject[length2];
        RuntimeHelpers.fillNil(newValues, this.getRuntime());
        this.values = newValues;
        this.begin = 0;
    }

    private void realloc(int newLength, int valuesLength) {
        IRubyObject[] reallocated = new IRubyObject[newLength];
        try {
            if (newLength > valuesLength) {
                RuntimeHelpers.fillNil(reallocated, valuesLength, newLength, this.getRuntime());
                System.arraycopy(this.values, this.begin, reallocated, 0, valuesLength);
            } else {
                System.arraycopy(this.values, this.begin, reallocated, 0, newLength);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        this.begin = 0;
        this.values = reallocated;
    }

    private static void fill(IRubyObject[] arr, int from, int to, IRubyObject with) {
        for (int i = from; i < to; ++i) {
            arr[i] = with;
        }
    }

    private static final void checkLength(Ruby runtime2, long length2) {
        if (length2 < 0L) {
            throw runtime2.newArgumentError("negative array size (or size too big)");
        }
        if (length2 >= Integer.MAX_VALUE) {
            throw runtime2.newArgumentError("array size too big");
        }
    }

    public List getList() {
        return Arrays.asList(this.toJavaArray());
    }

    public int getLength() {
        return this.realLength;
    }

    public IRubyObject[] toJavaArray() {
        IRubyObject[] copy = new IRubyObject[this.realLength];
        try {
            System.arraycopy(this.values, this.begin, copy, 0, this.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return copy;
    }

    public IRubyObject[] toJavaArrayUnsafe() {
        return !this.isShared ? this.values : this.toJavaArray();
    }

    public IRubyObject[] toJavaArrayMaybeUnsafe() {
        return !this.isShared && this.begin == 0 && this.values.length == this.realLength ? this.values : this.toJavaArray();
    }

    private RubyArray makeShared() {
        return this.makeShared(this.begin, this.realLength, this.getMetaClass());
    }

    private RubyArray makeShared(int beg, int len, RubyClass klass) {
        return this.makeShared(beg, len, new RubyArray(klass.getRuntime(), klass));
    }

    private RubyArray makeShared(int beg, int len, RubyArray sharedArray) {
        this.isShared = true;
        sharedArray.values = this.values;
        sharedArray.isShared = true;
        sharedArray.begin = beg;
        sharedArray.realLength = len;
        return sharedArray;
    }

    private RubyArray makeSharedFirst(ThreadContext context, IRubyObject num, boolean last2) {
        int n = RubyNumeric.num2int(num);
        if (n > this.realLength) {
            n = this.realLength;
        } else if (n < 0) {
            throw context.getRuntime().newArgumentError("negative array size");
        }
        return this.makeShared(last2 ? this.realLength - n : 0, n, this.getMetaClass());
    }

    private RubyArray makeSharedFirst(ThreadContext context, IRubyObject num, boolean last2, RubyClass klass) {
        int n = RubyNumeric.num2int(num);
        if (n > this.realLength) {
            n = this.realLength;
        } else if (n < 0) {
            throw context.getRuntime().newArgumentError("negative array size");
        }
        return this.makeShared(last2 ? this.realLength - n : 0, n, klass);
    }

    private final void modifyCheck() {
        if ((this.flags & 0x204) != 0) {
            if ((this.flags & 4) != 0) {
                throw this.getRuntime().newFrozenError("array");
            }
            if ((this.flags & 0x200) != 0) {
                throw this.getRuntime().newTypeError("can't modify array during iteration");
            }
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify array");
        }
    }

    private final void modify() {
        this.modifyCheck();
        if (this.isShared) {
            IRubyObject[] vals = new IRubyObject[this.realLength];
            this.isShared = false;
            try {
                System.arraycopy(this.values, this.begin, vals, 0, this.realLength);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.begin = 0;
            this.values = vals;
        }
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.initialize(context, block);
            }
            case 1: {
                return this.initializeCommon(context, args2[0], null, block);
            }
            case 2: {
                return this.initializeCommon(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 2);
        return null;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        this.modifyCheck();
        Ruby runtime2 = context.getRuntime();
        this.realLength = 0;
        if (block.isGiven() && runtime2.isVerbose()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, Block block) {
        return this.initializeCommon(context, arg0, null, block);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.initializeCommon(context, arg0, arg1, block);
    }

    private IRubyObject initializeCommon(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject val;
        Ruby runtime2 = context.getRuntime();
        if (arg1 == null && !(arg0 instanceof RubyFixnum) && !(val = arg0.checkArrayType()).isNil()) {
            this.replace(val);
            return this;
        }
        long len = RubyNumeric.num2long(arg0);
        if (len < 0L) {
            throw runtime2.newArgumentError("negative array size");
        }
        if (len >= Integer.MAX_VALUE) {
            throw runtime2.newArgumentError("array size too big");
        }
        int ilen = (int)len;
        this.modify();
        if (ilen > this.values.length - this.begin) {
            this.values = new IRubyObject[ilen];
            this.begin = 0;
        }
        if (block.isGiven()) {
            if (arg1 != null) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
            }
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject nil = runtime2.getNil();
                for (int i = 0; i < ilen; ++i) {
                    this.store(i, block.yield(context, nil));
                    this.realLength = i + 1;
                }
            } else {
                for (int i = 0; i < ilen; ++i) {
                    this.store(i, block.yield(context, RubyFixnum.newFixnum(runtime2, i)));
                    this.realLength = i + 1;
                }
            }
        } else {
            try {
                if (arg1 == null) {
                    RuntimeHelpers.fillNil(this.values, this.begin, this.begin + ilen, runtime2);
                } else {
                    RubyArray.fill(this.values, this.begin, this.begin + ilen, arg1);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = ilen;
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject orig) {
        return this.replace(orig);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public IRubyObject replace(IRubyObject orig) {
        this.modifyCheck();
        RubyArray origArr = orig.convertToArray();
        if (this == orig) {
            return this;
        }
        origArr.isShared = true;
        this.isShared = true;
        this.values = origArr.values;
        this.realLength = origArr.realLength;
        this.begin = origArr.begin;
        return this;
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.getRuntime().is1_9()) {
            return this.inspect();
        }
        if (this.realLength == 0) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        return this.join(this.getRuntime().getCurrentContext(), this.getRuntime().getGlobalVariables().get("$,"));
    }

    public boolean includes(ThreadContext context, IRubyObject item) {
        int begin2;
        for (int i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            IRubyObject value2;
            try {
                value2 = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                continue;
            }
            if (!RubyArray.equalInternal(context, value2, item)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isInspecting(this)) {
            return RubyFixnum.zero(runtime2);
        }
        try {
            runtime2.registerInspecting(this);
            int begin2 = this.begin;
            int h = this.realLength;
            for (int i = begin2; i < begin2 + this.realLength; ++i) {
                IRubyObject value2;
                h = h << 1 | (h < 0 ? 1 : 0);
                try {
                    value2 = this.values[i];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.concurrentModification();
                    continue;
                }
                h = (int)((long)h ^ RubyNumeric.num2long(value2.callMethod(context, "hash")));
            }
            RubyFixnum rubyFixnum = runtime2.newFixnum(h);
            return rubyFixnum;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"hash"}, compat=CompatVersion.RUBY1_9)
    public RubyFixnum hash19(final ThreadContext context) {
        return (RubyFixnum)this.getRuntime().execRecursiveOuter(new Ruby.RecursiveFunction(){

            public IRubyObject call(IRubyObject obj, boolean recur) {
                int begin2 = RubyArray.this.begin;
                long h = RubyArray.this.realLength;
                if (recur) {
                    h ^= RubyNumeric.num2long(RubyArray.this.getRuntime().getArray().callMethod(context, "hash"));
                } else {
                    for (int i = begin2; i < begin2 + RubyArray.this.realLength; ++i) {
                        IRubyObject value2;
                        h = h << 1 | (long)(h < 0L ? 1 : 0);
                        try {
                            value2 = RubyArray.this.values[i];
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            RubyArray.this.concurrentModification();
                            continue;
                        }
                        h ^= RubyNumeric.num2long(value2.callMethod(context, "hash"));
                    }
                }
                return RubyArray.this.getRuntime().newFixnum(h);
            }
        }, this);
    }

    public final IRubyObject store(long index2, IRubyObject value2) {
        if (index2 < 0L && (index2 += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (index2 - (long)this.realLength) + " out of array");
        }
        this.modify();
        if (index2 >= (long)this.realLength) {
            int valuesLength = this.values.length - this.begin;
            if (index2 >= (long)valuesLength) {
                this.storeRealloc(index2, valuesLength);
            }
            this.realLength = (int)index2 + 1;
        }
        try {
            this.values[this.begin + (int)index2] = value2;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return value2;
    }

    private void storeRealloc(long index2, int valuesLength) {
        long newLength = valuesLength >> 1;
        if (newLength < 16L) {
            newLength = 16L;
        }
        if (index2 >= Integer.MAX_VALUE || (newLength += index2) >= Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("index too big");
        }
        this.realloc((int)newLength, valuesLength);
    }

    private final IRubyObject elt(long offset2) {
        if (offset2 < 0L || offset2 >= (long)this.realLength) {
            return this.getRuntime().getNil();
        }
        return this.eltOk(offset2);
    }

    private final IRubyObject eltOk(long offset2) {
        try {
            return this.values[this.begin + (int)offset2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
    }

    public final IRubyObject entry(long offset2) {
        return offset2 < 0L ? this.elt(offset2 + (long)this.realLength) : this.elt(offset2);
    }

    public final IRubyObject entry(int offset2) {
        return offset2 < 0 ? this.elt(offset2 + this.realLength) : this.elt(offset2);
    }

    public final IRubyObject eltInternal(int offset2) {
        return this.values[this.begin + offset2];
    }

    public final IRubyObject eltInternalSet(int offset2, IRubyObject item) {
        IRubyObject iRubyObject = item;
        this.values[this.begin + offset2] = iRubyObject;
        return iRubyObject;
    }

    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.fetch(context, args2[0], block);
            }
            case 2: {
                return this.fetch(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"fetch"}, frame=true)
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, Block block) {
        long index2 = RubyNumeric.num2long(arg0);
        if (index2 < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            throw this.getRuntime().newIndexError("index " + index2 + " out of array");
        }
        try {
            return this.values[this.begin + (int)index2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
    }

    @JRubyMethod(name={"fetch"}, frame=true)
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        long index2;
        if (block.isGiven()) {
            this.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument", new Object[0]);
        }
        if ((index2 = RubyNumeric.num2long(arg0)) < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            return arg1;
        }
        try {
            return this.values[this.begin + (int)index2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return this.getRuntime().getNil();
        }
    }

    private static RubyArray aryToAry(IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return (RubyArray)obj;
        }
        if (obj.respondsTo("to_ary")) {
            return obj.convertToArray();
        }
        RubyArray arr = new RubyArray(obj.getRuntime(), false);
        arr.values = new IRubyObject[]{obj};
        arr.realLength = 1;
        return arr;
    }

    private final void splice(long beg, long len, IRubyObject rpl) {
        int rlen;
        RubyArray rplArr;
        if (len < 0L) {
            throw this.getRuntime().newIndexError("negative length (" + len + ")");
        }
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (beg - (long)this.realLength) + " out of array");
        }
        if (rpl == null || rpl.isNil()) {
            rplArr = null;
            rlen = 0;
        } else {
            rplArr = RubyArray.aryToAry(rpl);
            rlen = rplArr.realLength;
        }
        this.modify();
        int valuesLength = this.values.length - this.begin;
        if (beg >= (long)this.realLength) {
            len = beg + (long)rlen;
            if (len >= (long)valuesLength) {
                this.spliceRealloc((int)len, valuesLength);
            }
            try {
                RuntimeHelpers.fillNil(this.values, this.begin + this.realLength, this.begin + (int)beg, this.getRuntime());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = (int)len;
        } else {
            int alen;
            if (beg + len > (long)this.realLength) {
                len = (long)this.realLength - beg;
            }
            if ((alen = this.realLength + rlen - (int)len) >= valuesLength) {
                this.spliceRealloc(alen, valuesLength);
            }
            if (len != (long)rlen) {
                try {
                    System.arraycopy(this.values, this.begin + (int)(beg + len), this.values, this.begin + (int)beg + rlen, this.realLength - (int)(beg + len));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.concurrentModification();
                }
                this.realLength = alen;
            }
        }
        if (rlen > 0) {
            try {
                System.arraycopy(rplArr.values, rplArr.begin, this.values, this.begin + (int)beg, rlen);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
    }

    private final void spliceOne(long beg, IRubyObject rpl) {
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (beg - (long)this.realLength) + " out of array");
        }
        this.modify();
        int valuesLength = this.values.length - this.begin;
        if (beg >= (long)this.realLength) {
            int len = (int)beg + 1;
            if (len >= valuesLength) {
                this.spliceRealloc(len, valuesLength);
            }
            RuntimeHelpers.fillNil(this.values, this.begin + this.realLength, this.begin + (int)beg, this.getRuntime());
            this.realLength = len;
        } else {
            int len = beg > (long)this.realLength ? this.realLength - (int)beg : 0;
            int alen = this.realLength + 1 - len;
            if (alen >= valuesLength) {
                this.spliceRealloc(alen, valuesLength);
            }
            if (len == 0) {
                try {
                    System.arraycopy(this.values, this.begin + (int)beg, this.values, this.begin + (int)beg + 1, this.realLength - (int)beg);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.concurrentModification();
                }
                this.realLength = alen;
            }
        }
        try {
            this.values[this.begin + (int)beg] = rpl;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
    }

    private void spliceRealloc(int length2, int valuesLength) {
        int tryLength = valuesLength + (valuesLength >> 1);
        int len = length2 > tryLength ? length2 : tryLength;
        IRubyObject[] vals = new IRubyObject[len];
        System.arraycopy(this.values, this.begin, vals, 0, this.realLength);
        if (len > length2) {
            RuntimeHelpers.fillNil(vals, length2, len, this.getRuntime());
        }
        this.begin = 0;
        this.values = vals;
    }

    @JRubyMethod
    public IRubyObject insert() {
        throw this.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject insert(IRubyObject arg2) {
        return this;
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject insert19(IRubyObject arg2) {
        this.modifyCheck();
        return this.insert(arg2);
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject insert(IRubyObject arg1, IRubyObject arg2) {
        long pos2 = RubyNumeric.num2long(arg1);
        if (pos2 == -1L) {
            pos2 = this.realLength;
        }
        if (pos2 < 0L) {
            ++pos2;
        }
        this.spliceOne(pos2, arg2);
        return this;
    }

    @JRubyMethod(name={"insert"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject insert19(IRubyObject arg1, IRubyObject arg2) {
        this.modifyCheck();
        return this.insert(arg1, arg2);
    }

    @JRubyMethod(name={"insert"}, required=1, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject insert(IRubyObject[] args2) {
        if (args2.length == 1) {
            return this;
        }
        long pos2 = RubyNumeric.num2long(args2[0]);
        if (pos2 == -1L) {
            pos2 = this.realLength;
        }
        if (pos2 < 0L) {
            ++pos2;
        }
        RubyArray inserted = new RubyArray(this.getRuntime(), false);
        inserted.values = args2;
        inserted.begin = 1;
        inserted.realLength = args2.length - 1;
        this.splice(pos2, 0L, inserted);
        return this;
    }

    @JRubyMethod(name={"insert"}, required=1, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject insert19(IRubyObject[] args2) {
        this.modifyCheck();
        return this.insert(args2);
    }

    public final RubyArray aryDup() {
        RubyArray dup2 = new RubyArray(this.getRuntime(), this.getMetaClass(), this);
        dup2.flags |= this.flags & 8;
        dup2.flags |= this.flags & 0x10;
        return dup2;
    }

    @JRubyMethod(name={"transpose"})
    public RubyArray transpose() {
        RubyArray result = null;
        int alen = this.realLength;
        if (alen == 0) {
            return this.aryDup();
        }
        Ruby runtime2 = this.getRuntime();
        int elen = -1;
        int end2 = this.begin + alen;
        for (int i = this.begin; i < end2; ++i) {
            int j;
            RubyArray tmp = this.elt(i).convertToArray();
            if (elen < 0) {
                elen = tmp.realLength;
                result = new RubyArray(runtime2, elen);
                for (j = 0; j < elen; ++j) {
                    result.store(j, new RubyArray(runtime2, alen));
                }
            } else if (elen != tmp.realLength) {
                throw runtime2.newIndexError("element size differs (" + tmp.realLength + " should be " + elen + ")");
            }
            for (j = 0; j < elen; ++j) {
                ((RubyArray)result.elt(j)).store(i - this.begin, tmp.elt(j));
            }
        }
        return result;
    }

    private final IRubyObject values_at(long olen, IRubyObject[] args2) {
        RubyArray result = new RubyArray(this.getRuntime(), args2.length);
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] instanceof RubyFixnum) {
                result.append(this.entry(((RubyFixnum)args2[i]).getLongValue()));
                continue;
            }
            if (args2[i] instanceof RubyRange) {
                long[] beglen = ((RubyRange)args2[i]).begLen(olen, 0);
                if (beglen == null) continue;
                int beg = (int)beglen[0];
                int len = (int)beglen[1];
                int end2 = this.begin + len;
                for (int j = this.begin; j < end2; ++j) {
                    result.append(this.entry(j + beg));
                }
                continue;
            }
            result.append(this.entry(RubyNumeric.num2long(args2[i])));
        }
        RuntimeHelpers.fillNil(result.values, result.realLength, result.values.length, this.getRuntime());
        return result;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.realLength, args2);
    }

    public IRubyObject subseq(long beg, long len) {
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), IRubyObject.NULL_ARRAY);
        }
        return this.makeShared(this.begin + (int)beg, (int)len, this.getMetaClass());
    }

    public IRubyObject subseqLight(long beg, long len) {
        Ruby runtime2 = this.getRuntime();
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return runtime2.getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray(runtime2, this.getMetaClass(), IRubyObject.NULL_ARRAY, false);
        }
        return this.makeShared(this.begin + (int)beg, (int)len, new RubyArray(runtime2, this.getMetaClass(), false));
    }

    @JRubyMethod(name={"length"}, alias={"size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.realLength);
    }

    @JRubyMethod(name={"<<"}, required=1)
    public RubyArray append(IRubyObject item) {
        this.modify();
        int valuesLength = this.values.length - this.begin;
        if (this.realLength == valuesLength) {
            if (this.realLength == Integer.MAX_VALUE) {
                throw this.getRuntime().newArgumentError("index too big");
            }
            long newLength = valuesLength + (valuesLength >> 1);
            if (newLength > Integer.MAX_VALUE) {
                newLength = Integer.MAX_VALUE;
            } else if (newLength < 16L) {
                newLength = 16L;
            }
            this.realloc((int)newLength, valuesLength);
        }
        try {
            this.values[this.begin + this.realLength++] = item;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"push"}, rest=true, compat=CompatVersion.RUBY1_8)
    public RubyArray push_m(IRubyObject[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.append(items[i]);
        }
        return this;
    }

    @JRubyMethod(name={"push"}, rest=true, compat=CompatVersion.RUBY1_9)
    public RubyArray push_m19(IRubyObject[] items) {
        this.modifyCheck();
        return this.push_m(items);
    }

    @JRubyMethod
    public IRubyObject pop(ThreadContext context) {
        this.modifyCheck();
        if (this.realLength == 0) {
            return context.getRuntime().getNil();
        }
        try {
            if (this.isShared) {
                return this.values[this.begin + --this.realLength];
            }
            int index2 = this.begin + --this.realLength;
            IRubyObject obj = this.values[index2];
            this.values[index2] = context.getRuntime().getNil();
            return obj;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return context.getRuntime().getNil();
        }
    }

    @JRubyMethod
    public IRubyObject pop(ThreadContext context, IRubyObject num) {
        this.modifyCheck();
        RubyArray result = this.makeSharedFirst(context, num, true, context.getRuntime().getArray());
        this.realLength -= result.realLength;
        return result;
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        IRubyObject obj;
        this.modifyCheck();
        Ruby runtime2 = context.getRuntime();
        if (this.realLength == 0) {
            return runtime2.getNil();
        }
        try {
            obj = this.values[this.begin];
            if (!this.isShared) {
                this.values[this.begin] = runtime2.getNil();
            }
            ++this.begin;
            --this.realLength;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return runtime2.getNil();
        }
        return obj;
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context, IRubyObject num) {
        this.modify();
        RubyArray result = this.makeSharedFirst(context, num, false, context.getRuntime().getArray());
        int n = result.realLength;
        this.begin += n;
        this.realLength -= n;
        return result;
    }

    @JRubyMethod(name={"unshift"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject unshift() {
        return this;
    }

    @JRubyMethod(name={"unshift"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject unshift19() {
        this.modifyCheck();
        return this;
    }

    @JRubyMethod(name={"unshift"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject unshift(IRubyObject item) {
        if (this.begin == 0 || this.isShared) {
            this.modify();
            int valuesLength = this.values.length - this.begin;
            if (this.realLength == valuesLength) {
                int newLength = valuesLength >> 1;
                if (newLength < 16) {
                    newLength = 16;
                }
                IRubyObject[] vals = new IRubyObject[newLength += valuesLength];
                try {
                    System.arraycopy(this.values, this.begin, vals, 1, this.realLength);
                    RuntimeHelpers.fillNil(vals, this.realLength + 1, newLength, this.getRuntime());
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.concurrentModification();
                }
                this.values = vals;
                this.begin = 0;
            } else {
                try {
                    System.arraycopy(this.values, this.begin, this.values, this.begin + 1, this.realLength);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.concurrentModification();
                }
            }
        } else {
            this.modifyCheck();
            --this.begin;
        }
        ++this.realLength;
        this.values[this.begin] = item;
        return this;
    }

    @JRubyMethod(name={"unshift"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject unshift19(IRubyObject item) {
        this.modifyCheck();
        return this.unshift(item);
    }

    @JRubyMethod(name={"unshift"}, rest=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject unshift(IRubyObject[] items) {
        long len = this.realLength;
        if (items.length == 0) {
            return this;
        }
        this.store(len + (long)items.length - 1L, this.getRuntime().getNil());
        try {
            System.arraycopy(this.values, this.begin, this.values, this.begin + items.length, (int)len);
            System.arraycopy(items, 0, this.values, this.begin, items.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"unshift"}, rest=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject unshift19(IRubyObject[] items) {
        this.modifyCheck();
        return this.unshift(items);
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(ThreadContext context, IRubyObject item) {
        return context.getRuntime().newBoolean(this.includes(context, item));
    }

    @Override
    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isFrozen() || (this.flags & 0x200) != 0);
    }

    public IRubyObject aref(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.aref(args2[0]);
            }
            case 2: {
                return this.aref(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]", "slice"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject aref(IRubyObject arg0) {
        assert (!arg0.getRuntime().is1_9());
        if (arg0 instanceof RubyFixnum) {
            return this.entry(((RubyFixnum)arg0).getLongValue());
        }
        if (arg0 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        return this.arefCommon(arg0);
    }

    @JRubyMethod(name={"[]", "slice"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject aref19(IRubyObject arg0) {
        return arg0 instanceof RubyFixnum ? this.entry(((RubyFixnum)arg0).getLongValue()) : this.arefCommon(arg0);
    }

    private IRubyObject arefCommon(IRubyObject arg0) {
        if (arg0 instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg0).begLen(this.realLength, 0);
            return beglen == null ? this.getRuntime().getNil() : this.subseq(beglen[0], beglen[1]);
        }
        return this.entry(RubyNumeric.num2long(arg0));
    }

    @JRubyMethod(name={"[]", "slice"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject aref(IRubyObject arg0, IRubyObject arg1) {
        assert (!arg0.getRuntime().is1_9());
        if (arg0 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        return this.arefCommon(arg0, arg1);
    }

    @JRubyMethod(name={"[]", "slice"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject aref19(IRubyObject arg0, IRubyObject arg1) {
        return this.arefCommon(arg0, arg1);
    }

    private IRubyObject arefCommon(IRubyObject arg0, IRubyObject arg1) {
        long beg = RubyNumeric.num2long(arg0);
        if (beg < 0L) {
            beg += (long)this.realLength;
        }
        return this.subseq(beg, RubyNumeric.num2long(arg1));
    }

    public IRubyObject aset(IRubyObject[] args2) {
        switch (args2.length) {
            case 2: {
                return this.aset(args2[0], args2[1]);
            }
            case 3: {
                return this.aset(args2[0], args2[1], args2[2]);
            }
        }
        throw this.getRuntime().newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
    }

    @JRubyMethod(name={"[]="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1) {
        assert (!this.getRuntime().is1_9());
        if (arg0 instanceof RubyFixnum) {
            this.store(((RubyFixnum)arg0).getLongValue(), arg1);
        } else if (arg0 instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg0).begLen(this.realLength, 1);
            this.splice(beglen[0], beglen[1], arg1);
        } else {
            if (arg0 instanceof RubySymbol) {
                throw this.getRuntime().newTypeError("Symbol as array index");
            }
            this.store(RubyNumeric.num2long(arg0), arg1);
        }
        return arg1;
    }

    @JRubyMethod(name={"[]="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject aset19(IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            this.store(((RubyFixnum)arg0).getLongValue(), arg1);
        } else if (arg0 instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg0).begLen(this.realLength, 1);
            this.splice(beglen[0], beglen[1], arg1);
        } else {
            this.store(RubyNumeric.num2long(arg0), arg1);
        }
        return arg1;
    }

    @JRubyMethod(name={"[]="}, compat=CompatVersion.RUBY1_8)
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        assert (!this.getRuntime().is1_9());
        if (arg0 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as array index");
        }
        if (arg1 instanceof RubySymbol) {
            throw this.getRuntime().newTypeError("Symbol as subarray length");
        }
        this.splice(RubyNumeric.num2long(arg0), RubyNumeric.num2long(arg1), arg2);
        return arg2;
    }

    @JRubyMethod(name={"[]="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject aset19(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.splice(RubyNumeric.num2long(arg0), RubyNumeric.num2long(arg1), arg2);
        return arg2;
    }

    @JRubyMethod(name={"at"}, required=1)
    public IRubyObject at(IRubyObject pos2) {
        return this.entry(RubyNumeric.num2long(pos2));
    }

    @JRubyMethod(name={"concat"}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyArray concat(IRubyObject obj) {
        RubyArray ary = obj.convertToArray();
        if (ary.realLength > 0) {
            this.splice(this.realLength, 0L, ary);
        }
        return this;
    }

    @JRubyMethod(name={"concat"}, required=1, compat=CompatVersion.RUBY1_9)
    public RubyArray concat19(IRubyObject obj) {
        this.modifyCheck();
        return this.concat(obj);
    }

    private IRubyObject inspectAry(ThreadContext context) {
        ByteList buffer = new ByteList();
        buffer.append(91);
        boolean tainted = this.isTaint();
        for (int i = 0; i < this.realLength; ++i) {
            RubyString str;
            if (i > 0) {
                buffer.append(44).append(32);
            }
            if ((str = RubyArray.inspect(context, this.values[this.begin + i])).isTaint()) {
                tainted = true;
            }
            buffer.append(str.getByteList());
        }
        buffer.append(93);
        RubyString str = this.getRuntime().newString(buffer);
        if (tainted) {
            str.setTaint(true);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.realLength == 0) {
            return this.getRuntime().newString("[]");
        }
        if (this.getRuntime().isInspecting(this)) {
            return this.getRuntime().newString("[...]");
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectAry(this.getRuntime().getCurrentContext());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public IRubyObject first(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.first(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin];
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(IRubyObject arg0) {
        long n = RubyNumeric.num2long(arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else if (n < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin, (int)n, this.getRuntime().getArray());
    }

    public IRubyObject last(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.last();
            }
            case 1: {
                return this.last(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + this.realLength - 1];
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(IRubyObject arg0) {
        long n = RubyNumeric.num2long(arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else if (n < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin + this.realLength - (int)n, (int)n, this.getRuntime().getArray());
    }

    public IRubyObject eachCommon(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newLocalJumpErrorNoBlock();
        }
        for (int i = 0; i < this.realLength; ++i) {
            block.yield(context, this.values[this.begin + i]);
        }
        return this;
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachCommon(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each");
    }

    public IRubyObject eachIndex(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            throw runtime2.newLocalJumpErrorNoBlock();
        }
        for (int i = 0; i < this.realLength; ++i) {
            block.yield(context, runtime2.newFixnum(i));
        }
        return this;
    }

    @JRubyMethod(name={"each_index"}, frame=true)
    public IRubyObject each_index(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachIndex(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "each_index");
    }

    public IRubyObject reverseEach(ThreadContext context, Block block) {
        int len = this.realLength;
        while (len-- > 0) {
            block.yield(context, this.values[this.begin + len]);
            if (this.realLength >= len) continue;
            len = this.realLength;
        }
        return this;
    }

    @JRubyMethod(name={"reverse_each"}, frame=true)
    public IRubyObject reverse_each(ThreadContext context, Block block) {
        return block.isGiven() ? this.reverseEach(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "reverse_each");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectJoin(ThreadContext context, RubyArray tmp, IRubyObject sep) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.isInspecting(this)) {
            return tmp.join(context, sep);
        }
        try {
            runtime2.registerInspecting(this);
            IRubyObject iRubyObject = tmp.join(context, sep);
            return iRubyObject;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    @JRubyMethod(name={"join"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject join(ThreadContext context, IRubyObject sep) {
        Ruby runtime2 = context.getRuntime();
        if (this.realLength == 0) {
            return RubyString.newEmptyString(runtime2);
        }
        boolean taint2 = this.isTaint() || sep.isTaint();
        boolean untrusted = this.isUntrusted() || sep.isUntrusted();
        int len = 1;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject value2;
            try {
                value2 = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return RubyString.newEmptyString(runtime2);
            }
            IRubyObject tmp = value2.checkStringType();
            len += tmp.isNil() ? 10 : ((RubyString)tmp).getByteList().length();
        }
        ByteList sepBytes = null;
        if (!sep.isNil()) {
            sepBytes = sep.convertToString().getByteList();
            len += sepBytes.getRealSize() * (this.realLength - 1);
        }
        ByteList buf = new ByteList(len);
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject tmp;
            try {
                tmp = this.values[this.begin + i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return RubyString.newEmptyString(runtime2);
            }
            if (!(tmp instanceof RubyString)) {
                tmp = tmp instanceof RubyArray ? (tmp == this || runtime2.isInspecting(tmp) ? runtime2.newString("[...]") : this.inspectJoin(context, (RubyArray)tmp, sep)) : RubyString.objAsString(context, tmp);
            }
            if (i > 0 && sepBytes != null) {
                buf.append(sepBytes);
            }
            buf.append(tmp.asString().getByteList());
            if (tmp.isTaint()) {
                taint2 = true;
            }
            if (!tmp.isUntrusted()) continue;
            untrusted = true;
        }
        RubyString result = runtime2.newString(buf);
        if (taint2) {
            result.setTaint(true);
        }
        if (untrusted) {
            result.untrust(context);
        }
        return result;
    }

    @JRubyMethod(name={"join"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject join(ThreadContext context) {
        return this.join(context, context.getRuntime().getGlobalVariables().get("$,"));
    }

    private boolean[] join0(ThreadContext context, ByteList sep, int max2, ByteList result) {
        boolean t = false;
        boolean u = false;
        for (int i = this.begin; i < max2; ++i) {
            IRubyObject val;
            try {
                val = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return new boolean[]{t, u};
            }
            if (i > this.begin && sep != null) {
                result.append(sep);
            }
            result.append(((RubyString)val).getByteList());
            if (val.isTaint()) {
                t = true;
            }
            if (!val.isUntrusted()) continue;
            u = true;
        }
        return new boolean[]{t, u};
    }

    private void join1(final ThreadContext context, IRubyObject obj, final ByteList sep, int i, final ByteList result) {
        while (i < this.begin + this.realLength) {
            IRubyObject val;
            if (i > this.begin && sep != null) {
                result.append(sep);
            }
            try {
                val = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return;
            }
            if (val instanceof RubyString) {
                result.append(((RubyString)val).getByteList());
            } else if (val instanceof RubyArray) {
                obj = val;
                if (val == this) {
                    throw this.getRuntime().newArgumentError("recursive array join");
                }
                final RubyArray ary = (RubyArray)val;
                final IRubyObject outobj = obj;
                this.getRuntime().execRecursive(new Ruby.RecursiveFunction(){

                    public IRubyObject call(IRubyObject obj, boolean recur) {
                        if (recur) {
                            throw RubyArray.this.getRuntime().newArgumentError("recursive array join");
                        }
                        ary.join1(context, outobj, sep, 0, result);
                        return RubyArray.this.getRuntime().getNil();
                    }
                }, obj);
            } else {
                IRubyObject tmp = val.checkStringType19();
                if (!tmp.isNil()) {
                    val = tmp;
                    result.append(((RubyString)val).getByteList());
                } else {
                    tmp = TypeConverter.convertToTypeWithCheck(val, this.getRuntime().getArray(), "to_a");
                    if (!tmp.isNil()) {
                        obj = val;
                        val = tmp;
                        if (val == this) {
                            throw this.getRuntime().newArgumentError("recursive array join");
                        }
                        final RubyArray ary = (RubyArray)val;
                        final IRubyObject outobj = obj;
                        this.getRuntime().execRecursive(new Ruby.RecursiveFunction(){

                            public IRubyObject call(IRubyObject obj, boolean recur) {
                                if (recur) {
                                    throw RubyArray.this.getRuntime().newArgumentError("recursive array join");
                                }
                                ary.join1(context, outobj, sep, 0, result);
                                return RubyArray.this.getRuntime().getNil();
                            }
                        }, obj);
                    } else {
                        val = RubyString.objAsString(context, val);
                        result.append(((RubyString)val).getByteList());
                    }
                }
            }
            ++i;
        }
    }

    @JRubyMethod(name={"join"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject join19(ThreadContext context, IRubyObject sep) {
        Ruby runtime2 = context.getRuntime();
        if (this.realLength == 0) {
            return RubyString.newEmptyString(runtime2);
        }
        boolean taint2 = this.isTaint() || sep.isTaint();
        boolean untrusted = this.isUntrusted() || sep.isUntrusted();
        int len = 1;
        ByteList sepBytes = null;
        if (!sep.isNil()) {
            sepBytes = sep.convertToString().getByteList();
            len += sepBytes.getRealSize() * (this.realLength - 1);
        }
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject val;
            try {
                val = this.values[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
                return RubyString.newEmptyString(runtime2);
            }
            IRubyObject tmp = val.checkStringType19();
            if (tmp.isNil() || tmp != val) {
                ByteList buf = new ByteList(len + (this.begin + this.realLength - i) * 10);
                boolean[] tu = this.join0(context, sepBytes, i, buf);
                this.join1(context, this, sepBytes, i, buf);
                RubyString result = runtime2.newString(buf);
                if (taint2 || tu[0]) {
                    result.setTaint(true);
                }
                if (untrusted || tu[1]) {
                    result.untrust(context);
                }
                return result;
            }
            len += ((RubyString)tmp).getByteList().length();
        }
        ByteList buf = new ByteList(len);
        boolean[] tu = this.join0(context, sepBytes, this.begin + this.realLength, buf);
        RubyString result = runtime2.newString(buf);
        if (taint2 || tu[0]) {
            result.setTaint(true);
        }
        if (untrusted || tu[1]) {
            result.untrust(context);
        }
        return result;
    }

    @JRubyMethod(name={"join"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject join19(ThreadContext context) {
        return this.join19(context, context.getRuntime().getGlobalVariables().get("$,"));
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        if (this.getMetaClass() != this.getRuntime().getArray()) {
            RubyArray dup2 = new RubyArray(this.getRuntime(), this.getRuntime().isObjectSpaceEnabled());
            this.isShared = true;
            dup2.isShared = true;
            dup2.values = this.values;
            dup2.realLength = this.realLength;
            dup2.begin = this.begin;
            return dup2;
        }
        return this;
    }

    @JRubyMethod(name={"to_ary"})
    public IRubyObject to_ary() {
        return this;
    }

    @Override
    public RubyArray convertToArray() {
        return this;
    }

    @Override
    public IRubyObject checkArrayType() {
        return this;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        if (this == obj) {
            return context.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            if (!obj.respondsTo("to_ary")) {
                return context.getRuntime().getFalse();
            }
            return RuntimeHelpers.rbEqual(context, obj, this);
        }
        return RecursiveComparator.compare(context, "==", this, obj, null);
    }

    public RubyBoolean compare(ThreadContext context, String method2, IRubyObject other, Set<RecursiveComparator.Pair> seen) {
        Ruby runtime2 = context.getRuntime();
        if (!(other instanceof RubyArray)) {
            if (!other.respondsTo("to_ary")) {
                return runtime2.getFalse();
            }
            return RuntimeHelpers.rbEqual(context, other, this);
        }
        RubyArray ary = (RubyArray)other;
        if (this.realLength != ary.realLength) {
            return runtime2.getFalse();
        }
        for (int i = 0; i < this.realLength; ++i) {
            if (RecursiveComparator.compare(context, method2, this.elt(i), ary.elt(i), seen).isTrue()) continue;
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql(ThreadContext context, IRubyObject obj) {
        return RecursiveComparator.compare(context, "eql?", this, obj, null);
    }

    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang() {
        int p2;
        this.modify();
        int t = p2 = this.begin;
        int end2 = p2 + this.realLength;
        while (t < end2) {
            if (this.values[t].isNil()) {
                ++t;
                continue;
            }
            this.values[p2++] = this.values[t++];
        }
        if (this.realLength == (p2 -= this.begin)) {
            return this.getRuntime().getNil();
        }
        this.realloc(p2, this.values.length - this.begin);
        this.realLength = p2;
        return this;
    }

    @JRubyMethod(name={"compact"})
    public IRubyObject compact() {
        RubyArray ary = this.aryDup();
        ary.compact_bang();
        return ary;
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p() {
        return this.realLength == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject rb_clear() {
        this.modifyCheck();
        if (this.isShared) {
            this.alloc(16);
            this.isShared = false;
        } else if (this.values.length > 32) {
            this.alloc(32);
        } else {
            try {
                this.begin = 0;
                RuntimeHelpers.fillNil(this.values, 0, this.realLength, this.getRuntime());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
        this.realLength = 0;
        return this;
    }

    @JRubyMethod(name={"fill"}, frame=true)
    public IRubyObject fill(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.fillCommon(context, 0, (long)this.realLength, block);
        }
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"fill"}, frame=true)
    public IRubyObject fill(ThreadContext context, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            if (arg2 instanceof RubyRange) {
                int[] beglen = ((RubyRange)arg2).begLenInt(this.realLength, 1);
                return this.fillCommon(context, beglen[0], (long)beglen[1], block);
            }
            int beg = this.fillBegin(arg2);
            return this.fillCommon(context, beg, this.fillLen(beg, null), block);
        }
        return this.fillCommon(context, 0, (long)this.realLength, arg2);
    }

    @JRubyMethod(name={"fill"}, frame=true)
    public IRubyObject fill(ThreadContext context, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            int beg = this.fillBegin(arg1);
            return this.fillCommon(context, beg, this.fillLen(beg, arg2), block);
        }
        if (arg2 instanceof RubyRange) {
            int[] beglen = ((RubyRange)arg2).begLenInt(this.realLength, 1);
            return this.fillCommon(context, beglen[0], (long)beglen[1], arg1);
        }
        int beg = this.fillBegin(arg2);
        return this.fillCommon(context, beg, this.fillLen(beg, null), arg1);
    }

    @JRubyMethod(name={"fill"}, frame=true)
    public IRubyObject fill(ThreadContext context, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(3, 2);
        }
        int beg = this.fillBegin(arg2);
        return this.fillCommon(context, beg, this.fillLen(beg, arg3), arg1);
    }

    private int fillBegin(IRubyObject arg2) {
        int beg;
        int n = beg = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (beg < 0 && (beg = this.realLength + beg) < 0) {
            beg = 0;
        }
        return beg;
    }

    private long fillLen(long beg, IRubyObject arg2) {
        if (arg2 == null || arg2.isNil()) {
            return (long)this.realLength - beg;
        }
        return RubyNumeric.num2long(arg2);
    }

    private IRubyObject fillCommon(ThreadContext context, int beg, long len, IRubyObject item) {
        this.modify();
        if (len < 0L) {
            return this;
        }
        if (len > (long)(Integer.MAX_VALUE - beg)) {
            throw context.getRuntime().newArgumentError("argument too big");
        }
        int end2 = (int)((long)beg + len);
        if (end2 > this.realLength) {
            int valuesLength = this.values.length - this.begin;
            if (end2 >= valuesLength) {
                this.realloc(end2, valuesLength);
            }
            this.realLength = end2;
        }
        if (len > 0L) {
            try {
                RubyArray.fill(this.values, this.begin + beg, this.begin + end2, item);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
        return this;
    }

    private IRubyObject fillCommon(ThreadContext context, int beg, long len, Block block) {
        this.modify();
        if (len < 0L) {
            return this;
        }
        if (len > (long)(Integer.MAX_VALUE - beg)) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        int end2 = (int)((long)beg + len);
        if (end2 > this.realLength) {
            int valuesLength = this.values.length - this.begin;
            if (end2 >= valuesLength) {
                this.realloc(end2, valuesLength);
            }
            this.realLength = end2;
        }
        Ruby runtime2 = context.getRuntime();
        for (int i = beg; i < end2; ++i) {
            IRubyObject v = block.yield(context, runtime2.newFixnum(i));
            if (i >= this.realLength) break;
            try {
                this.values[this.begin + i] = v;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
        return this;
    }

    public IRubyObject index(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!RubyArray.equalInternal(context, this.values[i], obj)) continue;
            return runtime2.newFixnum(i - this.begin);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"index", "find_index"}, frame=true)
    public IRubyObject index(ThreadContext context, IRubyObject obj, Block unused2) {
        if (unused2.isGiven()) {
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        return this.index(context, obj);
    }

    @JRubyMethod(name={"index", "find_index"}, frame=true)
    public IRubyObject index(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "index");
        }
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!block.yield(context, this.values[i]).isTrue()) continue;
            return runtime2.newFixnum(i - this.begin);
        }
        return runtime2.getNil();
    }

    public IRubyObject rindex(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        int i = this.realLength;
        while (i-- > 0) {
            if (i > this.realLength) {
                i = this.realLength;
                continue;
            }
            if (!RubyArray.equalInternal(context, this.values[this.begin + i], obj)) continue;
            return runtime2.newFixnum(i);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"rindex"}, frame=true)
    public IRubyObject rindex(ThreadContext context, IRubyObject obj, Block unused2) {
        if (unused2.isGiven()) {
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        return this.rindex(context, obj);
    }

    @JRubyMethod(name={"rindex"}, frame=true)
    public IRubyObject rindex(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "rindex");
        }
        int i = this.realLength;
        while (i-- > 0) {
            if (i > this.realLength) {
                i = this.realLength;
                continue;
            }
            if (!block.yield(context, this.values[this.begin + i]).isTrue()) continue;
            return runtime2.newFixnum(i);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"indexes", "indices"}, required=1, rest=true)
    public IRubyObject indexes(IRubyObject[] args2) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Array#indexes is deprecated; use Array#values_at", "Array#indexes", "Array#values_at");
        RubyArray ary = new RubyArray(this.getRuntime(), args2.length);
        for (int i = 0; i < args2.length; ++i) {
            ary.append(this.aref(args2[i]));
        }
        return ary;
    }

    @JRubyMethod(name={"reverse!"})
    public IRubyObject reverse_bang() {
        this.modify();
        try {
            if (this.realLength > 1) {
                IRubyObject[] vals = this.values;
                int p2 = this.begin;
                int len = this.realLength;
                for (int i = 0; i < len >> 1; ++i) {
                    IRubyObject tmp = vals[p2 + i];
                    vals[p2 + i] = vals[p2 + len - i - 1];
                    vals[p2 + len - i - 1] = tmp;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public IRubyObject reverse() {
        RubyArray dup2 = this.realLength > 1 ? this.safeReverse() : new RubyArray(this.getRuntime(), this.getMetaClass(), this);
        dup2.flags |= this.flags & 8;
        return dup2;
    }

    private RubyArray safeReverse() {
        int length2 = this.realLength;
        int begin2 = this.begin;
        IRubyObject[] values = this.values;
        IRubyObject[] vals = new IRubyObject[length2];
        try {
            for (int i = 0; i <= length2 >> 1; ++i) {
                vals[i] = values[begin2 + length2 - i - 1];
                vals[length2 - i - 1] = values[begin2 + i];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return new RubyArray(this.getRuntime(), this.getMetaClass(), vals);
    }

    @JRubyMethod(name={"collect", "map"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject collect(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return new RubyArray(runtime2, runtime2.getArray(), this);
        }
        IRubyObject[] arr = new IRubyObject[this.realLength];
        for (int i = 0; i < this.realLength; ++i) {
            arr[i] = block.yield(context, this.values[i + this.begin]);
        }
        return new RubyArray(runtime2, arr);
    }

    @JRubyMethod(name={"collect", "map"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject collect19(ThreadContext context, Block block) {
        return block.isGiven() ? this.collect(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "collect");
    }

    public RubyArray collectBang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newLocalJumpErrorNoBlock();
        }
        this.modify();
        int len = this.realLength;
        for (int i = 0; i < len; ++i) {
            this.store(i, block.yield(context, this.values[this.begin + i]));
        }
        return this;
    }

    @JRubyMethod(name={"collect!"}, frame=true)
    public IRubyObject collect_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectBang(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "collect!");
    }

    @JRubyMethod(name={"map!"}, frame=true)
    public IRubyObject map_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectBang(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "map!");
    }

    public IRubyObject selectCommon(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = new RubyArray(runtime2, this.realLength);
        for (int i = 0; i < this.realLength; ++i) {
            if (!block.yield(context, this.values[this.begin + i]).isTrue()) continue;
            result.append(this.elt(i));
        }
        RuntimeHelpers.fillNil(result.values, result.realLength, result.values.length, runtime2);
        return result;
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(ThreadContext context, Block block) {
        return block.isGiven() ? this.selectCommon(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "select");
    }

    @JRubyMethod(name={"delete"}, required=1, frame=true)
    public IRubyObject delete(ThreadContext context, IRubyObject item, Block block) {
        int i2 = 0;
        Ruby runtime2 = context.getRuntime();
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject e = this.values[this.begin + i1];
            if (RubyArray.equalInternal(context, e, item)) continue;
            if (i1 != i2) {
                this.store(i2, e);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            if (block.isGiven()) {
                return block.yield(context, item);
            }
            return runtime2.getNil();
        }
        this.modify();
        int realLength = this.realLength;
        int begin2 = this.begin;
        IRubyObject[] values = this.values;
        if (realLength > i2) {
            try {
                RuntimeHelpers.fillNil(values, begin2 + i2, begin2 + realLength, context.getRuntime());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = i2;
            int valuesLength = values.length - begin2;
            if (i2 << 1 < valuesLength && valuesLength > 16) {
                this.realloc(i2 << 1, valuesLength);
            }
        }
        return item;
    }

    private final IRubyObject delete_at(int pos2) {
        int len = this.realLength;
        if (pos2 >= len || pos2 < 0 && (pos2 += len) < 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        IRubyObject obj = this.values[this.begin + pos2];
        try {
            System.arraycopy(this.values, this.begin + pos2 + 1, this.values, this.begin + pos2, len - (pos2 + 1));
            this.values[this.begin + len - 1] = this.getRuntime().getNil();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        --this.realLength;
        return obj;
    }

    @JRubyMethod(name={"delete_at"}, required=1)
    public IRubyObject delete_at(IRubyObject obj) {
        return this.delete_at((int)RubyNumeric.num2long(obj));
    }

    public IRubyObject rejectCommon(ThreadContext context, Block block) {
        RubyArray ary = this.aryDup();
        ary.reject_bang(context, block);
        return ary;
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public IRubyObject reject(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectCommon(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "reject");
    }

    public IRubyObject rejectBang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newLocalJumpErrorNoBlock();
        }
        int i2 = 0;
        this.modify();
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject v = this.values[this.begin + i1];
            if (block.yield(context, v).isTrue()) continue;
            if (i1 != i2) {
                this.store(i2, v);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            return context.getRuntime().getNil();
        }
        if (i2 < this.realLength) {
            try {
                RuntimeHelpers.fillNil(this.values, this.begin + i2, this.begin + this.realLength, context.getRuntime());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = i2;
        }
        return this;
    }

    @JRubyMethod(name={"reject!"}, frame=true)
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectBang(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "reject!");
    }

    public IRubyObject deleteIf(ThreadContext context, Block block) {
        this.reject_bang(context, block);
        return this;
    }

    @JRubyMethod(name={"delete_if"}, frame=true)
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return block.isGiven() ? this.deleteIf(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "delete_if");
    }

    @JRubyMethod(name={"zip"}, optional=1, rest=true, frame=true)
    public IRubyObject zip(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.getRuntime();
        args2 = RubyEnumerable.zipCommonConvert(runtime2, args2, "to_ary");
        if (block.isGiven()) {
            for (int i = 0; i < this.realLength; ++i) {
                IRubyObject[] tmp = new IRubyObject[args2.length + 1];
                tmp[0] = this.values[this.begin + i];
                for (int j = 0; j < args2.length; ++j) {
                    tmp[j + 1] = ((RubyArray)args2[j]).elt(i);
                }
                block.yield(context, RubyArray.newArrayNoCopyLight(runtime2, tmp));
            }
            return runtime2.getNil();
        }
        IRubyObject[] result = new IRubyObject[this.realLength];
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject[] tmp = new IRubyObject[args2.length + 1];
            tmp[0] = this.values[this.begin + i];
            for (int j = 0; j < args2.length; ++j) {
                tmp[j + 1] = ((RubyArray)args2[j]).elt(i);
            }
            result[i] = RubyArray.newArrayNoCopyLight(runtime2, tmp);
        }
        return RubyArray.newArrayNoCopy(runtime2, result);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject obj) {
        boolean isAnArray;
        Ruby runtime2 = context.getRuntime();
        IRubyObject ary2 = runtime2.getNil();
        boolean bl = isAnArray = obj instanceof RubyArray || obj.getMetaClass().getSuperClass() == runtime2.getArray();
        if (!isAnArray && !obj.respondsTo("to_ary")) {
            return ary2;
        }
        ary2 = !isAnArray ? obj.callMethod(context, "to_ary") : obj.convertToArray();
        return this.cmpCommon(context, runtime2, (RubyArray)ary2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject cmpCommon(ThreadContext context, Ruby runtime2, RubyArray ary2) {
        int len;
        if (this == ary2 || runtime2.isInspecting(this)) {
            return RubyFixnum.zero(runtime2);
        }
        try {
            runtime2.registerInspecting(this);
            len = this.realLength;
            if (len > ary2.realLength) {
                len = ary2.realLength;
            }
            for (int i = 0; i < len; ++i) {
                IRubyObject v = this.elt(i).callMethod(context, "<=>", ary2.elt(i));
                if (v instanceof RubyFixnum && ((RubyFixnum)v).getLongValue() == 0L) continue;
                IRubyObject iRubyObject = v;
                return iRubyObject;
            }
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
        len = this.realLength - ary2.realLength;
        if (len == 0) {
            return RubyFixnum.zero(runtime2);
        }
        if (len > 0) {
            return RubyFixnum.one(runtime2);
        }
        return RubyFixnum.minus_one(runtime2);
    }

    public IRubyObject slice_bang(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.slice_bang(args2[0]);
            }
            case 2: {
                return this.slice_bang(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    private IRubyObject slice_internal(long pos2, long len, IRubyObject arg0, IRubyObject arg1, Ruby runtime2) {
        if (len < 0L) {
            return runtime2.getNil();
        }
        int orig_len = this.realLength;
        if (pos2 < 0L ? (pos2 += (long)orig_len) < 0L : (long)orig_len < pos2) {
            return runtime2.getNil();
        }
        if ((long)orig_len < pos2 + len) {
            len = (long)orig_len - pos2;
        }
        if (len == 0L) {
            return runtime2.newEmptyArray();
        }
        arg1 = this.makeShared(this.begin + (int)pos2, (int)len, this.getMetaClass());
        this.splice(pos2, len, null);
        return arg1;
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject arg0) {
        this.modifyCheck();
        Ruby runtime2 = this.getRuntime();
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            if (!range.checkBegin(this.realLength)) {
                return runtime2.getNil();
            }
            long[] beglen = range.begLen(this.realLength, 1);
            long pos2 = beglen[0];
            long len = beglen[1];
            return this.slice_internal(pos2, len, arg0, null, runtime2);
        }
        return this.delete_at((int)RubyNumeric.num2long(arg0));
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject arg0, IRubyObject arg1) {
        this.modifyCheck();
        long pos2 = RubyNumeric.num2long(arg0);
        long len = RubyNumeric.num2long(arg1);
        return this.slice_internal(pos2, len, arg0, arg1, this.getRuntime());
    }

    @JRubyMethod(name={"assoc"}, required=1)
    public IRubyObject assoc(ThreadContext context, IRubyObject key2) {
        Ruby runtime2 = context.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject v = this.values[i];
            if (!(v instanceof RubyArray)) continue;
            RubyArray arr = (RubyArray)v;
            if (arr.realLength <= 0 || !RubyArray.equalInternal(context, arr.values[arr.begin], key2)) continue;
            return arr;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"rassoc"}, required=1)
    public IRubyObject rassoc(ThreadContext context, IRubyObject value2) {
        Ruby runtime2 = context.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject v = this.values[i];
            if (!(v instanceof RubyArray)) continue;
            RubyArray arr = (RubyArray)v;
            if (arr.realLength <= 1 || !RubyArray.equalInternal(context, arr.values[arr.begin + 1], value2)) continue;
            return arr;
        }
        return runtime2.getNil();
    }

    private boolean flatten(ThreadContext context, int level2, RubyArray result) {
        Ruby runtime2 = context.getRuntime();
        RubyArray stack = new RubyArray(runtime2, 16, false);
        IdentityHashMap<IRubyObject, IRubyObject> memo = new IdentityHashMap<IRubyObject, IRubyObject>();
        RubyArray ary = this;
        memo.put(ary, NEVER);
        boolean modified = false;
        int i = 0;
        while (true) {
            IRubyObject tmp;
            if (i < ary.realLength) {
                IRubyObject elt;
                if ((tmp = (elt = ary.values[ary.begin + i++]).checkArrayType()).isNil() || level2 >= 0 && stack.realLength / 2 >= level2) {
                    result.append(elt);
                    continue;
                }
                modified = true;
                if (memo.get(tmp) != null) {
                    throw runtime2.newArgumentError("tried to flatten recursive array");
                }
                memo.put(tmp, NEVER);
                stack.append(ary);
                stack.append(RubyFixnum.newFixnum(runtime2, i));
                ary = (RubyArray)tmp;
                i = 0;
                continue;
            }
            if (stack.realLength == 0) break;
            memo.remove(ary);
            tmp = stack.pop(context);
            i = (int)((RubyFixnum)tmp).getLongValue();
            ary = (RubyArray)stack.pop(context);
        }
        return modified;
    }

    @JRubyMethod(name={"flatten!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject flatten_bang(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = new RubyArray(runtime2, this.getMetaClass(), this.realLength);
        if (this.flatten(context, -1, result)) {
            this.modify();
            this.begin = 0;
            this.realLength = result.realLength;
            this.values = result.values;
            return this;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"flatten!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten_bang19(ThreadContext context) {
        this.modifyCheck();
        return this.flatten_bang(context);
    }

    @JRubyMethod(name={"flatten!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject flatten_bang(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        int level2 = RubyNumeric.num2int(arg2);
        if (level2 == 0) {
            return runtime2.getNil();
        }
        RubyArray result = new RubyArray(runtime2, this.getMetaClass(), this.realLength);
        if (this.flatten(context, level2, result)) {
            this.begin = 0;
            this.realLength = result.realLength;
            this.values = result.values;
            return this;
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"flatten!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten_bang19(ThreadContext context, IRubyObject arg2) {
        this.modifyCheck();
        return this.flatten_bang(context, arg2);
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject flatten(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = new RubyArray(runtime2, this.getMetaClass(), this.realLength);
        this.flatten(context, -1, result);
        result.infectBy(this);
        return result;
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject flatten(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        int level2 = RubyNumeric.num2int(arg2);
        if (level2 == 0) {
            return this;
        }
        RubyArray result = new RubyArray(runtime2, this.getMetaClass(), this.realLength);
        this.flatten(context, level2, result);
        result.infectBy(this);
        return result;
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray result = new RubyArray(runtime2, this.getMetaClass(), this.realLength);
        this.flatten(context, -1, result);
        result.infectBy(this);
        return result;
    }

    @JRubyMethod(name={"flatten"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject flatten19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        int level2 = RubyNumeric.num2int(arg2);
        if (level2 == 0) {
            return this.makeShared();
        }
        RubyArray result = new RubyArray(runtime2, this.getMetaClass(), this.realLength);
        this.flatten(context, level2, result);
        result.infectBy(this);
        return result;
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject count(ThreadContext context, Block block) {
        if (block.isGiven()) {
            int n = 0;
            for (int i = 0; i < this.realLength; ++i) {
                if (!block.yield(context, this.values[this.begin + i]).isTrue()) continue;
                ++n;
            }
            return RubyFixnum.newFixnum(context.getRuntime(), n);
        }
        return RubyFixnum.newFixnum(context.getRuntime(), this.realLength);
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject count(ThreadContext context, IRubyObject obj, Block block) {
        if (block.isGiven()) {
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used", new Object[0]);
        }
        int n = 0;
        for (int i = 0; i < this.realLength; ++i) {
            if (!RubyArray.equalInternal(context, this.values[this.begin + i], obj)) continue;
            ++n;
        }
        return RubyFixnum.newFixnum(context.getRuntime(), n);
    }

    @JRubyMethod(name={"nitems"})
    public IRubyObject nitems() {
        int n = 0;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (this.values[i].isNil()) continue;
            ++n;
        }
        return this.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject obj) {
        RubyArray y = obj.convertToArray();
        int len = this.realLength + y.realLength;
        RubyArray z = new RubyArray(this.getRuntime(), len);
        try {
            System.arraycopy(this.values, this.begin, z.values, 0, this.realLength);
            System.arraycopy(y.values, y.begin, z.values, this.realLength, y.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        z.realLength = len;
        return z;
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_times(ThreadContext context, IRubyObject times2) {
        IRubyObject tmp = times2.checkStringType();
        if (!tmp.isNil()) {
            return this.join(context, tmp);
        }
        long len = RubyNumeric.num2long(times2);
        Ruby runtime2 = context.getRuntime();
        if (len == 0L) {
            return new RubyArray(runtime2, this.getMetaClass(), IRubyObject.NULL_ARRAY).infectBy(this);
        }
        if (len < 0L) {
            throw runtime2.newArgumentError("negative argument");
        }
        if (Long.MAX_VALUE / len < (long)this.realLength) {
            throw runtime2.newArgumentError("argument too big");
        }
        RubyArray.checkLength(runtime2, len *= (long)this.realLength);
        RubyArray ary2 = new RubyArray(runtime2, this.getMetaClass(), (int)len);
        ary2.realLength = ary2.values.length;
        try {
            int i = 0;
            while ((long)i < len) {
                System.arraycopy(this.values, this.begin, ary2.values, i, this.realLength);
                i += this.realLength;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        ary2.infectBy(this);
        return ary2;
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_times19(ThreadContext context, IRubyObject times2) {
        IRubyObject tmp = times2.checkStringType();
        if (!tmp.isNil()) {
            return this.join19(context, tmp);
        }
        long len = RubyNumeric.num2long(times2);
        Ruby runtime2 = context.getRuntime();
        if (len == 0L) {
            return new RubyArray(runtime2, this.getMetaClass(), IRubyObject.NULL_ARRAY).infectBy(this);
        }
        if (len < 0L) {
            throw runtime2.newArgumentError("negative argument");
        }
        if (Long.MAX_VALUE / len < (long)this.realLength) {
            throw runtime2.newArgumentError("argument too big");
        }
        RubyArray.checkLength(runtime2, len *= (long)this.realLength);
        RubyArray ary2 = new RubyArray(runtime2, this.getMetaClass(), (int)len);
        ary2.realLength = ary2.values.length;
        try {
            int i = 0;
            while ((long)i < len) {
                System.arraycopy(this.values, this.begin, ary2.values, i, this.realLength);
                i += this.realLength;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        ary2.infectBy(this);
        return ary2;
    }

    private RubyHash makeHash() {
        return this.makeHash(new RubyHash(this.getRuntime(), false));
    }

    private RubyHash makeHash(RubyHash hash2) {
        int begin2;
        for (int i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            hash2.fastASet(this.values[i], NEVER);
        }
        return hash2;
    }

    private RubyHash makeHash(RubyArray ary2) {
        return ary2.makeHash(this.makeHash());
    }

    private RubyHash makeHash(ThreadContext context, RubyArray ary2, Block block) {
        return ary2.makeHash(this.makeHash(context, block));
    }

    private RubyHash makeHash(ThreadContext context, Block block) {
        return this.makeHash(context, new RubyHash(this.getRuntime(), false), block);
    }

    private RubyHash makeHash(ThreadContext context, RubyHash hash2, Block block) {
        int begin2;
        for (int i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            IRubyObject k = block.yield(context, v);
            if (hash2.fastARef(k) != null) continue;
            hash2.fastASet(k, v);
        }
        return hash2;
    }

    @JRubyMethod(name={"uniq!"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject uniq_bang(ThreadContext context) {
        RubyHash hash2 = this.makeHash();
        if (this.realLength == hash2.size()) {
            return context.getRuntime().getNil();
        }
        int j = 0;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            if (!hash2.fastDelete(v)) continue;
            this.store(j++, v);
        }
        this.realLength = j;
        return this;
    }

    @JRubyMethod(name={"uniq!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject uniq_bang19(ThreadContext context, Block block) {
        this.modifyCheck();
        if (!block.isGiven()) {
            return this.uniq_bang(context);
        }
        RubyHash hash2 = this.makeHash(context, block);
        if (this.realLength == hash2.size()) {
            return context.getRuntime().getNil();
        }
        this.realLength = 0;
        hash2.visitAll(new RubyHash.Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                RubyArray.this.append(value2);
            }
        });
        return this;
    }

    @JRubyMethod(name={"uniq"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject uniq(ThreadContext context) {
        RubyHash hash2 = this.makeHash();
        if (this.realLength == hash2.size()) {
            return this.makeShared();
        }
        RubyArray result = new RubyArray(context.getRuntime(), this.getMetaClass(), hash2.size());
        int j = 0;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            if (!hash2.fastDelete(v)) continue;
            result.values[j++] = v;
        }
        result.realLength = j;
        return result;
    }

    @JRubyMethod(name={"uniq"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject uniq19(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return this.uniq(context);
        }
        RubyHash hash2 = this.makeHash(context, block);
        if (this.realLength == hash2.size()) {
            return context.getRuntime().getNil();
        }
        final RubyArray result = new RubyArray(context.getRuntime(), this.getMetaClass(), hash2.size());
        hash2.visitAll(new RubyHash.Visitor(){

            public void visit(IRubyObject key2, IRubyObject value2) {
                result.append(value2);
            }
        });
        return result;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_diff(IRubyObject other) {
        int begin2;
        RubyHash hash2 = other.convertToArray().makeHash();
        RubyArray ary3 = new RubyArray(this.getRuntime(), 16);
        for (int i = begin2 = this.begin; i < begin2 + this.realLength; ++i) {
            if (hash2.fastARef(this.values[i]) != null) continue;
            ary3.append(this.elt(i - begin2));
        }
        RuntimeHelpers.fillNil(ary3.values, ary3.realLength, ary3.values.length, this.getRuntime());
        return ary3;
    }

    @JRubyMethod(name={"&"}, required=1)
    public IRubyObject op_and(IRubyObject other) {
        RubyArray ary2 = other.convertToArray();
        RubyHash hash2 = ary2.makeHash();
        RubyArray ary3 = new RubyArray(this.getRuntime(), this.realLength < ary2.realLength ? this.realLength : ary2.realLength);
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            if (!hash2.fastDelete(v)) continue;
            ary3.append(v);
        }
        RuntimeHelpers.fillNil(ary3.values, ary3.realLength, ary3.values.length, this.getRuntime());
        return ary3;
    }

    @JRubyMethod(name={"|"}, required=1)
    public IRubyObject op_or(IRubyObject other) {
        IRubyObject v;
        int i;
        RubyArray ary2 = other.convertToArray();
        RubyHash set = this.makeHash(ary2);
        RubyArray ary3 = new RubyArray(this.getRuntime(), this.realLength + ary2.realLength);
        for (i = 0; i < this.realLength; ++i) {
            v = this.elt(i);
            if (!set.fastDelete(v)) continue;
            ary3.append(v);
        }
        for (i = 0; i < ary2.realLength; ++i) {
            v = ary2.elt(i);
            if (!set.fastDelete(v)) continue;
            ary3.append(v);
        }
        RuntimeHelpers.fillNil(ary3.values, ary3.realLength, ary3.values.length, this.getRuntime());
        return ary3;
    }

    @JRubyMethod(name={"sort"}, frame=true, compat=CompatVersion.RUBY1_8)
    public RubyArray sort(ThreadContext context, Block block) {
        RubyArray ary = this.aryDup();
        ary.sort_bang(context, block);
        return ary;
    }

    @JRubyMethod(name={"sort"}, frame=true, compat=CompatVersion.RUBY1_9)
    public RubyArray sort19(ThreadContext context, Block block) {
        RubyArray ary = this.aryDup();
        ary.sort_bang19(context, block);
        return ary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"sort!"}, frame=true, compat=CompatVersion.RUBY1_8)
    public IRubyObject sort_bang(ThreadContext context, Block block) {
        this.modify();
        if (this.realLength > 1) {
            this.flags |= 0x200;
            try {
                IRubyObject iRubyObject = block.isGiven() ? this.sortInternal(context, block) : this.sortInternal(context, false);
                return iRubyObject;
            }
            finally {
                this.flags &= 0xFFFFFDFF;
            }
        }
        return this;
    }

    @JRubyMethod(name={"sort!"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject sort_bang19(ThreadContext context, Block block) {
        this.modify();
        if (this.realLength > 1) {
            return block.isGiven() ? this.sortInternal(context, block) : this.sortInternal(context, true);
        }
        return this;
    }

    private IRubyObject sortInternal(final ThreadContext context, boolean honorOverride) {
        final boolean fixnumBypass = !honorOverride || context.getRuntime().newFixnum(0).isBuiltin("<=>");
        final boolean stringBypass = !honorOverride || context.getRuntime().newString("").isBuiltin("<=>");
        Qsort.sort(this.values, this.begin, this.begin + this.realLength, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (fixnumBypass && o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                    return RubyArray.compareFixnums((RubyFixnum)o1, (RubyFixnum)o2);
                }
                if (stringBypass && o1 instanceof RubyString && o2 instanceof RubyString) {
                    return ((RubyString)o1).op_cmp((RubyString)o2);
                }
                return RubyArray.compareOthers(context, (IRubyObject)o1, (IRubyObject)o2);
            }
        });
        return this;
    }

    private static int compareFixnums(RubyFixnum o1, RubyFixnum o2) {
        long b;
        long a = o1.getLongValue();
        return a > (b = o2.getLongValue()) ? 1 : (a == b ? 0 : -1);
    }

    private static int compareOthers(ThreadContext context, IRubyObject o1, IRubyObject o2) {
        IRubyObject ret = o1.callMethod(context, "<=>", o2);
        int n = RubyComparable.cmpint(context, ret, o1, o2);
        return n;
    }

    private IRubyObject sortInternal(final ThreadContext context, final Block block) {
        Qsort.sort(this.values, this.begin, this.begin + this.realLength, new Comparator(){

            public int compare(Object o1, Object o2) {
                IRubyObject obj1 = (IRubyObject)o1;
                IRubyObject obj2 = (IRubyObject)o2;
                IRubyObject ret = block.yieldArray(context, RubyArray.this.getRuntime().newArray(obj1, obj2), null, null);
                return RubyComparable.cmpint(context, ret, obj1, obj2);
            }
        });
        return this;
    }

    @JRubyMethod(name={"sort_by!"}, compat=CompatVersion.RUBY1_9, frame=true)
    public IRubyObject sort_by_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "sort_by!");
        }
        this.modifyCheck();
        RubyArray sorted = RuntimeHelpers.invoke(context, (IRubyObject)this, "sort_by", block).convertToArray();
        this.values = sorted.values;
        this.isShared = false;
        this.begin = 0;
        return this;
    }

    @JRubyMethod(name={"take"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject take(ThreadContext context, IRubyObject n) {
        Ruby runtime2 = context.getRuntime();
        long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime2.newArgumentError("attempt to take negative size");
        }
        return this.subseq(0L, len);
    }

    @JRubyMethod(name={"take_while"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject take_while(ThreadContext context, Block block) {
        int i;
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "take_while");
        }
        for (i = this.begin; i < this.begin + this.realLength && block.yield(context, this.values[i]).isTrue(); ++i) {
        }
        return this.subseq(0L, i - this.begin);
    }

    @JRubyMethod(name={"drop"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject drop(ThreadContext context, IRubyObject n) {
        Ruby runtime2 = context.getRuntime();
        long pos2 = RubyNumeric.num2long(n);
        if (pos2 < 0L) {
            throw runtime2.newArgumentError("attempt to drop negative size");
        }
        IRubyObject result = this.subseq(pos2, this.realLength);
        return result.isNil() ? runtime2.newEmptyArray() : result;
    }

    @JRubyMethod(name={"drop_while"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject drop_while(ThreadContext context, Block block) {
        int i;
        Ruby runtime2 = context.getRuntime();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "drop_while");
        }
        for (i = this.begin; i < this.begin + this.realLength && block.yield(context, this.values[i]).isTrue(); ++i) {
        }
        IRubyObject result = this.subseq(i - this.begin, this.realLength);
        return result.isNil() ? runtime2.newEmptyArray() : result;
    }

    @JRubyMethod(name={"cycle"})
    public IRubyObject cycle(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), this, "cycle");
        }
        return this.cycleCommon(context, -1L, block);
    }

    @JRubyMethod(name={"cycle"})
    public IRubyObject cycle(ThreadContext context, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return this.cycle(context, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "cycle", arg2);
        }
        long times2 = RubyNumeric.num2long(arg2);
        if (times2 <= 0L) {
            return context.getRuntime().getNil();
        }
        return this.cycleCommon(context, times2, block);
    }

    private IRubyObject cycleCommon(ThreadContext context, long n, Block block) {
        while (this.realLength > 0 && (n < 0L || 0L < n--)) {
            for (int i = this.begin; i < this.begin + this.realLength; ++i) {
                block.yield(context, this.values[i]);
            }
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"product"}, rest=true)
    public IRubyObject product(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        int n = args2.length + 1;
        RubyArray[] arrays = new RubyArray[n];
        int[] counters = new int[n];
        arrays[0] = this;
        for (int i = 1; i < n; ++i) {
            arrays[i] = args2[i - 1].convertToArray();
        }
        int resultLen = 1;
        for (int i = 0; i < n; ++i) {
            int k = arrays[i].realLength;
            int l = resultLen;
            if (k == 0) {
                return RubyArray.newEmptyArray(runtime2);
            }
            if ((resultLen *= k) >= k && resultLen >= l && resultLen / k == l) continue;
            throw runtime2.newRangeError("too big to product");
        }
        RubyArray result = RubyArray.newArray(runtime2, resultLen);
        for (int i = 0; i < resultLen; ++i) {
            int m;
            RubyArray sub3 = RubyArray.newArray(runtime2, n);
            for (int j = 0; j < n; ++j) {
                sub3.append(arrays[j].entry(counters[j]));
            }
            result.append(sub3);
            int n2 = m = n - 1;
            counters[n2] = counters[n2] + 1;
            while (m > 0 && counters[m] == arrays[m].realLength) {
                counters[m] = 0;
                int n3 = --m;
                counters[n3] = counters[n3] + 1;
            }
        }
        return result;
    }

    private int combinationLength(ThreadContext context, int n, int k) {
        if (k * 2 > n) {
            k = n - k;
        }
        if (k == 0) {
            return 1;
        }
        if (k < 0) {
            return 0;
        }
        int val = 1;
        int i = 1;
        while (i <= k) {
            long m;
            if ((long)(val *= n) < (m = (long)val)) {
                throw context.getRuntime().newRangeError("too big for combination");
            }
            val /= i;
            ++i;
            --n;
        }
        return val;
    }

    @JRubyMethod(name={"combination"})
    public IRubyObject combination(ThreadContext context, IRubyObject num, Block block) {
        block6: {
            int n;
            Ruby runtime2;
            block7: {
                block5: {
                    runtime2 = context.getRuntime();
                    if (!block.isGiven()) {
                        return RubyEnumerator.enumeratorize(runtime2, (IRubyObject)this, "combination", num);
                    }
                    n = RubyNumeric.num2int(num);
                    if (n != 0) break block5;
                    block.yield(context, RubyArray.newEmptyArray(runtime2));
                    break block6;
                }
                if (n != 1) break block7;
                for (int i = 0; i < this.realLength; ++i) {
                    block.yield(context, RubyArray.newArray(runtime2, this.values[this.begin + i]));
                }
                break block6;
            }
            if (n < 0 || this.realLength < n) break block6;
            int[] stack = new int[n + 1];
            int nlen = this.combinationLength(context, this.realLength, n);
            IRubyObject[] chosen = new IRubyObject[n];
            int lev = 0;
            stack[0] = -1;
            for (int i = 0; i < nlen; ++i) {
                chosen[lev] = this.values[this.begin + stack[lev + 1]];
                ++lev;
                while (lev < n) {
                    int n2 = stack[lev] + 1;
                    stack[lev + 1] = n2;
                    chosen[lev] = this.values[this.begin + n2];
                    ++lev;
                }
                block.yield(context, RubyArray.newArray(runtime2, chosen));
                do {
                    int n3 = lev--;
                    stack[n3] = stack[n3] + 1;
                } while (lev != 0 && stack[lev + 1] + n == this.realLength + lev + 1);
            }
        }
        return this;
    }

    private void permute(ThreadContext context, int n, int r, int[] p2, int index2, boolean[] used, RubyArray values, Block block) {
        for (int i = 0; i < n; ++i) {
            if (used[i]) continue;
            p2[index2] = i;
            if (index2 < r - 1) {
                used[i] = true;
                this.permute(context, n, r, p2, index2 + 1, used, values, block);
                used[i] = false;
                continue;
            }
            RubyArray result = RubyArray.newArray(context.getRuntime(), r);
            for (int j = 0; j < r; ++j) {
                result.values[result.begin + j] = values.values[values.begin + p2[j]];
            }
            result.realLength = r;
            block.yield(context, result);
        }
    }

    @JRubyMethod(name={"permutation"})
    public IRubyObject permutation(ThreadContext context, IRubyObject num, Block block) {
        return block.isGiven() ? this.permutationCommon(context, RubyNumeric.num2int(num), block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "permutation", num);
    }

    @JRubyMethod(name={"permutation"})
    public IRubyObject permutation(ThreadContext context, Block block) {
        return block.isGiven() ? this.permutationCommon(context, this.realLength, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "permutation");
    }

    private IRubyObject permutationCommon(ThreadContext context, int r, Block block) {
        if (r == 0) {
            block.yield(context, RubyArray.newEmptyArray(context.getRuntime()));
        } else if (r == 1) {
            for (int i = 0; i < this.realLength; ++i) {
                block.yield(context, RubyArray.newArray(context.getRuntime(), this.values[this.begin + i]));
            }
        } else if (r >= 0 && this.realLength >= r) {
            int n = this.realLength;
            this.permute(context, n, r, new int[n], 0, new boolean[n], this.makeShared(this.begin, n, this.getMetaClass()), block);
        }
        return this;
    }

    @JRubyMethod(name={"choice"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject choice(ThreadContext context) {
        return this.realLength == 0 ? context.getRuntime().getNil() : this.choiceCommon(context);
    }

    @JRubyMethod(name={"choice"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject choice19(ThreadContext context) {
        if (this.realLength == 0) {
            throw context.getRuntime().newNoMethodError("undefined method 'choice' for []:Array", null, context.getRuntime().getNil());
        }
        return this.choiceCommon(context);
    }

    public IRubyObject choiceCommon(ThreadContext context) {
        return this.values[this.begin + context.getRuntime().getRandom().nextInt(this.realLength)];
    }

    @JRubyMethod(name={"shuffle!"})
    public IRubyObject shuffle_bang(ThreadContext context) {
        this.modify();
        Random random = context.getRuntime().getRandom();
        int i = this.realLength;
        try {
            while (i > 0) {
                int r = random.nextInt(i);
                IRubyObject tmp = this.values[this.begin + --i];
                this.values[this.begin + i] = this.values[this.begin + r];
                this.values[this.begin + r] = tmp;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"shuffle"})
    public IRubyObject shuffle(ThreadContext context) {
        RubyArray ary = this.aryDup();
        ary.shuffle_bang(context);
        return ary;
    }

    @JRubyMethod(name={"sample"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sample(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.realLength == 0) {
            return runtime2.getNil();
        }
        int i = this.realLength == 1 ? 0 : runtime2.getRandom().nextInt(this.realLength);
        try {
            return this.values[this.begin + i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
            return runtime2.getNil();
        }
    }

    @JRubyMethod(name={"sample"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject sample(ThreadContext context, IRubyObject nv) {
        Ruby runtime2 = context.getRuntime();
        Random random = runtime2.getRandom();
        int n = RubyNumeric.num2int(nv);
        if (n < 0) {
            throw runtime2.newArgumentError("negative sample number");
        }
        if (n > this.realLength) {
            n = this.realLength;
        }
        switch (n) {
            case 0: {
                return RubyArray.newEmptyArray(runtime2);
            }
            case 1: {
                if (this.realLength <= 0) {
                    return RubyArray.newEmptyArray(runtime2);
                }
                return RubyArray.newArray(runtime2, this.values[this.begin + random.nextInt(this.realLength)]);
            }
            case 2: {
                int i = random.nextInt(this.realLength);
                int j = random.nextInt(this.realLength - 1);
                if (j >= i) {
                    ++j;
                }
                return RubyArray.newArray(runtime2, this.values[this.begin + i], this.values[this.begin + j]);
            }
            case 3: {
                int i = random.nextInt(this.realLength);
                int j = random.nextInt(this.realLength - 1);
                int k = random.nextInt(this.realLength - 2);
                int l = j;
                int g = i;
                if (j >= i) {
                    l = i;
                    g = ++j;
                }
                if (k >= l && ++k >= g) {
                    ++k;
                }
                return new RubyArray(runtime2, new IRubyObject[]{this.values[this.begin + i], this.values[this.begin + j], this.values[this.begin + k]});
            }
        }
        int len = this.realLength;
        if (n > len) {
            n = len;
        }
        if (n < SORTED_THRESHOLD) {
            int i;
            int[] idx = new int[SORTED_THRESHOLD];
            int[] sorted = new int[SORTED_THRESHOLD];
            sorted[0] = idx[0] = random.nextInt(len);
            for (i = 1; i < n; ++i) {
                int j;
                int k = random.nextInt(--len);
                for (j = 0; j < i && k >= sorted[j]; ++k, ++j) {
                }
                System.arraycopy(sorted, j, sorted, j + 1, i - j);
                sorted[j] = idx[i] = k;
            }
            IRubyObject[] result = new IRubyObject[n];
            for (i = 0; i < n; ++i) {
                result[i] = this.values[this.begin + idx[i]];
            }
            return new RubyArray(runtime2, result);
        }
        IRubyObject[] result = new IRubyObject[len];
        System.arraycopy(this.values, this.begin, result, 0, len);
        for (int i = 0; i < n; ++i) {
            int j = random.nextInt(len - i) + i;
            IRubyObject tmp = result[j];
            result[j] = result[i];
            result[i] = tmp;
        }
        RubyArray ary = new RubyArray(runtime2, result);
        ary.realLength = n;
        return ary;
    }

    private static void aryReverse(IRubyObject[] _p1, int p1, IRubyObject[] _p2, int p2) {
        while (p1 < p2) {
            IRubyObject tmp = _p1[p1];
            _p1[p1++] = _p2[p2];
            _p2[p2--] = tmp;
        }
    }

    private IRubyObject internalRotateBang(ThreadContext context, int cnt) {
        this.modify();
        if (cnt != 0) {
            IRubyObject[] ptr = this.values;
            int len = this.realLength;
            if (len > 0 && (cnt = RubyArray.rotateCount(cnt, len)) > 0) {
                if (cnt < --len) {
                    RubyArray.aryReverse(ptr, this.begin + cnt, ptr, this.begin + len);
                }
                if (--cnt > 0) {
                    RubyArray.aryReverse(ptr, this.begin, ptr, this.begin + cnt);
                }
                if (len > 0) {
                    RubyArray.aryReverse(ptr, this.begin, ptr, this.begin + len);
                }
                return this;
            }
        }
        return context.getRuntime().getNil();
    }

    private static int rotateCount(int cnt, int len) {
        return cnt < 0 ? len - ~cnt % len - 1 : cnt % len;
    }

    private IRubyObject internalRotate(ThreadContext context, int cnt) {
        int len = this.realLength;
        RubyArray rotated = this.aryDup();
        rotated.modify();
        if (len > 0) {
            cnt = RubyArray.rotateCount(cnt, len);
            IRubyObject[] ptr = this.values;
            IRubyObject[] ptr2 = rotated.values;
            System.arraycopy(ptr, this.begin + cnt, ptr2, 0, len -= cnt);
            System.arraycopy(ptr, this.begin, ptr2, len, cnt);
        }
        return rotated;
    }

    @JRubyMethod(name={"rotate!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rotate_bang(ThreadContext context) {
        this.internalRotateBang(context, 1);
        return this;
    }

    @JRubyMethod(name={"rotate!"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rotate_bang(ThreadContext context, IRubyObject cnt) {
        this.internalRotateBang(context, RubyNumeric.fix2int(cnt));
        return this;
    }

    @JRubyMethod(name={"rotate"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rotate(ThreadContext context) {
        return this.internalRotate(context, 1);
    }

    @JRubyMethod(name={"rotate"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject rotate(ThreadContext context, IRubyObject cnt) {
        return this.internalRotate(context, RubyNumeric.fix2int(cnt));
    }

    public IRubyObject all_p(ThreadContext context, Block block) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.all_pCommon(context, this, block);
        }
        if (!block.isGiven()) {
            return this.all_pBlockless(context);
        }
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (block.yield(context, this.values[i]).isTrue()) continue;
            return context.getRuntime().getFalse();
        }
        return context.getRuntime().getTrue();
    }

    private IRubyObject all_pBlockless(ThreadContext context) {
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (this.values[i].isTrue()) continue;
            return context.getRuntime().getFalse();
        }
        return context.getRuntime().getTrue();
    }

    public IRubyObject any_p(ThreadContext context, Block block) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.any_pCommon(context, this, block);
        }
        if (!block.isGiven()) {
            return this.any_pBlockless(context);
        }
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!block.yield(context, this.values[i]).isTrue()) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    private IRubyObject any_pBlockless(ThreadContext context) {
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!this.values[i].isTrue()) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public IRubyObject find(ThreadContext context, IRubyObject ifnone, Block block) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.detectCommon(context, this, block);
        }
        return this.detectCommon(context, ifnone, block);
    }

    public IRubyObject find_index(ThreadContext context, Block block) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.find_indexCommon(context, (IRubyObject)this, block);
        }
        for (int i = 0; i < this.realLength; ++i) {
            if (!block.yield(context, this.values[this.begin + i]).isTrue()) continue;
            return context.getRuntime().newFixnum(i);
        }
        return context.getRuntime().getNil();
    }

    public IRubyObject find_index(ThreadContext context, IRubyObject cond) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.find_indexCommon(context, (IRubyObject)this, cond);
        }
        for (int i = 0; i < this.realLength; ++i) {
            if (!this.values[this.begin + i].equals(cond)) continue;
            return context.getRuntime().newFixnum(i);
        }
        return context.getRuntime().getNil();
    }

    public IRubyObject detectCommon(ThreadContext context, IRubyObject ifnone, Block block) {
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!block.yield(context, this.values[i]).isTrue()) continue;
            return this.values[i];
        }
        return ifnone != null ? ifnone.callMethod(context, "call") : context.getRuntime().getNil();
    }

    public static void marshalTo(RubyArray array, MarshalStream output) throws IOException {
        output.registerLinkTarget(array);
        output.writeInt(array.getList().size());
        Iterator iter = array.getList().iterator();
        while (iter.hasNext()) {
            output.dumpObject((IRubyObject)iter.next());
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyArray result = input.getRuntime().newArray();
        input.registerLinkTarget(result);
        int size2 = input.unmarshalInt();
        for (int i = 0; i < size2; ++i) {
            result.append(input.unmarshalObject());
        }
        return result;
    }

    @JRubyMethod(name={"try_convert"}, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject self, IRubyObject arg2) {
        return arg2.checkArrayType();
    }

    @JRubyMethod(name={"pack"}, required=1)
    public RubyString pack(ThreadContext context, IRubyObject obj) {
        RubyString iFmt = RubyString.objAsString(context, obj);
        return Pack.pack(this.getRuntime(), this, iFmt.getByteList());
    }

    @Override
    public Class getJavaClass() {
        return List.class;
    }

    @Override
    public int size() {
        return this.realLength;
    }

    @Override
    public boolean isEmpty() {
        return this.realLength == 0;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.realLength];
        for (int i = this.begin; i < this.realLength; ++i) {
            array[i - this.begin] = this.values[i].toJava(Object.class);
        }
        return array;
    }

    @Override
    public Object[] toArray(Object[] arg2) {
        Object[] array = arg2;
        if (array.length < this.realLength) {
            Class<?> type2 = array.getClass().getComponentType();
            array = (Object[])Array.newInstance(type2, this.realLength);
        }
        int length2 = this.realLength - this.begin;
        for (int i = 0; i < length2; ++i) {
            array[i] = this.values[i + this.begin].toJava(Object.class);
        }
        return array;
    }

    @Override
    public boolean add(Object element) {
        this.append(JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element));
        return true;
    }

    @Override
    public boolean remove(Object element) {
        IRubyObject deleted = this.delete(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element), Block.NULL_BLOCK);
        return !deleted.isNil();
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return !c.isEmpty();
    }

    public boolean addAll(int index2, Collection c) {
        Iterator iter = c.iterator();
        int i = index2;
        while (iter.hasNext()) {
            this.add(i, iter.next());
            ++i;
        }
        return !c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean listChanged = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            listChanged = true;
        }
        return listChanged;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean listChanged = false;
        for (Object element : this) {
            if (c.contains(element)) continue;
            this.remove(element);
            listChanged = true;
        }
        return listChanged;
    }

    public Object get(int index2) {
        return this.elt(index2).toJava(Object.class);
    }

    public Object set(int index2, Object element) {
        return this.store(index2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element));
    }

    public void add(int index2, Object element) {
        this.insert(new IRubyObject[]{RubyFixnum.newFixnum(this.getRuntime(), index2), JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element)});
    }

    public Object remove(int index2) {
        return this.delete_at(index2).toJava(Object.class);
    }

    @Override
    public int indexOf(Object element) {
        int begin2 = this.begin;
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element);
            for (int i = begin2; i < begin2 + this.realLength; ++i) {
                if (!convertedElement.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        int begin2 = this.begin;
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element);
            for (int i = begin2 + this.realLength - 1; i >= begin2; --i) {
                if (!convertedElement.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return new RubyArrayConversionIterator();
    }

    public ListIterator listIterator() {
        return new RubyArrayConversionListIterator();
    }

    public ListIterator listIterator(int index2) {
        return new RubyArrayConversionListIterator(index2);
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        IRubyObject subList = this.subseq(fromIndex, toIndex - fromIndex + 1);
        return subList.isNil() ? null : (List)((Object)subList);
    }

    @Override
    public void clear() {
        this.rb_clear();
    }

    final class RubyArrayConversionListIterator
    extends RubyArrayConversionIterator
    implements ListIterator {
        public RubyArrayConversionListIterator() {
        }

        public RubyArrayConversionListIterator(int index2) {
            this.index = index2;
        }

        public boolean hasPrevious() {
            return this.index >= 0;
        }

        public Object previous() {
            this.last = --this.index;
            return RubyArray.this.elt(this.index).toJava(Object.class);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object obj) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.store(this.last, JavaUtil.convertJavaToUsableRubyObject(RubyArray.this.getRuntime(), obj));
        }

        public void add(Object obj) {
            RubyArray.this.insert(new IRubyObject[]{RubyFixnum.newFixnum(RubyArray.this.getRuntime(), this.index++), JavaUtil.convertJavaToUsableRubyObject(RubyArray.this.getRuntime(), obj)});
            this.last = -1;
        }
    }

    public class RubyArrayConversionIterator
    implements Iterator {
        protected int index = 0;
        protected int last = -1;

        public boolean hasNext() {
            return this.index < RubyArray.this.realLength;
        }

        public Object next() {
            IRubyObject element = RubyArray.this.elt(this.index);
            this.last = this.index++;
            return element.toJava(Object.class);
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.delete_at(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }
    }
}

